/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.pool2;

import java.io.Closeable;
import java.util.Collection;
import java.util.NoSuchElementException;
import org.apache.tomcat.dbcp.pool2.DestroyMode;

public interface KeyedObjectPool<K, V>
extends Closeable {
    public void addObject(K var1) throws Exception, IllegalStateException, UnsupportedOperationException;

    default public void addObjects(Collection<K> collection, int n) throws Exception, IllegalArgumentException {
        if (collection == null) {
            throw new IllegalArgumentException("keys must not be null.");
        }
        for (K k : collection) {
            this.addObjects(k, n);
        }
    }

    default public void addObjects(K k, int n) throws Exception, IllegalArgumentException {
        if (k == null) {
            throw new IllegalArgumentException("key must not be null.");
        }
        for (int i = 0; i < n; ++i) {
            this.addObject(k);
        }
    }

    public V borrowObject(K var1) throws Exception, NoSuchElementException, IllegalStateException;

    public void clear() throws Exception, UnsupportedOperationException;

    public void clear(K var1) throws Exception, UnsupportedOperationException;

    @Override
    public void close();

    public int getNumActive();

    public int getNumActive(K var1);

    public int getNumIdle();

    public int getNumIdle(K var1);

    public void invalidateObject(K var1, V var2) throws Exception;

    default public void invalidateObject(K k, V v, DestroyMode destroyMode) throws Exception {
        this.invalidateObject(k, v);
    }

    public void returnObject(K var1, V var2) throws Exception;
}

