/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.label;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.label.AbstractGoodsLabel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.GoodsType;

public final class ProductionLabel
extends AbstractGoodsLabel {
    private static final Logger logger = Logger.getLogger(ProductionLabel.class.getName());
    private int maxIcons = 7;
    private boolean drawPlus;
    private int compressedWidth = -1;
    private final ImageIcon goodsIcon;
    private transient Image stringImage;

    public ProductionLabel(FreeColClient freeColClient, AbstractGoods ag) {
        this(freeColClient, ag, -1);
    }

    public ProductionLabel(FreeColClient freeColClient, AbstractGoods ag, int maximumProduction) {
        this(freeColClient, ag, maximumProduction, 0, false);
    }

    public ProductionLabel(FreeColClient freeColClient, AbstractGoods ag, int maximumProduction, int stockNumber, boolean showStockAmount) {
        super(freeColClient, ag);
        boolean showMax;
        ImageLibrary lib = this.getImageLibrary();
        if (this.getType() == null) {
            FreeCol.trace(logger, "Bad production label (no type)");
        } else if (stockNumber < 0 && this.getAmount() == 0) {
            FreeCol.trace(logger, "Bad production label: " + ag + " stock=" + stockNumber);
        }
        ClientOptions options = freeColClient.getClientOptions();
        GoodsType horses = freeColClient.getGame().getSpecification().getGoodsType("model.goods.horses");
        this.maxIcons = ag.getType() == horses ? 1 : options.getInteger("model.option.guiMaxNumberOfGoodsImages");
        this.goodsIcon = ag.getType() == null ? null : new ImageIcon(lib.getScaledGoodsTypeImage(ag.getType()));
        this.compressedWidth = this.goodsIcon == null ? 0 : this.goodsIcon.getIconWidth() * 2;
        this.setFont(lib.getScaledFont("simple-bold-tiny", null));
        this.setForeground(this.getAmount() < 0 ? Color.RED : Color.WHITE);
        this.setToolTipText(this.getType() == null || this.getAmount() == 0 ? null : Messages.message(this.getAbstractGoods().getLabel()));
        int amount = this.getAmount();
        int displayNumber = options.getInteger("model.option.guiMinNumberToDisplayGoodsCount");
        boolean bl = showMax = amount > 0 && maximumProduction > amount;
        if (amount < 0 || amount >= displayNumber || amount > this.maxIcons || stockNumber > 0 || showMax) {
            Object number = "";
            if (showStockAmount && stockNumber >= 0) {
                number = String.valueOf(stockNumber);
                this.drawPlus = true;
            }
            if (amount >= 0 && this.drawPlus) {
                number = (String)number + "+";
            }
            number = (String)number + String.valueOf(amount);
            if (showMax) {
                number = (String)number + "/" + maximumProduction;
            }
            BufferedImage dummy = new BufferedImage(1, 1, 2);
            Graphics2D g = dummy.createGraphics();
            this.stringImage = lib.getStringImage(g, (String)number, this.getForeground(), this.getFont());
            g.dispose();
        } else {
            this.stringImage = null;
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        int maxSpacing;
        boolean iconsTooFarApart;
        int iconWidth;
        int pixelsPerIcon;
        int stringWidth = this.stringImage == null ? 0 : this.stringImage.getWidth(null);
        int drawImageCount = Math.min(Math.abs(this.getAmount()), this.maxIcons);
        if (drawImageCount == 0) {
            drawImageCount = 1;
        }
        if ((pixelsPerIcon = (iconWidth = this.goodsIcon.getIconWidth()) / 2) - iconWidth < 0) {
            pixelsPerIcon = (this.compressedWidth - iconWidth) / drawImageCount;
        }
        boolean bl = iconsTooFarApart = pixelsPerIcon > (maxSpacing = iconWidth);
        if (iconsTooFarApart) {
            pixelsPerIcon = maxSpacing;
        }
        int coverage = pixelsPerIcon * (drawImageCount - 1) + iconWidth;
        int leftOffset = 0;
        int width = Math.max(this.getWidth(), Math.max(stringWidth, coverage));
        if (coverage < width) {
            leftOffset = (width - coverage) / 2;
        }
        int height = Math.max(this.getHeight(), this.goodsIcon.getImage().getHeight(null));
        this.setSize(new Dimension(width, height));
        for (int i = 0; i < drawImageCount; ++i) {
            this.goodsIcon.paintIcon(null, g, leftOffset + i * pixelsPerIcon, 0);
        }
        if (this.stringImage != null) {
            int textOffset = width > stringWidth ? (width - stringWidth) / 2 : 0;
            textOffset = textOffset >= 0 ? textOffset : 0;
            g.drawImage(this.stringImage, textOffset, this.goodsIcon.getIconHeight() / 2 - this.stringImage.getHeight(null) / 2, null);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        int maxSpacing;
        boolean iconsTooFarApart;
        if (this.goodsIcon == null) {
            return new Dimension(0, 0);
        }
        int drawImageCount = Math.max(1, Math.min(Math.abs(this.getAmount()), this.maxIcons));
        int iconWidth = this.goodsIcon.getIconWidth();
        int pixelsPerIcon = iconWidth / 2;
        if (pixelsPerIcon - iconWidth < 0) {
            pixelsPerIcon = (this.compressedWidth - iconWidth) / drawImageCount;
        }
        boolean bl = iconsTooFarApart = pixelsPerIcon > (maxSpacing = iconWidth);
        if (iconsTooFarApart) {
            pixelsPerIcon = maxSpacing;
        }
        int width = pixelsPerIcon * (drawImageCount - 1) + iconWidth;
        if (this.stringImage != null) {
            width = Math.max(this.stringImage.getWidth(null), width);
        }
        return new Dimension(width, this.goodsIcon.getImage().getHeight(null));
    }
}

