# Neo Geo/Yamaha YM2610

originally an arcade board, but SNK shortly adapted it to a rather expensive video game console with the world's biggest cartridges because some people liked the system so much they wanted a home version of it.

its soundchip is a 4-in-1: 4ch 4-op FM, YM2149 (AY-3-8910 clone) and 2 different format ADPCM in a single package!

# effects

- `10xy`: set LFO parameters.
  - `x` toggles the LFO.
  - `y` sets its speed.
- `11xx`: set feedback of channel.
- `12xx`: set operator 1 level.
- `13xx`: set operator 2 level.
- `14xx`: set operator 3 level.
- `15xx`: set operator 4 level.
- `16xy`: set multiplier of operator.
  - `x` is the operator (1-4).
  - `y` is the mutliplier.
- `18xx`: toggle extended channel 2 mode.
  - 0 disables it and 1 enables it.
  - only in extended channel 2 system.
- `19xx`: set attack of all operators.
- `1Axx`: set attack of operator 1.
- `1Bxx`: set attack of operator 2.
- `1Cxx`: set attack of operator 3.
- `1Dxx`: set attack of operator 4.
- `20xx`: set SSG channel mode. `xx` may be one of the following:
  - `00`: square
  - `01`: noise
  - `02`: square and noise
  - `03`: nothing (apparently)
  - `04`: envelope and square
  - `05`: envelope and noise
  - `06`: envelope and square and noise
  - `07`: nothing
- `21xx`: set noise frequency. `xx` is a value between 00 and 1F.
- `22xy`: set envelope mode.
  - `x` sets the envelope shape, which may be one of the following:
    - `0: \___` decay
    - `4: /___` attack once
    - `8: \\\\` saw
    - `9: \___` decay
    - `A: \/\/` inverse obelisco
    - `B: \¯¯¯` decay once
    - `C: ////` inverse saw
    - `D: /¯¯¯` attack
    - `E: /\/\` obelisco
    - `F: /___` attack once
  - if `y` is 1 then the envelope will affect this channel.
- `23xx`: set envelope period low byte.
- `24xx`: set envelope period high byte.
- `25xx`: slide envelope period up.
- `26xx`: slide envelope period down.
- `29xy`: enable SSG auto-envelope mode.
  - in this mode the envelope period is set to the channel's notes, multiplied by a fraction.
  - `x` is the numerator.
  - `y` is the denominator.
  - if `x` or `y` are 0 this will disable auto-envelope mode.
- `30xx`: enable envelope hard reset.
  - this works by inserting a quick release and tiny delay before a new note.
- `50xy`: set AM of operator.
  - `x` is the operator (1-4). a value of 0 means "all operators".
  - `y` determines whether AM is on.
- `51xy` set SL of operator.
  - `x` is the operator (1-4). a value of 0 means "all operators".
  - `y` is the value.
- `52xy` set RR of operator.
  - `x` is the operator (1-4). a value of 0 means "all operators".
  - `y` is the value.
- `53xy` set DT of operator.
  - `x` is the operator (1-4). a value of 0 means "all operators".
  - `y` is the value:
    - 0: +0
    - 1: +1
    - 2: +2
    - 3: +3
    - 4: -0
    - 5: -3
    - 6: -2
    - 7: -1
- `54xy` set RS of operator.
  - `x` is the operator (1-4). a value of 0 means "all operators".
  - `y` is the value.
- `55xy` set SSG-EG of operator.
  - `x` is the operator (1-4). a value of 0 means "all operators".
  - `y` is the value (0-8).
    - values between 0 and 7 set SSG-EG.
    - value 8 disables it.
- `56xx`: set DR of all operators.
- `57xx`: set DR of operator 1.
- `58xx`: set DR of operator 2.
- `59xx`: set DR of operator 3.
- `5Axx`: set DR of operator 4.
- `5Bxx`: set D2R/SR of all operators.
- `5Cxx`: set D2R/SR of operator 1.
- `5Dxx`: set D2R/SR of operator 2.
- `5Exx`: set D2R/SR of operator 3.
- `5Fxx`: set D2R/SR of operator 4.