/* Dialogs.c generated by valac 0.56.3, the Vala compiler
 * generated from Dialogs.vala, do not modify */

/*
 * Copyright 2021 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <meta/window.h>
#include <meta/meta-close-dialog.h>
#include <gee.h>
#include <meta/display.h>
#include <glib/gi18n-lib.h>

#define GALA_ACCESS_DIALOG_PANTHEON_PORTAL_NAME "org.freedesktop.impl.portal.desktop.pantheon"
#define GALA_ACCESS_DIALOG_FDO_PORTAL_PATH "/org/freedesktop/portal/desktop"
#define GALA_ACCESS_DIALOG_GALA_DIALOG_PATH "/io/elementary/gala/dialog"
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_ACCESS_PORTAL (gala_access_portal_get_type ())
#define GALA_ACCESS_PORTAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_ACCESS_PORTAL, GalaAccessPortal))
#define GALA_IS_ACCESS_PORTAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_ACCESS_PORTAL))
#define GALA_ACCESS_PORTAL_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GALA_TYPE_ACCESS_PORTAL, GalaAccessPortalIface))

typedef struct _GalaAccessPortal GalaAccessPortal;
typedef struct _GalaAccessPortalIface GalaAccessPortalIface;

#define GALA_TYPE_ACCESS_PORTAL_PROXY (gala_access_portal_proxy_get_type ())
typedef GDBusProxy GalaAccessPortalProxy;
typedef GDBusProxyClass GalaAccessPortalProxyClass;
typedef struct _GalaAccessPortalAccessDialogReadyData GalaAccessPortalAccessDialogReadyData;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define GALA_TYPE_REQUEST (gala_request_get_type ())
#define GALA_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_REQUEST, GalaRequest))
#define GALA_IS_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_REQUEST))
#define GALA_REQUEST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GALA_TYPE_REQUEST, GalaRequestIface))

typedef struct _GalaRequest GalaRequest;
typedef struct _GalaRequestIface GalaRequestIface;

#define GALA_TYPE_REQUEST_PROXY (gala_request_proxy_get_type ())
typedef GDBusProxy GalaRequestProxy;
typedef GDBusProxyClass GalaRequestProxyClass;

#define GALA_TYPE_ACCESS_DIALOG (gala_access_dialog_get_type ())
#define GALA_ACCESS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_ACCESS_DIALOG, GalaAccessDialog))
#define GALA_ACCESS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_ACCESS_DIALOG, GalaAccessDialogClass))
#define GALA_IS_ACCESS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_ACCESS_DIALOG))
#define GALA_IS_ACCESS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_ACCESS_DIALOG))
#define GALA_ACCESS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_ACCESS_DIALOG, GalaAccessDialogClass))

typedef struct _GalaAccessDialog GalaAccessDialog;
typedef struct _GalaAccessDialogClass GalaAccessDialogClass;
typedef struct _GalaAccessDialogPrivate GalaAccessDialogPrivate;
enum  {
	GALA_ACCESS_DIALOG_0_PROPERTY,
	GALA_ACCESS_DIALOG_PARENT_PROPERTY,
	GALA_ACCESS_DIALOG_TITLE_PROPERTY,
	GALA_ACCESS_DIALOG_BODY_PROPERTY,
	GALA_ACCESS_DIALOG_ICON_PROPERTY,
	GALA_ACCESS_DIALOG_ACCEPT_LABEL_PROPERTY,
	GALA_ACCESS_DIALOG_DENY_LABEL_PROPERTY,
	GALA_ACCESS_DIALOG_NUM_PROPERTIES
};
static GParamSpec* gala_access_dialog_properties[GALA_ACCESS_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define GALA_TYPE_CLOSE_DIALOG (gala_close_dialog_get_type ())
#define GALA_CLOSE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_CLOSE_DIALOG, GalaCloseDialog))
#define GALA_CLOSE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_CLOSE_DIALOG, GalaCloseDialogClass))
#define GALA_IS_CLOSE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_CLOSE_DIALOG))
#define GALA_IS_CLOSE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_CLOSE_DIALOG))
#define GALA_CLOSE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_CLOSE_DIALOG, GalaCloseDialogClass))

typedef struct _GalaCloseDialog GalaCloseDialog;
typedef struct _GalaCloseDialogClass GalaCloseDialogClass;
enum  {
	GALA_ACCESS_DIALOG_RESPONSE_SIGNAL,
	GALA_ACCESS_DIALOG_SHOW_SIGNAL,
	GALA_ACCESS_DIALOG_NUM_SIGNALS
};
static guint gala_access_dialog_signals[GALA_ACCESS_DIALOG_NUM_SIGNALS] = {0};
typedef struct _GalaCloseDialogPrivate GalaCloseDialogPrivate;
enum  {
	GALA_CLOSE_DIALOG_0_PROPERTY,
	GALA_CLOSE_DIALOG_WINDOW_PROPERTY,
	GALA_CLOSE_DIALOG_NUM_PROPERTIES
};
static GParamSpec* gala_close_dialog_properties[GALA_CLOSE_DIALOG_NUM_PROPERTIES];

struct _GalaAccessPortalIface {
	GTypeInterface parent_iface;
	void (*access_dialog) (GalaAccessPortal* self, const char* request_path, const gchar* app_id, const gchar* window_handle, const gchar* title, const gchar* sub_title, const gchar* body, GHashTable* options, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*access_dialog_finish) (GalaAccessPortal* self, GAsyncResult* _res_, guint* response, GError** error);
};

struct _GalaAccessPortalAccessDialogReadyData {
	GDBusMethodInvocation* _invocation_;
	char* request_path;
	gchar* app_id;
	gchar* window_handle;
	gchar* title;
	gchar* sub_title;
	gchar* body;
	GHashTable* options;
};

struct _GalaRequestIface {
	GTypeInterface parent_iface;
	void (*close) (GalaRequest* self, GError** error);
};

struct _GalaAccessDialog {
	GObject parent_instance;
	GalaAccessDialogPrivate * priv;
	char* path;
};

struct _GalaAccessDialogClass {
	GObjectClass parent_class;
	void (*on_response) (GalaAccessDialog* self, GObject* obj, GAsyncResult* res);
	void (*show) (GalaAccessDialog* self);
};

struct _GalaAccessDialogPrivate {
	MetaWindow* _parent;
	gchar* _title;
	gchar* _body;
	gchar* _icon;
	gchar* _accept_label;
	gchar* _deny_label;
};

struct _GalaCloseDialog {
	GalaAccessDialog parent_instance;
	GalaCloseDialogPrivate * priv;
};

struct _GalaCloseDialogClass {
	GalaAccessDialogClass parent_class;
};

static gint GalaAccessDialog_private_offset;
static gpointer gala_access_dialog_parent_class = NULL;
VALA_EXTERN GalaAccessPortal* gala_access_dialog_portal;
GalaAccessPortal* gala_access_dialog_portal = NULL;
static gpointer gala_close_dialog_parent_class = NULL;
VALA_EXTERN GeeSet* gala_close_dialog_open_dialogs;
GeeSet* gala_close_dialog_open_dialogs = NULL;
static MetaCloseDialogInterface * gala_close_dialog_meta_close_dialog_parent_iface = NULL;

VALA_EXTERN GType gala_access_portal_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint gala_access_portal_register_object (void* object,
                                          GDBusConnection* connection,
                                          const gchar* path,
                                          GError** error);
VALA_EXTERN GType gala_access_portal_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaAccessPortal, g_object_unref)
VALA_EXTERN void gala_access_portal_access_dialog (GalaAccessPortal* self,
                                       const char* request_path,
                                       const gchar* app_id,
                                       const gchar* window_handle,
                                       const gchar* title,
                                       const gchar* sub_title,
                                       const gchar* body,
                                       GHashTable* options,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
VALA_EXTERN void gala_access_portal_access_dialog_finish (GalaAccessPortal* self,
                                              GAsyncResult* _res_,
                                              guint* response,
                                              GError** error);
static GType gala_access_portal_get_type_once (void);
static void gala_access_portal_proxy_g_signal (GDBusProxy* proxy,
                                        const gchar* sender_name,
                                        const gchar* signal_name,
                                        GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object,
                                   GAsyncResult *res,
                                   void *user_data);
static void gala_access_portal_proxy_access_dialog_async (GalaAccessPortal* self,
                                                   const char* request_path,
                                                   const gchar* app_id,
                                                   const gchar* window_handle,
                                                   const gchar* title,
                                                   const gchar* sub_title,
                                                   const gchar* body,
                                                   GHashTable* options,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
static void gala_access_portal_proxy_access_dialog_finish (GalaAccessPortal* self,
                                                    GAsyncResult* _res_,
                                                    guint* response,
                                                    GError** error);
static void gala_access_portal_proxy_gala_access_portal_interface_init (GalaAccessPortalIface* iface);
static void _dbus_gala_access_portal_access_dialog (GalaAccessPortal* self,
                                             GVariant* _parameters_,
                                             GDBusMethodInvocation* invocation);
static void _dbus_gala_access_portal_access_dialog_ready (GObject * source_object,
                                                   GAsyncResult * _res_,
                                                   gpointer _user_data_);
static void gala_access_portal_dbus_interface_method_call (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* method_name,
                                                    GVariant* parameters,
                                                    GDBusMethodInvocation* invocation,
                                                    gpointer user_data);
static GVariant* gala_access_portal_dbus_interface_get_property (GDBusConnection* connection,
                                                          const gchar* sender,
                                                          const gchar* object_path,
                                                          const gchar* interface_name,
                                                          const gchar* property_name,
                                                          GError** error,
                                                          gpointer user_data);
static gboolean gala_access_portal_dbus_interface_set_property (GDBusConnection* connection,
                                                         const gchar* sender,
                                                         const gchar* object_path,
                                                         const gchar* interface_name,
                                                         const gchar* property_name,
                                                         GVariant* value,
                                                         GError** error,
                                                         gpointer user_data);
static void _gala_access_portal_unregister_object (gpointer user_data);
VALA_EXTERN GType gala_request_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint gala_request_register_object (void* object,
                                    GDBusConnection* connection,
                                    const gchar* path,
                                    GError** error);
VALA_EXTERN GType gala_request_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaRequest, g_object_unref)
VALA_EXTERN void gala_request_close (GalaRequest* self,
                         GError** error);
static GType gala_request_get_type_once (void);
static void gala_request_proxy_g_signal (GDBusProxy* proxy,
                                  const gchar* sender_name,
                                  const gchar* signal_name,
                                  GVariant* parameters);
static void gala_request_proxy_close (GalaRequest* self,
                               GError** error);
static void gala_request_proxy_gala_request_interface_init (GalaRequestIface* iface);
static void _dbus_gala_request_close (GalaRequest* self,
                               GVariant* _parameters_,
                               GDBusMethodInvocation* invocation);
static void gala_request_dbus_interface_method_call (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* method_name,
                                              GVariant* parameters,
                                              GDBusMethodInvocation* invocation,
                                              gpointer user_data);
static GVariant* gala_request_dbus_interface_get_property (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* property_name,
                                                    GError** error,
                                                    gpointer user_data);
static gboolean gala_request_dbus_interface_set_property (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* property_name,
                                                   GVariant* value,
                                                   GError** error,
                                                   gpointer user_data);
static void _gala_request_unregister_object (gpointer user_data);
VALA_EXTERN GType gala_access_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaAccessDialog, g_object_unref)
VALA_EXTERN void gala_access_dialog_on_response (GalaAccessDialog* self,
                                     GObject* obj,
                                     GAsyncResult* res);
VALA_EXTERN void gala_access_dialog_watch_portal (void);
static void __lambda139_ (void);
static void ___lambda139__gbus_name_appeared_callback (GDBusConnection* connection,
                                                const gchar* name,
                                                const gchar* name_owner,
                                                gpointer self);
static void __lambda140_ (void);
static void ___lambda140__gbus_name_vanished_callback (GDBusConnection* connection,
                                                const gchar* name,
                                                gpointer self);
VALA_EXTERN GalaAccessDialog* gala_access_dialog_new (const gchar* title,
                                          const gchar* body,
                                          const gchar* icon);
VALA_EXTERN GalaAccessDialog* gala_access_dialog_construct (GType object_type,
                                                const gchar* title,
                                                const gchar* body,
                                                const gchar* icon);
VALA_EXTERN void gala_access_dialog_close (GalaAccessDialog* self);
static void gala_access_dialog_real_on_response (GalaAccessDialog* self,
                                          GObject* obj,
                                          GAsyncResult* res);
VALA_EXTERN MetaWindow* gala_access_dialog_get_parent (GalaAccessDialog* self);
VALA_EXTERN void gala_access_dialog_set_parent (GalaAccessDialog* self,
                                    MetaWindow* value);
VALA_EXTERN const gchar* gala_access_dialog_get_title (GalaAccessDialog* self);
static void gala_access_dialog_set_title (GalaAccessDialog* self,
                                   const gchar* value);
VALA_EXTERN const gchar* gala_access_dialog_get_body (GalaAccessDialog* self);
static void gala_access_dialog_set_body (GalaAccessDialog* self,
                                  const gchar* value);
VALA_EXTERN const gchar* gala_access_dialog_get_icon (GalaAccessDialog* self);
static void gala_access_dialog_set_icon (GalaAccessDialog* self,
                                  const gchar* value);
VALA_EXTERN const gchar* gala_access_dialog_get_accept_label (GalaAccessDialog* self);
VALA_EXTERN void gala_access_dialog_set_accept_label (GalaAccessDialog* self,
                                          const gchar* value);
VALA_EXTERN const gchar* gala_access_dialog_get_deny_label (GalaAccessDialog* self);
VALA_EXTERN void gala_access_dialog_set_deny_label (GalaAccessDialog* self,
                                        const gchar* value);
static void gala_access_dialog_real_show (GalaAccessDialog* self);
static void _g_free0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
static GVariant* _variant_new1 (const gchar* value);
static GVariant* _variant_new2 (const gchar* value);
static GVariant* _variant_new3 (const gchar* value);
VALA_EXTERN GType gala_close_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaCloseDialog, g_object_unref)
static GVariant* _variant_new4 (gboolean value);
static void _gala_access_dialog_on_response_gasync_ready_callback (GObject* source_object,
                                                            GAsyncResult* res,
                                                            gpointer self);
static void gala_access_dialog_finalize (GObject * obj);
static GType gala_access_dialog_get_type_once (void);
static void _vala_gala_access_dialog_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_gala_access_dialog_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
gchar* g_locale_from_utf8 (const gchar* str,
                           gssize len,
                           gsize* bytes_read,
                           gsize* bytes_wrriten,
                           GError** err);
VALA_EXTERN GalaCloseDialog* gala_close_dialog_new (MetaWindow* window);
VALA_EXTERN GalaCloseDialog* gala_close_dialog_construct (GType object_type,
                                              MetaWindow* window);
static void gala_close_dialog_real_show (MetaCloseDialog* base);
static void gala_close_dialog_real_hide (MetaCloseDialog* base);
static void gala_close_dialog_real_focus (MetaCloseDialog* base);
static gboolean __lambda141_ (GalaCloseDialog* self,
                       MetaWindow* w);
static gboolean ___lambda141__meta_window_foreach_func (MetaWindow* window,
                                                 gpointer self);
static void gala_close_dialog_real_on_response (GalaAccessDialog* base,
                                         GObject* obj,
                                         GAsyncResult* res);
static GObject * gala_close_dialog_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static void gala_close_dialog_finalize (GObject * obj);
static GType gala_close_dialog_get_type_once (void);
static void _vala_gala_close_dialog_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_gala_close_dialog_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);

static const GDBusArgInfo _gala_access_portal_dbus_arg_info_access_dialog_request_path = {-1, "request_path", "o", NULL};
static const GDBusArgInfo _gala_access_portal_dbus_arg_info_access_dialog_app_id = {-1, "app_id", "s", NULL};
static const GDBusArgInfo _gala_access_portal_dbus_arg_info_access_dialog_window_handle = {-1, "window_handle", "s", NULL};
static const GDBusArgInfo _gala_access_portal_dbus_arg_info_access_dialog_title = {-1, "title", "s", NULL};
static const GDBusArgInfo _gala_access_portal_dbus_arg_info_access_dialog_sub_title = {-1, "sub_title", "s", NULL};
static const GDBusArgInfo _gala_access_portal_dbus_arg_info_access_dialog_body = {-1, "body", "s", NULL};
static const GDBusArgInfo _gala_access_portal_dbus_arg_info_access_dialog_options = {-1, "options", "a{sv}", NULL};
static const GDBusArgInfo _gala_access_portal_dbus_arg_info_access_dialog_response = {-1, "response", "u", NULL};
static const GDBusArgInfo * const _gala_access_portal_dbus_arg_info_access_dialog_in[] = {&_gala_access_portal_dbus_arg_info_access_dialog_request_path, &_gala_access_portal_dbus_arg_info_access_dialog_app_id, &_gala_access_portal_dbus_arg_info_access_dialog_window_handle, &_gala_access_portal_dbus_arg_info_access_dialog_title, &_gala_access_portal_dbus_arg_info_access_dialog_sub_title, &_gala_access_portal_dbus_arg_info_access_dialog_body, &_gala_access_portal_dbus_arg_info_access_dialog_options, NULL};
static const GDBusArgInfo * const _gala_access_portal_dbus_arg_info_access_dialog_out[] = {&_gala_access_portal_dbus_arg_info_access_dialog_response, NULL};
static const GDBusMethodInfo _gala_access_portal_dbus_method_info_access_dialog = {-1, "AccessDialog", (GDBusArgInfo **) (&_gala_access_portal_dbus_arg_info_access_dialog_in), (GDBusArgInfo **) (&_gala_access_portal_dbus_arg_info_access_dialog_out), NULL};
static const GDBusMethodInfo * const _gala_access_portal_dbus_method_info[] = {&_gala_access_portal_dbus_method_info_access_dialog, NULL};
static const GDBusSignalInfo * const _gala_access_portal_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _gala_access_portal_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _gala_access_portal_dbus_interface_info = {-1, "org.freedesktop.impl.portal.Access", (GDBusMethodInfo **) (&_gala_access_portal_dbus_method_info), (GDBusSignalInfo **) (&_gala_access_portal_dbus_signal_info), (GDBusPropertyInfo **) (&_gala_access_portal_dbus_property_info), NULL};
static const GDBusInterfaceVTable _gala_access_portal_dbus_interface_vtable = {gala_access_portal_dbus_interface_method_call, gala_access_portal_dbus_interface_get_property, gala_access_portal_dbus_interface_set_property};
static const GDBusArgInfo * const _gala_request_dbus_arg_info_close_in[] = {NULL};
static const GDBusArgInfo * const _gala_request_dbus_arg_info_close_out[] = {NULL};
static const GDBusMethodInfo _gala_request_dbus_method_info_close = {-1, "Close", (GDBusArgInfo **) (&_gala_request_dbus_arg_info_close_in), (GDBusArgInfo **) (&_gala_request_dbus_arg_info_close_out), NULL};
static const GDBusMethodInfo * const _gala_request_dbus_method_info[] = {&_gala_request_dbus_method_info_close, NULL};
static const GDBusSignalInfo * const _gala_request_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _gala_request_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _gala_request_dbus_interface_info = {-1, "org.freedesktop.impl.portal.Request", (GDBusMethodInfo **) (&_gala_request_dbus_method_info), (GDBusSignalInfo **) (&_gala_request_dbus_signal_info), (GDBusPropertyInfo **) (&_gala_request_dbus_property_info), NULL};
static const GDBusInterfaceVTable _gala_request_dbus_interface_vtable = {gala_request_dbus_interface_method_call, gala_request_dbus_interface_get_property, gala_request_dbus_interface_set_property};

void
gala_access_portal_access_dialog (GalaAccessPortal* self,
                                  const char* request_path,
                                  const gchar* app_id,
                                  const gchar* window_handle,
                                  const gchar* title,
                                  const gchar* sub_title,
                                  const gchar* body,
                                  GHashTable* options,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	GalaAccessPortalIface* _iface_;
	_iface_ = GALA_ACCESS_PORTAL_GET_INTERFACE (self);
	if (_iface_->access_dialog) {
		_iface_->access_dialog (self, request_path, app_id, window_handle, title, sub_title, body, options, _callback_, _user_data_);
	}
}

void
gala_access_portal_access_dialog_finish (GalaAccessPortal* self,
                                         GAsyncResult* _res_,
                                         guint* response,
                                         GError** error)
{
	GalaAccessPortalIface* _iface_;
	_iface_ = GALA_ACCESS_PORTAL_GET_INTERFACE (self);
	if (_iface_->access_dialog_finish) {
		_iface_->access_dialog_finish (self, _res_, response, error);
	}
}

static void
gala_access_portal_default_init (GalaAccessPortalIface * iface,
                                 gpointer iface_data)
{
}

static GType
gala_access_portal_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaAccessPortalIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_access_portal_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType gala_access_portal_type_id;
	gala_access_portal_type_id = g_type_register_static (G_TYPE_INTERFACE, "GalaAccessPortal", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (gala_access_portal_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (gala_access_portal_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) gala_access_portal_proxy_get_type);
	g_type_set_qdata (gala_access_portal_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.impl.portal.Access");
	g_type_set_qdata (gala_access_portal_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_gala_access_portal_dbus_interface_info));
	g_type_set_qdata (gala_access_portal_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) gala_access_portal_register_object);
	return gala_access_portal_type_id;
}

GType
gala_access_portal_get_type (void)
{
	static volatile gsize gala_access_portal_type_id__once = 0;
	if (g_once_init_enter (&gala_access_portal_type_id__once)) {
		GType gala_access_portal_type_id;
		gala_access_portal_type_id = gala_access_portal_get_type_once ();
		g_once_init_leave (&gala_access_portal_type_id__once, gala_access_portal_type_id);
	}
	return gala_access_portal_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (GalaAccessPortalProxy, gala_access_portal_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (GALA_TYPE_ACCESS_PORTAL, gala_access_portal_proxy_gala_access_portal_interface_init) )
static void
gala_access_portal_proxy_class_init (GalaAccessPortalProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = gala_access_portal_proxy_g_signal;
}

static void
gala_access_portal_proxy_g_signal (GDBusProxy* proxy,
                                   const gchar* sender_name,
                                   const gchar* signal_name,
                                   GVariant* parameters)
{
}

static void
gala_access_portal_proxy_init (GalaAccessPortalProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_gala_access_portal_dbus_interface_info));
}

static void
_vala_g_async_ready_callback (GObject *source_object,
                              GAsyncResult *res,
                              void *user_data)
{
	g_task_return_pointer (user_data, g_object_ref (res), g_object_unref);
	g_object_unref (user_data);
}

static void
gala_access_portal_proxy_access_dialog_async (GalaAccessPortal* self,
                                              const char* request_path,
                                              const gchar* app_id,
                                              const gchar* window_handle,
                                              const gchar* title,
                                              const gchar* sub_title,
                                              const gchar* body,
                                              GHashTable* options,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp52_;
	GHashTableIter _tmp53_;
	gpointer _tmp54_;
	gpointer _tmp55_;
	G_IO_ERROR;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.impl.portal.Access", "AccessDialog");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_object_path (request_path));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (app_id));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (window_handle));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (title));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sub_title));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (body));
	g_hash_table_iter_init (&_tmp53_, options);
	g_variant_builder_init (&_tmp52_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp53_, &_tmp54_, &_tmp55_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp54_;
		_value = (GVariant*) _tmp55_;
		g_variant_builder_add (&_tmp52_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp52_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
gala_access_portal_proxy_access_dialog_finish (GalaAccessPortal* self,
                                               GAsyncResult* _res_,
                                               guint* response,
                                               GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	guint _vala_response = 0U;
	GVariant* _tmp56_;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp56_ = g_variant_iter_next_value (&_reply_iter);
	_vala_response = g_variant_get_uint32 (_tmp56_);
	g_variant_unref (_tmp56_);
	*response = _vala_response;
	g_object_unref (_reply_message);
}

static void
gala_access_portal_proxy_gala_access_portal_interface_init (GalaAccessPortalIface* iface)
{
	iface->access_dialog = gala_access_portal_proxy_access_dialog_async;
	iface->access_dialog_finish = gala_access_portal_proxy_access_dialog_finish;
}

static void
_dbus_gala_access_portal_access_dialog (GalaAccessPortal* self,
                                        GVariant* _parameters_,
                                        GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	GalaAccessPortalAccessDialogReadyData* _ready_data;
	GVariant* _tmp57_;
	GVariant* _tmp58_;
	GVariant* _tmp59_;
	GVariant* _tmp60_;
	GVariant* _tmp61_;
	GVariant* _tmp62_;
	GVariant* _tmp63_;
	GHashTable* _tmp64_;
	GVariantIter _tmp65_;
	GVariant* _tmp66_;
	GVariant* _tmp67_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (GalaAccessPortalAccessDialogReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp57_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->request_path = g_variant_dup_string (_tmp57_, NULL);
	g_variant_unref (_tmp57_);
	_tmp58_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->app_id = g_variant_dup_string (_tmp58_, NULL);
	g_variant_unref (_tmp58_);
	_tmp59_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->window_handle = g_variant_dup_string (_tmp59_, NULL);
	g_variant_unref (_tmp59_);
	_tmp60_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->title = g_variant_dup_string (_tmp60_, NULL);
	g_variant_unref (_tmp60_);
	_tmp61_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->sub_title = g_variant_dup_string (_tmp61_, NULL);
	g_variant_unref (_tmp61_);
	_tmp62_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->body = g_variant_dup_string (_tmp62_, NULL);
	g_variant_unref (_tmp62_);
	_tmp63_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp64_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
	g_variant_iter_init (&_tmp65_, _tmp63_);
	while (g_variant_iter_loop (&_tmp65_, "{?*}", &_tmp66_, &_tmp67_)) {
		g_hash_table_insert (_tmp64_, g_variant_dup_string (_tmp66_, NULL), g_variant_get_variant (_tmp67_));
	}
	_ready_data->options = _tmp64_;
	g_variant_unref (_tmp63_);
	gala_access_portal_access_dialog (self, _ready_data->request_path, _ready_data->app_id, _ready_data->window_handle, _ready_data->title, _ready_data->sub_title, _ready_data->body, _ready_data->options, (GAsyncReadyCallback) _dbus_gala_access_portal_access_dialog_ready, _ready_data);
	_error:
	;
}

static void
_dbus_gala_access_portal_access_dialog_ready (GObject * source_object,
                                              GAsyncResult * _res_,
                                              gpointer _user_data_)
{
	GalaAccessPortalAccessDialogReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	guint response = 0U;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	gala_access_portal_access_dialog_finish ((GalaAccessPortal*) source_object, _res_, &response, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_uint32 (response));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->request_path);
	_g_free0 (_ready_data->app_id);
	_g_free0 (_ready_data->window_handle);
	_g_free0 (_ready_data->title);
	_g_free0 (_ready_data->sub_title);
	_g_free0 (_ready_data->body);
	_g_hash_table_unref0 (_ready_data->options);
	g_slice_free (GalaAccessPortalAccessDialogReadyData, _ready_data);
}

static void
gala_access_portal_dbus_interface_method_call (GDBusConnection* connection,
                                               const gchar* sender,
                                               const gchar* object_path,
                                               const gchar* interface_name,
                                               const gchar* method_name,
                                               GVariant* parameters,
                                               GDBusMethodInvocation* invocation,
                                               gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "AccessDialog") == 0) {
		_dbus_gala_access_portal_access_dialog (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
gala_access_portal_dbus_interface_get_property (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* property_name,
                                                GError** error,
                                                gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
gala_access_portal_dbus_interface_set_property (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* property_name,
                                                GVariant* value,
                                                GError** error,
                                                gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
gala_access_portal_register_object (gpointer object,
                                    GDBusConnection* connection,
                                    const gchar* path,
                                    GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_gala_access_portal_dbus_interface_info), &_gala_access_portal_dbus_interface_vtable, data, _gala_access_portal_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_gala_access_portal_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

void
gala_request_close (GalaRequest* self,
                    GError** error)
{
	GalaRequestIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GALA_REQUEST_GET_INTERFACE (self);
	if (_iface_->close) {
		_iface_->close (self, error);
	}
}

static void
gala_request_default_init (GalaRequestIface * iface,
                           gpointer iface_data)
{
}

static GType
gala_request_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaRequestIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_request_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType gala_request_type_id;
	gala_request_type_id = g_type_register_static (G_TYPE_INTERFACE, "GalaRequest", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (gala_request_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (gala_request_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) gala_request_proxy_get_type);
	g_type_set_qdata (gala_request_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.impl.portal.Request");
	g_type_set_qdata (gala_request_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_gala_request_dbus_interface_info));
	g_type_set_qdata (gala_request_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) gala_request_register_object);
	return gala_request_type_id;
}

GType
gala_request_get_type (void)
{
	static volatile gsize gala_request_type_id__once = 0;
	if (g_once_init_enter (&gala_request_type_id__once)) {
		GType gala_request_type_id;
		gala_request_type_id = gala_request_get_type_once ();
		g_once_init_leave (&gala_request_type_id__once, gala_request_type_id);
	}
	return gala_request_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (GalaRequestProxy, gala_request_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (GALA_TYPE_REQUEST, gala_request_proxy_gala_request_interface_init) )
static void
gala_request_proxy_class_init (GalaRequestProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = gala_request_proxy_g_signal;
}

static void
gala_request_proxy_g_signal (GDBusProxy* proxy,
                             const gchar* sender_name,
                             const gchar* signal_name,
                             GVariant* parameters)
{
}

static void
gala_request_proxy_init (GalaRequestProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_gala_request_dbus_interface_info));
}

static void
gala_request_proxy_close (GalaRequest* self,
                          GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.impl.portal.Request", "Close");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
gala_request_proxy_gala_request_interface_init (GalaRequestIface* iface)
{
	iface->close = gala_request_proxy_close;
}

static void
_dbus_gala_request_close (GalaRequest* self,
                          GVariant* _parameters_,
                          GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	gala_request_close (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
gala_request_dbus_interface_method_call (GDBusConnection* connection,
                                         const gchar* sender,
                                         const gchar* object_path,
                                         const gchar* interface_name,
                                         const gchar* method_name,
                                         GVariant* parameters,
                                         GDBusMethodInvocation* invocation,
                                         gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Close") == 0) {
		_dbus_gala_request_close (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
gala_request_dbus_interface_get_property (GDBusConnection* connection,
                                          const gchar* sender,
                                          const gchar* object_path,
                                          const gchar* interface_name,
                                          const gchar* property_name,
                                          GError** error,
                                          gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
gala_request_dbus_interface_set_property (GDBusConnection* connection,
                                          const gchar* sender,
                                          const gchar* object_path,
                                          const gchar* interface_name,
                                          const gchar* property_name,
                                          GVariant* value,
                                          GError** error,
                                          gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
gala_request_register_object (gpointer object,
                              GDBusConnection* connection,
                              const gchar* path,
                              GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_gala_request_dbus_interface_info), &_gala_request_dbus_interface_vtable, data, _gala_request_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_gala_request_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
gala_access_dialog_get_instance_private (GalaAccessDialog* self)
{
	return G_STRUCT_MEMBER_P (self, GalaAccessDialog_private_offset);
}

static void
__lambda139_ (void)
{
	GError* _inner_error0_ = NULL;
	{
		GalaAccessPortal* _tmp0_ = NULL;
		GalaAccessPortal* _tmp1_;
		GalaAccessPortal* _tmp2_;
		_tmp1_ = (GalaAccessPortal*) g_initable_new (GALA_TYPE_ACCESS_PORTAL_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", GALA_ACCESS_DIALOG_PANTHEON_PORTAL_NAME, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", GALA_ACCESS_DIALOG_FDO_PORTAL_PATH, "g-interface-name", "org.freedesktop.impl.portal.Access", NULL);
		_tmp0_ = (GalaAccessPortal*) _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (gala_access_dialog_portal);
		gala_access_dialog_portal = _tmp2_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("Dialogs.vala:50: can't reach portal session: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda139__gbus_name_appeared_callback (GDBusConnection* connection,
                                           const gchar* name,
                                           const gchar* name_owner,
                                           gpointer self)
{
	__lambda139_ ();
}

static void
__lambda140_ (void)
{
	_g_object_unref0 (gala_access_dialog_portal);
	gala_access_dialog_portal = NULL;
}

static void
___lambda140__gbus_name_vanished_callback (GDBusConnection* connection,
                                           const gchar* name,
                                           gpointer self)
{
	__lambda140_ ();
}

void
gala_access_dialog_watch_portal (void)
{
	g_bus_watch_name_with_closures (G_BUS_TYPE_SESSION, GALA_ACCESS_DIALOG_PANTHEON_PORTAL_NAME, G_BUS_NAME_WATCHER_FLAGS_NONE, (GClosure*) ((___lambda139__gbus_name_appeared_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda139__gbus_name_appeared_callback, NULL, (GClosureNotify) NULL)), (GClosure*) ((___lambda140__gbus_name_vanished_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda140__gbus_name_vanished_callback, NULL, (GClosureNotify) NULL)));
}

GalaAccessDialog*
gala_access_dialog_construct (GType object_type,
                              const gchar* title,
                              const gchar* body,
                              const gchar* icon)
{
	GalaAccessDialog * self = NULL;
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (body != NULL, NULL);
	g_return_val_if_fail (icon != NULL, NULL);
	self = (GalaAccessDialog*) g_object_new (object_type, "title", title, "body", body, "icon", icon, NULL);
	return self;
}

GalaAccessDialog*
gala_access_dialog_new (const gchar* title,
                        const gchar* body,
                        const gchar* icon)
{
	return gala_access_dialog_construct (GALA_TYPE_ACCESS_DIALOG, title, body, icon);
}

void
gala_access_dialog_close (GalaAccessDialog* self)
{
	const char* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->path;
	if (_tmp0_ != NULL) {
		{
			GalaRequest* request = NULL;
			const char* _tmp1_;
			GalaRequest* _tmp2_;
			GalaRequest* _tmp3_;
			_tmp1_ = self->path;
			_tmp2_ = (GalaRequest*) g_initable_new (GALA_TYPE_REQUEST_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", GALA_ACCESS_DIALOG_PANTHEON_PORTAL_NAME, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", (const gchar*) _tmp1_, "g-interface-name", "org.freedesktop.impl.portal.Request", NULL);
			request = (GalaRequest*) _tmp2_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp3_ = request;
			gala_request_close (_tmp3_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (request);
				goto __catch0_g_error;
			}
			_g_object_unref0 (request);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp4_;
			const gchar* _tmp5_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp4_ = e;
			_tmp5_ = _tmp4_->message;
			g_warning ("Dialogs.vala:99: %s", _tmp5_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_free0 (self->path);
		self->path = NULL;
	}
}

static void
gala_access_dialog_real_on_response (GalaAccessDialog* self,
                                     GObject* obj,
                                     GAsyncResult* res)
{
	guint ret = 0U;
	GError* _inner_error0_ = NULL;
	{
		GalaAccessPortal* _tmp0_;
		guint _tmp1_ = 0U;
		_tmp0_ = gala_access_dialog_portal;
		gala_access_portal_access_dialog_finish (_tmp0_, res, &_tmp1_, &_inner_error0_);
		ret = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("Dialogs.vala:112: %s", _tmp3_);
		ret = (guint) 2;
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_signal_emit (self, gala_access_dialog_signals[GALA_ACCESS_DIALOG_RESPONSE_SIGNAL], 0, ret);
	gala_access_dialog_close (self);
}

void
gala_access_dialog_on_response (GalaAccessDialog* self,
                                GObject* obj,
                                GAsyncResult* res)
{
	GalaAccessDialogClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = GALA_ACCESS_DIALOG_GET_CLASS (self);
	if (_klass_->on_response) {
		_klass_->on_response (self, obj, res);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

MetaWindow*
gala_access_dialog_get_parent (GalaAccessDialog* self)
{
	MetaWindow* result;
	MetaWindow* _tmp0_;
	MetaWindow* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_parent;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

void
gala_access_dialog_set_parent (GalaAccessDialog* self,
                               MetaWindow* value)
{
	MetaWindow* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_access_dialog_get_parent (self);
	if (old_value != value) {
		MetaWindow* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_parent);
		self->priv->_parent = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_access_dialog_properties[GALA_ACCESS_DIALOG_PARENT_PROPERTY]);
	}
	_g_object_unref0 (old_value);
}

const gchar*
gala_access_dialog_get_title (GalaAccessDialog* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_title;
	result = _tmp0_;
	return result;
}

static void
gala_access_dialog_set_title (GalaAccessDialog* self,
                              const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_access_dialog_get_title (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_title);
		self->priv->_title = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_access_dialog_properties[GALA_ACCESS_DIALOG_TITLE_PROPERTY]);
	}
}

const gchar*
gala_access_dialog_get_body (GalaAccessDialog* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_body;
	result = _tmp0_;
	return result;
}

static void
gala_access_dialog_set_body (GalaAccessDialog* self,
                             const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_access_dialog_get_body (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_body);
		self->priv->_body = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_access_dialog_properties[GALA_ACCESS_DIALOG_BODY_PROPERTY]);
	}
}

const gchar*
gala_access_dialog_get_icon (GalaAccessDialog* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon;
	result = _tmp0_;
	return result;
}

static void
gala_access_dialog_set_icon (GalaAccessDialog* self,
                             const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_access_dialog_get_icon (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_icon);
		self->priv->_icon = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_access_dialog_properties[GALA_ACCESS_DIALOG_ICON_PROPERTY]);
	}
}

const gchar*
gala_access_dialog_get_accept_label (GalaAccessDialog* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_accept_label;
	result = _tmp0_;
	return result;
}

void
gala_access_dialog_set_accept_label (GalaAccessDialog* self,
                                     const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_access_dialog_get_accept_label (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_accept_label);
		self->priv->_accept_label = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_access_dialog_properties[GALA_ACCESS_DIALOG_ACCEPT_LABEL_PROPERTY]);
	}
}

const gchar*
gala_access_dialog_get_deny_label (GalaAccessDialog* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_deny_label;
	result = _tmp0_;
	return result;
}

void
gala_access_dialog_set_deny_label (GalaAccessDialog* self,
                                   const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_access_dialog_get_deny_label (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_deny_label);
		self->priv->_deny_label = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_access_dialog_properties[GALA_ACCESS_DIALOG_DENY_LABEL_PROPERTY]);
	}
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_variant_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}

static GVariant*
_variant_new1 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new2 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new3 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new4 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static void
_gala_access_dialog_on_response_gasync_ready_callback (GObject* source_object,
                                                       GAsyncResult* res,
                                                       gpointer self)
{
	gala_access_dialog_on_response ((GalaAccessDialog*) self, source_object, res);
	g_object_unref (self);
}

static void
gala_access_dialog_real_show (GalaAccessDialog* self)
{
	GalaAccessPortal* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	char* _tmp5_;
	gchar* parent_handler = NULL;
	gchar* _tmp6_;
	gchar* app_id = NULL;
	gchar* _tmp7_;
	MetaWindow* _tmp8_;
	MetaWindow* _tmp9_;
	MetaWindow* _tmp10_;
	gboolean _tmp11_;
	GHashTable* options = NULL;
	GHashFunc _tmp27_;
	GEqualFunc _tmp28_;
	GHashTable* _tmp29_;
	GHashTable* _tmp30_;
	gchar* _tmp31_;
	const gchar* _tmp32_;
	GVariant* _tmp33_;
	GHashTable* _tmp34_;
	gchar* _tmp35_;
	const gchar* _tmp36_;
	GVariant* _tmp37_;
	GHashTable* _tmp38_;
	gchar* _tmp39_;
	const gchar* _tmp40_;
	GVariant* _tmp41_;
	GalaAccessPortal* _tmp45_;
	const char* _tmp46_;
	const gchar* _tmp47_;
	const gchar* _tmp48_;
	const gchar* _tmp49_;
	const gchar* _tmp50_;
	GHashTable* _tmp51_;
	_tmp0_ = gala_access_dialog_portal;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = g_strdup_printf ("/%i", (gint) g_random_int_range ((gint32) 0, (gint32) G_MAXINT));
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (GALA_ACCESS_DIALOG_GALA_DIALOG_PATH, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 (self->path);
	self->path = _tmp5_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_tmp6_ = g_strdup ("");
	parent_handler = _tmp6_;
	_tmp7_ = g_strdup ("");
	app_id = _tmp7_;
	_tmp8_ = gala_access_dialog_get_parent (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = _tmp9_;
	_tmp11_ = _tmp10_ != NULL;
	_g_object_unref0 (_tmp10_);
	if (_tmp11_) {
		MetaWindow* _tmp12_;
		MetaWindow* _tmp13_;
		MetaWindow* _tmp14_;
		gboolean _tmp15_;
		const gchar* _tmp20_ = NULL;
		MetaWindow* _tmp21_;
		MetaWindow* _tmp22_;
		MetaWindow* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		gchar* _tmp26_;
		_tmp12_ = gala_access_dialog_get_parent (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = _tmp13_;
		_tmp15_ = meta_window_get_client_type (_tmp14_) == META_WINDOW_CLIENT_TYPE_X11;
		_g_object_unref0 (_tmp14_);
		if (_tmp15_) {
			MetaWindow* _tmp16_;
			MetaWindow* _tmp17_;
			MetaWindow* _tmp18_;
			gchar* _tmp19_;
			_tmp16_ = gala_access_dialog_get_parent (self);
			_tmp17_ = _tmp16_;
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strdup_printf ("x11:%x", (guint) meta_window_get_xwindow (_tmp18_));
			_g_free0 (parent_handler);
			parent_handler = _tmp19_;
			_g_object_unref0 (_tmp18_);
		}
		_tmp21_ = gala_access_dialog_get_parent (self);
		_tmp22_ = _tmp21_;
		_tmp23_ = _tmp22_;
		_tmp24_ = meta_window_get_sandboxed_app_id (_tmp23_);
		_tmp25_ = _tmp24_;
		_g_object_unref0 (_tmp23_);
		_tmp20_ = _tmp25_;
		if (_tmp20_ == NULL) {
			_tmp20_ = "";
		}
		_tmp26_ = g_strdup (_tmp20_);
		_g_free0 (app_id);
		app_id = _tmp26_;
	}
	_tmp27_ = g_str_hash;
	_tmp28_ = g_str_equal;
	_tmp29_ = g_hash_table_new_full (_tmp27_, _tmp28_, _g_free0_, _g_variant_unref0_);
	options = _tmp29_;
	_tmp30_ = options;
	_tmp31_ = g_strdup ("grant_label");
	_tmp32_ = self->priv->_accept_label;
	_tmp33_ = _variant_new1 (_tmp32_);
	g_hash_table_insert (_tmp30_, _tmp31_, _tmp33_);
	_tmp34_ = options;
	_tmp35_ = g_strdup ("deny_label");
	_tmp36_ = self->priv->_deny_label;
	_tmp37_ = _variant_new2 (_tmp36_);
	g_hash_table_insert (_tmp34_, _tmp35_, _tmp37_);
	_tmp38_ = options;
	_tmp39_ = g_strdup ("icon");
	_tmp40_ = self->priv->_icon;
	_tmp41_ = _variant_new3 (_tmp40_);
	g_hash_table_insert (_tmp38_, _tmp39_, _tmp41_);
	if (GALA_IS_CLOSE_DIALOG (self)) {
		GHashTable* _tmp42_;
		gchar* _tmp43_;
		GVariant* _tmp44_;
		_tmp42_ = options;
		_tmp43_ = g_strdup ("destructive");
		_tmp44_ = _variant_new4 (TRUE);
		g_hash_table_insert (_tmp42_, _tmp43_, _tmp44_);
	}
	_tmp45_ = gala_access_dialog_portal;
	_tmp46_ = self->path;
	_tmp47_ = app_id;
	_tmp48_ = parent_handler;
	_tmp49_ = self->priv->_title;
	_tmp50_ = self->priv->_body;
	_tmp51_ = options;
	gala_access_portal_access_dialog (_tmp45_, _tmp46_, _tmp47_, _tmp48_, _tmp49_, _tmp50_, "", _tmp51_, _gala_access_dialog_on_response_gasync_ready_callback, g_object_ref (self));
	_g_hash_table_unref0 (options);
	_g_free0 (app_id);
	_g_free0 (parent_handler);
}

static void
gala_access_dialog_class_init (GalaAccessDialogClass * klass,
                               gpointer klass_data)
{
	gala_access_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaAccessDialog_private_offset);
	((GalaAccessDialogClass *) klass)->on_response = (void (*) (GalaAccessDialog*, GObject*, GAsyncResult*)) gala_access_dialog_real_on_response;
	((GalaAccessDialogClass *) klass)->show = gala_access_dialog_real_show;
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_access_dialog_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_access_dialog_set_property;
	G_OBJECT_CLASS (klass)->finalize = gala_access_dialog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_ACCESS_DIALOG_PARENT_PROPERTY, gala_access_dialog_properties[GALA_ACCESS_DIALOG_PARENT_PROPERTY] = g_param_spec_object ("parent", "parent", "parent", meta_window_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_ACCESS_DIALOG_TITLE_PROPERTY, gala_access_dialog_properties[GALA_ACCESS_DIALOG_TITLE_PROPERTY] = g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_ACCESS_DIALOG_BODY_PROPERTY, gala_access_dialog_properties[GALA_ACCESS_DIALOG_BODY_PROPERTY] = g_param_spec_string ("body", "body", "body", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_ACCESS_DIALOG_ICON_PROPERTY, gala_access_dialog_properties[GALA_ACCESS_DIALOG_ICON_PROPERTY] = g_param_spec_string ("icon", "icon", "icon", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_ACCESS_DIALOG_ACCEPT_LABEL_PROPERTY, gala_access_dialog_properties[GALA_ACCESS_DIALOG_ACCEPT_LABEL_PROPERTY] = g_param_spec_string ("accept-label", "accept-label", "accept-label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_ACCESS_DIALOG_DENY_LABEL_PROPERTY, gala_access_dialog_properties[GALA_ACCESS_DIALOG_DENY_LABEL_PROPERTY] = g_param_spec_string ("deny-label", "deny-label", "deny-label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gala_access_dialog_signals[GALA_ACCESS_DIALOG_RESPONSE_SIGNAL] = g_signal_new ("response", GALA_TYPE_ACCESS_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
	gala_access_dialog_signals[GALA_ACCESS_DIALOG_SHOW_SIGNAL] = g_signal_new ("show", GALA_TYPE_ACCESS_DIALOG, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GalaAccessDialogClass, show), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
gala_access_dialog_instance_init (GalaAccessDialog * self,
                                  gpointer klass)
{
	self->priv = gala_access_dialog_get_instance_private (self);
	self->path = NULL;
}

static void
gala_access_dialog_finalize (GObject * obj)
{
	GalaAccessDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_ACCESS_DIALOG, GalaAccessDialog);
	_g_object_unref0 (self->priv->_parent);
	_g_free0 (self->priv->_title);
	_g_free0 (self->priv->_body);
	_g_free0 (self->priv->_icon);
	_g_free0 (self->priv->_accept_label);
	_g_free0 (self->priv->_deny_label);
	_g_free0 (self->path);
	G_OBJECT_CLASS (gala_access_dialog_parent_class)->finalize (obj);
}

static GType
gala_access_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaAccessDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_access_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaAccessDialog), 0, (GInstanceInitFunc) gala_access_dialog_instance_init, NULL };
	GType gala_access_dialog_type_id;
	gala_access_dialog_type_id = g_type_register_static (G_TYPE_OBJECT, "GalaAccessDialog", &g_define_type_info, 0);
	GalaAccessDialog_private_offset = g_type_add_instance_private (gala_access_dialog_type_id, sizeof (GalaAccessDialogPrivate));
	return gala_access_dialog_type_id;
}

GType
gala_access_dialog_get_type (void)
{
	static volatile gsize gala_access_dialog_type_id__once = 0;
	if (g_once_init_enter (&gala_access_dialog_type_id__once)) {
		GType gala_access_dialog_type_id;
		gala_access_dialog_type_id = gala_access_dialog_get_type_once ();
		g_once_init_leave (&gala_access_dialog_type_id__once, gala_access_dialog_type_id);
	}
	return gala_access_dialog_type_id__once;
}

static void
_vala_gala_access_dialog_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	GalaAccessDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_ACCESS_DIALOG, GalaAccessDialog);
	switch (property_id) {
		case GALA_ACCESS_DIALOG_PARENT_PROPERTY:
		g_value_take_object (value, gala_access_dialog_get_parent (self));
		break;
		case GALA_ACCESS_DIALOG_TITLE_PROPERTY:
		g_value_set_string (value, gala_access_dialog_get_title (self));
		break;
		case GALA_ACCESS_DIALOG_BODY_PROPERTY:
		g_value_set_string (value, gala_access_dialog_get_body (self));
		break;
		case GALA_ACCESS_DIALOG_ICON_PROPERTY:
		g_value_set_string (value, gala_access_dialog_get_icon (self));
		break;
		case GALA_ACCESS_DIALOG_ACCEPT_LABEL_PROPERTY:
		g_value_set_string (value, gala_access_dialog_get_accept_label (self));
		break;
		case GALA_ACCESS_DIALOG_DENY_LABEL_PROPERTY:
		g_value_set_string (value, gala_access_dialog_get_deny_label (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_access_dialog_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	GalaAccessDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_ACCESS_DIALOG, GalaAccessDialog);
	switch (property_id) {
		case GALA_ACCESS_DIALOG_PARENT_PROPERTY:
		gala_access_dialog_set_parent (self, g_value_get_object (value));
		break;
		case GALA_ACCESS_DIALOG_TITLE_PROPERTY:
		gala_access_dialog_set_title (self, g_value_get_string (value));
		break;
		case GALA_ACCESS_DIALOG_BODY_PROPERTY:
		gala_access_dialog_set_body (self, g_value_get_string (value));
		break;
		case GALA_ACCESS_DIALOG_ICON_PROPERTY:
		gala_access_dialog_set_icon (self, g_value_get_string (value));
		break;
		case GALA_ACCESS_DIALOG_ACCEPT_LABEL_PROPERTY:
		gala_access_dialog_set_accept_label (self, g_value_get_string (value));
		break;
		case GALA_ACCESS_DIALOG_DENY_LABEL_PROPERTY:
		gala_access_dialog_set_deny_label (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

GalaCloseDialog*
gala_close_dialog_construct (GType object_type,
                             MetaWindow* window)
{
	GalaCloseDialog * self = NULL;
	g_return_val_if_fail (window != NULL, NULL);
	self = (GalaCloseDialog*) g_object_new (object_type, "window", window, NULL);
	return self;
}

GalaCloseDialog*
gala_close_dialog_new (MetaWindow* window)
{
	return gala_close_dialog_construct (GALA_TYPE_CLOSE_DIALOG, window);
}

static void
gala_close_dialog_real_show (MetaCloseDialog* base)
{
	GalaCloseDialog * self;
	const char* _tmp0_;
	self = (GalaCloseDialog*) base;
	_tmp0_ = ((GalaAccessDialog*) self)->path;
	if (_tmp0_ != NULL) {
		meta_close_dialog_focus ((MetaCloseDialog*) self);
	}
	GALA_ACCESS_DIALOG_CLASS (gala_close_dialog_parent_class)->show (G_TYPE_CHECK_INSTANCE_CAST (self, GALA_TYPE_ACCESS_DIALOG, GalaAccessDialog));
}

static void
gala_close_dialog_real_hide (MetaCloseDialog* base)
{
	GalaCloseDialog * self;
	self = (GalaCloseDialog*) base;
	gala_access_dialog_close ((GalaAccessDialog*) self);
}

static gboolean
__lambda141_ (GalaCloseDialog* self,
              MetaWindow* w)
{
	const gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	_tmp0_ = meta_window_get_role (w);
	if (g_strcmp0 (_tmp0_, "AccessDialog") == 0) {
		MetaDisplay* _tmp1_;
		_tmp1_ = meta_window_get_display (w);
		meta_window_activate (w, meta_display_get_current_time (_tmp1_));
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

static gboolean
___lambda141__meta_window_foreach_func (MetaWindow* window,
                                        gpointer self)
{
	gboolean result;
	result = __lambda141_ ((GalaCloseDialog*) self, window);
	return result;
}

static void
gala_close_dialog_real_focus (MetaCloseDialog* base)
{
	GalaCloseDialog * self;
	const char* _tmp0_;
	MetaWindow* _tmp1_;
	MetaWindow* _tmp2_;
	MetaWindow* _tmp3_;
	self = (GalaCloseDialog*) base;
	_tmp0_ = ((GalaAccessDialog*) self)->path;
	if (_tmp0_ == NULL) {
		return;
	}
	g_object_get ((MetaCloseDialog*) self, "window", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	meta_window_foreach_transient (_tmp3_, ___lambda141__meta_window_foreach_func, self);
	_g_object_unref0 (_tmp3_);
}

static void
gala_close_dialog_real_on_response (GalaAccessDialog* base,
                                    GObject* obj,
                                    GAsyncResult* res)
{
	GalaCloseDialog * self;
	guint ret = 0U;
	GError* _inner_error0_ = NULL;
	self = (GalaCloseDialog*) base;
	ret = (guint) 2;
	{
		GalaAccessPortal* _tmp0_;
		guint _tmp1_ = 0U;
		_tmp0_ = gala_access_dialog_portal;
		gala_access_portal_access_dialog_finish (_tmp0_, res, &_tmp1_, &_inner_error0_);
		ret = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("Dialogs.vala:198: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	if (ret == ((guint) 0)) {
		g_signal_emit_by_name (self, "response", META_CLOSE_DIALOG_RESPONSE_FORCE_CLOSE, NULL);
	} else {
		g_signal_emit_by_name (self, "response", META_CLOSE_DIALOG_RESPONSE_WAIT, NULL);
	}
	gala_access_dialog_close ((GalaAccessDialog*) self);
}

static MetaWindow*
gala_close_dialog_real_get_window (MetaCloseDialog* base)
{
	MetaWindow* result;
	GalaCloseDialog* self;
	MetaWindow* _tmp0_;
	MetaWindow* _tmp1_;
	self = (GalaCloseDialog*) base;
	_tmp0_ = gala_access_dialog_get_parent ((GalaAccessDialog*) self);
	_tmp1_ = _tmp0_;
	result = _tmp1_;
	return result;
}

static void
gala_close_dialog_real_set_window (MetaCloseDialog* base,
                                   MetaWindow* value)
{
	GalaCloseDialog* self;
	self = (GalaCloseDialog*) base;
	gala_access_dialog_set_parent ((GalaAccessDialog*) self, value);
	g_object_notify_by_pspec ((GObject *) self, gala_close_dialog_properties[GALA_CLOSE_DIALOG_WINDOW_PROPERTY]);
}

static GObject *
gala_close_dialog_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaCloseDialog * self;
	gchar* _tmp0_ = NULL;
	MetaWindow* _tmp1_;
	MetaWindow* _tmp2_;
	MetaWindow* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* window_title = NULL;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	GeeSet* _tmp18_;
	parent_class = G_OBJECT_CLASS (gala_close_dialog_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_CLOSE_DIALOG, GalaCloseDialog);
	gala_access_dialog_set_icon ((GalaAccessDialog*) self, "computer-fail");
	g_object_get ((MetaCloseDialog*) self, "window", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = meta_window_get_title (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_locale_from_utf8 (_tmp5_, (gssize) -1, NULL, NULL, NULL);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp3_);
	_tmp0_ = _tmp7_;
	if (_tmp0_ == NULL) {
		MetaWindow* _tmp8_;
		MetaWindow* _tmp9_;
		MetaWindow* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		g_object_get ((MetaCloseDialog*) self, "window", &_tmp8_, NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = _tmp9_;
		_tmp11_ = meta_window_get_sandboxed_app_id (_tmp10_);
		_tmp12_ = g_strdup (_tmp11_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp12_;
		_g_object_unref0 (_tmp10_);
	}
	_tmp13_ = _tmp0_;
	_tmp0_ = NULL;
	window_title = _tmp13_;
	_tmp14_ = window_title;
	if (_tmp14_ != NULL) {
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp15_ = window_title;
		_tmp16_ = g_strdup_printf (_ ("“%s” is not responding"), _tmp15_);
		_tmp17_ = _tmp16_;
		gala_access_dialog_set_title ((GalaAccessDialog*) self, _tmp17_);
		_g_free0 (_tmp17_);
	} else {
		gala_access_dialog_set_title ((GalaAccessDialog*) self, _ ("Application is not responding"));
	}
	gala_access_dialog_set_body ((GalaAccessDialog*) self, _ ("You may choose to wait a short while for it to continue or force the a" \
"pplication quit entirely."));
	gala_access_dialog_set_accept_label ((GalaAccessDialog*) self, _ ("Force Quit"));
	gala_access_dialog_set_deny_label ((GalaAccessDialog*) self, _ ("Wait"));
	_tmp18_ = gala_close_dialog_open_dialogs;
	gee_collection_add ((GeeCollection*) _tmp18_, self);
	_g_free0 (window_title);
	_g_free0 (_tmp0_);
	return obj;
}

static void
gala_close_dialog_class_init (GalaCloseDialogClass * klass,
                              gpointer klass_data)
{
	GeeHashSet* _tmp0_;
	gala_close_dialog_parent_class = g_type_class_peek_parent (klass);
	((GalaAccessDialogClass *) klass)->on_response = (void (*) (GalaAccessDialog*, GObject*, GAsyncResult*)) gala_close_dialog_real_on_response;
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_close_dialog_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_close_dialog_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_close_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_close_dialog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_CLOSE_DIALOG_WINDOW_PROPERTY, gala_close_dialog_properties[GALA_CLOSE_DIALOG_WINDOW_PROPERTY] = g_param_spec_object ("window", "window", "window", meta_window_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	_tmp0_ = gee_hash_set_new (GALA_TYPE_CLOSE_DIALOG, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	gala_close_dialog_open_dialogs = (GeeSet*) _tmp0_;
}

static void
gala_close_dialog_meta_close_dialog_interface_init (MetaCloseDialogInterface * iface,
                                                    gpointer iface_data)
{
	gala_close_dialog_meta_close_dialog_parent_iface = g_type_interface_peek_parent (iface);
	iface->show = (void (*) (MetaCloseDialog*)) gala_close_dialog_real_show;
	iface->hide = (void (*) (MetaCloseDialog*)) gala_close_dialog_real_hide;
	iface->focus = (void (*) (MetaCloseDialog*)) gala_close_dialog_real_focus;
}

static void
gala_close_dialog_instance_init (GalaCloseDialog * self,
                                 gpointer klass)
{
}

static void
gala_close_dialog_finalize (GObject * obj)
{
	GalaCloseDialog * self;
	GeeSet* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_CLOSE_DIALOG, GalaCloseDialog);
	_tmp0_ = gala_close_dialog_open_dialogs;
	gee_collection_remove ((GeeCollection*) _tmp0_, self);
	G_OBJECT_CLASS (gala_close_dialog_parent_class)->finalize (obj);
}

static GType
gala_close_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaCloseDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_close_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaCloseDialog), 0, (GInstanceInitFunc) gala_close_dialog_instance_init, NULL };
	static const GInterfaceInfo meta_close_dialog_info = { (GInterfaceInitFunc) gala_close_dialog_meta_close_dialog_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gala_close_dialog_type_id;
	gala_close_dialog_type_id = g_type_register_static (GALA_TYPE_ACCESS_DIALOG, "GalaCloseDialog", &g_define_type_info, 0);
	g_type_add_interface_static (gala_close_dialog_type_id, meta_close_dialog_get_type (), &meta_close_dialog_info);
	return gala_close_dialog_type_id;
}

GType
gala_close_dialog_get_type (void)
{
	static volatile gsize gala_close_dialog_type_id__once = 0;
	if (g_once_init_enter (&gala_close_dialog_type_id__once)) {
		GType gala_close_dialog_type_id;
		gala_close_dialog_type_id = gala_close_dialog_get_type_once ();
		g_once_init_leave (&gala_close_dialog_type_id__once, gala_close_dialog_type_id);
	}
	return gala_close_dialog_type_id__once;
}

static void
_vala_gala_close_dialog_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	GalaCloseDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_CLOSE_DIALOG, GalaCloseDialog);
	switch (property_id) {
		case GALA_CLOSE_DIALOG_WINDOW_PROPERTY:
		g_value_take_object (value, gala_close_dialog_real_get_window ((MetaCloseDialog*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_close_dialog_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	GalaCloseDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_CLOSE_DIALOG, GalaCloseDialog);
	switch (property_id) {
		case GALA_CLOSE_DIALOG_WINDOW_PROPERTY:
		gala_close_dialog_real_set_window ((MetaCloseDialog*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

