"use strict";

var _cozydb = _interopRequireDefault(require("cozydb"));

var _path = _interopRequireDefault(require("path"));

var _pouchdb = _interopRequireDefault(require("pouchdb"));

var fs = _interopRequireWildcard(require("fs"));

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function configureCozyDB(options) {
  return new Promise((resolve, reject) => {
    _cozydb.default.configure(options, null, err => {
      if (err) {
        return reject(err);
      }

      resolve();
    });
  });
}

function runHelper(_x, _x2) {
  return _runHelper.apply(this, arguments);
}

function _runHelper() {
  _runHelper = _asyncToGenerator(function* (options, cleanPassword) {
    options.name = 'Kresus';
    options.root = options.root || _path.default.join(__dirname, '..'); // eslint-disable-next-line camelcase

    options.db = new _pouchdb.default(options.dbName);
    options.modelsPath = _path.default.join(__dirname, 'models', 'pouch');
    yield configureCozyDB(options);

    let all = require('./all');

    let jsonOutput = yield all.getAllData(0,
    /* isExport */
    true, cleanPassword);
    return jsonOutput;
  });
  return _runHelper.apply(this, arguments);
}

function run(_x3) {
  return _run.apply(this, arguments);
}

function _run() {
  _run = _asyncToGenerator(function* (options) {
    return yield runHelper(options,
    /* cleanPassword */
    false);
  });
  return _run.apply(this, arguments);
}

function main(_x4, _x5) {
  return _main.apply(this, arguments);
}

function _main() {
  _main = _asyncToGenerator(function* (options, outputFile) {
    let jsonOutput = yield runHelper(options,
    /* cleanPassword */
    true);
    let textOutput = JSON.stringify(jsonOutput, null, 2);
    fs.writeFileSync(outputFile, textOutput);
  });
  return _main.apply(this, arguments);
}

module.exports = {
  main,
  run
};