/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import javax.management.ObjectName;
import org.languagetool.JLanguageTool;
import org.languagetool.server.ActiveRules;
import org.languagetool.server.DatabaseAccess;
import org.languagetool.server.ErrorRequestLimiter;
import org.languagetool.server.HTTPServerConfig;
import org.languagetool.server.LanguageToolHttpHandler;
import org.languagetool.server.PortBindingException;
import org.languagetool.server.RequestLimiter;
import org.languagetool.server.Server;
import org.languagetool.server.ServerMetricsCollector;
import org.languagetool.server.ServerTools;
import org.languagetool.tools.Tools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPServer
extends Server {
    private static final Logger log = LoggerFactory.getLogger(HTTPServer.class);
    private final ThreadPoolExecutor executorService;

    public HTTPServer() {
        this(new HTTPServerConfig());
    }

    public HTTPServer(HTTPServerConfig config) {
        this(config, false, DEFAULT_ALLOWED_IPS);
    }

    public HTTPServer(HTTPServerConfig config, boolean runInternally) {
        this(config, runInternally, "localhost", DEFAULT_ALLOWED_IPS);
    }

    public HTTPServer(HTTPServerConfig config, boolean runInternally, Set<String> allowedIps) {
        this(config, runInternally, "localhost", allowedIps);
    }

    public HTTPServer(HTTPServerConfig config, boolean runInternally, String host, Set<String> allowedIps) {
        this.port = config.getPort();
        this.host = host;
        try {
            if (System.getProperty("monitorActiveRules") != null) {
                ManagementFactory.getPlatformMBeanServer().registerMBean(new ActiveRules(), ObjectName.getInstance("org.languagetool:name=ActiveRules, type=ActiveRules"));
            }
            RequestLimiter limiter = this.getRequestLimiterOrNull(config);
            ErrorRequestLimiter errorLimiter = this.getErrorRequestLimiterOrNull(config);
            this.executorService = this.getExecutorService(config);
            BlockingQueue<Runnable> workQueue = this.executorService.getQueue();
            this.httpHandler = new LanguageToolHttpHandler(config, allowedIps, runInternally, limiter, errorLimiter, workQueue, this);
            if (this.port == 0) {
                int minPort = config.getMinPort();
                int maxPort = config.getMaxPort();
                this.port = this.getPortFromRange(minPort, maxPort);
            }
            InetSocketAddress address = host != null ? new InetSocketAddress(host, this.port) : new InetSocketAddress(this.port);
            this.server = HttpServer.create(address, 0);
            this.server.createContext("/", this.httpHandler);
            this.server.setExecutor(this.executorService);
            if (config.isPrometheusMonitoring()) {
                ServerMetricsCollector.init(config);
            }
        }
        catch (Exception e) {
            ResourceBundle messages = JLanguageTool.getMessageBundle();
            String message = Tools.i18n(messages, "http_server_start_failed", host, Integer.toString(this.port));
            throw new PortBindingException(message, e);
        }
    }

    private int getPortFromRange(int minPort, int maxPort) throws IOException {
        if (minPort > 0 && minPort < maxPort) {
            log.info("Try to find a free Port for Server in range {}-{}", (Object)minPort, (Object)maxPort);
            for (int p = minPort; p <= maxPort; ++p) {
                try {
                    log.info("Check port {}", (Object)p);
                    ServerSocket serverSocket = new ServerSocket(p);
                    this.port = serverSocket.getLocalPort();
                    serverSocket.close();
                    log.info("Port {} is available.", (Object)p);
                    return p;
                }
                catch (IOException ex) {
                    log.debug("Port {} is not available.", (Object)p);
                    continue;
                }
            }
            throw new IOException("No free port in range (" + minPort + " - " + maxPort + ") found.");
        }
        throw new IOException("Invalid port configuration found. The value for '--port' need to be greater than 0 or if set to 0 you need to specify a minPort and maxPort in your properties file (minPort must be lower that maxPort).");
    }

    @Override
    public void stop() {
        super.stop();
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
    }

    public static void main(String[] args) {
        if (HTTPServer.usageRequested(args)) {
            System.out.println("Usage: " + HTTPServer.class.getSimpleName() + " [--config propertyFile] [--port|-p port] [--public]");
            System.out.println("  --config FILE  a Java property file (one key=value entry per line) with values for:");
            HTTPServer.printCommonConfigFileOptions();
            HTTPServer.printCommonOptions();
            System.exit(1);
        }
        HTTPServerConfig config = new HTTPServerConfig(args);
        DatabaseAccess.init(config);
        try {
            HTTPServer server;
            HTTPServer.checkForNonRootUser();
            if (config.isPublicAccess()) {
                ServerTools.print("WARNING: running in HTTP mode, consider running LanguageTool behind a reverse proxy that takes care of encryption (HTTPS)");
                ServerTools.print("WARNING: running in public mode, LanguageTool API can be accessed without restrictions!");
                server = new HTTPServer(config, false, null, null);
            } else {
                server = new HTTPServer(config, false, "localhost", DEFAULT_ALLOWED_IPS);
            }
            server.run();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not start LanguageTool HTTP server on localhost, port " + config.getPort(), e);
        }
    }

    @Override
    protected String getProtocol() {
        return "http";
    }
}

