import { EphemeralEvent, WeakEvent } from "../event-types";
import { Request } from "./request";
/**
 * Incoming event from the homeserver.
 */
export declare class MatrixRequest<T> extends Request<T> {
    readonly event: T;
    constructor(event: T);
}
/**
 * A timeline event, such as a room timeline message.
 */
export declare class TimelineMatrixRequest extends MatrixRequest<WeakEvent> {
    readonly event: WeakEvent;
    constructor(event: WeakEvent);
    sender(): string;
    type(): string;
    stateKey(): string | undefined;
    roomId(): string;
    content(): Record<string, unknown>;
}
/**
 * Ephemeral event, such as a typing notification.
 */
export declare class EphemeralMatrixRequest extends MatrixRequest<EphemeralEvent> {
    readonly event: EphemeralEvent;
    constructor(event: EphemeralEvent);
    type(): string;
}
