/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.StringLocated;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.creole.atom.Atom;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.Line;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.security.SImageIO;
import net.sourceforge.plantuml.ugraphic.AffineTransformType;
import net.sourceforge.plantuml.ugraphic.PixelImage;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UImageSvg;

class EmbeddedDiagramDraw
extends AbstractTextBlock
implements Line,
Atom {
    private BufferedImage image;
    private final ISkinSimple skinParam;
    private final List<StringLocated> as2;

    @Override
    public List<Atom> splitInTwo(StringBounder stringBounder, double width) {
        return Arrays.asList(this);
    }

    EmbeddedDiagramDraw(ISkinSimple skinParam, List<StringLocated> as2) {
        this.skinParam = skinParam;
        this.as2 = as2;
    }

    @Override
    public double getStartingAltitude(StringBounder stringBounder) {
        return 0.0;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        try {
            BufferedImage im = this.getImage();
            return new Dimension2DDouble(im.getWidth(), im.getHeight());
        }
        catch (IOException e) {
            Logme.error(e);
        }
        catch (InterruptedException e) {
            Logme.error(e);
        }
        return new Dimension2DDouble(42.0, 42.0);
    }

    @Override
    public void drawU(UGraphic ug) {
        try {
            boolean isSvg = ug.matchesProperty("SVG");
            if (isSvg) {
                String imageSvg = this.getImageSvg();
                UImageSvg svg = new UImageSvg(imageSvg, 1.0);
                ug.draw(svg);
                return;
            }
            BufferedImage im = this.getImage();
            UImage image = new UImage(new PixelImage(im, AffineTransformType.TYPE_BILINEAR));
            ug.draw(image);
        }
        catch (IOException e) {
            Logme.error(e);
        }
        catch (InterruptedException e) {
            Logme.error(e);
        }
    }

    private String getImageSvg() throws IOException, InterruptedException {
        Diagram system = this.getSystem();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        system.exportDiagram(os, 0, new FileFormatOption(FileFormat.SVG));
        os.close();
        return new String(os.toByteArray());
    }

    private BufferedImage getImage() throws IOException, InterruptedException {
        if (this.image == null) {
            this.image = this.getImageSlow();
        }
        return this.image;
    }

    private BufferedImage getImageSlow() throws IOException, InterruptedException {
        Diagram system = this.getSystem();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        system.exportDiagram(os, 0, new FileFormatOption(FileFormat.PNG));
        os.close();
        return SImageIO.read(os.toByteArray());
    }

    @Override
    public HorizontalAlignment getHorizontalAlignment() {
        return HorizontalAlignment.LEFT;
    }

    private Diagram getSystem() throws IOException, InterruptedException {
        BlockUml blockUml = new BlockUml(this.skinParam.getThemeStyle(), this.as2, Defines.createEmpty(), this.skinParam, null, null);
        return blockUml.getDiagram();
    }
}

