/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project;

import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.api.ThemeStyle;
import net.sourceforge.plantuml.project.LoadPlanable;
import net.sourceforge.plantuml.project.OpenClose;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.time.DayOfWeek;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorSet;

public class TimeHeaderParameters {
    private final Map<Day, HColor> colorDays;
    private final ThemeStyle themeStyle;
    private final double scale;
    private final Day min;
    private final Day max;
    private final HColorSet colorSet;
    private final Style timelineStyle;
    private final Style closedStyle;
    private final Locale locale;
    private final OpenClose openClose;
    private final Map<DayOfWeek, HColor> colorDaysOfWeek;
    private final Set<Day> verticalSeparatorBefore;

    public TimeHeaderParameters(Map<Day, HColor> colorDays, ThemeStyle themeStyle, double scale, Day min, Day max, HColorSet colorSet, Style timelineStyle, Style closedStyle, Locale locale, OpenClose openClose, Map<DayOfWeek, HColor> colorDaysOfWeek, Set<Day> verticalSeparatorBefore) {
        this.colorDays = colorDays;
        this.themeStyle = themeStyle;
        this.scale = scale;
        this.min = min;
        this.max = max;
        this.colorSet = colorSet;
        this.timelineStyle = timelineStyle;
        this.closedStyle = closedStyle;
        this.locale = locale;
        this.openClose = openClose;
        this.colorDaysOfWeek = colorDaysOfWeek;
        this.verticalSeparatorBefore = verticalSeparatorBefore;
    }

    public HColor getColor(Day wink) {
        return this.colorDays.get(wink);
    }

    public HColor getColor(DayOfWeek dayOfWeek) {
        return this.colorDaysOfWeek.get((Object)dayOfWeek);
    }

    public ThemeStyle getThemeStyle() {
        return this.themeStyle;
    }

    public final double getScale() {
        return this.scale;
    }

    public final Day getMin() {
        return this.min;
    }

    public final Day getMax() {
        return this.max;
    }

    public final HColorSet getColorSet() {
        return this.colorSet;
    }

    public final Style getTimelineStyle() {
        return this.timelineStyle;
    }

    public final Style getClosedStyle() {
        return this.closedStyle;
    }

    public final Locale getLocale() {
        return this.locale;
    }

    public final LoadPlanable getLoadPlanable() {
        return this.openClose;
    }

    public Day getStartingDay() {
        return this.openClose.getStartingDay();
    }

    public final Set<Day> getVerticalSeparatorBefore() {
        return this.verticalSeparatorBefore;
    }
}

