/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.view;

import java.awt.event.HierarchyListener;
import org.protege.editor.owl.model.event.EventType;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.ui.view.AbstractOWLViewComponent;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;

public abstract class AbstractActiveOntologyViewComponent
extends AbstractOWLViewComponent {
    private OWLModelManagerListener owlModelManagerListener;
    private OWLOntologyChangeListener owlOntologyChangeListener;
    private HierarchyListener hierarchyListener;
    private boolean updateView;

    @Override
    protected final void initialiseOWLView() throws Exception {
        this.owlModelManagerListener = event -> {
            if (event.isType(EventType.ACTIVE_ONTOLOGY_CHANGED)) {
                this.updateView = true;
                this.markForUpdate();
            }
        };
        this.getOWLModelManager().addListener(this.owlModelManagerListener);
        this.owlOntologyChangeListener = changes -> {
            for (OWLOntologyChange chg : changes) {
                if (!chg.getOntology().equals(this.getOWLModelManager().getActiveOntology())) continue;
                this.updateView = true;
                this.markForUpdate();
                break;
            }
        };
        this.getOWLModelManager().addOntologyChangeListener(this.owlOntologyChangeListener);
        this.hierarchyListener = e -> this.markForUpdate();
        this.addHierarchyListener(this.hierarchyListener);
        this.initialiseOntologyView();
    }

    protected abstract void initialiseOntologyView() throws Exception;

    @Override
    protected final void disposeOWLView() {
        this.getOWLModelManager().removeListener(this.owlModelManagerListener);
        this.getOWLModelManager().removeOntologyChangeListener(this.owlOntologyChangeListener);
        this.disposeOntologyView();
    }

    protected abstract void disposeOntologyView();

    private void markForUpdate() {
        if (this.isShowing() && this.updateView) {
            try {
                if (this.isSynchronizing()) {
                    this.updateView(this.getOWLModelManager().getActiveOntology());
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.updateView = false;
        } else {
            this.updateView = true;
        }
    }

    protected abstract void updateView(OWLOntology var1) throws Exception;
}

