# frozen_string_literal: true

# Released under the MIT License.
# Copyright, 2019-2022, by Samuel Williams.

require 'async/http/body/hijack'
require 'protocol/http/response'
require 'protocol/websocket/headers'

module Async
	module WebSocket
		# The response from the server back to the client for negotiating HTTP/1.x WebSockets.
		class UpgradeResponse < ::Protocol::HTTP::Response
			include ::Protocol::WebSocket::Headers
			
			def initialize(request, headers = nil, protocol: nil, &block)
				headers = ::Protocol::HTTP::Headers[headers]
				
				if accept_nounce = request.headers[SEC_WEBSOCKET_KEY]&.first
					headers.add(SEC_WEBSOCKET_ACCEPT, Nounce.accept_digest(accept_nounce))
					status = 101
				else
					status = 400
				end
				
				if protocol
					headers.add(SEC_WEBSOCKET_PROTOCOL, protocol)
				end
				
				body = Async::HTTP::Body::Hijack.wrap(request, &block)
				super(request.version, status, headers, body, PROTOCOL)
			end
		end
	end
end
