require 'cucumber/messages/message'

# The code was auto-generated by {this script}[https://github.com/cucumber/messages/blob/main/jsonschema/scripts/codegen.rb]
#

module Cucumber
  module Messages


    ##
    # Represents the Attachment message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    # //// Attachments (parse errors, execution errors, screenshots, links...)
    # 
    # *
    #  An attachment represents any kind of data associated with a line in a
    #  [Source](#io.cucumber.messages.Source) file. It can be used for:
    # 
    #  * Syntax errors during parse time
    #  * Screenshots captured and attached during execution
    #  * Logs captured and attached during execution
    # 
    #  It is not to be used for runtime errors raised/thrown during execution. This
    #  is captured in `TestResult`.
    #

    class Attachment < ::Cucumber::Messages::Message

      ##
      # *
      #  The body of the attachment. If `contentEncoding` is `IDENTITY`, the attachment
      #  is simply the string. If it's `BASE64`, the string should be Base64 decoded to
      #  obtain the attachment.

      attr_reader :body

      ##
      # *
      #  Whether to interpret `body` "as-is" (IDENTITY) or if it needs to be Base64-decoded (BASE64).
      # 
      #  Content encoding is *not* determined by the media type, but rather by the type
      #  of the object being attached:
      # 
      #  - string => IDENTITY
      #  - byte array => BASE64
      #  - stream => BASE64

      attr_reader :content_encoding

      ##
      # *
      #  Suggested file name of the attachment. (Provided by the user as an argument to `attach`)

      attr_reader :file_name

      ##
      # *
      #  The media type of the data. This can be any valid
      #  [IANA Media Type](https://www.iana.org/assignments/media-types/media-types.xhtml)
      #  as well as Cucumber-specific media types such as `text/x.cucumber.gherkin+plain`
      #  and `text/x.cucumber.stacktrace+plain`

      attr_reader :media_type

      attr_reader :source

      attr_reader :test_case_started_id

      attr_reader :test_step_id

      ##
      # *
      #  A URL where the attachment can be retrieved. This field should not be set by Cucumber.
      #  It should be set by a program that reads a message stream and does the following for
      #  each Attachment message:
      # 
      #  - Writes the body (after base64 decoding if necessary) to a new file.
      #  - Sets `body` and `contentEncoding` to `null`
      #  - Writes out the new attachment message
      # 
      #  This will result in a smaller message stream, which can improve performance and
      #  reduce bandwidth of message consumers. It also makes it easier to process and download attachments
      #  separately from reports.

      attr_reader :url

      def initialize(
        body: '',
        content_encoding: AttachmentContentEncoding::IDENTITY,
        file_name: nil,
        media_type: '',
        source: nil,
        test_case_started_id: nil,
        test_step_id: nil,
        url: nil
      )
        @body = body
        @content_encoding = content_encoding
        @file_name = file_name
        @media_type = media_type
        @source = source
        @test_case_started_id = test_case_started_id
        @test_step_id = test_step_id
        @url = url
      end
    end


    ##
    # Represents the Duration message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    # The structure is pretty close of the Timestamp one. For clarity, a second type
    #  of message is used.
    #

    class Duration < ::Cucumber::Messages::Message

      attr_reader :seconds

      ##
      # Non-negative fractions of a second at nanosecond resolution. Negative
      #  second values with fractions must still have non-negative nanos values
      #  that count forward in time. Must be from 0 to 999,999,999
      #  inclusive.

      attr_reader :nanos

      def initialize(
        seconds: 0,
        nanos: 0
      )
        @seconds = seconds
        @nanos = nanos
      end
    end


    ##
    # Represents the Envelope message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    # When removing a field, replace it with reserved, rather than deleting the line.
    #  When adding a field, add it to the end and increment the number by one.
    #  See https://developers.google.com/protocol-buffers/docs/proto#updating for details
    # 
    # *
    #  All the messages that are passed between different components/processes are Envelope
    #  messages.
    #

    class Envelope < ::Cucumber::Messages::Message

      attr_reader :attachment

      attr_reader :gherkin_document

      attr_reader :hook

      attr_reader :meta

      attr_reader :parameter_type

      attr_reader :parse_error

      attr_reader :pickle

      attr_reader :source

      attr_reader :step_definition

      attr_reader :test_case

      attr_reader :test_case_finished

      attr_reader :test_case_started

      attr_reader :test_run_finished

      attr_reader :test_run_started

      attr_reader :test_step_finished

      attr_reader :test_step_started

      attr_reader :undefined_parameter_type

      def initialize(
        attachment: nil,
        gherkin_document: nil,
        hook: nil,
        meta: nil,
        parameter_type: nil,
        parse_error: nil,
        pickle: nil,
        source: nil,
        step_definition: nil,
        test_case: nil,
        test_case_finished: nil,
        test_case_started: nil,
        test_run_finished: nil,
        test_run_started: nil,
        test_step_finished: nil,
        test_step_started: nil,
        undefined_parameter_type: nil
      )
        @attachment = attachment
        @gherkin_document = gherkin_document
        @hook = hook
        @meta = meta
        @parameter_type = parameter_type
        @parse_error = parse_error
        @pickle = pickle
        @source = source
        @step_definition = step_definition
        @test_case = test_case
        @test_case_finished = test_case_finished
        @test_case_started = test_case_started
        @test_run_finished = test_run_finished
        @test_run_started = test_run_started
        @test_step_finished = test_step_finished
        @test_step_started = test_step_started
        @undefined_parameter_type = undefined_parameter_type
      end
    end


    ##
    # Represents the GherkinDocument message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    # *
    #  The [AST](https://en.wikipedia.org/wiki/Abstract_syntax_tree) of a Gherkin document.
    #  Cucumber implementations should *not* depend on `GherkinDocument` or any of its
    #  children for execution - use [Pickle](#io.cucumber.messages.Pickle) instead.
    # 
    #  The only consumers of `GherkinDocument` should only be formatters that produce
    #  "rich" output, resembling the original Gherkin document.
    #

    class GherkinDocument < ::Cucumber::Messages::Message

      ##
      # *
      #  The [URI](https://en.wikipedia.org/wiki/Uniform_Resource_Identifier)
      #  of the source, typically a file path relative to the root directory

      attr_reader :uri

      attr_reader :feature

      ##
      # All the comments in the Gherkin document

      attr_reader :comments

      def initialize(
        uri: nil,
        feature: nil,
        comments: []
      )
        @uri = uri
        @feature = feature
        @comments = comments
      end
    end


    ##
    # Represents the Background message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    
    #

    class Background < ::Cucumber::Messages::Message

      ##
      # The location of the `Background` keyword

      attr_reader :location

      attr_reader :keyword

      attr_reader :name

      attr_reader :description

      attr_reader :steps

      attr_reader :id

      def initialize(
        location: Location.new,
        keyword: '',
        name: '',
        description: '',
        steps: [],
        id: ''
      )
        @location = location
        @keyword = keyword
        @name = name
        @description = description
        @steps = steps
        @id = id
      end
    end


    ##
    # Represents the Comment message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    # *
    #  A comment in a Gherkin document
    #

    class Comment < ::Cucumber::Messages::Message

      ##
      # The location of the comment

      attr_reader :location

      ##
      # The text of the comment

      attr_reader :text

      def initialize(
        location: Location.new,
        text: ''
      )
        @location = location
        @text = text
      end
    end


    ##
    # Represents the DataTable message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    
    #

    class DataTable < ::Cucumber::Messages::Message

      attr_reader :location

      attr_reader :rows

      def initialize(
        location: Location.new,
        rows: []
      )
        @location = location
        @rows = rows
      end
    end


    ##
    # Represents the DocString message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    
    #

    class DocString < ::Cucumber::Messages::Message

      attr_reader :location

      attr_reader :media_type

      attr_reader :content

      attr_reader :delimiter

      def initialize(
        location: Location.new,
        media_type: nil,
        content: '',
        delimiter: ''
      )
        @location = location
        @media_type = media_type
        @content = content
        @delimiter = delimiter
      end
    end


    ##
    # Represents the Examples message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    
    #

    class Examples < ::Cucumber::Messages::Message

      ##
      # The location of the `Examples` keyword

      attr_reader :location

      attr_reader :tags

      attr_reader :keyword

      attr_reader :name

      attr_reader :description

      attr_reader :table_header

      attr_reader :table_body

      attr_reader :id

      def initialize(
        location: Location.new,
        tags: [],
        keyword: '',
        name: '',
        description: '',
        table_header: nil,
        table_body: [],
        id: ''
      )
        @location = location
        @tags = tags
        @keyword = keyword
        @name = name
        @description = description
        @table_header = table_header
        @table_body = table_body
        @id = id
      end
    end


    ##
    # Represents the Feature message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    
    #

    class Feature < ::Cucumber::Messages::Message

      ##
      # The location of the `Feature` keyword

      attr_reader :location

      ##
      # All the tags placed above the `Feature` keyword

      attr_reader :tags

      ##
      # The [ISO 639-1](https://en.wikipedia.org/wiki/ISO_639-1) language code of the Gherkin document

      attr_reader :language

      ##
      # The text of the `Feature` keyword (in the language specified by `language`)

      attr_reader :keyword

      ##
      # The name of the feature (the text following the `keyword`)

      attr_reader :name

      ##
      # The line(s) underneath the line with the `keyword` that are used as description

      attr_reader :description

      ##
      # Zero or more children

      attr_reader :children

      def initialize(
        location: Location.new,
        tags: [],
        language: '',
        keyword: '',
        name: '',
        description: '',
        children: []
      )
        @location = location
        @tags = tags
        @language = language
        @keyword = keyword
        @name = name
        @description = description
        @children = children
      end
    end


    ##
    # Represents the FeatureChild message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    # *
    #  A child node of a `Feature` node
    #

    class FeatureChild < ::Cucumber::Messages::Message

      attr_reader :rule

      attr_reader :background

      attr_reader :scenario

      def initialize(
        rule: nil,
        background: nil,
        scenario: nil
      )
        @rule = rule
        @background = background
        @scenario = scenario
      end
    end


    ##
    # Represents the Rule message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    
    #

    class Rule < ::Cucumber::Messages::Message

      ##
      # The location of the `Rule` keyword

      attr_reader :location

      ##
      # All the tags placed above the `Rule` keyword

      attr_reader :tags

      attr_reader :keyword

      attr_reader :name

      attr_reader :description

      attr_reader :children

      attr_reader :id

      def initialize(
        location: Location.new,
        tags: [],
        keyword: '',
        name: '',
        description: '',
        children: [],
        id: ''
      )
        @location = location
        @tags = tags
        @keyword = keyword
        @name = name
        @description = description
        @children = children
        @id = id
      end
    end


    ##
    # Represents the RuleChild message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    # *
    #  A child node of a `Rule` node
    #

    class RuleChild < ::Cucumber::Messages::Message

      attr_reader :background

      attr_reader :scenario

      def initialize(
        background: nil,
        scenario: nil
      )
        @background = background
        @scenario = scenario
      end
    end


    ##
    # Represents the Scenario message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    
    #

    class Scenario < ::Cucumber::Messages::Message

      ##
      # The location of the `Scenario` keyword

      attr_reader :location

      attr_reader :tags

      attr_reader :keyword

      attr_reader :name

      attr_reader :description

      attr_reader :steps

      attr_reader :examples

      attr_reader :id

      def initialize(
        location: Location.new,
        tags: [],
        keyword: '',
        name: '',
        description: '',
        steps: [],
        examples: [],
        id: ''
      )
        @location = location
        @tags = tags
        @keyword = keyword
        @name = name
        @description = description
        @steps = steps
        @examples = examples
        @id = id
      end
    end


    ##
    # Represents the Step message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    # A step
    #

    class Step < ::Cucumber::Messages::Message

      ##
      # The location of the steps' `keyword`

      attr_reader :location

      ##
      # The actual keyword as it appeared in the source.

      attr_reader :keyword

      ##
      # The test phase signalled by the keyword: Context definition (Given), Action performance (When), Outcome assertion (Then). Other keywords signal Continuation (And and But) from a prior keyword. Please note that all translations which a dialect maps to multiple keywords (`*` is in this category for all dialects), map to 'Unknown'.

      attr_reader :keyword_type

      attr_reader :text

      attr_reader :doc_string

      attr_reader :data_table

      ##
      # Unique ID to be able to reference the Step from PickleStep

      attr_reader :id

      def initialize(
        location: Location.new,
        keyword: '',
        keyword_type: nil,
        text: '',
        doc_string: nil,
        data_table: nil,
        id: ''
      )
        @location = location
        @keyword = keyword
        @keyword_type = keyword_type
        @text = text
        @doc_string = doc_string
        @data_table = data_table
        @id = id
      end
    end


    ##
    # Represents the TableCell message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    # A cell in a `TableRow`
    #

    class TableCell < ::Cucumber::Messages::Message

      ##
      # The location of the cell

      attr_reader :location

      ##
      # The value of the cell

      attr_reader :value

      def initialize(
        location: Location.new,
        value: ''
      )
        @location = location
        @value = value
      end
    end


    ##
    # Represents the TableRow message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    # A row in a table
    #

    class TableRow < ::Cucumber::Messages::Message

      ##
      # The location of the first cell in the row

      attr_reader :location

      ##
      # Cells in the row

      attr_reader :cells

      attr_reader :id

      def initialize(
        location: Location.new,
        cells: [],
        id: ''
      )
        @location = location
        @cells = cells
        @id = id
      end
    end


    ##
    # Represents the Tag message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    # *
    #  A tag
    #

    class Tag < ::Cucumber::Messages::Message

      ##
      # Location of the tag

      attr_reader :location

      ##
      # The name of the tag (including the leading `@`)

      attr_reader :name

      ##
      # Unique ID to be able to reference the Tag from PickleTag

      attr_reader :id

      def initialize(
        location: Location.new,
        name: '',
        id: ''
      )
        @location = location
        @name = name
        @id = id
      end
    end


    ##
    # Represents the Hook message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    
    #

    class Hook < ::Cucumber::Messages::Message

      attr_reader :id

      attr_reader :name

      attr_reader :source_reference

      attr_reader :tag_expression

      def initialize(
        id: '',
        name: nil,
        source_reference: SourceReference.new,
        tag_expression: nil
      )
        @id = id
        @name = name
        @source_reference = source_reference
        @tag_expression = tag_expression
      end
    end


    ##
    # Represents the Location message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    # *
    #  Points to a line and a column in a text file
    #

    class Location < ::Cucumber::Messages::Message

      attr_reader :line

      attr_reader :column

      def initialize(
        line: 0,
        column: nil
      )
        @line = line
        @column = column
      end
    end


    ##
    # Represents the Meta message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    # *
    #  This message contains meta information about the environment. Consumers can use
    #  this for various purposes.
    #

    class Meta < ::Cucumber::Messages::Message

      ##
      # *
      #  The [SEMVER](https://semver.org/) version number of the protocol

      attr_reader :protocol_version

      ##
      # SpecFlow, Cucumber-JVM, Cucumber.js, Cucumber-Ruby, Behat etc.

      attr_reader :implementation

      ##
      # Java, Ruby, Node.js etc

      attr_reader :runtime

      ##
      # Windows, Linux, MacOS etc

      attr_reader :os

      ##
      # 386, arm, amd64 etc

      attr_reader :cpu

      attr_reader :ci

      def initialize(
        protocol_version: '',
        implementation: Product.new,
        runtime: Product.new,
        os: Product.new,
        cpu: Product.new,
        ci: nil
      )
        @protocol_version = protocol_version
        @implementation = implementation
        @runtime = runtime
        @os = os
        @cpu = cpu
        @ci = ci
      end
    end


    ##
    # Represents the Ci message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    # CI environment
    #

    class Ci < ::Cucumber::Messages::Message

      ##
      # Name of the CI product, e.g. "Jenkins", "CircleCI" etc.

      attr_reader :name

      ##
      # Link to the build

      attr_reader :url

      ##
      # The build number. Some CI servers use non-numeric build numbers, which is why this is a string

      attr_reader :build_number

      attr_reader :git

      def initialize(
        name: '',
        url: nil,
        build_number: nil,
        git: nil
      )
        @name = name
        @url = url
        @build_number = build_number
        @git = git
      end
    end


    ##
    # Represents the Git message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    # Information about Git, provided by the Build/CI server as environment
    #  variables.
    #

    class Git < ::Cucumber::Messages::Message

      attr_reader :remote

      attr_reader :revision

      attr_reader :branch

      attr_reader :tag

      def initialize(
        remote: '',
        revision: '',
        branch: nil,
        tag: nil
      )
        @remote = remote
        @revision = revision
        @branch = branch
        @tag = tag
      end
    end


    ##
    # Represents the Product message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    # Used to describe various properties of Meta
    #

    class Product < ::Cucumber::Messages::Message

      ##
      # The product name

      attr_reader :name

      ##
      # The product version

      attr_reader :version

      def initialize(
        name: '',
        version: nil
      )
        @name = name
        @version = version
      end
    end


    ##
    # Represents the ParameterType message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    
    #

    class ParameterType < ::Cucumber::Messages::Message

      ##
      # The name is unique, so we don't need an id.

      attr_reader :name

      attr_reader :regular_expressions

      attr_reader :prefer_for_regular_expression_match

      attr_reader :use_for_snippets

      attr_reader :id

      def initialize(
        name: '',
        regular_expressions: [],
        prefer_for_regular_expression_match: false,
        use_for_snippets: false,
        id: ''
      )
        @name = name
        @regular_expressions = regular_expressions
        @prefer_for_regular_expression_match = prefer_for_regular_expression_match
        @use_for_snippets = use_for_snippets
        @id = id
      end
    end


    ##
    # Represents the ParseError message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    
    #

    class ParseError < ::Cucumber::Messages::Message

      attr_reader :source

      attr_reader :message

      def initialize(
        source: SourceReference.new,
        message: ''
      )
        @source = source
        @message = message
      end
    end


    ##
    # Represents the Pickle message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    # //// Pickles
    # 
    # *
    #  A `Pickle` represents a template for a `TestCase`. It is typically derived
    #  from another format, such as [GherkinDocument](#io.cucumber.messages.GherkinDocument).
    #  In the future a `Pickle` may be derived from other formats such as Markdown or
    #  Excel files.
    # 
    #  By making `Pickle` the main data structure Cucumber uses for execution, the
    #  implementation of Cucumber itself becomes simpler, as it doesn't have to deal
    #  with the complex structure of a [GherkinDocument](#io.cucumber.messages.GherkinDocument).
    # 
    #  Each `PickleStep` of a `Pickle` is matched with a `StepDefinition` to create a `TestCase`
    #

    class Pickle < ::Cucumber::Messages::Message

      ##
      # *
      #  A unique id for the pickle

      attr_reader :id

      ##
      # The uri of the source file

      attr_reader :uri

      ##
      # The name of the pickle

      attr_reader :name

      ##
      # The language of the pickle

      attr_reader :language

      ##
      # One or more steps

      attr_reader :steps

      ##
      # *
      #  One or more tags. If this pickle is constructed from a Gherkin document,
      #  It includes inherited tags from the `Feature` as well.

      attr_reader :tags

      ##
      # *
      #  Points to the AST node locations of the pickle. The last one represents the unique
      #  id of the pickle. A pickle constructed from `Examples` will have the first
      #  id originating from the `Scenario` AST node, and the second from the `TableRow` AST node.

      attr_reader :ast_node_ids

      def initialize(
        id: '',
        uri: '',
        name: '',
        language: '',
        steps: [],
        tags: [],
        ast_node_ids: []
      )
        @id = id
        @uri = uri
        @name = name
        @language = language
        @steps = steps
        @tags = tags
        @ast_node_ids = ast_node_ids
      end
    end


    ##
    # Represents the PickleDocString message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    
    #

    class PickleDocString < ::Cucumber::Messages::Message

      attr_reader :media_type

      attr_reader :content

      def initialize(
        media_type: nil,
        content: ''
      )
        @media_type = media_type
        @content = content
      end
    end


    ##
    # Represents the PickleStep message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    # *
    #  An executable step
    #

    class PickleStep < ::Cucumber::Messages::Message

      attr_reader :argument

      ##
      # References the IDs of the source of the step. For Gherkin, this can be
      #  the ID of a Step, and possibly also the ID of a TableRow

      attr_reader :ast_node_ids

      ##
      # A unique ID for the PickleStep

      attr_reader :id

      ##
      # The context in which the step was specified: context (Given), action (When) or outcome (Then).
      # 
      # Note that the keywords `But` and `And` inherit their meaning from prior steps and the `*` 'keyword' doesn't have specific meaning (hence Unknown)

      attr_reader :type

      attr_reader :text

      def initialize(
        argument: nil,
        ast_node_ids: [],
        id: '',
        type: nil,
        text: ''
      )
        @argument = argument
        @ast_node_ids = ast_node_ids
        @id = id
        @type = type
        @text = text
      end
    end


    ##
    # Represents the PickleStepArgument message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    # An optional argument
    #

    class PickleStepArgument < ::Cucumber::Messages::Message

      attr_reader :doc_string

      attr_reader :data_table

      def initialize(
        doc_string: nil,
        data_table: nil
      )
        @doc_string = doc_string
        @data_table = data_table
      end
    end


    ##
    # Represents the PickleTable message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    
    #

    class PickleTable < ::Cucumber::Messages::Message

      attr_reader :rows

      def initialize(
        rows: []
      )
        @rows = rows
      end
    end


    ##
    # Represents the PickleTableCell message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    
    #

    class PickleTableCell < ::Cucumber::Messages::Message

      attr_reader :value

      def initialize(
        value: ''
      )
        @value = value
      end
    end


    ##
    # Represents the PickleTableRow message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    
    #

    class PickleTableRow < ::Cucumber::Messages::Message

      attr_reader :cells

      def initialize(
        cells: []
      )
        @cells = cells
      end
    end


    ##
    # Represents the PickleTag message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    # *
    #  A tag
    #

    class PickleTag < ::Cucumber::Messages::Message

      attr_reader :name

      ##
      # Points to the AST node this was created from

      attr_reader :ast_node_id

      def initialize(
        name: '',
        ast_node_id: ''
      )
        @name = name
        @ast_node_id = ast_node_id
      end
    end


    ##
    # Represents the Source message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    # //// Source
    # 
    # *
    #  A source file, typically a Gherkin document or Java/Ruby/JavaScript source code
    #

    class Source < ::Cucumber::Messages::Message

      ##
      # *
      #  The [URI](https://en.wikipedia.org/wiki/Uniform_Resource_Identifier)
      #  of the source, typically a file path relative to the root directory

      attr_reader :uri

      ##
      # The contents of the file

      attr_reader :data

      ##
      # The media type of the file. Can be used to specify custom types, such as
      #  text/x.cucumber.gherkin+plain

      attr_reader :media_type

      def initialize(
        uri: '',
        data: '',
        media_type: SourceMediaType::TEXT_X_CUCUMBER_GHERKIN_PLAIN
      )
        @uri = uri
        @data = data
        @media_type = media_type
      end
    end


    ##
    # Represents the SourceReference message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    # *
    #  Points to a [Source](#io.cucumber.messages.Source) identified by `uri` and a
    #  [Location](#io.cucumber.messages.Location) within that file.
    #

    class SourceReference < ::Cucumber::Messages::Message

      attr_reader :uri

      attr_reader :java_method

      attr_reader :java_stack_trace_element

      attr_reader :location

      def initialize(
        uri: nil,
        java_method: nil,
        java_stack_trace_element: nil,
        location: nil
      )
        @uri = uri
        @java_method = java_method
        @java_stack_trace_element = java_stack_trace_element
        @location = location
      end
    end


    ##
    # Represents the JavaMethod message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    
    #

    class JavaMethod < ::Cucumber::Messages::Message

      attr_reader :class_name

      attr_reader :method_name

      attr_reader :method_parameter_types

      def initialize(
        class_name: '',
        method_name: '',
        method_parameter_types: []
      )
        @class_name = class_name
        @method_name = method_name
        @method_parameter_types = method_parameter_types
      end
    end


    ##
    # Represents the JavaStackTraceElement message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    
    #

    class JavaStackTraceElement < ::Cucumber::Messages::Message

      attr_reader :class_name

      attr_reader :file_name

      attr_reader :method_name

      def initialize(
        class_name: '',
        file_name: '',
        method_name: ''
      )
        @class_name = class_name
        @file_name = file_name
        @method_name = method_name
      end
    end


    ##
    # Represents the StepDefinition message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    
    #

    class StepDefinition < ::Cucumber::Messages::Message

      attr_reader :id

      attr_reader :pattern

      attr_reader :source_reference

      def initialize(
        id: '',
        pattern: StepDefinitionPattern.new,
        source_reference: SourceReference.new
      )
        @id = id
        @pattern = pattern
        @source_reference = source_reference
      end
    end


    ##
    # Represents the StepDefinitionPattern message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    
    #

    class StepDefinitionPattern < ::Cucumber::Messages::Message

      attr_reader :source

      attr_reader :type

      def initialize(
        source: '',
        type: StepDefinitionPatternType::CUCUMBER_EXPRESSION
      )
        @source = source
        @type = type
      end
    end


    ##
    # Represents the TestCase message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    # //// TestCases
    # 
    # *
    #  A `TestCase` contains a sequence of `TestStep`s.
    #

    class TestCase < ::Cucumber::Messages::Message

      attr_reader :id

      ##
      # The ID of the `Pickle` this `TestCase` is derived from.

      attr_reader :pickle_id

      attr_reader :test_steps

      def initialize(
        id: '',
        pickle_id: '',
        test_steps: []
      )
        @id = id
        @pickle_id = pickle_id
        @test_steps = test_steps
      end
    end


    ##
    # Represents the Group message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    
    #

    class Group < ::Cucumber::Messages::Message

      attr_reader :children

      attr_reader :start

      attr_reader :value

      def initialize(
        children: [],
        start: nil,
        value: nil
      )
        @children = children
        @start = start
        @value = value
      end
    end


    ##
    # Represents the StepMatchArgument message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    # *
    #  Represents a single argument extracted from a step match and passed to a step definition.
    #  This is used for the following purposes:
    #  - Construct an argument to pass to a step definition (possibly through a parameter type transform)
    #  - Highlight the matched parameter in rich formatters such as the HTML formatter
    # 
    #  This message closely matches the `Argument` class in the `cucumber-expressions` library.
    #

    class StepMatchArgument < ::Cucumber::Messages::Message

      ##
      # *
      #  Represents the outermost capture group of an argument. This message closely matches the
      #  `Group` class in the `cucumber-expressions` library.

      attr_reader :group

      attr_reader :parameter_type_name

      def initialize(
        group: Group.new,
        parameter_type_name: nil
      )
        @group = group
        @parameter_type_name = parameter_type_name
      end
    end


    ##
    # Represents the StepMatchArgumentsList message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    
    #

    class StepMatchArgumentsList < ::Cucumber::Messages::Message

      attr_reader :step_match_arguments

      def initialize(
        step_match_arguments: []
      )
        @step_match_arguments = step_match_arguments
      end
    end


    ##
    # Represents the TestStep message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    # *
    #  A `TestStep` is derived from either a `PickleStep`
    #  combined with a `StepDefinition`, or from a `Hook`.
    #

    class TestStep < ::Cucumber::Messages::Message

      ##
      # Pointer to the `Hook` (if derived from a Hook)

      attr_reader :hook_id

      attr_reader :id

      ##
      # Pointer to the `PickleStep` (if derived from a `PickleStep`)

      attr_reader :pickle_step_id

      ##
      # Pointer to all the matching `StepDefinition`s (if derived from a `PickleStep`)

      attr_reader :step_definition_ids

      ##
      # A list of list of StepMatchArgument (if derived from a `PickleStep`).
      #  Each element represents a matching step definition. A size of 0 means `UNDEFINED`,
      #  and a size of 2+ means `AMBIGUOUS`

      attr_reader :step_match_arguments_lists

      def initialize(
        hook_id: nil,
        id: '',
        pickle_step_id: nil,
        step_definition_ids: nil,
        step_match_arguments_lists: nil
      )
        @hook_id = hook_id
        @id = id
        @pickle_step_id = pickle_step_id
        @step_definition_ids = step_definition_ids
        @step_match_arguments_lists = step_match_arguments_lists
      end
    end


    ##
    # Represents the TestCaseFinished message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    
    #

    class TestCaseFinished < ::Cucumber::Messages::Message

      attr_reader :test_case_started_id

      attr_reader :timestamp

      attr_reader :will_be_retried

      def initialize(
        test_case_started_id: '',
        timestamp: Timestamp.new,
        will_be_retried: false
      )
        @test_case_started_id = test_case_started_id
        @timestamp = timestamp
        @will_be_retried = will_be_retried
      end
    end


    ##
    # Represents the TestCaseStarted message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    
    #

    class TestCaseStarted < ::Cucumber::Messages::Message

      ##
      # *
      #  The first attempt should have value 0, and for each retry the value
      #  should increase by 1.

      attr_reader :attempt

      ##
      # *
      #  Because a `TestCase` can be run multiple times (in case of a retry),
      #  we use this field to group messages relating to the same attempt.

      attr_reader :id

      attr_reader :test_case_id

      ##
      # An identifier for the worker process running this test case, if test cases are being run in parallel. The identifier will be unique per worker, but no particular format is defined - it could be an index, uuid, machine name etc - and as such should be assumed that it's not human readable.

      attr_reader :worker_id

      attr_reader :timestamp

      def initialize(
        attempt: 0,
        id: '',
        test_case_id: '',
        worker_id: nil,
        timestamp: Timestamp.new
      )
        @attempt = attempt
        @id = id
        @test_case_id = test_case_id
        @worker_id = worker_id
        @timestamp = timestamp
      end
    end


    ##
    # Represents the TestRunFinished message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    
    #

    class TestRunFinished < ::Cucumber::Messages::Message

      ##
      # Error message. Can be a stack trace from a failed `BeforeAll` or `AfterAll`.
      #  If there are undefined parameter types, the message is simply
      #  "The following parameter type(s() are not defined: xxx, yyy".
      #  The independent `UndefinedParameterType` messages can be used to generate
      #  snippets for those parameter types.

      attr_reader :message

      ##
      # success = StrictModeEnabled ? (failed_count == 0 && ambiguous_count == 0 && undefined_count == 0 && pending_count == 0) : (failed_count == 0 && ambiguous_count == 0)

      attr_reader :success

      ##
      # Timestamp when the TestRun is finished

      attr_reader :timestamp

      def initialize(
        message: nil,
        success: false,
        timestamp: Timestamp.new
      )
        @message = message
        @success = success
        @timestamp = timestamp
      end
    end


    ##
    # Represents the TestRunStarted message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    
    #

    class TestRunStarted < ::Cucumber::Messages::Message

      attr_reader :timestamp

      def initialize(
        timestamp: Timestamp.new
      )
        @timestamp = timestamp
      end
    end


    ##
    # Represents the TestStepFinished message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    
    #

    class TestStepFinished < ::Cucumber::Messages::Message

      attr_reader :test_case_started_id

      attr_reader :test_step_id

      attr_reader :test_step_result

      attr_reader :timestamp

      def initialize(
        test_case_started_id: '',
        test_step_id: '',
        test_step_result: TestStepResult.new,
        timestamp: Timestamp.new
      )
        @test_case_started_id = test_case_started_id
        @test_step_id = test_step_id
        @test_step_result = test_step_result
        @timestamp = timestamp
      end
    end


    ##
    # Represents the TestStepResult message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    
    #

    class TestStepResult < ::Cucumber::Messages::Message

      attr_reader :duration

      attr_reader :message

      attr_reader :status

      def initialize(
        duration: Duration.new,
        message: nil,
        status: TestStepResultStatus::UNKNOWN
      )
        @duration = duration
        @message = message
        @status = status
      end
    end


    ##
    # Represents the TestStepStarted message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    
    #

    class TestStepStarted < ::Cucumber::Messages::Message

      attr_reader :test_case_started_id

      attr_reader :test_step_id

      attr_reader :timestamp

      def initialize(
        test_case_started_id: '',
        test_step_id: '',
        timestamp: Timestamp.new
      )
        @test_case_started_id = test_case_started_id
        @test_step_id = test_step_id
        @timestamp = timestamp
      end
    end


    ##
    # Represents the Timestamp message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    
    #

    class Timestamp < ::Cucumber::Messages::Message

      ##
      # Represents seconds of UTC time since Unix epoch
      #  1970-01-01T00:00:00Z. Must be from 0001-01-01T00:00:00Z to
      #  9999-12-31T23:59:59Z inclusive.

      attr_reader :seconds

      ##
      # Non-negative fractions of a second at nanosecond resolution. Negative
      #  second values with fractions must still have non-negative nanos values
      #  that count forward in time. Must be from 0 to 999,999,999
      #  inclusive.

      attr_reader :nanos

      def initialize(
        seconds: 0,
        nanos: 0
      )
        @seconds = seconds
        @nanos = nanos
      end
    end


    ##
    # Represents the UndefinedParameterType message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    #
    
    #

    class UndefinedParameterType < ::Cucumber::Messages::Message

      attr_reader :expression

      attr_reader :name

      def initialize(
        expression: '',
        name: ''
      )
        @expression = expression
        @name = name
      end
    end

  end
end

class Cucumber::Messages::AttachmentContentEncoding
  IDENTITY = 'IDENTITY'
  BASE64 = 'BASE64'
end

class Cucumber::Messages::PickleStepType
  UNKNOWN = 'Unknown'
  CONTEXT = 'Context'
  ACTION = 'Action'
  OUTCOME = 'Outcome'
end

class Cucumber::Messages::SourceMediaType
  TEXT_X_CUCUMBER_GHERKIN_PLAIN = 'text/x.cucumber.gherkin+plain'
  TEXT_X_CUCUMBER_GHERKIN_MARKDOWN = 'text/x.cucumber.gherkin+markdown'
end

class Cucumber::Messages::StepDefinitionPatternType
  CUCUMBER_EXPRESSION = 'CUCUMBER_EXPRESSION'
  REGULAR_EXPRESSION = 'REGULAR_EXPRESSION'
end

class Cucumber::Messages::StepKeywordType
  UNKNOWN = 'Unknown'
  CONTEXT = 'Context'
  ACTION = 'Action'
  OUTCOME = 'Outcome'
  CONJUNCTION = 'Conjunction'
end

class Cucumber::Messages::TestStepResultStatus
  UNKNOWN = 'UNKNOWN'
  PASSED = 'PASSED'
  SKIPPED = 'SKIPPED'
  PENDING = 'PENDING'
  UNDEFINED = 'UNDEFINED'
  AMBIGUOUS = 'AMBIGUOUS'
  FAILED = 'FAILED'
end

