/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.escape;

import java.sql.SQLException;
import java.text.BreakIterator;
import java.util.ArrayDeque;
import java.util.Locale;
import java.util.regex.Pattern;
import org.firebirdsql.jdbc.FBProcedureCall;
import org.firebirdsql.jdbc.escape.FBEscapedCallParser;
import org.firebirdsql.jdbc.escape.FBEscapedFunctionHelper;
import org.firebirdsql.jdbc.escape.FBSQLParseException;

public final class FBEscapedParser {
    private static final String ESCAPE_CALL_KEYWORD = "call";
    private static final String ESCAPE_CALL_KEYWORD3 = "?";
    private static final String ESCAPE_DATE_KEYWORD = "d";
    private static final String ESCAPE_TIME_KEYWORD = "t";
    private static final String ESCAPE_TIMESTAMP_KEYWORD = "ts";
    private static final String ESCAPE_FUNCTION_KEYWORD = "fn";
    private static final String ESCAPE_ESCAPE_KEYWORD = "escape";
    private static final String ESCAPE_OUTERJOIN_KEYWORD = "oj";
    private static final String ESCAPE_LIMIT_KEYWORD = "limit";
    private static final Pattern CHECK_ESCAPE_PATTERN = Pattern.compile("\\{(?:(?:\\?\\s*=\\s*)?call|d|ts?|escape|fn|oj|limit)\\s", 2);
    private static final String LIMIT_OFFSET_CLAUSE = " offset ";
    private final EscapeParserMode mode;

    public FBEscapedParser(EscapeParserMode mode) {
        this.mode = mode;
    }

    private boolean checkForEscapes(String sql) {
        return CHECK_ESCAPE_PATTERN.matcher(sql).find();
    }

    public String parse(String sql) throws SQLException {
        if (!this.checkForEscapes(sql)) {
            return sql;
        }
        ParserState state = ParserState.INITIAL_STATE;
        ArrayDeque<StringBuilder> bufferStack = new ArrayDeque<StringBuilder>(8);
        int sqlLength = sql.length();
        StringBuilder buffer = new StringBuilder(sqlLength);
        block7: for (int i = 0; i < sqlLength; ++i) {
            char currentChar = sql.charAt(i);
            state = state.nextState(currentChar);
            switch (state) {
                case INITIAL_STATE: {
                    continue block7;
                }
                case NORMAL_STATE: 
                case LITERAL_STATE: 
                case START_LINE_COMMENT: 
                case LINE_COMMENT: 
                case START_BLOCK_COMMENT: 
                case BLOCK_COMMENT: 
                case END_BLOCK_COMMENT: 
                case POSSIBLE_Q_LITERAL_ENTER: {
                    buffer.append(currentChar);
                    continue block7;
                }
                case ESCAPE_ENTER_STATE: {
                    bufferStack.push(buffer);
                    buffer = new StringBuilder();
                    continue block7;
                }
                case ESCAPE_EXIT_STATE: {
                    if (bufferStack.isEmpty()) {
                        throw new FBSQLParseException("Unbalanced JDBC escape, too many '}'");
                    }
                    String escapeText = buffer.toString();
                    buffer = (StringBuilder)bufferStack.pop();
                    this.escapeToNative(buffer, escapeText);
                    continue block7;
                }
                case Q_LITERAL_START: {
                    buffer.append(currentChar);
                    if (++i >= sqlLength) {
                        throw new FBSQLParseException("Unexpected end of string at parser state " + (Object)((Object)state));
                    }
                    char alternateStartChar = sql.charAt(i);
                    buffer.append(alternateStartChar);
                    char alternateEndChar = FBEscapedParser.qLiteralEndChar(alternateStartChar);
                    ++i;
                    while (i < sqlLength) {
                        currentChar = sql.charAt(i);
                        buffer.append(currentChar);
                        if (currentChar == alternateEndChar && i + 1 < sqlLength && sql.charAt(i + 1) == '\'') {
                            state = ParserState.Q_LITERAL_END;
                            break;
                        }
                        ++i;
                    }
                    if (i != sqlLength) continue block7;
                    throw new FBSQLParseException("Unexpected end of string at parser state " + (Object)((Object)state));
                }
                default: {
                    throw new FBSQLParseException("Unexpected parser state " + (Object)((Object)state));
                }
            }
        }
        if (bufferStack.isEmpty()) {
            return buffer.toString();
        }
        throw new FBSQLParseException("Unbalanced JDBC escape, too many '{'");
    }

    private static char qLiteralEndChar(char startChar) {
        switch (startChar) {
            case '(': {
                return ')';
            }
            case '{': {
                return '}';
            }
            case '[': {
                return ']';
            }
            case '<': {
                return '>';
            }
        }
        return startChar;
    }

    private void processEscaped(String escaped, StringBuilder keyword, StringBuilder payload) {
        int payloadEnd;
        int payloadStart;
        assert (keyword.length() == 0 && payload.length() == 0) : "StringBuilders keyword and payload should be empty";
        BreakIterator iterator = BreakIterator.getWordInstance();
        iterator.setText(escaped);
        int keyStart = iterator.first();
        int keyEnd = iterator.next();
        keyword.append(escaped, keyStart, keyEnd);
        for (payloadStart = keyEnd; payloadStart < escaped.length() - 1 && escaped.charAt(payloadStart) <= ' '; ++payloadStart) {
        }
        for (payloadEnd = escaped.length(); payloadEnd > payloadStart && escaped.charAt(payloadEnd - 1) <= ' '; --payloadEnd) {
        }
        payload.append(escaped, payloadStart, payloadEnd);
    }

    private void escapeToNative(StringBuilder target, String escaped) throws SQLException {
        String keywordStr;
        StringBuilder keyword = new StringBuilder();
        StringBuilder payload = new StringBuilder(Math.max(16, escaped.length()));
        this.processEscaped(escaped, keyword, payload);
        switch (keywordStr = keyword.toString().toLowerCase(Locale.ROOT)) {
            case "call": {
                this.convertProcedureCall(target, "{" + keyword + ' ' + payload + '}');
                break;
            }
            case "?": {
                this.convertProcedureCall(target, "{?" + payload + '}');
                break;
            }
            case "d": {
                this.toDateString(target, payload);
                break;
            }
            case "escape": {
                this.convertEscapeString(target, payload);
                break;
            }
            case "fn": {
                this.convertEscapedFunction(target, payload);
                break;
            }
            case "oj": {
                this.convertOuterJoin(target, payload);
                break;
            }
            case "t": {
                this.toTimeString(target, payload);
                break;
            }
            case "ts": {
                this.toTimestampString(target, payload);
                break;
            }
            case "limit": {
                this.convertLimitString(target, payload);
                break;
            }
            default: {
                throw new FBSQLParseException("Unknown keyword " + keywordStr + " for escaped syntax.");
            }
        }
    }

    private void toDateString(StringBuilder target, CharSequence dateStr) {
        target.append("DATE ").append(dateStr);
    }

    private void toTimeString(StringBuilder target, CharSequence timeStr) {
        target.append("TIME ").append(timeStr);
    }

    private void toTimestampString(StringBuilder target, CharSequence timestampStr) {
        target.append("TIMESTAMP ").append(timestampStr);
    }

    private void convertProcedureCall(StringBuilder target, String procedureCall) throws SQLException {
        FBEscapedCallParser tempParser = new FBEscapedCallParser(this.mode);
        FBProcedureCall call = tempParser.parseCall(procedureCall);
        call.checkParameters();
        target.append(call.getSQL(false));
    }

    private void convertOuterJoin(StringBuilder target, CharSequence outerJoin) {
        target.append(outerJoin);
    }

    private void convertEscapeString(StringBuilder target, CharSequence escapeString) {
        target.append("ESCAPE ").append(escapeString);
    }

    private void convertLimitString(StringBuilder target, CharSequence limitClause) throws FBSQLParseException {
        String limitEscape = limitClause.toString().toLowerCase(Locale.ROOT);
        int offsetStart = limitEscape.indexOf(LIMIT_OFFSET_CLAUSE);
        if (offsetStart == -1) {
            target.append("ROWS ").append(limitEscape);
        } else {
            String rows = limitEscape.substring(0, offsetStart).trim();
            String offset = limitEscape.substring(offsetStart + LIMIT_OFFSET_CLAUSE.length()).trim();
            if (offset.indexOf(63) != -1) {
                throw new FBSQLParseException("Extended limit escape ({limit <rows> offset <offset_rows>}) does not support parameters for <offset_rows>");
            }
            target.append("ROWS ").append(offset).append(" TO ").append(offset).append("+").append(rows);
        }
    }

    private void convertEscapedFunction(StringBuilder target, CharSequence escapedFunction) throws FBSQLParseException {
        String templateResult = FBEscapedFunctionHelper.convertTemplate(escapedFunction.toString(), this.mode);
        target.append(templateResult != null ? templateResult : escapedFunction);
    }

    public static enum EscapeParserMode {
        USE_BUILT_IN,
        USE_STANDARD_UDF;

    }

    private static enum ParserState {
        INITIAL_STATE{

            @Override
            protected ParserState nextState(char inputChar) throws FBSQLParseException {
                return Character.isWhitespace(inputChar) ? INITIAL_STATE : NORMAL_STATE.nextState(inputChar);
            }
        }
        ,
        NORMAL_STATE{

            @Override
            protected ParserState nextState(char inputChar) {
                switch (inputChar) {
                    case '\'': {
                        return LITERAL_STATE;
                    }
                    case '{': {
                        return ESCAPE_ENTER_STATE;
                    }
                    case '}': {
                        return ESCAPE_EXIT_STATE;
                    }
                    case '-': {
                        return START_LINE_COMMENT;
                    }
                    case '/': {
                        return START_BLOCK_COMMENT;
                    }
                    case 'Q': 
                    case 'q': {
                        return POSSIBLE_Q_LITERAL_ENTER;
                    }
                }
                return NORMAL_STATE;
            }
        }
        ,
        LITERAL_STATE{

            @Override
            protected ParserState nextState(char inputChar) {
                return inputChar == '\'' ? NORMAL_STATE : LITERAL_STATE;
            }
        }
        ,
        ESCAPE_ENTER_STATE{

            @Override
            protected ParserState nextState(char inputChar) throws FBSQLParseException {
                switch (inputChar) {
                    case '?': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'L': 
                    case 'O': 
                    case 'T': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': 
                    case 'l': 
                    case 'o': 
                    case 't': {
                        return NORMAL_STATE;
                    }
                }
                throw new FBSQLParseException("Unexpected first character inside JDBC escape: " + inputChar);
            }
        }
        ,
        ESCAPE_EXIT_STATE{

            @Override
            protected ParserState nextState(char inputChar) throws FBSQLParseException {
                return NORMAL_STATE.nextState(inputChar);
            }
        }
        ,
        START_LINE_COMMENT{

            @Override
            protected ParserState nextState(char inputChar) throws FBSQLParseException {
                return inputChar == '-' ? LINE_COMMENT : NORMAL_STATE.nextState(inputChar);
            }
        }
        ,
        LINE_COMMENT{

            @Override
            protected ParserState nextState(char inputChar) {
                return inputChar == '\n' ? NORMAL_STATE : LINE_COMMENT;
            }
        }
        ,
        START_BLOCK_COMMENT{

            @Override
            protected ParserState nextState(char inputChar) throws FBSQLParseException {
                return inputChar == '*' ? BLOCK_COMMENT : NORMAL_STATE.nextState(inputChar);
            }
        }
        ,
        BLOCK_COMMENT{

            @Override
            protected ParserState nextState(char inputChar) {
                return inputChar == '*' ? END_BLOCK_COMMENT : BLOCK_COMMENT;
            }
        }
        ,
        END_BLOCK_COMMENT{

            @Override
            protected ParserState nextState(char inputChar) {
                return inputChar == '/' ? NORMAL_STATE : BLOCK_COMMENT;
            }
        }
        ,
        POSSIBLE_Q_LITERAL_ENTER{

            @Override
            protected ParserState nextState(char inputChar) {
                return inputChar == '\'' ? Q_LITERAL_START : NORMAL_STATE;
            }
        }
        ,
        Q_LITERAL_START{

            @Override
            protected ParserState nextState(char inputChar) throws FBSQLParseException {
                throw new FBSQLParseException("Q-literal handling needs to be performed separately");
            }
        }
        ,
        Q_LITERAL_END{

            @Override
            protected ParserState nextState(char inputChar) throws FBSQLParseException {
                if (inputChar != '\'') {
                    throw new FBSQLParseException("Invalid char " + inputChar + " for state Q_LITERAL_END");
                }
                return NORMAL_STATE;
            }
        };


        protected abstract ParserState nextState(char var1) throws FBSQLParseException;
    }
}

