/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jca;

import java.io.ByteArrayInputStream;
import java.io.PrintWriter;
import java.net.SocketTimeoutException;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.firebirdsql.gds.DatabaseParameterBuffer;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.JaybirdSystemProperties;
import org.firebirdsql.gds.TransactionParameterBuffer;
import org.firebirdsql.gds.impl.DbAttachInfo;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.gds.ng.FbConnectionProperties;
import org.firebirdsql.gds.ng.FbDatabase;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.FbStatement;
import org.firebirdsql.gds.ng.FbTransaction;
import org.firebirdsql.gds.ng.TransactionState;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.gds.ng.listeners.DefaultDatabaseListener;
import org.firebirdsql.gds.ng.listeners.DefaultStatementListener;
import org.firebirdsql.gds.ng.listeners.ExceptionListener;
import org.firebirdsql.jca.FBConnectionRequestInfo;
import org.firebirdsql.jca.FBIncorrectXidException;
import org.firebirdsql.jca.FBLocalTransaction;
import org.firebirdsql.jca.FBManagedConnectionFactory;
import org.firebirdsql.jca.FBManagedConnectionMetaData;
import org.firebirdsql.jca.FBResourceException;
import org.firebirdsql.jca.FBTpb;
import org.firebirdsql.jca.FBXAException;
import org.firebirdsql.jca.FBXid;
import org.firebirdsql.jca.FatalGDSErrorHelper;
import org.firebirdsql.jdbc.FBConnection;
import org.firebirdsql.jdbc.FBTpbMapper;
import org.firebirdsql.jdbc.Synchronizable;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FieldDataProvider;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;
import org.firebirdsql.util.SQLExceptionChainBuilder;

public class FBManagedConnection
implements ManagedConnection,
XAResource,
ExceptionListener,
Synchronizable {
    public static final String WARNING_NO_CHARSET = "WARNING: No connection character set specified (property lc_ctype, encoding, charSet or localEncoding), defaulting to character set ";
    public static final String ERROR_NO_CHARSET = "Connection rejected: No connection character set specified (property lc_ctype, encoding, charSet or localEncoding). Please specify a connection character set (eg property charSet=utf-8) or consult the Jaybird documentation for more information.";
    private static final Logger log = LoggerFactory.getLogger(FBManagedConnection.class);
    private final FBManagedConnectionFactory mcf;
    private final List<ConnectionEventListener> connectionEventListeners = new CopyOnWriteArrayList<ConnectionEventListener>();
    private final List<FBConnection> connectionHandles = Collections.synchronizedList(new ArrayList());
    private SQLWarning unnotifiedWarnings;
    private int timeout = 0;
    private final Map<Xid, FbTransaction> xidMap = new ConcurrentHashMap<Xid, FbTransaction>();
    private GDSHelper gdsHelper;
    private final FbDatabase database;
    private final Object syncObject;
    private final FBConnectionRequestInfo cri;
    private FBTpbMapper transactionMapping;
    private FBTpb tpb;
    private int transactionIsolation;
    private volatile boolean managedEnvironment = true;
    private volatile boolean connectionSharing = true;
    private final Set<Xid> preparedXid = Collections.synchronizedSet(new HashSet());
    private volatile boolean inDistributedTransaction = false;
    private static final Set<TransactionState> XID_ACTIVE_STATE = Collections.unmodifiableSet(EnumSet.of(TransactionState.ACTIVE, TransactionState.PREPARED, TransactionState.PREPARING));
    private static final String FORGET_FIND_QUERY = "SELECT RDB$TRANSACTION_ID, RDB$TRANSACTION_DESCRIPTION FROM RDB$TRANSACTIONS WHERE RDB$TRANSACTION_STATE IN (2, 3)";
    private static final String FORGET_DELETE_QUERY = "DELETE FROM RDB$TRANSACTIONS WHERE RDB$TRANSACTION_ID = ";
    private static final String RECOVERY_QUERY = "SELECT RDB$TRANSACTION_ID, RDB$TRANSACTION_DESCRIPTION FROM RDB$TRANSACTIONS";
    private static final String RECOVERY_QUERY_PARAMETRIZED = "SELECT RDB$TRANSACTION_ID, RDB$TRANSACTION_DESCRIPTION FROM RDB$TRANSACTIONS WHERE RDB$TRANSACTION_DESCRIPTION = CAST(? AS VARCHAR(32764) CHARACTER SET OCTETS)";
    static final CELNotifier connectionClosedNotifier = new CELNotifier(){

        @Override
        public void notify(ConnectionEventListener cel, ConnectionEvent ce) {
            cel.connectionClosed(ce);
        }
    };
    static final CELNotifier connectionErrorOccurredNotifier = new CELNotifier(){

        @Override
        public void notify(ConnectionEventListener cel, ConnectionEvent ce) {
            cel.connectionErrorOccurred(ce);
        }
    };
    static final CELNotifier localTransactionStartedNotifier = new CELNotifier(){

        @Override
        public void notify(ConnectionEventListener cel, ConnectionEvent ce) {
            cel.localTransactionStarted(ce);
        }
    };
    static final CELNotifier localTransactionCommittedNotifier = new CELNotifier(){

        @Override
        public void notify(ConnectionEventListener cel, ConnectionEvent ce) {
            cel.localTransactionCommitted(ce);
        }
    };
    static final CELNotifier localTransactionRolledbackNotifier = new CELNotifier(){

        @Override
        public void notify(ConnectionEventListener cel, ConnectionEvent ce) {
            cel.localTransactionRolledback(ce);
        }
    };

    FBManagedConnection(Subject subject, ConnectionRequestInfo cri, FBManagedConnectionFactory mcf) throws ResourceException {
        this.mcf = mcf;
        this.cri = this.getCombinedConnectionRequestInfo(subject, cri);
        this.tpb = mcf.getDefaultTpb();
        this.transactionIsolation = mcf.getDefaultTransactionIsolation();
        try {
            DatabaseParameterBuffer dpb = this.cri.getDpb();
            if (dpb.getArgumentAsString(48) == null && dpb.getArgumentAsString(135) == null) {
                String defaultEncoding = FBManagedConnection.getDefaultConnectionEncoding();
                if (defaultEncoding == null) {
                    throw new SQLNonTransientConnectionException(ERROR_NO_CHARSET, "08000");
                }
                dpb.addArgument(48, defaultEncoding);
                String warningMessage = WARNING_NO_CHARSET + defaultEncoding;
                log.warn(warningMessage);
                this.notifyWarning(new SQLWarning(warningMessage));
            }
            if (!dpb.hasArgument(57) && DriverManager.getLoginTimeout() > 0) {
                dpb.addArgument(57, DriverManager.getLoginTimeout());
            }
            FbConnectionProperties connectionProperties = new FbConnectionProperties();
            connectionProperties.fromDpb(dpb);
            String gdsTypeName = mcf.getGDSType().toString();
            if (!"EMBEDDED".equals(gdsTypeName) && !"LOCAL".equals(gdsTypeName)) {
                DbAttachInfo dbAttachInfo = DbAttachInfo.parseConnectString(mcf.getDatabase());
                connectionProperties.setServerName(dbAttachInfo.getServer());
                connectionProperties.setPortNumber(dbAttachInfo.getPort());
                connectionProperties.setDatabaseName(dbAttachInfo.getFileName());
            } else {
                connectionProperties.setDatabaseName(mcf.getDatabase());
            }
            this.database = mcf.getDatabaseFactory().connect(connectionProperties);
            this.database.addDatabaseListener(new MCDatabaseListener());
            this.database.addExceptionListener(this);
            this.database.attach();
            this.syncObject = this.database.getSynchronizationObject();
            this.gdsHelper = new GDSHelper(this.database);
        }
        catch (SQLException ex) {
            throw new FBResourceException(ex);
        }
    }

    @Override
    public void errorOccurred(Object source, SQLException ex) {
        log.trace(ex.getMessage());
        if (!FatalGDSErrorHelper.isFatal(ex)) {
            return;
        }
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 5, (Exception)ex);
        this.notify(connectionErrorOccurredNotifier, event);
    }

    private FBConnectionRequestInfo getCombinedConnectionRequestInfo(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        if (cri == null) {
            cri = this.mcf.getDefaultConnectionRequestInfo();
        }
        try {
            FBConnectionRequestInfo fbcri = (FBConnectionRequestInfo)cri;
            if (subject != null) {
                for (Object cred : subject.getPrivateCredentials()) {
                    if (!(cred instanceof PasswordCredential) || !this.mcf.equals(((PasswordCredential)cred).getManagedConnectionFactory())) continue;
                    PasswordCredential pcred = (PasswordCredential)cred;
                    String user = pcred.getUserName();
                    String password = new String(pcred.getPassword());
                    fbcri.setPassword(password);
                    fbcri.setUserName(user);
                    break;
                }
            }
            return fbcri;
        }
        catch (ClassCastException cce) {
            throw new FBResourceException("Incorrect ConnectionRequestInfo class supplied");
        }
    }

    public GDSHelper getGDSHelper() throws SQLException {
        if (this.gdsHelper == null) {
            throw new FbExceptionBuilder().exception(335544363).toSQLException();
        }
        return this.gdsHelper;
    }

    public String getDatabase() {
        return this.mcf.getDatabase();
    }

    public boolean isManagedEnvironment() {
        return this.managedEnvironment;
    }

    public boolean inTransaction() {
        return this.gdsHelper != null && this.gdsHelper.inTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setManagedEnvironment(boolean managedEnvironment) throws ResourceException {
        this.managedEnvironment = managedEnvironment;
        if (!this.connectionSharing) {
            List<FBConnection> list = this.connectionHandles;
            synchronized (list) {
                if (this.connectionHandles.size() > 1) {
                    throw new IllegalStateException("Multiple connections associated with this managed connection in non-sharing mode.");
                }
                for (FBConnection connection : this.connectionHandles) {
                    try {
                        connection.setManagedEnvironment(managedEnvironment);
                    }
                    catch (SQLException ex) {
                        throw new FBResourceException(ex);
                    }
                }
            }
        }
    }

    public boolean isConnectionSharing() {
        return this.connectionSharing;
    }

    public void setConnectionSharing(boolean connectionSharing) throws ResourceException {
        if (!this.connectionHandles.isEmpty()) {
            throw new IllegalStateException("Cannot change connection sharing with active connection handles.");
        }
        this.connectionSharing = connectionSharing;
    }

    public LocalTransaction getLocalTransaction() {
        return new FBLocalTransaction(this, null);
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        return new FBManagedConnectionMetaData(this);
    }

    public void setLogWriter(PrintWriter out) {
    }

    public PrintWriter getLogWriter() {
        return null;
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.connectionEventListeners.add(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.connectionEventListeners.remove(listener);
    }

    public void associateConnection(Object connection) throws ResourceException {
        if (!this.connectionSharing) {
            this.disassociateConnections();
        }
        try {
            FBConnection abstractConnection = (FBConnection)connection;
            abstractConnection.setManagedConnection(this);
            this.connectionHandles.add(abstractConnection);
        }
        catch (ClassCastException cce) {
            throw new FBResourceException("invalid connection supplied to associateConnection.", cce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() throws ResourceException {
        this.disassociateConnections();
        Object object = this.syncObject;
        synchronized (object) {
            try {
                this.getGDSHelper().setCurrentTransaction(null);
            }
            catch (SQLException e) {
                throw new FBResourceException(e);
            }
            this.transactionMapping = null;
            this.tpb = this.mcf.getDefaultTpb();
            this.transactionIsolation = this.mcf.getDefaultTransactionIsolation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disassociateConnections() throws ResourceException {
        SQLExceptionChainBuilder<SQLException> chain = new SQLExceptionChainBuilder<SQLException>();
        List<FBConnection> list = this.connectionHandles;
        synchronized (list) {
            ArrayList<FBConnection> connectionHandleCopy = new ArrayList<FBConnection>(this.connectionHandles);
            for (FBConnection connection : connectionHandleCopy) {
                try {
                    connection.close();
                }
                catch (SQLException sqlex) {
                    chain.append(sqlex);
                }
            }
        }
        if (chain.hasException()) {
            throw new FBResourceException((Exception)chain.getException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceDisassociateConnections() {
        List<FBConnection> list = this.connectionHandles;
        synchronized (list) {
            Iterator<FBConnection> connectionIterator = this.connectionHandles.iterator();
            while (connectionIterator.hasNext()) {
                FBConnection connection = connectionIterator.next();
                connection.setManagedConnection(null);
                try {
                    connection.close();
                }
                catch (SQLException sqlex) {
                    log.debug("Exception ignored during forced disassociation", sqlex);
                }
                connectionIterator.remove();
            }
        }
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        if (!this.matches(subject, cri)) {
            throw new FBResourceException("Incompatible subject or ConnectionRequestInfo in getConnection!");
        }
        if (!this.connectionSharing) {
            this.disassociateConnections();
        }
        FBConnection c = this.mcf.newConnection(this);
        try {
            if (this.unnotifiedWarnings != null) {
                c.addWarning(this.unnotifiedWarnings);
                this.unnotifiedWarnings = null;
            }
            c.setManagedEnvironment(this.isManagedEnvironment());
            this.connectionHandles.add(c);
            return c;
        }
        catch (SQLException ex) {
            throw new FBResourceException(ex);
        }
    }

    public void destroy() throws ResourceException {
        this.destroy(null);
    }

    public void destroy(ConnectionEvent connectionEvent) throws ResourceException {
        if (this.gdsHelper == null) {
            return;
        }
        try {
            if (this.isBrokenConnection(connectionEvent)) {
                FbDatabase currentDatabase = this.gdsHelper.getCurrentDatabase();
                currentDatabase.forceClose();
            } else {
                if (this.inTransaction()) {
                    throw new IllegalStateException("Can't destroy managed connection with active transaction");
                }
                this.gdsHelper.detachDatabase();
            }
        }
        catch (SQLException ge) {
            throw new FBResourceException("Can't detach from db.", ge);
        }
        finally {
            this.gdsHelper = null;
            this.forceDisassociateConnections();
        }
    }

    private boolean isBrokenConnection(ConnectionEvent connectionEvent) {
        if (connectionEvent == null || connectionEvent.getId() != 5) {
            return false;
        }
        Exception connectionEventException = connectionEvent.getException();
        if (connectionEventException == null) {
            return false;
        }
        SQLException firstSqlException = this.findException(connectionEventException, SQLException.class);
        if (firstSqlException != null && this.isBrokenConnectionErrorCode(firstSqlException.getErrorCode())) {
            return true;
        }
        if (this.findException(connectionEventException, SocketTimeoutException.class) != null) {
            return true;
        }
        return this.findException(connectionEventException, SocketTimeoutException.class) != null;
    }

    private boolean isBrokenConnectionErrorCode(int iscCode) {
        return iscCode == 335544721 || iscCode == 335544726 || iscCode == 335544727;
    }

    private <T extends Exception> T findException(Exception root, Class<T> exceptionType) {
        for (Throwable current = root; current != null; current = current.getCause()) {
            if (!exceptionType.isInstance(current)) continue;
            return (T)((Exception)exceptionType.cast(current));
        }
        return null;
    }

    public XAResource getXAResource() {
        log.debug("XAResource requested from FBManagedConnection");
        return this;
    }

    boolean isXidActive(Xid xid) {
        FbTransaction transaction = this.xidMap.get(xid);
        return transaction != null && XID_ACTIVE_STATE.contains((Object)transaction.getState());
    }

    @Override
    public void commit(Xid id, boolean onePhase) throws XAException {
        try {
            this.mcf.notifyCommit(this, id, onePhase);
        }
        catch (GDSException ge) {
            throw new XAException(ge.getXAErrorCode());
        }
    }

    void internalCommit(Xid xid, boolean onePhase) throws XAException {
        if (log.isTraceEnabled()) {
            log.trace("Commit called: " + xid);
        }
        FbTransaction committingTr = this.xidMap.get(xid);
        if (onePhase && this.isPrepared(xid)) {
            throw new FBXAException("Cannot commit one-phase when transaction has been prepared", -6);
        }
        if (!onePhase && !this.isPrepared(xid)) {
            throw new FBXAException("Cannot commit two-phase when transaction has not been prepared", -6);
        }
        if (committingTr == null) {
            throw new FBXAException("Commit called with unknown transaction", -4);
        }
        try {
            if (committingTr == this.getGDSHelper().getCurrentTransaction()) {
                throw new FBXAException("Commit called with non-ended xid", -6);
            }
            committingTr.commit();
        }
        catch (SQLException ge) {
            if (this.gdsHelper != null) {
                try {
                    committingTr.rollback();
                }
                catch (SQLException ge2) {
                    log.debug("Exception rolling back failed tx: ", ge2);
                }
            } else {
                log.warn("Unable to rollback failed tx, connection closed or lost");
            }
            throw new FBXAException(ge.getMessage(), -3, ge);
        }
        finally {
            this.xidMap.remove(xid);
            this.preparedXid.remove(xid);
        }
    }

    private boolean isPrepared(Xid xid) {
        return this.preparedXid.contains(xid);
    }

    @Override
    public void end(Xid id, int flags) throws XAException {
        if (flags != 0x4000000 && flags != 0x20000000 && flags != 0x2000000) {
            throw new FBXAException("flag not allowed in this context: " + flags + ", valid flags are TMSUCCESS, TMFAIL, TMSUSPEND", -6);
        }
        try {
            this.internalEnd(id, flags);
        }
        catch (SQLException e) {
            throw new FBXAException(-3, e);
        }
        this.mcf.notifyEnd(this, id);
        this.inDistributedTransaction = false;
        try {
            this.setManagedEnvironment(this.isManagedEnvironment());
        }
        catch (ResourceException ex) {
            throw new FBXAException("Reset of managed state failed", -3, (Exception)((Object)ex));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void internalEnd(Xid xid, int flags) throws XAException, SQLException {
        FbTransaction endingTr;
        if (log.isDebugEnabled()) {
            log.debug("End called: " + xid);
        }
        if ((endingTr = this.xidMap.get(xid)) == null) {
            throw new FBXAException("Unrecognized transaction", -4);
        }
        if (flags == 0x20000000) {
            try {
                endingTr.rollback();
                this.getGDSHelper().setCurrentTransaction(null);
                return;
            }
            catch (SQLException ex) {
                throw new FBXAException("can't rollback transaction", -7, ex);
            }
        } else if (flags == 0x4000000) {
            if (this.gdsHelper == null || endingTr != this.gdsHelper.getCurrentTransaction()) throw new FBXAException("You are trying to end a transaction that is not the current transaction", -5);
            this.gdsHelper.setCurrentTransaction(null);
            return;
        } else {
            if (flags != 0x2000000) return;
            if (this.gdsHelper == null || endingTr != this.gdsHelper.getCurrentTransaction()) throw new FBXAException("You are trying to suspend a transaction that is not the current transaction", -5);
            this.gdsHelper.setCurrentTransaction(null);
        }
    }

    @Override
    public void forget(Xid id) throws XAException {
        FbStatement stmtHandle2;
        FbTransaction trHandle2;
        long inLimboId = -1L;
        try {
            trHandle2 = this.database.startTransaction(this.tpb.getTransactionParameterBuffer());
            stmtHandle2 = this.database.createStatement(trHandle2);
            GDSHelper gdsHelper2 = new GDSHelper(this.database);
            gdsHelper2.setCurrentTransaction(trHandle2);
            stmtHandle2.prepare(FORGET_FIND_QUERY);
            DataProvider dataProvider0 = new DataProvider(0);
            stmtHandle2.addStatementListener(dataProvider0);
            DataProvider dataProvider1 = new DataProvider(1);
            stmtHandle2.addStatementListener(dataProvider1);
            stmtHandle2.execute(RowValue.EMPTY_ROW_VALUE);
            stmtHandle2.fetchRows(10);
            FBField field0 = FBField.createField(stmtHandle2.getRowDescriptor().getFieldDescriptor(0), dataProvider0, gdsHelper2, false);
            FBField field1 = FBField.createField(stmtHandle2.getRowDescriptor().getFieldDescriptor(1), dataProvider1, gdsHelper2, false);
            for (int row = 0; row < dataProvider0.getRowCount(); ++row) {
                dataProvider0.setRow(row);
                dataProvider1.setRow(row);
                long inLimboTxId = field0.getLong();
                byte[] inLimboMessage = field1.getBytes();
                try {
                    FBXid xid = new FBXid(new ByteArrayInputStream(inLimboMessage), inLimboTxId);
                    boolean gtridEquals = Arrays.equals(xid.getGlobalTransactionId(), id.getGlobalTransactionId());
                    boolean bqualEquals = Arrays.equals(xid.getBranchQualifier(), id.getBranchQualifier());
                    if (!gtridEquals || !bqualEquals) continue;
                    inLimboId = inLimboTxId;
                    break;
                }
                catch (FBIncorrectXidException ex) {
                    String message = "incorrect XID format in RDB$TRANSACTIONS where RDB$TRANSACTION_ID=" + inLimboTxId;
                    log.warn(message + ": " + (Object)((Object)ex) + "; see debug level for stacktrace");
                    log.debug(message, (Throwable)((Object)ex));
                }
            }
            stmtHandle2.close();
            trHandle2.commit();
        }
        catch (SQLException | ResourceException ex) {
            log.debug("can't perform query to fetch xids", ex);
            throw new FBXAException(-7, (Exception)ex);
        }
        if (inLimboId == -1L) {
            throw new FBXAException("XID not found", -4);
        }
        try {
            trHandle2 = this.database.startTransaction(this.tpb.getTransactionParameterBuffer());
            stmtHandle2 = this.database.createStatement(trHandle2);
            stmtHandle2.prepare(FORGET_DELETE_QUERY + inLimboId);
            stmtHandle2.execute(RowValue.EMPTY_ROW_VALUE);
            stmtHandle2.close();
            trHandle2.commit();
        }
        catch (SQLException ex) {
            throw new FBXAException("can't perform query to fetch xids", -7, ex);
        }
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.timeout;
    }

    @Override
    public boolean isSameRM(XAResource res) throws XAException {
        return res instanceof FBManagedConnection && this.database == ((FBManagedConnection)res).database;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        try {
            return this.mcf.notifyPrepare(this, xid);
        }
        catch (GDSException ge) {
            throw new FBXAException(-3, ge);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int internalPrepare(Xid xid) throws FBXAException {
        FbTransaction committingTr;
        if (log.isTraceEnabled()) {
            log.trace("prepare called: " + xid);
        }
        if ((committingTr = this.xidMap.get(xid)) == null) {
            throw new FBXAException("Prepare called with unknown transaction", -4);
        }
        try {
            if (committingTr == this.getGDSHelper().getCurrentTransaction()) {
                throw new FBXAException("Prepare called with non-ended xid", -6);
            }
            FBXid fbxid = xid instanceof FBXid ? (FBXid)xid : new FBXid(xid);
            byte[] message = fbxid.toBytes();
            committingTr.prepare(message);
        }
        catch (SQLException ge) {
            try {
                if (this.gdsHelper != null) {
                    committingTr.rollback();
                } else {
                    log.warn("Unable to rollback failed tx, connection closed or lost");
                }
            }
            catch (SQLException ge2) {
                log.debug("Exception rolling back failed tx: ", ge2);
            }
            finally {
                this.xidMap.remove(xid);
            }
            log.warn("error in prepare", ge);
            throw new FBXAException(-3, ge);
        }
        this.preparedXid.add(xid);
        return 0;
    }

    @Override
    public Xid[] recover(int flags) throws XAException {
        if (flags != 0x1000000 && flags != 0x800000 && flags != 0 && flags != 0x1800000) {
            throw new FBXAException("flag not allowed in this context: " + flags + ", valid flags are TMSTARTRSCAN, TMENDRSCAN, TMNOFLAGS, TMSTARTRSCAN|TMENDRSCAN", -6);
        }
        try {
            ArrayList<FBXid> xids = new ArrayList<FBXid>();
            FbTransaction trHandle2 = this.database.startTransaction(this.tpb.getTransactionParameterBuffer());
            FbStatement stmtHandle2 = this.database.createStatement(trHandle2);
            GDSHelper gdsHelper2 = new GDSHelper(this.database);
            gdsHelper2.setCurrentTransaction(trHandle2);
            stmtHandle2.prepare(RECOVERY_QUERY);
            DataProvider dataProvider0 = new DataProvider(0);
            stmtHandle2.addStatementListener(dataProvider0);
            DataProvider dataProvider1 = new DataProvider(1);
            stmtHandle2.addStatementListener(dataProvider1);
            stmtHandle2.execute(RowValue.EMPTY_ROW_VALUE);
            stmtHandle2.fetchRows(10);
            FBField field0 = FBField.createField(stmtHandle2.getRowDescriptor().getFieldDescriptor(0), dataProvider0, gdsHelper2, false);
            FBField field1 = FBField.createField(stmtHandle2.getRowDescriptor().getFieldDescriptor(1), dataProvider1, gdsHelper2, false);
            for (int row = 0; row < dataProvider0.getRowCount(); ++row) {
                dataProvider0.setRow(row);
                dataProvider1.setRow(row);
                long inLimboTxId = field0.getLong();
                byte[] inLimboMessage = field1.getBytes();
                try {
                    FBXid xid = new FBXid(new ByteArrayInputStream(inLimboMessage), inLimboTxId);
                    xids.add(xid);
                    continue;
                }
                catch (FBIncorrectXidException ex) {
                    log.warn("ignoring XID stored with invalid format in RDB$TRANSACTIONS for RDB$TRANSACTION_ID=" + inLimboTxId);
                }
            }
            stmtHandle2.close();
            trHandle2.commit();
            return xids.toArray(new FBXid[0]);
        }
        catch (SQLException | ResourceException e) {
            throw new FBXAException("can't perform query to fetch xids", -7, (Exception)e);
        }
    }

    protected Xid findSingleXid(Xid externalXid) throws XAException {
        try {
            FbTransaction trHandle2 = this.database.startTransaction(this.tpb.getTransactionParameterBuffer());
            FbStatement stmtHandle2 = this.database.createStatement(trHandle2);
            GDSHelper gdsHelper2 = new GDSHelper(this.database);
            gdsHelper2.setCurrentTransaction(trHandle2);
            stmtHandle2.prepare(RECOVERY_QUERY_PARAMETRIZED);
            DataProvider dataProvider0 = new DataProvider(0);
            stmtHandle2.addStatementListener(dataProvider0);
            DataProvider dataProvider1 = new DataProvider(1);
            stmtHandle2.addStatementListener(dataProvider1);
            FBXid tempXid = new FBXid(externalXid);
            RowValue parameters = RowValue.of(stmtHandle2.getParameterDescriptor(), (byte[][])new byte[][]{tempXid.toBytes()});
            stmtHandle2.execute(parameters);
            stmtHandle2.fetchRows(1);
            FBField field0 = FBField.createField(stmtHandle2.getRowDescriptor().getFieldDescriptor(0), dataProvider0, gdsHelper2, false);
            FBField field1 = FBField.createField(stmtHandle2.getRowDescriptor().getFieldDescriptor(1), dataProvider1, gdsHelper2, false);
            FBXid xid = null;
            if (dataProvider0.getRowCount() > 0) {
                dataProvider0.setRow(0);
                dataProvider1.setRow(0);
                long inLimboTxId = field0.getLong();
                byte[] inLimboMessage = field1.getBytes();
                try {
                    xid = new FBXid(new ByteArrayInputStream(inLimboMessage), inLimboTxId);
                }
                catch (FBIncorrectXidException ex) {
                    log.warn("ignoring XID stored with invalid format in RDB$TRANSACTIONS for RDB$TRANSACTION_ID=" + inLimboTxId);
                }
            }
            stmtHandle2.close();
            trHandle2.commit();
            return xid;
        }
        catch (SQLException | ResourceException e) {
            throw new FBXAException("can't perform query to fetch xids", -7, (Exception)e);
        }
    }

    @Override
    public final Object getSynchronizationObject() {
        return this.syncObject;
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        try {
            this.mcf.notifyRollback(this, xid);
        }
        catch (GDSException ge) {
            throw new FBXAException(ge.getXAErrorCode(), ge);
        }
    }

    void internalRollback(Xid xid) throws XAException {
        FbTransaction committingTr;
        if (log.isTraceEnabled()) {
            log.trace("rollback called: " + xid);
        }
        if ((committingTr = this.xidMap.get(xid)) == null) {
            throw new FBXAException("Rollback called with unknown transaction: " + xid);
        }
        try {
            if (committingTr == this.getGDSHelper().getCurrentTransaction()) {
                throw new FBXAException("Rollback called with non-ended xid", -6);
            }
            try {
                committingTr.rollback();
            }
            finally {
                this.xidMap.remove(xid);
                this.preparedXid.remove(xid);
            }
        }
        catch (SQLException ge) {
            log.debug("Exception in rollback", ge);
            throw new FBXAException(ge.getMessage(), -3, ge);
        }
    }

    @Override
    public boolean setTransactionTimeout(int timeout) throws XAException {
        this.timeout = timeout;
        return true;
    }

    public boolean inDistributedTransaction() {
        return this.inDistributedTransaction;
    }

    @Override
    public void start(Xid id, int flags) throws XAException {
        if (flags != 0 && flags != 0x200000 && flags != 0x8000000) {
            throw new FBXAException("flag not allowed in this context: " + flags + ", valid flags are TMNOFLAGS, TMJOIN, TMRESUME", -6);
        }
        if (flags == 0x200000) {
            throw new FBXAException("Joining two transactions is not supported", -7);
        }
        try {
            this.setTransactionIsolation(this.mcf.getDefaultTransactionIsolation());
            this.internalStart(id, flags);
            this.mcf.notifyStart(this, id);
            this.inDistributedTransaction = true;
            this.setManagedEnvironment(this.isManagedEnvironment());
        }
        catch (GDSException ge) {
            throw new FBXAException(ge.getXAErrorCode(), ge);
        }
        catch (SQLException | ResourceException e) {
            throw new FBXAException(-3, (Exception)e);
        }
    }

    public void internalStart(Xid id, int flags) throws XAException, SQLException {
        if (log.isTraceEnabled()) {
            log.trace("start called: " + id);
        }
        if (this.getGDSHelper().getCurrentTransaction() != null) {
            throw new FBXAException("Transaction already started", -6);
        }
        this.findIscTrHandle(id, flags);
    }

    public void close(FBConnection c) {
        c.setManagedConnection(null);
        this.connectionHandles.remove(c);
        ConnectionEvent ce = new ConnectionEvent((ManagedConnection)this, 1, null);
        ce.setConnectionHandle((Object)c);
        this.notify(connectionClosedNotifier, ce);
    }

    public FBConnectionRequestInfo getConnectionRequestInfo() {
        return this.cri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionParameterBuffer getTransactionParameters() {
        Object object = this.syncObject;
        synchronized (object) {
            return this.tpb.getTransactionParameterBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransactionParameters(TransactionParameterBuffer transactionParameters) {
        Object object = this.syncObject;
        synchronized (object) {
            this.tpb.setTransactionParameterBuffer(transactionParameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionParameterBuffer getTransactionParameters(int isolation) {
        Object object = this.syncObject;
        synchronized (object) {
            FBTpbMapper mapping = this.transactionMapping;
            if (mapping == null) {
                return this.mcf.getTransactionParameters(isolation);
            }
            return mapping.getMapping(isolation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransactionParameters(int isolation, TransactionParameterBuffer transactionParams) throws ResourceException {
        Object object = this.syncObject;
        synchronized (object) {
            FBTpbMapper mapping = this.transactionMapping;
            if (mapping == null) {
                mapping = this.transactionMapping = this.mcf.getTransactionMappingCopy();
            }
            mapping.setMapping(isolation, transactionParams);
            if (this.getTransactionIsolation() == isolation) {
                this.setTransactionIsolation(isolation);
            }
        }
    }

    private void findIscTrHandle(Xid xid, int flags) throws SQLException, XAException {
        this.getGDSHelper().setCurrentTransaction(null);
        if (flags == 0x8000000) {
            FbTransaction trHandle = this.xidMap.get(xid);
            if (trHandle == null) {
                throw new FBXAException("You are trying to resume a transaction that is not attached to this XAResource", -5);
            }
            this.getGDSHelper().setCurrentTransaction(trHandle);
            return;
        }
        for (Xid knownXid : this.xidMap.keySet()) {
            boolean sameFormatId = knownXid.getFormatId() == xid.getFormatId();
            boolean sameGtrid = Arrays.equals(knownXid.getGlobalTransactionId(), xid.getGlobalTransactionId());
            boolean sameBqual = Arrays.equals(knownXid.getBranchQualifier(), xid.getBranchQualifier());
            if (!sameFormatId || !sameGtrid || !sameBqual) continue;
            throw new FBXAException("A transaction with the same XID has already been started", -8);
        }
        try {
            FbTransaction transaction = this.getGDSHelper().startTransaction(this.tpb.getTransactionParameterBuffer());
            this.xidMap.put(xid, transaction);
        }
        catch (SQLException e) {
            throw new FBXAException(e.getMessage(), -3, e);
        }
    }

    void notify(CELNotifier notifier, ConnectionEvent ce) {
        for (ConnectionEventListener cel : this.connectionEventListeners) {
            notifier.notify(cel, ce);
        }
    }

    boolean matches(Subject subj, ConnectionRequestInfo cri) {
        if (cri == null) {
            return true;
        }
        if (!(cri instanceof FBConnectionRequestInfo)) {
            return false;
        }
        try {
            return this.cri.equals(this.getCombinedConnectionRequestInfo(subj, cri));
        }
        catch (ResourceException re) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTransactionIsolation() throws ResourceException {
        Object object = this.syncObject;
        synchronized (object) {
            return this.transactionIsolation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransactionIsolation(int isolation) throws ResourceException {
        Object object = this.syncObject;
        synchronized (object) {
            this.transactionIsolation = isolation;
            FBTpbMapper mapping = this.transactionMapping;
            this.tpb = mapping == null ? this.mcf.getTpb(isolation) : new FBTpb(mapping.getMapping(isolation));
        }
    }

    public ManagedConnectionFactory getManagedConnectionFactory() {
        return this.mcf;
    }

    public void setReadOnly(boolean readOnly) {
        this.tpb.setReadOnly(readOnly);
    }

    public boolean isReadOnly() {
        return this.tpb.isReadOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWarning(SQLWarning warning) {
        List<FBConnection> list = this.connectionHandles;
        synchronized (list) {
            if (this.connectionHandles.isEmpty()) {
                if (this.unnotifiedWarnings == null) {
                    this.unnotifiedWarnings = warning;
                } else {
                    this.unnotifiedWarnings.setNextWarning(warning);
                }
            }
            for (FBConnection connection : this.connectionHandles) {
                connection.addWarning(warning);
            }
        }
    }

    private static String getDefaultConnectionEncoding() {
        try {
            String defaultConnectionEncoding = JaybirdSystemProperties.getDefaultConnectionEncoding();
            if (defaultConnectionEncoding == null) {
                if (JaybirdSystemProperties.isRequireConnectionEncoding()) {
                    return null;
                }
                return "NONE";
            }
            return defaultConnectionEncoding;
        }
        catch (Exception e) {
            log.error("Exception obtaining default connection encoding", e);
            return "NONE";
        }
    }

    private class MCDatabaseListener
    extends DefaultDatabaseListener {
        private MCDatabaseListener() {
        }

        @Override
        public void warningReceived(FbDatabase database, SQLWarning warning) {
            if (database != FBManagedConnection.this.database) {
                database.removeDatabaseListener(this);
                return;
            }
            FBManagedConnection.this.notifyWarning(warning);
        }
    }

    static interface CELNotifier {
        public void notify(ConnectionEventListener var1, ConnectionEvent var2);
    }

    private static class DataProvider
    extends DefaultStatementListener
    implements FieldDataProvider {
        private final List<RowValue> rows = new ArrayList<RowValue>();
        private final int fieldPos;
        private int row;

        private DataProvider(int fieldPos) {
            this.fieldPos = fieldPos;
        }

        public void setRow(int row) {
            this.row = row;
        }

        @Override
        public byte[] getFieldData() {
            return this.rows.get(this.row).getFieldData(this.fieldPos);
        }

        @Override
        public void setFieldData(byte[] data) {
            throw new UnsupportedOperationException();
        }

        public int getRowCount() {
            return this.rows.size();
        }

        @Override
        public void receivedRow(FbStatement sender, RowValue rowValue) {
            this.rows.add(rowValue);
        }
    }
}

