/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jca;

import java.io.ObjectStreamException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.firebirdsql.gds.DatabaseParameterBuffer;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.TransactionParameterBuffer;
import org.firebirdsql.gds.impl.GDSFactory;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.gds.ng.FbDatabase;
import org.firebirdsql.gds.ng.FbDatabaseFactory;
import org.firebirdsql.gds.ng.FbStatement;
import org.firebirdsql.gds.ng.FbTransaction;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.jca.FBConnectionRequestInfo;
import org.firebirdsql.jca.FBManagedConnection;
import org.firebirdsql.jca.FBResourceException;
import org.firebirdsql.jca.FBStandAloneConnectionManager;
import org.firebirdsql.jca.FBTpb;
import org.firebirdsql.jca.FBXAException;
import org.firebirdsql.jca.FBXid;
import org.firebirdsql.jca.FirebirdLocalTransaction;
import org.firebirdsql.jdbc.FBConnection;
import org.firebirdsql.jdbc.FBConnectionProperties;
import org.firebirdsql.jdbc.FBDataSource;
import org.firebirdsql.jdbc.FBTpbMapper;
import org.firebirdsql.jdbc.FirebirdConnectionProperties;

public class FBManagedConnectionFactory
implements ManagedConnectionFactory,
FirebirdConnectionProperties,
Serializable {
    private static final long serialVersionUID = 7500832904323015501L;
    private static final Map<FBConnectionProperties, SoftReference<FBManagedConnectionFactory>> mcfInstances = new ConcurrentHashMap<FBConnectionProperties, SoftReference<FBManagedConnectionFactory>>();
    private static final ReferenceQueue<FBManagedConnectionFactory> mcfReferenceQueue = new ReferenceQueue();
    private ConnectionManager defaultCm;
    private int hashCode;
    private GDSType gdsType;
    private final transient Map<Xid, FBManagedConnection> xidMap = new ConcurrentHashMap<Xid, FBManagedConnection>();
    private final transient Object startLock = new Object();
    private transient boolean started = false;
    private FBConnectionProperties connectionProperties;

    public FBManagedConnectionFactory() {
        this(GDSFactory.getDefaultGDSType(), new FBConnectionProperties());
    }

    public FBManagedConnectionFactory(GDSType gdsType) {
        this(gdsType, new FBConnectionProperties());
    }

    public FBManagedConnectionFactory(GDSType gdsType, FBConnectionProperties connectionProperties) {
        this.defaultCm = new FBStandAloneConnectionManager();
        this.connectionProperties = connectionProperties;
        this.setType(gdsType.toString());
    }

    public FbDatabaseFactory getDatabaseFactory() {
        return GDSFactory.getDatabaseFactoryForType(this.getGDSType());
    }

    public GDSType getGDSType() {
        if (this.gdsType != null) {
            return this.gdsType;
        }
        this.gdsType = GDSType.getType(this.getType());
        return this.gdsType;
    }

    @Deprecated
    public int getBlobBufferLength() {
        return this.getBlobBufferSize();
    }

    @Deprecated
    public void setBlobBufferLength(int value) {
        this.setBlobBufferSize(value);
    }

    @Deprecated
    public Integer getTransactionIsolation() {
        return this.getDefaultTransactionIsolation();
    }

    @Deprecated
    public void setTransactionIsolation(Integer value) {
        if (value != null) {
            this.setDefaultTransactionIsolation(value);
        }
    }

    @Deprecated
    public String getTransactionIsolationName() {
        return this.getDefaultIsolation();
    }

    @Deprecated
    public void setTransactionIsolationName(String name) {
        this.setDefaultIsolation(name);
    }

    @Deprecated
    public String getLocalEncoding() {
        return this.getCharSet();
    }

    @Deprecated
    public void setLocalEncoding(String localEncoding) {
        this.setCharSet(localEncoding);
    }

    @Override
    public int getBlobBufferSize() {
        return this.connectionProperties.getBlobBufferSize();
    }

    @Override
    public int getBuffersNumber() {
        return this.connectionProperties.getBuffersNumber();
    }

    @Override
    public String getCharSet() {
        return this.connectionProperties.getCharSet();
    }

    @Override
    public String getDatabase() {
        return this.connectionProperties.getDatabase();
    }

    @Override
    public DatabaseParameterBuffer getDatabaseParameterBuffer() throws SQLException {
        return this.connectionProperties.getDatabaseParameterBuffer();
    }

    @Override
    public String getDefaultIsolation() {
        return this.connectionProperties.getDefaultIsolation();
    }

    @Override
    public int getDefaultTransactionIsolation() {
        return this.connectionProperties.getDefaultTransactionIsolation();
    }

    @Override
    public String getEncoding() {
        return this.connectionProperties.getEncoding();
    }

    @Override
    public String getNonStandardProperty(String key) {
        return this.connectionProperties.getNonStandardProperty(key);
    }

    @Override
    public String getPassword() {
        return this.connectionProperties.getPassword();
    }

    @Override
    public String getRoleName() {
        return this.connectionProperties.getRoleName();
    }

    @Override
    public int getSocketBufferSize() {
        return this.connectionProperties.getSocketBufferSize();
    }

    @Override
    public String getSqlDialect() {
        return this.connectionProperties.getSqlDialect();
    }

    @Override
    public String getTpbMapping() {
        return this.connectionProperties.getTpbMapping();
    }

    @Override
    public TransactionParameterBuffer getTransactionParameters(int isolation) {
        return this.connectionProperties.getTransactionParameters(isolation);
    }

    @Override
    public String getType() {
        return this.connectionProperties.getType();
    }

    @Override
    public String getUserName() {
        return this.connectionProperties.getUserName();
    }

    @Override
    public boolean isTimestampUsesLocalTimezone() {
        return this.connectionProperties.isTimestampUsesLocalTimezone();
    }

    @Override
    public boolean isUseStandardUdf() {
        return this.connectionProperties.isUseStandardUdf();
    }

    @Override
    public boolean isUseStreamBlobs() {
        return this.connectionProperties.isUseStreamBlobs();
    }

    @Override
    public void setBlobBufferSize(int bufferSize) {
        this.connectionProperties.setBlobBufferSize(bufferSize);
    }

    @Override
    public void setBuffersNumber(int buffersNumber) {
        this.connectionProperties.setBuffersNumber(buffersNumber);
    }

    @Override
    public void setCharSet(String charSet) {
        this.connectionProperties.setCharSet(charSet);
    }

    @Override
    public void setDatabase(String database) {
        this.connectionProperties.setDatabase(database);
    }

    @Override
    public void setDefaultIsolation(String isolation) {
        this.connectionProperties.setDefaultIsolation(isolation);
    }

    @Override
    public void setDefaultTransactionIsolation(int defaultIsolationLevel) {
        this.connectionProperties.setDefaultTransactionIsolation(defaultIsolationLevel);
    }

    @Override
    public void setEncoding(String encoding) {
        this.connectionProperties.setEncoding(encoding);
    }

    @Override
    public void setNonStandardProperty(String key, String value) {
        this.connectionProperties.setNonStandardProperty(key, value);
    }

    @Override
    public void setNonStandardProperty(String propertyMapping) {
        this.connectionProperties.setNonStandardProperty(propertyMapping);
    }

    @Override
    public void setPassword(String password) {
        this.connectionProperties.setPassword(password);
    }

    @Override
    public void setRoleName(String roleName) {
        this.connectionProperties.setRoleName(roleName);
    }

    @Override
    public void setSocketBufferSize(int socketBufferSize) {
        this.connectionProperties.setSocketBufferSize(socketBufferSize);
    }

    @Override
    public void setSqlDialect(String sqlDialect) {
        this.connectionProperties.setSqlDialect(sqlDialect);
    }

    @Override
    public void setTimestampUsesLocalTimezone(boolean timestampUsesLocalTimezone) {
        this.connectionProperties.setTimestampUsesLocalTimezone(timestampUsesLocalTimezone);
    }

    @Override
    public void setTpbMapping(String tpbMapping) {
        this.connectionProperties.setTpbMapping(tpbMapping);
    }

    @Override
    public void setTransactionParameters(int isolation, TransactionParameterBuffer tpb) {
        this.connectionProperties.setTransactionParameters(isolation, tpb);
    }

    @Override
    public void setType(String type) {
        if (this.gdsType != null) {
            throw new IllegalStateException("Cannot change GDS type at runtime.");
        }
        this.connectionProperties.setType(type);
    }

    @Override
    public void setUserName(String userName) {
        this.connectionProperties.setUserName(userName);
    }

    @Override
    public void setUseStandardUdf(boolean useStandardUdf) {
        this.connectionProperties.setUseStandardUdf(useStandardUdf);
    }

    @Override
    public void setUseStreamBlobs(boolean useStreamBlobs) {
        this.connectionProperties.setUseStreamBlobs(useStreamBlobs);
    }

    @Override
    public boolean isDefaultResultSetHoldable() {
        return this.connectionProperties.isDefaultResultSetHoldable();
    }

    @Override
    public void setDefaultResultSetHoldable(boolean isHoldable) {
        this.connectionProperties.setDefaultResultSetHoldable(isHoldable);
    }

    public void setDefaultConnectionManager(ConnectionManager defaultCm) {
        this.defaultCm = defaultCm;
    }

    @Override
    public int getSoTimeout() {
        return this.connectionProperties.getSoTimeout();
    }

    @Override
    public void setSoTimeout(int soTimeout) {
        this.connectionProperties.setSoTimeout(soTimeout);
    }

    @Override
    public int getConnectTimeout() {
        return this.connectionProperties.getConnectTimeout();
    }

    @Override
    public void setConnectTimeout(int connectTimeout) {
        this.connectionProperties.setConnectTimeout(connectTimeout);
    }

    @Override
    public boolean isUseFirebirdAutocommit() {
        return this.connectionProperties.isUseFirebirdAutocommit();
    }

    @Override
    public void setUseFirebirdAutocommit(boolean useFirebirdAutocommit) {
        this.connectionProperties.setUseFirebirdAutocommit(useFirebirdAutocommit);
    }

    @Override
    public String getWireCrypt() {
        return this.connectionProperties.getWireCrypt();
    }

    @Override
    public void setWireCrypt(String wireCrypt) {
        this.connectionProperties.setWireCrypt(wireCrypt);
    }

    @Override
    public String getDbCryptConfig() {
        return this.connectionProperties.getDbCryptConfig();
    }

    @Override
    public void setDbCryptConfig(String dbCryptConfig) {
        this.connectionProperties.setDbCryptConfig(dbCryptConfig);
    }

    @Override
    public String getAuthPlugins() {
        return this.connectionProperties.getAuthPlugins();
    }

    @Override
    public void setAuthPlugins(String authPlugins) {
        this.connectionProperties.setAuthPlugins(authPlugins);
    }

    @Override
    public String getGeneratedKeysEnabled() {
        return this.connectionProperties.getGeneratedKeysEnabled();
    }

    @Override
    public void setGeneratedKeysEnabled(String generatedKeysEnabled) {
        this.connectionProperties.setGeneratedKeysEnabled(generatedKeysEnabled);
    }

    @Override
    public String getDataTypeBind() {
        return this.connectionProperties.getDataTypeBind();
    }

    @Override
    public void setDataTypeBind(String dataTypeBind) {
        this.connectionProperties.setDataTypeBind(dataTypeBind);
    }

    @Override
    public String getSessionTimeZone() {
        return this.connectionProperties.getSessionTimeZone();
    }

    @Override
    public void setSessionTimeZone(String sessionTimeZone) {
        this.connectionProperties.setSessionTimeZone(sessionTimeZone);
    }

    @Override
    public boolean isIgnoreProcedureType() {
        return this.connectionProperties.isIgnoreProcedureType();
    }

    @Override
    public void setIgnoreProcedureType(boolean ignoreProcedureType) {
        this.connectionProperties.setIgnoreProcedureType(ignoreProcedureType);
    }

    @Override
    public boolean isWireCompression() {
        return this.connectionProperties.isWireCompression();
    }

    @Override
    public void setWireCompression(boolean wireCompression) {
        this.connectionProperties.setWireCompression(wireCompression);
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        int result = 17;
        if ((result = 37 * result + this.connectionProperties.hashCode()) == 0) {
            result = 17;
        }
        if (this.gdsType != null) {
            this.hashCode = result;
        }
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof FBManagedConnectionFactory)) {
            return false;
        }
        FBManagedConnectionFactory that = (FBManagedConnectionFactory)other;
        return this.connectionProperties.equals(that.connectionProperties);
    }

    public FBConnectionRequestInfo getDefaultConnectionRequestInfo() throws ResourceException {
        try {
            return new FBConnectionRequestInfo(this.getDatabaseParameterBuffer().deepCopy());
        }
        catch (SQLException ex) {
            throw new FBResourceException(ex);
        }
    }

    public FBTpb getDefaultTpb() throws ResourceException {
        int defaultTransactionIsolation = this.connectionProperties.getMapper().getDefaultTransactionIsolation();
        return this.getTpb(defaultTransactionIsolation);
    }

    public FBTpb getTpb(int defaultTransactionIsolation) throws FBResourceException {
        return new FBTpb(this.connectionProperties.getMapper().getMapping(defaultTransactionIsolation));
    }

    FBTpbMapper getTransactionMappingCopy() throws ResourceException {
        return (FBTpbMapper)this.connectionProperties.getMapper().clone();
    }

    public Object createConnectionFactory(ConnectionManager cxManager) throws ResourceException {
        this.start();
        return new FBDataSource(this, cxManager);
    }

    public Object createConnectionFactory() throws ResourceException {
        this.start();
        return new FBDataSource(this, this.defaultCm);
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        this.start();
        return new FBManagedConnection(subject, cri, this);
    }

    public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        for (Object connection : connectionSet) {
            FBManagedConnection mc;
            if (!(connection instanceof FBManagedConnection) || !(mc = (FBManagedConnection)connection).matches(subject, cxRequestInfo)) continue;
            return mc;
        }
        return null;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
    }

    public PrintWriter getLogWriter() {
        return null;
    }

    private Object readResolve() throws ObjectStreamException {
        FBManagedConnectionFactory mcf = this.internalCanonicalize();
        if (mcf != null) {
            return mcf;
        }
        mcf = new FBManagedConnectionFactory(this.getGDSType(), (FBConnectionProperties)this.connectionProperties.clone());
        return mcf;
    }

    public FBManagedConnectionFactory canonicalize() {
        FBManagedConnectionFactory mcf = this.internalCanonicalize();
        if (mcf != null) {
            return mcf;
        }
        this.start();
        return this;
    }

    private FBManagedConnectionFactory internalCanonicalize() {
        SoftReference<FBManagedConnectionFactory> factoryReference = mcfInstances.get(this.getCacheKey());
        return factoryReference != null ? factoryReference.get() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start() {
        Object object = this.startLock;
        synchronized (object) {
            if (this.started) {
                return;
            }
            mcfInstances.put(this.getCacheKey(), new SoftReference<FBManagedConnectionFactory>(this, mcfReferenceQueue));
            this.started = true;
        }
        this.cleanMcfInstances();
    }

    private void cleanMcfInstances() {
        Reference<FBManagedConnectionFactory> reference;
        while ((reference = mcfReferenceQueue.poll()) != null) {
            mcfInstances.values().remove(reference);
        }
    }

    void notifyStart(FBManagedConnection mc, Xid xid) throws GDSException {
        this.xidMap.put(xid, mc);
    }

    void notifyEnd(FBManagedConnection mc, Xid xid) throws XAException {
    }

    int notifyPrepare(FBManagedConnection mc, Xid xid) throws GDSException, XAException {
        FBManagedConnection targetMc = this.xidMap.get(xid);
        if (targetMc == null) {
            throw new FBXAException("Commit called with unknown transaction", -4);
        }
        return targetMc.internalPrepare(xid);
    }

    void notifyCommit(FBManagedConnection mc, Xid xid, boolean onePhase) throws GDSException, XAException {
        FBManagedConnection targetMc = this.xidMap.get(xid);
        if (targetMc == null) {
            this.tryCompleteInLimboTransaction(xid, true);
        } else {
            targetMc.internalCommit(xid, onePhase);
        }
        this.xidMap.remove(xid);
    }

    void notifyRollback(FBManagedConnection mc, Xid xid) throws GDSException, XAException {
        FBManagedConnection targetMc = this.xidMap.get(xid);
        if (targetMc == null) {
            this.tryCompleteInLimboTransaction(xid, false);
        } else {
            targetMc.internalRollback(xid);
        }
        this.xidMap.remove(xid);
    }

    public void forget(FBManagedConnection mc, Xid xid) throws GDSException {
        this.xidMap.remove(xid);
    }

    public void recover(FBManagedConnection mc, Xid xid) throws GDSException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryCompleteInLimboTransaction(Xid xid, boolean commit) throws XAException {
        block27: {
            try {
                FBManagedConnection tempMc = null;
                FirebirdLocalTransaction tempLocalTx = null;
                try {
                    tempMc = new FBManagedConnection(null, null, this);
                    tempLocalTx = (FirebirdLocalTransaction)tempMc.getLocalTransaction();
                    tempLocalTx.begin();
                    long fbTransactionId = 0L;
                    boolean found = false;
                    if (tempMc.getGDSHelper().compareToVersion(2, 0) < 0) {
                        FBXid[] inLimboIds;
                        for (FBXid inLimboId : inLimboIds = (FBXid[])tempMc.recover(0x1000000)) {
                            if (!inLimboId.equals(xid)) continue;
                            found = true;
                            fbTransactionId = inLimboId.getFirebirdTransactionId();
                        }
                    } else {
                        FBXid foundXid = (FBXid)tempMc.findSingleXid(xid);
                        if (foundXid != null && foundXid.equals(xid)) {
                            found = true;
                            fbTransactionId = foundXid.getFirebirdTransactionId();
                        }
                    }
                    if (!found) {
                        throw new FBXAException((commit ? "Commit" : "Rollback") + " called with unknown transaction.", -4);
                    }
                    FbDatabase dbHandle = tempMc.getGDSHelper().getCurrentDatabase();
                    FbTransaction trHandle = dbHandle.reconnectTransaction(fbTransactionId);
                    if (commit) {
                        trHandle.commit();
                    } else {
                        trHandle.rollback();
                    }
                    if (tempMc.getGDSHelper().compareToVersion(3, 0) >= 0) break block27;
                    try {
                        String query = "delete from rdb$transactions where rdb$transaction_id = " + fbTransactionId;
                        FbTransaction trHandle2 = dbHandle.startTransaction(this.getDefaultTpb().getTransactionParameterBuffer());
                        FbStatement stmtHandle2 = dbHandle.createStatement(trHandle2);
                        stmtHandle2.prepare(query);
                        stmtHandle2.execute(RowValue.EMPTY_ROW_VALUE);
                        stmtHandle2.close();
                        trHandle2.commit();
                    }
                    catch (SQLException sqle) {
                        throw new FBXAException("unable to remove in limbo transaction from rdb$transactions where rdb$transaction_id = " + fbTransactionId, -3);
                    }
                }
                catch (SQLException ex) {
                    int errorCode = -3;
                    int sqlError = ex.getErrorCode();
                    if (sqlError == 335544353) {
                        if (ex.getMessage().contains("committed")) {
                            errorCode = 7;
                        } else if (ex.getMessage().contains("rolled back")) {
                            errorCode = 7;
                        }
                    }
                    throw new FBXAException("unable to complete in limbo transaction", errorCode, ex);
                }
                finally {
                    try {
                        if (tempLocalTx != null && tempLocalTx.inTransaction()) {
                            tempLocalTx.commit();
                        }
                    }
                    finally {
                        if (tempMc != null) {
                            tempMc.destroy();
                        }
                    }
                }
            }
            catch (ResourceException ex) {
                throw new FBXAException(-3, (Exception)((Object)ex));
            }
        }
    }

    FBConnection newConnection(FBManagedConnection mc) throws ResourceException {
        Class<?> connectionClass = GDSFactory.getConnectionClass(this.getGDSType());
        if (!FBConnection.class.isAssignableFrom(connectionClass)) {
            throw new IllegalArgumentException("Specified connection class does not extend " + FBConnection.class.getName() + " class");
        }
        try {
            Constructor<?> constructor = connectionClass.getConstructor(FBManagedConnection.class);
            return (FBConnection)constructor.newInstance(mc);
        }
        catch (NoSuchMethodException ex) {
            throw new FBResourceException("Cannot instantiate connection class " + connectionClass.getName() + ", no constructor accepting " + FBManagedConnection.class + " class as single parameter was found.");
        }
        catch (InvocationTargetException ex) {
            if (ex.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)ex.getTargetException();
            }
            if (ex.getTargetException() instanceof Error) {
                throw (Error)ex.getTargetException();
            }
            throw new FBResourceException((Exception)ex.getTargetException());
        }
        catch (IllegalAccessException ex) {
            throw new FBResourceException("Constructor for class " + connectionClass.getName() + " is not accessible.");
        }
        catch (InstantiationException ex) {
            throw new FBResourceException("Cannot instantiate class" + connectionClass.getName());
        }
    }

    public final FBConnectionProperties getCacheKey() {
        return (FBConnectionProperties)this.connectionProperties.clone();
    }
}

