/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.firebirdsql.gds.ng.DatatypeCoder;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.jdbc.field.AbstractWithoutTimeZoneField;
import org.firebirdsql.jdbc.field.FieldDataProvider;

class FBTimestampField
extends AbstractWithoutTimeZoneField {
    FBTimestampField(FieldDescriptor fieldDescriptor, FieldDataProvider dataProvider, int requiredType) throws SQLException {
        super(fieldDescriptor, dataProvider, requiredType);
    }

    @Override
    public String getString() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return String.valueOf(this.getTimestamp());
    }

    @Override
    public Date getDate(Calendar cal) throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new Date(this.getDatatypeCoder().decodeTimestampCalendar(this.getFieldData(), cal).getTime());
    }

    @Override
    public Time getTime(Calendar cal) throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new Time(this.getDatatypeCoder().decodeTimestampCalendar(this.getFieldData(), cal).getTime());
    }

    @Override
    public Timestamp getTimestamp(Calendar cal) throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.getDatatypeCoder().decodeTimestampCalendar(this.getFieldData(), cal);
    }

    @Override
    public void setString(String value) throws SQLException {
        if (value == null) {
            this.setNull();
            return;
        }
        this.setTimestamp(Timestamp.valueOf(value));
    }

    @Override
    public void setDate(Date value, Calendar cal) throws SQLException {
        if (value == null) {
            this.setNull();
            return;
        }
        this.setFieldData(this.getDatatypeCoder().encodeTimestampCalendar(new Timestamp(value.getTime()), cal));
    }

    @Override
    public void setTime(Time value, Calendar cal) throws SQLException {
        if (value == null) {
            this.setNull();
            return;
        }
        this.setFieldData(this.getDatatypeCoder().encodeTimestampCalendar(new Timestamp(value.getTime()), cal));
    }

    @Override
    public void setTimestamp(Timestamp value, Calendar cal) throws SQLException {
        if (value == null) {
            this.setNull();
            return;
        }
        this.setFieldData(this.getDatatypeCoder().encodeTimestampCalendar(value, cal));
    }

    @Override
    public DatatypeCoder.RawDateTimeStruct getRawDateTimeStruct() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.getDatatypeCoder().decodeTimestampRaw(this.getFieldData());
    }

    @Override
    public void setRawDateTimeStruct(DatatypeCoder.RawDateTimeStruct raw) throws SQLException {
        if (raw == null) {
            this.setNull();
            return;
        }
        this.setFieldData(this.getDatatypeCoder().encodeTimestampRaw(raw));
    }
}

