/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline.command;

import java.io.PrintStream;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AvailableJDBCDrivers
implements Iterable<Driver> {
    private static final Logger LOGGER = Logger.getLogger(AvailableJDBCDrivers.class.getName());
    private final List<Driver> availableJDBCDrivers = AvailableJDBCDrivers.availableJDBCDrivers();

    private static List<Driver> availableJDBCDrivers() {
        ArrayList<Driver> availableJDBCDrivers = new ArrayList<Driver>();
        try {
            availableJDBCDrivers.addAll(Collections.list(DriverManager.getDrivers()));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not list JDBC drivers", e);
        }
        return availableJDBCDrivers;
    }

    @Override
    public Iterator<Driver> iterator() {
        return this.availableJDBCDrivers.iterator();
    }

    public void print(PrintStream out) {
        if (out == null) {
            return;
        }
        out.println();
        out.println("Available JDBC drivers:");
        for (Driver driver : this.availableJDBCDrivers) {
            out.printf(" %-50s %2d.%d%n", driver.getClass().getName(), driver.getMajorVersion(), driver.getMinorVersion());
        }
    }

    public int size() {
        return this.availableJDBCDrivers.size();
    }

    public String toString() {
        return "AvailableJDBCDrivers " + this.availableJDBCDrivers;
    }
}

