/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline.shell;

import picocli.CommandLine;
import schemacrawler.schemacrawler.DatabaseServerType;
import schemacrawler.tools.databaseconnector.DatabaseConnectorRegistry;
import us.fatehi.utility.Utility;

@CommandLine.Command(name="servers", header={"** List available SchemaCrawler database plugins"}, headerHeading="", synopsisHeading="Shell Command:%n", customSynopsis={"servers"}, optionListHeading="Options:%n")
public class AvailableServersCommand
implements Runnable {
    private static String availableServersDescriptive() {
        CommandLine.Help.ColorScheme.Builder colorSchemaBuilder = new CommandLine.Help.ColorScheme.Builder();
        colorSchemaBuilder.ansi(CommandLine.Help.Ansi.OFF);
        CommandLine.Help.TextTable textTable = CommandLine.Help.TextTable.forColumns((CommandLine.Help.ColorScheme)colorSchemaBuilder.build(), (CommandLine.Help.Column[])new CommandLine.Help.Column[]{new CommandLine.Help.Column(15, 1, CommandLine.Help.Column.Overflow.SPAN), new CommandLine.Help.Column(65, 1, CommandLine.Help.Column.Overflow.WRAP)});
        DatabaseConnectorRegistry databaseConnectorRegistry = DatabaseConnectorRegistry.getDatabaseConnectorRegistry();
        for (DatabaseServerType serverType : databaseConnectorRegistry) {
            textTable.addRowValues(new String[]{serverType.getDatabaseSystemIdentifier(), serverType.getDatabaseSystemName()});
        }
        return textTable.toString();
    }

    @Override
    public void run() {
        String availableServers = AvailableServersCommand.availableServersDescriptive();
        if (!Utility.isBlank((CharSequence)availableServers)) {
            System.out.println();
            System.out.println("Available SchemaCrawler database server plugins:");
            System.out.println(availableServers);
            System.out.println("Notes:");
            System.out.println("- For help on an individual database plugin,");
            System.out.println("  run SchemaCrawler with options like: `-h server:mysql`");
            System.out.println("  or, from the SchemaCrawler interactive shell: `help server:mysql`");
            System.out.println("- Options for the server plugins should be provided with the `connect` command");
        }
    }
}

