/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.snowflake.client.core.ParameterBindingDTO;
import net.snowflake.client.core.ResultUtil;
import net.snowflake.client.core.SFBaseResultSet;
import net.snowflake.client.core.SFBaseStatement;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFStatement;
import net.snowflake.client.core.StmtUtil;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakeLoggedFeatureNotSupportedException;
import net.snowflake.client.jdbc.SnowflakeResultSetV1;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeSQLLoggedException;
import net.snowflake.client.jdbc.SnowflakeStatement;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;
import net.snowflake.client.util.VariableTypeArray;

class SnowflakeStatementV1
implements Statement,
SnowflakeStatement {
    static final SFLogger logger = SFLoggerFactory.getLogger(SnowflakeStatementV1.class);
    private static final long NO_UPDATES = -1L;
    protected final SnowflakeConnectionV1 connection;
    protected final int resultSetType;
    protected final int resultSetConcurrency;
    protected final int resultSetHoldability;
    private int maxRows = 0;
    private final Set<ResultSet> openResultSets = ConcurrentHashMap.newKeySet();
    private ResultSet resultSet = null;
    private int fetchSize = 50;
    private Boolean isClosed = false;
    private long updateCount = -1L;
    private int queryTimeout = 0;
    private final int maxFieldSize = 0x1000000;
    SFBaseStatement sfBaseStatement;
    private boolean poolable;
    private String queryID;
    private List<String> batchQueryIDs = new LinkedList<String>();
    protected final List<BatchEntry> batch = new ArrayList<BatchEntry>();
    private SQLWarning sqlWarnings;

    SnowflakeStatementV1(SnowflakeConnectionV1 connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        logger.debug(" public SnowflakeStatement(SnowflakeConnectionV1 conn)", false);
        this.connection = connection;
        if (resultSetType != 1003) {
            throw new SQLFeatureNotSupportedException(String.format("ResultSet type %d is not supported.", resultSetType), ErrorCode.FEATURE_UNSUPPORTED.getSqlState(), ErrorCode.FEATURE_UNSUPPORTED.getMessageCode());
        }
        if (resultSetConcurrency != 1007) {
            throw new SQLFeatureNotSupportedException(String.format("ResultSet concurrency %d is not supported.", resultSetConcurrency), ErrorCode.FEATURE_UNSUPPORTED.getSqlState(), ErrorCode.FEATURE_UNSUPPORTED.getMessageCode());
        }
        if (resultSetHoldability != 2) {
            throw new SQLFeatureNotSupportedException(String.format("ResultSet holdability %d is not supported.", resultSetHoldability), ErrorCode.FEATURE_UNSUPPORTED.getSqlState(), ErrorCode.FEATURE_UNSUPPORTED.getMessageCode());
        }
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
        this.sfBaseStatement = connection != null ? connection.getHandler().getSFStatement() : null;
    }

    protected void raiseSQLExceptionIfStatementIsClosed() throws SQLException {
        if (this.isClosed.booleanValue()) {
            throw new SnowflakeSQLException(ErrorCode.STATEMENT_CLOSED, new Object[0]);
        }
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.raiseSQLExceptionIfStatementIsClosed();
        return this.executeQueryInternal(sql, false, null);
    }

    @Override
    public ResultSet executeAsyncQuery(String sql) throws SQLException {
        this.raiseSQLExceptionIfStatementIsClosed();
        return this.executeQueryInternal(sql, true, null);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return (int)this.executeLargeUpdate(sql);
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        return this.executeUpdateInternal(sql, null, true);
    }

    long executeUpdateInternal(String sql, Map<String, ParameterBindingDTO> parameterBindings, boolean updateQueryRequired) throws SQLException {
        this.raiseSQLExceptionIfStatementIsClosed();
        if (StmtUtil.checkStageManageCommand(sql) != null && parameterBindings != null) {
            throw new SnowflakeSQLLoggedException(this.connection.getSFBaseSession(), ErrorCode.UNSUPPORTED_STATEMENT_TYPE_IN_EXECUTION_API, StmtUtil.truncateSQL(sql));
        }
        try {
            SFBaseResultSet sfResultSet = this.sfBaseStatement.execute(sql, parameterBindings, SFBaseStatement.CallingMethod.EXECUTE_UPDATE);
            sfResultSet.setSession(this.connection.getSFBaseSession());
            this.updateCount = ResultUtil.calculateUpdateCount(sfResultSet);
            this.queryID = sfResultSet.getQueryId();
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
        finally {
            if (this.resultSet != null) {
                this.openResultSets.add(this.resultSet);
            }
            this.resultSet = null;
        }
        if (this.updateCount == -1L && updateQueryRequired) {
            throw new SnowflakeSQLLoggedException(this.connection.getSFBaseSession(), ErrorCode.UNSUPPORTED_STATEMENT_TYPE_IN_EXECUTION_API, StmtUtil.truncateSQL(sql));
        }
        return this.updateCount;
    }

    ResultSet executeQueryInternal(String sql, boolean asyncExec, Map<String, ParameterBindingDTO> parameterBindings) throws SQLException {
        SFBaseResultSet sfResultSet;
        try {
            if (asyncExec) {
                if (!this.connection.getHandler().supportsAsyncQuery()) {
                    throw new SQLFeatureNotSupportedException("Async execution not supported in current context.");
                }
                sfResultSet = this.sfBaseStatement.asyncExecute(sql, parameterBindings, SFBaseStatement.CallingMethod.EXECUTE_QUERY);
            } else {
                sfResultSet = this.sfBaseStatement.execute(sql, parameterBindings, SFBaseStatement.CallingMethod.EXECUTE_QUERY);
            }
            sfResultSet.setSession(this.connection.getSFBaseSession());
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
        if (this.resultSet != null) {
            this.openResultSets.add(this.resultSet);
        }
        this.resultSet = asyncExec ? this.connection.getHandler().createAsyncResultSet(sfResultSet, this) : this.connection.getHandler().createResultSet(sfResultSet, (Statement)this);
        return this.getResultSet();
    }

    boolean executeInternal(String sql, Map<String, ParameterBindingDTO> parameterBindings) throws SQLException {
        this.raiseSQLExceptionIfStatementIsClosed();
        this.connection.injectedDelay();
        logger.debug("execute: {}", sql);
        String trimmedSql = sql.trim();
        if (trimmedSql.length() >= 20 && trimmedSql.toLowerCase().startsWith("set-sf-property")) {
            this.executeSetProperty(sql);
            return false;
        }
        try {
            SFBaseResultSet sfResultSet = this.sfBaseStatement.execute(sql, parameterBindings, SFBaseStatement.CallingMethod.EXECUTE);
            sfResultSet.setSession(this.connection.getSFBaseSession());
            if (this.resultSet != null) {
                this.openResultSets.add(this.resultSet);
            }
            this.resultSet = this.connection.getHandler().createResultSet(sfResultSet, (Statement)this);
            this.queryID = sfResultSet.getQueryId();
            if (!(sfResultSet.getStatementType().isGenerateResultSet() || this.connection.getSFBaseSession().isSfSQLMode() && !this.sfBaseStatement.hasChildren())) {
                this.updateCount = ResultUtil.calculateUpdateCount(sfResultSet);
                if (this.resultSet != null) {
                    this.openResultSets.add(this.resultSet);
                }
                this.resultSet = null;
                return false;
            }
            this.updateCount = -1L;
            return true;
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    @Override
    public String getQueryID() {
        return this.queryID;
    }

    @Override
    public List<String> getBatchQueryIDs() {
        return Collections.unmodifiableList(this.batchQueryIDs);
    }

    public String[] getChildQueryIds(String queryID) throws SQLException {
        return this.sfBaseStatement.getChildQueryIds(queryID);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.executeInternal(sql, null);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        logger.debug("execute(String sql, int autoGeneratedKeys)", false);
        if (autoGeneratedKeys == 2) {
            return this.execute(sql);
        }
        throw new SnowflakeLoggedFeatureNotSupportedException(this.connection.getSFBaseSession());
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        logger.debug("execute(String sql, int[] columnIndexes)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.connection.getSFBaseSession());
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        logger.debug("execute(String sql, String[] columnNames)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.connection.getSFBaseSession());
    }

    @Override
    public int[] executeBatch() throws SQLException {
        logger.debug("int[] executeBatch()", false);
        return this.executeBatchInternal((boolean)false).intArr;
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        logger.debug("executeBatch()", false);
        return this.executeBatchInternal((boolean)true).longArr;
    }

    VariableTypeArray executeBatchInternal(boolean isLong) throws SQLException {
        VariableTypeArray updateCounts;
        this.raiseSQLExceptionIfStatementIsClosed();
        Throwable exceptionReturned = null;
        if (isLong) {
            long[] arr = new long[this.batch.size()];
            updateCounts = new VariableTypeArray(null, arr);
        } else {
            int size = this.batch.size();
            int[] arr = new int[size];
            updateCounts = new VariableTypeArray(arr, null);
        }
        this.batchQueryIDs.clear();
        for (int i = 0; i < this.batch.size(); ++i) {
            BatchEntry b = this.batch.get(i);
            try {
                long cnt = this.executeUpdateInternal(b.getSql(), b.getParameterBindings(), false);
                if (cnt == -1L) {
                    cnt = -2L;
                }
                if (isLong) {
                    updateCounts.longArr[i] = cnt;
                } else if (cnt <= Integer.MAX_VALUE) {
                    updateCounts.intArr[i] = (int)cnt;
                } else {
                    throw new SnowflakeSQLLoggedException(this.connection.getSFBaseSession(), (int)ErrorCode.EXECUTE_BATCH_INTEGER_OVERFLOW.getMessageCode(), "22003", i);
                }
                this.batchQueryIDs.add(this.queryID);
                continue;
            }
            catch (SQLException e) {
                Throwable throwable = exceptionReturned = exceptionReturned == null ? e : exceptionReturned;
                if (isLong) {
                    updateCounts.longArr[i] = -3L;
                    continue;
                }
                updateCounts.intArr[i] = -3;
            }
        }
        if (exceptionReturned != null && isLong) {
            throw new BatchUpdateException(exceptionReturned.getLocalizedMessage(), ((SQLException)exceptionReturned).getSQLState(), ((SQLException)exceptionReturned).getErrorCode(), updateCounts.longArr, exceptionReturned);
        }
        if (exceptionReturned != null) {
            throw new BatchUpdateException(exceptionReturned.getLocalizedMessage(), ((SQLException)exceptionReturned).getSQLState(), ((SQLException)exceptionReturned).getErrorCode(), updateCounts.intArr, exceptionReturned);
        }
        return updateCounts;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        logger.debug("executeUpdate(String sql, int autoGeneratedKeys)", false);
        return (int)this.executeLargeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        logger.debug("executeUpdate(String sql, int autoGeneratedKeys)", false);
        if (autoGeneratedKeys == 2) {
            return this.executeLargeUpdate(sql);
        }
        throw new SnowflakeLoggedFeatureNotSupportedException(this.connection.getSFBaseSession());
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        logger.debug("executeUpdate(String sql, int[] columnIndexes)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.connection.getSFBaseSession());
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        logger.debug("executeLargeUpdate(String sql, int[] columnIndexes)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.connection.getSFBaseSession());
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        logger.debug("executeUpdate(String sql, String[] columnNames)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.connection.getSFBaseSession());
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        logger.debug("executeUpdate(String sql, String[] columnNames)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.connection.getSFBaseSession());
    }

    @Override
    public Connection getConnection() throws SQLException {
        logger.debug("getConnection()", false);
        this.raiseSQLExceptionIfStatementIsClosed();
        return this.connection;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        logger.debug("getFetchDirection()", false);
        this.raiseSQLExceptionIfStatementIsClosed();
        return 1000;
    }

    @Override
    public int getFetchSize() throws SQLException {
        logger.debug("getFetchSize()", false);
        this.raiseSQLExceptionIfStatementIsClosed();
        return this.fetchSize;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        logger.debug("getGeneratedKeys()", false);
        this.raiseSQLExceptionIfStatementIsClosed();
        return new SnowflakeResultSetV1.EmptyResultSet();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        logger.debug("getMaxFieldSize()", false);
        this.raiseSQLExceptionIfStatementIsClosed();
        return 0x1000000;
    }

    @Override
    public int getMaxRows() throws SQLException {
        logger.debug("getMaxRows()", false);
        this.raiseSQLExceptionIfStatementIsClosed();
        return this.maxRows;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        logger.debug("getMoreResults()", false);
        return this.getMoreResults(1);
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        logger.debug("getMoreResults(int current)", false);
        this.raiseSQLExceptionIfStatementIsClosed();
        if (this.resultSet != null && (current == 1 || current == 3)) {
            this.resultSet.close();
        }
        boolean hasResultSet = this.sfBaseStatement.getMoreResults(current);
        SFBaseResultSet sfResultSet = this.sfBaseStatement.getResultSet();
        if (hasResultSet) {
            sfResultSet.setSession(this.connection.getSFBaseSession());
            if (this.resultSet != null) {
                this.openResultSets.add(this.resultSet);
            }
            this.resultSet = this.connection.getHandler().createResultSet(sfResultSet, (Statement)this);
            this.updateCount = -1L;
            return true;
        }
        if (sfResultSet != null) {
            if (this.resultSet != null) {
                this.openResultSets.add(this.resultSet);
            }
            this.resultSet = null;
            try {
                this.updateCount = ResultUtil.calculateUpdateCount(sfResultSet);
            }
            catch (SFException ex) {
                throw new SnowflakeSQLLoggedException(this.connection.getSFBaseSession(), ex);
            }
            return this.queryID != null && this.sfBaseStatement.hasChildren() && this.sfBaseStatement.getChildQueryIds(this.queryID).length > 0;
        }
        this.updateCount = -1L;
        return false;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        logger.debug("getQueryTimeout()", false);
        this.raiseSQLExceptionIfStatementIsClosed();
        return this.queryTimeout;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        logger.debug("getResultSet()", false);
        this.raiseSQLExceptionIfStatementIsClosed();
        return this.resultSet;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        logger.debug("getResultSetConcurrency()", false);
        this.raiseSQLExceptionIfStatementIsClosed();
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        logger.debug("getResultSetHoldability()", false);
        this.raiseSQLExceptionIfStatementIsClosed();
        return this.resultSetHoldability;
    }

    @Override
    public int getResultSetType() throws SQLException {
        logger.debug("getResultSetType()", false);
        this.raiseSQLExceptionIfStatementIsClosed();
        return this.resultSetType;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        logger.debug("getUpdateCount()", false);
        return (int)this.getUpdateCountIfDML();
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        logger.debug("getLargeUpdateCount()", false);
        return this.getUpdateCountIfDML();
    }

    private long getUpdateCountIfDML() throws SQLException {
        this.raiseSQLExceptionIfStatementIsClosed();
        return this.updateCount;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        logger.debug("getWarnings()", false);
        this.raiseSQLExceptionIfStatementIsClosed();
        return this.sqlWarnings;
    }

    @Override
    public boolean isClosed() throws SQLException {
        logger.debug("isClosed()", false);
        return this.isClosed;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        logger.debug("isPoolable()", false);
        this.raiseSQLExceptionIfStatementIsClosed();
        return this.poolable;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        logger.debug("setCursorName(String name)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.connection.getSFBaseSession());
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        logger.debug("setEscapeProcessing(boolean enable)", false);
        this.raiseSQLExceptionIfStatementIsClosed();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        logger.debug("setFetchDirection(int direction)", false);
        this.raiseSQLExceptionIfStatementIsClosed();
        if (direction != 1000) {
            throw new SnowflakeLoggedFeatureNotSupportedException(this.connection.getSFBaseSession());
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        logger.debug("setFetchSize(int rows), rows={}", rows);
        this.raiseSQLExceptionIfStatementIsClosed();
        this.fetchSize = rows;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        logger.debug("setMaxFieldSize(int max)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.connection.getSFBaseSession());
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        logger.debug("setMaxRows(int max)", false);
        this.raiseSQLExceptionIfStatementIsClosed();
        this.maxRows = max;
        try {
            if (this.sfBaseStatement != null) {
                this.sfBaseStatement.addProperty("rows_per_resultset", max);
            }
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        logger.debug("setPoolable(boolean poolable)", false);
        this.raiseSQLExceptionIfStatementIsClosed();
        if (poolable) {
            throw new SnowflakeLoggedFeatureNotSupportedException(this.connection.getSFBaseSession());
        }
        this.poolable = poolable;
    }

    @Override
    public void setParameter(String name, Object value) throws SQLException {
        logger.debug("setParameter", false);
        try {
            if (this.sfBaseStatement != null) {
                this.sfBaseStatement.addProperty(name, value);
            }
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex);
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        logger.debug("setQueryTimeout(int seconds)", false);
        this.raiseSQLExceptionIfStatementIsClosed();
        this.queryTimeout = seconds;
        try {
            if (this.sfBaseStatement != null) {
                this.sfBaseStatement.addProperty("query_timeout", seconds);
            }
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        logger.debug("isWrapperFor(Class<?> iface)", false);
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        logger.debug("unwrap(Class<T> iface)", false);
        if (!iface.isInstance(this)) {
            throw new SQLException(this.getClass().getName() + " not unwrappable from " + iface.getName());
        }
        return (T)this;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        logger.debug("closeOnCompletion()", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.connection.getSFBaseSession());
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        logger.debug("isCloseOnCompletion()", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.connection.getSFBaseSession());
    }

    @Override
    public void close() throws SQLException {
        this.close(true);
    }

    public void close(boolean removeClosedStatementFromConnection) throws SQLException {
        logger.debug("close()", false);
        if (this.resultSet != null) {
            this.resultSet.close();
            this.resultSet = null;
        }
        this.isClosed = true;
        this.batch.clear();
        for (ResultSet rs : this.openResultSets) {
            if (rs == null || rs.isClosed()) continue;
            if (rs.isWrapperFor(SnowflakeResultSetV1.class)) {
                rs.unwrap(SnowflakeResultSetV1.class).close(false);
                continue;
            }
            rs.close();
        }
        this.openResultSets.clear();
        this.sfBaseStatement.close();
        if (removeClosedStatementFromConnection) {
            this.connection.removeClosedStatement(this);
        }
    }

    @Override
    public void cancel() throws SQLException {
        logger.debug("cancel()", false);
        this.raiseSQLExceptionIfStatementIsClosed();
        try {
            this.sfBaseStatement.cancel();
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException((Throwable)ex, ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        logger.debug("clearWarnings()", false);
        this.raiseSQLExceptionIfStatementIsClosed();
        this.sqlWarnings = null;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        logger.debug("addBatch(String sql)", false);
        this.raiseSQLExceptionIfStatementIsClosed();
        this.batch.add(new BatchEntry(sql, null));
    }

    @Override
    public void clearBatch() throws SQLException {
        logger.debug("clearBatch()", false);
        this.raiseSQLExceptionIfStatementIsClosed();
        this.batch.clear();
    }

    private void executeSetProperty(String sql) {
        logger.debug("setting property", false);
        String[] tokens = sql.split("\\s+");
        if (tokens.length < 2) {
            return;
        }
        if ("tracing".equalsIgnoreCase(tokens[1])) {
            if (tokens.length >= 3) {
                // empty if block
            }
        } else {
            this.sfBaseStatement.executeSetProperty(sql);
        }
    }

    public SFBaseStatement getSFBaseStatement() throws SQLException {
        return this.sfBaseStatement;
    }

    public SFStatement getSfStatement() throws SnowflakeSQLException {
        if (this.sfBaseStatement instanceof SFStatement) {
            return (SFStatement)this.sfBaseStatement;
        }
        throw new SnowflakeSQLException("getSfStatement() called with a different SFStatementInterface type.");
    }

    public void removeClosedResultSet(ResultSet rs) {
        this.openResultSets.remove(rs);
    }

    public static class NoOpSnowflakeStatementV1
    extends SnowflakeStatementV1 {
        public NoOpSnowflakeStatementV1() throws SQLException {
            super(null, 1003, 1007, 2);
        }

        private void throwExceptionAnyway() throws SQLException {
            throw new SQLException("This is a dummy SnowflakeStatement, no member function should be called for it.");
        }

        @Override
        public ResultSet executeQuery(String sql) throws SQLException {
            this.throwExceptionAnyway();
            return null;
        }

        @Override
        public int executeUpdate(String sql) throws SQLException {
            this.throwExceptionAnyway();
            return 0;
        }

        @Override
        public long executeLargeUpdate(String sql) throws SQLException {
            this.throwExceptionAnyway();
            return 0L;
        }

        @Override
        public String getQueryID() {
            return "invalid_query_id";
        }

        @Override
        public List<String> getBatchQueryIDs() {
            return new ArrayList<String>();
        }

        @Override
        public boolean execute(String sql) throws SQLException {
            this.throwExceptionAnyway();
            return false;
        }

        @Override
        public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
            this.throwExceptionAnyway();
            return false;
        }

        @Override
        public boolean execute(String sql, int[] columnIndexes) throws SQLException {
            this.throwExceptionAnyway();
            return false;
        }

        @Override
        public boolean execute(String sql, String[] columnNames) throws SQLException {
            this.throwExceptionAnyway();
            return false;
        }

        @Override
        public int[] executeBatch() throws SQLException {
            this.throwExceptionAnyway();
            return new int[1];
        }

        @Override
        public long[] executeLargeBatch() throws SQLException {
            this.throwExceptionAnyway();
            return new long[1];
        }

        @Override
        public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
            this.throwExceptionAnyway();
            return 0;
        }

        @Override
        public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
            this.throwExceptionAnyway();
            return 0L;
        }

        @Override
        public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
            this.throwExceptionAnyway();
            return 0;
        }

        @Override
        public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
            this.throwExceptionAnyway();
            return 0L;
        }

        @Override
        public int executeUpdate(String sql, String[] columnNames) throws SQLException {
            this.throwExceptionAnyway();
            return 0;
        }

        @Override
        public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
            this.throwExceptionAnyway();
            return 0L;
        }

        @Override
        public Connection getConnection() throws SQLException {
            this.throwExceptionAnyway();
            return null;
        }

        @Override
        public int getFetchDirection() throws SQLException {
            this.throwExceptionAnyway();
            return 0;
        }

        @Override
        public int getFetchSize() throws SQLException {
            this.throwExceptionAnyway();
            return 0;
        }

        @Override
        public ResultSet getGeneratedKeys() throws SQLException {
            this.throwExceptionAnyway();
            return null;
        }

        @Override
        public int getMaxFieldSize() throws SQLException {
            this.throwExceptionAnyway();
            return 0;
        }

        @Override
        public int getMaxRows() throws SQLException {
            this.throwExceptionAnyway();
            return 0;
        }

        @Override
        public boolean getMoreResults() throws SQLException {
            this.throwExceptionAnyway();
            return false;
        }

        @Override
        public boolean getMoreResults(int current) throws SQLException {
            this.throwExceptionAnyway();
            return false;
        }

        @Override
        public int getQueryTimeout() throws SQLException {
            this.throwExceptionAnyway();
            return 0;
        }

        @Override
        public ResultSet getResultSet() throws SQLException {
            this.throwExceptionAnyway();
            return null;
        }

        @Override
        public int getResultSetConcurrency() throws SQLException {
            this.throwExceptionAnyway();
            return 0;
        }

        @Override
        public int getResultSetHoldability() throws SQLException {
            this.throwExceptionAnyway();
            return 0;
        }

        @Override
        public int getResultSetType() throws SQLException {
            this.throwExceptionAnyway();
            return 0;
        }

        @Override
        public int getUpdateCount() throws SQLException {
            this.throwExceptionAnyway();
            return 0;
        }

        @Override
        public long getLargeUpdateCount() throws SQLException {
            this.throwExceptionAnyway();
            return 0L;
        }

        @Override
        public SQLWarning getWarnings() throws SQLException {
            this.throwExceptionAnyway();
            return null;
        }

        @Override
        public boolean isClosed() throws SQLException {
            this.throwExceptionAnyway();
            return false;
        }

        @Override
        public boolean isPoolable() throws SQLException {
            this.throwExceptionAnyway();
            return false;
        }

        @Override
        public void setCursorName(String name) throws SQLException {
        }

        @Override
        public void setEscapeProcessing(boolean enable) throws SQLException {
        }

        @Override
        public void setFetchDirection(int direction) throws SQLException {
        }

        @Override
        public void setFetchSize(int rows) throws SQLException {
        }

        @Override
        public void setMaxFieldSize(int max) throws SQLException {
        }

        @Override
        public void setMaxRows(int max) throws SQLException {
        }

        @Override
        public void setPoolable(boolean poolable) throws SQLException {
        }

        @Override
        public void setParameter(String name, Object value) throws SQLException {
        }

        @Override
        public void setQueryTimeout(int seconds) throws SQLException {
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            logger.debug("isWrapperFor(Class<?> iface)", false);
            return iface.isInstance(this);
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            logger.debug("unwrap(Class<T> iface)", false);
            if (!iface.isInstance(this)) {
                throw new SQLException(this.getClass().getName() + " not unwrappable from " + iface.getName());
            }
            return (T)this;
        }

        @Override
        public void closeOnCompletion() throws SQLException {
        }

        @Override
        public boolean isCloseOnCompletion() throws SQLException {
            this.throwExceptionAnyway();
            return false;
        }

        @Override
        public void close() throws SQLException {
        }

        @Override
        public void close(boolean removeClosedStatementFromConnection) throws SQLException {
        }

        @Override
        public void cancel() throws SQLException {
        }

        @Override
        public void clearWarnings() throws SQLException {
        }

        @Override
        public void addBatch(String sql) throws SQLException {
        }

        @Override
        public void clearBatch() throws SQLException {
        }

        @Override
        public void removeClosedResultSet(ResultSet rs) {
        }
    }

    final class BatchEntry {
        private final String sql;
        private final Map<String, ParameterBindingDTO> parameterBindings;

        BatchEntry(String sql, Map<String, ParameterBindingDTO> parameterBindings) {
            this.sql = sql;
            this.parameterBindings = parameterBindings;
        }

        public String getSql() {
            return this.sql;
        }

        public Map<String, ParameterBindingDTO> getParameterBindings() {
            return this.parameterBindings;
        }
    }
}

