/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.monitoring;

public final class CsmConfiguration {
    private final boolean enabled;
    private final int port;
    private final String clientId;

    public CsmConfiguration(boolean enabled, int port, String clientId) {
        this.enabled = enabled;
        this.port = port;
        this.clientId = clientId;
    }

    public static Builder builder() {
        return new Builder();
    }

    private CsmConfiguration(Builder builder) {
        this.enabled = builder.enabled == null ? false : builder.enabled;
        this.port = builder.port == null ? 31000 : builder.port;
        this.clientId = builder.clientId == null ? "" : builder.clientId;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getPort() {
        return this.port;
    }

    public String getClientId() {
        return this.clientId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CsmConfiguration other = (CsmConfiguration)o;
        if (this.enabled != other.enabled) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        return this.clientId != null ? this.clientId.equals(other.clientId) : other.clientId == null;
    }

    public int hashCode() {
        int result = this.enabled ? 1 : 0;
        result = 31 * result + this.port;
        result = 31 * result + (this.clientId != null ? this.clientId.hashCode() : 0);
        return result;
    }

    public static class Builder {
        private Boolean enabled;
        private Integer port;
        private String clientId;

        private Builder() {
        }

        public Builder withEnabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder withClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder withPort(Integer port) {
            this.port = port;
            return this;
        }

        public CsmConfiguration build() {
            return new CsmConfiguration(this);
        }
    }
}

