/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.gax.httpjson;

import java.util.Set;
import java.util.concurrent.CancellationException;
import net.snowflake.client.jdbc.internal.google.api.core.AbstractApiFuture;
import net.snowflake.client.jdbc.internal.google.api.core.ApiFuture;
import net.snowflake.client.jdbc.internal.google.api.core.ApiFutureCallback;
import net.snowflake.client.jdbc.internal.google.api.core.ApiFutures;
import net.snowflake.client.jdbc.internal.google.api.gax.httpjson.HttpJsonApiExceptionFactory;
import net.snowflake.client.jdbc.internal.google.api.gax.httpjson.HttpJsonCallContext;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.ApiCallContext;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.StatusCode;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.UnaryCallable;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.google.common.util.concurrent.MoreExecutors;

class HttpJsonExceptionCallable<RequestT, ResponseT>
extends UnaryCallable<RequestT, ResponseT> {
    private final UnaryCallable<RequestT, ResponseT> callable;
    private final HttpJsonApiExceptionFactory exceptionFactory;

    HttpJsonExceptionCallable(UnaryCallable<RequestT, ResponseT> callable, Set<StatusCode.Code> retryableCodes) {
        this.callable = Preconditions.checkNotNull(callable);
        this.exceptionFactory = new HttpJsonApiExceptionFactory(retryableCodes);
    }

    @Override
    public ApiFuture<ResponseT> futureCall(RequestT request, ApiCallContext inputContext) {
        HttpJsonCallContext context = HttpJsonCallContext.createDefault().nullToSelf(inputContext);
        ApiFuture<ResponseT> innerCallFuture = this.callable.futureCall(request, context);
        ExceptionTransformingFuture transformingFuture = new ExceptionTransformingFuture(innerCallFuture);
        ApiFutures.addCallback(innerCallFuture, transformingFuture, MoreExecutors.directExecutor());
        return transformingFuture;
    }

    private class ExceptionTransformingFuture
    extends AbstractApiFuture<ResponseT>
    implements ApiFutureCallback<ResponseT> {
        private final ApiFuture<ResponseT> innerCallFuture;
        private volatile boolean cancelled = false;

        public ExceptionTransformingFuture(ApiFuture<ResponseT> innerCallFuture) {
            this.innerCallFuture = innerCallFuture;
        }

        @Override
        protected void interruptTask() {
            this.cancelled = true;
            this.innerCallFuture.cancel(true);
        }

        @Override
        public void onSuccess(ResponseT r) {
            super.set(r);
        }

        @Override
        public void onFailure(Throwable throwable) {
            if (throwable instanceof CancellationException && this.cancelled) {
                return;
            }
            this.setException(HttpJsonExceptionCallable.this.exceptionFactory.create(throwable));
        }
    }
}

