/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.ImmutableConnectionInfo;
import schemacrawler.schema.ConnectionInfo;
import us.fatehi.utility.Utility;
import us.fatehi.utility.string.StringFormat;

public final class ConnectionInfoBuilder {
    private static final Logger LOGGER = Logger.getLogger(ConnectionInfoBuilder.class.getName());
    private final Connection connection;

    public static ConnectionInfoBuilder builder(Connection connection) {
        return new ConnectionInfoBuilder(connection);
    }

    private static String getConnectionUrl(DatabaseMetaData dbMetaData) {
        if (dbMetaData == null) {
            return "";
        }
        try {
            String connectionUrl = dbMetaData.getURL();
            return connectionUrl;
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, new StringFormat("Could not obtain the database connection URL", e));
            return "";
        }
    }

    private static String getJdbcDriverClassName(String connectionUrl) {
        if (Utility.isBlank(connectionUrl)) {
            return "";
        }
        try {
            Driver jdbcDriver = DriverManager.getDriver(connectionUrl);
            return jdbcDriver.getClass().getName();
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, new StringFormat("Could not find a suitable JDBC driver for database connection URL <%s>", connectionUrl, e));
            return "";
        }
    }

    private ConnectionInfoBuilder(Connection connection) {
        this.connection = Objects.requireNonNull(connection, "No connection provided");
    }

    public ConnectionInfo build() throws SQLException {
        DatabaseMetaData dbMetaData = this.connection.getMetaData();
        String connectionUrl = ConnectionInfoBuilder.getConnectionUrl(dbMetaData);
        String jdbcDriverClassName = ConnectionInfoBuilder.getJdbcDriverClassName(connectionUrl);
        ImmutableConnectionInfo connectionInfo = new ImmutableConnectionInfo(dbMetaData.getDatabaseProductName(), dbMetaData.getDatabaseProductVersion(), connectionUrl, dbMetaData.getUserName(), jdbcDriverClassName, dbMetaData.getDriverName(), dbMetaData.getDriverVersion(), dbMetaData.getDriverMajorVersion(), dbMetaData.getDriverMinorVersion(), dbMetaData.getJDBCMajorVersion(), dbMetaData.getJDBCMinorVersion());
        return connectionInfo;
    }
}

