/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schemacrawler.SchemaInfoLevel;
import schemacrawler.schemacrawler.SchemaInfoRetrieval;
import us.fatehi.utility.scheduler.TaskDefinition;
import us.fatehi.utility.scheduler.TaskRunner;
import us.fatehi.utility.scheduler.TaskRunners;

public final class RetrievalTaskRunner {
    private static final Logger LOGGER = Logger.getLogger(RetrievalTaskRunner.class.getName());
    private final TaskRunner taskRunner;
    private final SchemaInfoLevel infoLevel;

    public RetrievalTaskRunner(SchemaInfoLevel infoLevel, int maxThreads) {
        this.infoLevel = Objects.requireNonNull(infoLevel, "No info-level provided");
        this.taskRunner = TaskRunners.getTaskRunner(infoLevel.getTag(), maxThreads);
    }

    public RetrievalTaskRunner add(SchemaInfoRetrieval retrieval, TaskDefinition.TaskRunnable function, SchemaInfoRetrieval ... additionalRetrievals) throws Exception {
        boolean shouldRun = this.shouldRun(retrieval) && this.shouldRun(additionalRetrievals);
        this.add(retrieval.name(), shouldRun, function);
        return this;
    }

    public RetrievalTaskRunner add(String retrievalName, TaskDefinition.TaskRunnable function, SchemaInfoRetrieval ... additionalRetrievals) throws Exception {
        boolean shouldRun = this.shouldRun(additionalRetrievals);
        this.add(retrievalName, shouldRun, function);
        return this;
    }

    public void stopAndLogTime() {
        try {
            this.taskRunner.stop();
        }
        finally {
            LOGGER.log(Level.INFO, this.taskRunner.report());
        }
    }

    public void submit() throws Exception {
        this.taskRunner.submit();
    }

    private void add(String retrievalName, boolean shouldRun, TaskDefinition.TaskRunnable function) throws Exception {
        if (shouldRun) {
            this.taskRunner.add(new TaskDefinition(retrievalName, function));
        } else {
            this.taskRunner.add(new TaskDefinition(retrievalName));
        }
    }

    private boolean shouldRun(SchemaInfoRetrieval ... additionalRetrievals) {
        boolean shouldRun = true;
        if (additionalRetrievals != null && additionalRetrievals.length > 0) {
            for (SchemaInfoRetrieval additionalRetrieval : additionalRetrievals) {
                shouldRun = shouldRun && this.infoLevel.is(additionalRetrieval);
            }
        }
        return shouldRun;
    }
}

