/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.types.DataValueDescriptor;

public class RowUtil {
    private static long rowCountBase = 0L;

    public static void setRowCountBase(long l) {
    }

    public static long getRowCountBase() {
        return rowCountBase;
    }

    public static ExecRow getEmptyValueRow(int n, LanguageConnectionContext languageConnectionContext) {
        return languageConnectionContext.getLanguageConnectionFactory().getExecutionFactory().getValueRow(n);
    }

    public static ExecIndexRow getEmptyIndexRow(int n, LanguageConnectionContext languageConnectionContext) {
        return languageConnectionContext.getLanguageConnectionFactory().getExecutionFactory().getIndexableRow(n);
    }

    public static void copyCloneColumns(ExecRow execRow, ExecRow execRow2, int n) {
        for (int i = 1; i <= n; ++i) {
            execRow.setColumn(i, execRow2.cloneColumn(i));
        }
    }

    public static void copyRefColumns(ExecRow execRow, ExecRow execRow2) {
        DataValueDescriptor[] dataValueDescriptorArray = execRow2.getRowArray();
        DataValueDescriptor[] dataValueDescriptorArray2 = execRow.getRowArray();
        System.arraycopy(dataValueDescriptorArray, 0, dataValueDescriptorArray2, 0, dataValueDescriptorArray.length);
    }

    public static void copyRefColumns(ExecRow execRow, ExecRow execRow2, int n) throws StandardException {
        RowUtil.copyRefColumns(execRow, 0, execRow2, 0, n);
    }

    public static void copyRefColumns(ExecRow execRow, ExecRow execRow2, int n, int n2) throws StandardException {
        RowUtil.copyRefColumns(execRow, 0, execRow2, n, n2);
    }

    public static void copyRefColumns(ExecRow execRow, int n, ExecRow execRow2, int n2, int n3) throws StandardException {
        for (int i = 1; i <= n3; ++i) {
            execRow.setColumn(i + n, execRow2.getColumn(i + n2));
        }
    }

    public static void copyRefColumns(ExecRow execRow, ExecRow execRow2, int[] nArray) throws StandardException {
        if (nArray == null) {
            return;
        }
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            execRow.setColumn(i + 1, execRow2.getColumn(nArray[i]));
        }
    }

    public static void copyRefColumns(ExecRow execRow, ExecRow execRow2, FormatableBitSet formatableBitSet) throws StandardException {
        if (formatableBitSet == null) {
            return;
        }
        int n = execRow.getRowArray().length;
        int n2 = 1;
        for (int i = 1; i <= n; ++i) {
            if (!formatableBitSet.get(i)) continue;
            execRow.setColumn(i, execRow2.getColumn(n2));
            ++n2;
        }
    }

    public static void copyRefColumns(ExecRow execRow) throws StandardException {
        for (int i = 1; i <= execRow.nColumns(); ++i) {
            execRow.setColumn(i, null);
        }
    }

    public static String toString(ExecRow execRow) {
        return "";
    }

    public static String toString(Object[] objectArray) {
        return "";
    }

    public static String toString(ExecRow execRow, int n, int n2) {
        return RowUtil.toString(execRow.getRowArray(), n, n2);
    }

    public static String toString(Object[] objectArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        for (int i = n; i <= n2; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(objectArray[i]);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static String toString(ExecRow execRow, int[] nArray) {
        return RowUtil.toString(execRow.getRowArray(), nArray);
    }

    public static String toString(Object[] objectArray, int[] nArray) {
        if (nArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        for (int i = 0; i < nArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(objectArray[nArray[i] - 1]);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static String intArrayToString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        for (int i = 0; i < nArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(nArray[i]);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static boolean inAscendingOrder(int[] nArray) {
        if (nArray != null) {
            int n = -1;
            for (int i = 0; i < nArray.length; ++i) {
                if (n > nArray[i]) {
                    return false;
                }
                n = nArray[i];
            }
        }
        return true;
    }

    public static FormatableBitSet shift(FormatableBitSet formatableBitSet, int n) {
        FormatableBitSet formatableBitSet2 = null;
        if (formatableBitSet != null) {
            int n2 = formatableBitSet.size();
            formatableBitSet2 = new FormatableBitSet(n2);
            for (int i = n; i < n2; ++i) {
                if (!formatableBitSet.get(i)) continue;
                formatableBitSet2.set(i - n);
            }
        }
        return formatableBitSet2;
    }
}

