/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.ioresource;

import java.io.BufferedReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import us.fatehi.utility.ioresource.InputResource;
import us.fatehi.utility.ioresource.InputResourceUtility;

public class ReaderInputResource
implements InputResource {
    private static final Logger LOGGER = Logger.getLogger(ReaderInputResource.class.getName());
    private final Reader reader;

    public ReaderInputResource(Reader reader) {
        this.reader = Objects.requireNonNull(reader, "No reader provided");
    }

    @Override
    public Reader openNewInputReader(Charset charset) {
        LOGGER.log(Level.INFO, "Input to provided reader");
        return InputResourceUtility.wrapReader(this.getDescription(), new BufferedReader(this.reader), false);
    }

    public String toString() {
        return "<reader>";
    }
}

