/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.trace;

import com.ibm.db2.cmx.runtime.internal.trace.SimpleLogFormatter;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class PrintWriterHandler
extends Handler {
    PrintWriter writer_;
    Formatter formatter_;

    public PrintWriterHandler(PrintWriter printWriter) {
        this.writer_ = printWriter;
        this.setFormatter(new SimpleLogFormatter());
    }

    @Override
    public void close() throws SecurityException {
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        if (this.writer_ != null) {
            PrintWriter printWriter = this.writer_;
            synchronized (printWriter) {
                this.writer_.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord logRecord) {
        if (this.writer_ != null) {
            String string = this.formatter_.format(logRecord);
            PrintWriter printWriter = this.writer_;
            synchronized (printWriter) {
                this.writer_.append(string);
                this.writer_.flush();
            }
        }
    }

    @Override
    public void setFormatter(Formatter formatter) throws SecurityException {
        this.formatter_ = formatter;
        AccessController.doPrivileged(new SetFormatterAction());
    }

    @Override
    public void setLevel(Level level) throws SecurityException {
    }

    class SetFormatterAction
    implements PrivilegedAction<PrintWriterHandler> {
        SetFormatterAction() {
        }

        @Override
        public PrintWriterHandler run() {
            PrintWriterHandler.super.setFormatter(PrintWriterHandler.this.formatter_);
            return null;
        }
    }
}

