/*
 * Decompiled with CFR 0.152.
 */
package net.jpountz.xxhash;

import java.nio.ByteBuffer;
import net.jpountz.util.ByteBufferUtils;
import net.jpountz.util.SafeUtils;
import net.jpountz.xxhash.XXHash32;
import net.jpountz.xxhash.XXHashFactory;
import net.jpountz.xxhash.XXHashJNI;

final class XXHash32JNI
extends XXHash32 {
    public static final XXHash32 INSTANCE = new XXHash32JNI();
    private static XXHash32 SAFE_INSTANCE;

    XXHash32JNI() {
    }

    @Override
    public int hash(byte[] byArray, int n2, int n3, int n4) {
        SafeUtils.checkRange(byArray, n2, n3);
        return XXHashJNI.XXH32(byArray, n2, n3, n4);
    }

    @Override
    public int hash(ByteBuffer byteBuffer, int n2, int n3, int n4) {
        if (byteBuffer.isDirect()) {
            ByteBufferUtils.checkRange(byteBuffer, n2, n3);
            return XXHashJNI.XXH32BB(byteBuffer, n2, n3, n4);
        }
        if (byteBuffer.hasArray()) {
            return this.hash(byteBuffer.array(), n2 + byteBuffer.arrayOffset(), n3, n4);
        }
        XXHash32 xXHash32 = SAFE_INSTANCE;
        if (xXHash32 == null) {
            xXHash32 = SAFE_INSTANCE = XXHashFactory.safeInstance().hash32();
        }
        return xXHash32.hash(byteBuffer, n2, n3, n4);
    }
}

