/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.storage;

import java.util.concurrent.Callable;
import java.util.function.Function;
import net.snowflake.client.jdbc.internal.google.api.gax.retrying.ResultRetryAlgorithm;
import net.snowflake.client.jdbc.internal.google.cloud.RetryHelper;
import net.snowflake.client.jdbc.internal.google.cloud.storage.StorageException;
import net.snowflake.client.jdbc.internal.google.cloud.storage.StorageOptions;
import net.snowflake.client.jdbc.internal.google.cloud.storage.spi.v1.HttpRpcContext;

final class Retrying {
    Retrying() {
    }

    static <T, U> U run(StorageOptions options, ResultRetryAlgorithm<?> algorithm, Callable<T> c, Function<T, U> f) {
        HttpRpcContext httpRpcContext = HttpRpcContext.getInstance();
        try {
            httpRpcContext.newInvocationId();
            T result = RetryHelper.runWithRetries(c, options.getRetrySettings(), algorithm, options.getClock());
            U u = result == null ? null : (U)f.apply(result);
            return u;
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.coalesce(e);
        }
        finally {
            httpRpcContext.clearInvocationId();
        }
    }
}

