/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opencensus.metrics.export;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;
import net.snowflake.client.jdbc.internal.javax.annotation.concurrent.Immutable;
import net.snowflake.client.jdbc.internal.opencensus.internal.Utils;
import net.snowflake.client.jdbc.internal.opencensus.metrics.export.AutoValue_Summary;
import net.snowflake.client.jdbc.internal.opencensus.metrics.export.AutoValue_Summary_Snapshot;
import net.snowflake.client.jdbc.internal.opencensus.metrics.export.AutoValue_Summary_Snapshot_ValueAtPercentile;

@Immutable
public abstract class Summary {
    Summary() {
    }

    public static Summary create(@Nullable Long count, @Nullable Double sum, Snapshot snapshot) {
        Summary.checkCountAndSum(count, sum);
        Utils.checkNotNull(snapshot, "snapshot");
        return new AutoValue_Summary(count, sum, snapshot);
    }

    @Nullable
    public abstract Long getCount();

    @Nullable
    public abstract Double getSum();

    public abstract Snapshot getSnapshot();

    private static void checkCountAndSum(@Nullable Long count, @Nullable Double sum) {
        Utils.checkArgument(count == null || count >= 0L, "count must be non-negative.");
        Utils.checkArgument(sum == null || sum >= 0.0, "sum must be non-negative.");
        if (count != null && count == 0L) {
            Utils.checkArgument(sum == null || sum == 0.0, "sum must be 0 if count is 0.");
        }
    }

    @Immutable
    public static abstract class Snapshot {
        @Nullable
        public abstract Long getCount();

        @Nullable
        public abstract Double getSum();

        public abstract List<ValueAtPercentile> getValueAtPercentiles();

        public static Snapshot create(@Nullable Long count, @Nullable Double sum, List<ValueAtPercentile> valueAtPercentiles) {
            Summary.checkCountAndSum(count, sum);
            Utils.checkListElementNotNull(Utils.checkNotNull(valueAtPercentiles, "valueAtPercentiles"), "valueAtPercentile");
            return new AutoValue_Summary_Snapshot(count, sum, Collections.unmodifiableList(new ArrayList<ValueAtPercentile>(valueAtPercentiles)));
        }

        @Immutable
        public static abstract class ValueAtPercentile {
            public abstract double getPercentile();

            public abstract double getValue();

            public static ValueAtPercentile create(double percentile, double value) {
                Utils.checkArgument(0.0 < percentile && percentile <= 100.0, "percentile must be in the interval (0.0, 100.0]");
                Utils.checkArgument(value >= 0.0, "value must be non-negative");
                return new AutoValue_Summary_Snapshot_ValueAtPercentile(percentile, value);
            }
        }
    }
}

