/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.oer.its;

import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1Object;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1OctetString;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1Primitive;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1Sequence;
import net.snowflake.client.jdbc.internal.org.bouncycastle.oer.its.EccP256CurvePoint;
import net.snowflake.client.jdbc.internal.org.bouncycastle.oer.its.Utils;

public class EcdsaP256Signature
extends ASN1Object {
    private final EccP256CurvePoint rSig;
    private final ASN1OctetString sSig;

    public EcdsaP256Signature(EccP256CurvePoint eccP256CurvePoint, ASN1OctetString aSN1OctetString) {
        this.rSig = eccP256CurvePoint;
        this.sSig = aSN1OctetString;
    }

    public static EcdsaP256Signature getInstance(Object object) {
        ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(object);
        return new Builder().setrSig(EccP256CurvePoint.getInstance(aSN1Sequence.getObjectAt(0))).setsSig(ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(1))).createEcdsaP256Signature();
    }

    public static Builder builder() {
        return new Builder();
    }

    public EccP256CurvePoint getrSig() {
        return this.rSig;
    }

    public ASN1OctetString getsSig() {
        return this.sSig;
    }

    public ASN1Primitive toASN1Primitive() {
        return Utils.toSequence(this.rSig, this.sSig);
    }

    public static class Builder {
        private EccP256CurvePoint rSig;
        private ASN1OctetString sSig;

        public Builder setrSig(EccP256CurvePoint eccP256CurvePoint) {
            this.rSig = eccP256CurvePoint;
            return this;
        }

        public Builder setsSig(ASN1OctetString aSN1OctetString) {
            this.sSig = aSN1OctetString;
            return this;
        }

        public EcdsaP256Signature createEcdsaP256Signature() {
            return new EcdsaP256Signature(this.rSig, this.sSig);
        }
    }
}

