/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.scheduler;

import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import us.fatehi.utility.Utility;
import us.fatehi.utility.string.StringFormat;

public final class TaskDefinition {
    private static final Logger LOGGER = Logger.getLogger(TaskDefinition.class.getName());
    private final String taskName;
    private final TaskRunnable task;

    public TaskDefinition(String taskName) {
        this.taskName = Utility.toSnakeCase(Utility.requireNotBlank(taskName, "Task name not provided"));
        this.task = () -> LOGGER.log(Level.INFO, new StringFormat("Not running task <%s>", taskName));
    }

    public TaskDefinition(String taskName, TaskRunnable task) {
        Utility.requireNotBlank(taskName, "Task name not provided");
        this.taskName = Utility.toSnakeCase(taskName);
        this.task = Objects.requireNonNull(task, "Task not provided");
    }

    public TaskRunnable getTask() {
        return this.task;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String toString() {
        return this.taskName;
    }

    @FunctionalInterface
    public static interface TaskRunnable {
        public void run() throws Exception;
    }
}

