/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import com.sun.j3d.internal.HashCodeUtil;
import javax.media.j3d.BoundingPolytope;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.CachedFrustum;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Transform3D;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;

public class BoundingBox
extends Bounds {
    Point3d lower;
    Point3d upper;
    private Point3d centroid = null;
    private static final double EPS = 1.0E-8;
    private BoundingSphere tmpSphere = null;
    private BoundingBox tmpBox = null;
    private BoundingPolytope tmpPolytope = null;
    private Point3d tmpP3d = null;

    public BoundingBox(Point3d point3d, Point3d point3d2) {
        this.boundId = 1;
        this.lower = new Point3d(point3d);
        this.upper = new Point3d(point3d2);
        this.updateBoundsStates();
    }

    public BoundingBox() {
        this.boundId = 1;
        this.lower = new Point3d(-1.0, -1.0, -1.0);
        this.upper = new Point3d(1.0, 1.0, 1.0);
        this.updateBoundsStates();
    }

    public BoundingBox(Bounds bounds) {
        this.boundId = 1;
        if (bounds == null) {
            this.lower = new Point3d(1.0, 1.0, 1.0);
            this.upper = new Point3d(-1.0, -1.0, -1.0);
        } else if (bounds.boundsIsInfinite) {
            this.lower = new Point3d(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
            this.upper = new Point3d(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        } else if (bounds.boundId == 1) {
            BoundingBox boundingBox = (BoundingBox)bounds;
            this.lower = new Point3d(boundingBox.lower.x, boundingBox.lower.y, boundingBox.lower.z);
            this.upper = new Point3d(boundingBox.upper.x, boundingBox.upper.y, boundingBox.upper.z);
        } else if (bounds.boundId == 2) {
            BoundingSphere boundingSphere = (BoundingSphere)bounds;
            this.lower = new Point3d(boundingSphere.center.x - boundingSphere.radius, boundingSphere.center.y - boundingSphere.radius, boundingSphere.center.z - boundingSphere.radius);
            this.upper = new Point3d(boundingSphere.center.x + boundingSphere.radius, boundingSphere.center.y + boundingSphere.radius, boundingSphere.center.z + boundingSphere.radius);
        } else if (bounds.boundId == 4) {
            BoundingPolytope boundingPolytope = (BoundingPolytope)bounds;
            if (boundingPolytope.nVerts < 1) {
                this.lower = new Point3d(-1.0, -1.0, -1.0);
                this.upper = new Point3d(1.0, 1.0, 1.0);
            } else {
                this.lower = new Point3d(boundingPolytope.verts[0].x, boundingPolytope.verts[0].y, boundingPolytope.verts[0].z);
                this.upper = new Point3d(boundingPolytope.verts[0].x, boundingPolytope.verts[0].y, boundingPolytope.verts[0].z);
                for (int i = 1; i < boundingPolytope.nVerts; ++i) {
                    if (boundingPolytope.verts[i].x < this.lower.x) {
                        this.lower.x = boundingPolytope.verts[i].x;
                    }
                    if (boundingPolytope.verts[i].y < this.lower.y) {
                        this.lower.y = boundingPolytope.verts[i].y;
                    }
                    if (boundingPolytope.verts[i].z < this.lower.z) {
                        this.lower.z = boundingPolytope.verts[i].z;
                    }
                    if (boundingPolytope.verts[i].x > this.upper.x) {
                        this.upper.x = boundingPolytope.verts[i].x;
                    }
                    if (boundingPolytope.verts[i].y > this.upper.y) {
                        this.upper.y = boundingPolytope.verts[i].y;
                    }
                    if (!(boundingPolytope.verts[i].z > this.upper.z)) continue;
                    this.upper.z = boundingPolytope.verts[i].z;
                }
            }
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingBox0"));
        }
        this.updateBoundsStates();
    }

    public BoundingBox(Bounds[] boundsArray) {
        int n;
        this.upper = new Point3d();
        this.lower = new Point3d();
        this.boundId = 1;
        if (boundsArray == null || boundsArray.length <= 0) {
            this.lower = new Point3d(1.0, 1.0, 1.0);
            this.upper = new Point3d(-1.0, -1.0, -1.0);
            this.updateBoundsStates();
            return;
        }
        for (n = 0; boundsArray[n] == null && n < boundsArray.length; ++n) {
        }
        if (n >= boundsArray.length) {
            this.lower = new Point3d(1.0, 1.0, 1.0);
            this.upper = new Point3d(-1.0, -1.0, -1.0);
            this.updateBoundsStates();
            return;
        }
        this.set(boundsArray[n++]);
        if (this.boundsIsInfinite) {
            return;
        }
        while (n < boundsArray.length) {
            if (boundsArray[n] != null && !boundsArray[n].boundsIsEmpty) {
                Bounds bounds;
                if (boundsArray[n].boundsIsInfinite) {
                    this.lower.z = Double.NEGATIVE_INFINITY;
                    this.lower.y = Double.NEGATIVE_INFINITY;
                    this.lower.x = Double.NEGATIVE_INFINITY;
                    this.upper.z = Double.POSITIVE_INFINITY;
                    this.upper.y = Double.POSITIVE_INFINITY;
                    this.upper.x = Double.POSITIVE_INFINITY;
                    break;
                }
                if (boundsArray[n].boundId == 1) {
                    bounds = (BoundingBox)boundsArray[n];
                    if (this.lower.x > bounds.lower.x) {
                        this.lower.x = bounds.lower.x;
                    }
                    if (this.lower.y > bounds.lower.y) {
                        this.lower.y = bounds.lower.y;
                    }
                    if (this.lower.z > bounds.lower.z) {
                        this.lower.z = bounds.lower.z;
                    }
                    if (this.upper.x < bounds.upper.x) {
                        this.upper.x = bounds.upper.x;
                    }
                    if (this.upper.y < bounds.upper.y) {
                        this.upper.y = bounds.upper.y;
                    }
                    if (this.upper.z < bounds.upper.z) {
                        this.upper.z = bounds.upper.z;
                    }
                } else if (boundsArray[n].boundId == 2) {
                    bounds = (BoundingSphere)boundsArray[n];
                    if (this.lower.x > ((BoundingSphere)bounds).center.x - ((BoundingSphere)bounds).radius) {
                        this.lower.x = ((BoundingSphere)bounds).center.x - ((BoundingSphere)bounds).radius;
                    }
                    if (this.lower.y > ((BoundingSphere)bounds).center.y - ((BoundingSphere)bounds).radius) {
                        this.lower.y = ((BoundingSphere)bounds).center.y - ((BoundingSphere)bounds).radius;
                    }
                    if (this.lower.z > ((BoundingSphere)bounds).center.z - ((BoundingSphere)bounds).radius) {
                        this.lower.z = ((BoundingSphere)bounds).center.z - ((BoundingSphere)bounds).radius;
                    }
                    if (this.upper.x < ((BoundingSphere)bounds).center.x + ((BoundingSphere)bounds).radius) {
                        this.upper.x = ((BoundingSphere)bounds).center.x + ((BoundingSphere)bounds).radius;
                    }
                    if (this.upper.y < ((BoundingSphere)bounds).center.y + ((BoundingSphere)bounds).radius) {
                        this.upper.y = ((BoundingSphere)bounds).center.y + ((BoundingSphere)bounds).radius;
                    }
                    if (this.upper.z < ((BoundingSphere)bounds).center.z + ((BoundingSphere)bounds).radius) {
                        this.upper.z = ((BoundingSphere)bounds).center.z + ((BoundingSphere)bounds).radius;
                    }
                } else if (boundsArray[n].boundId == 4) {
                    bounds = (BoundingPolytope)boundsArray[n];
                    for (n = 0; n < ((BoundingPolytope)bounds).nVerts; ++n) {
                        if (((BoundingPolytope)bounds).verts[n].x < this.lower.x) {
                            this.lower.x = ((BoundingPolytope)bounds).verts[n].x;
                        }
                        if (((BoundingPolytope)bounds).verts[n].y < this.lower.y) {
                            this.lower.y = ((BoundingPolytope)bounds).verts[n].y;
                        }
                        if (((BoundingPolytope)bounds).verts[n].z < this.lower.z) {
                            this.lower.z = ((BoundingPolytope)bounds).verts[n].z;
                        }
                        if (((BoundingPolytope)bounds).verts[n].x > this.upper.x) {
                            this.upper.x = ((BoundingPolytope)bounds).verts[n].x;
                        }
                        if (((BoundingPolytope)bounds).verts[n].y > this.upper.y) {
                            this.upper.y = ((BoundingPolytope)bounds).verts[n].y;
                        }
                        if (!(((BoundingPolytope)bounds).verts[n].z > this.upper.z)) continue;
                        this.upper.z = ((BoundingPolytope)bounds).verts[n].z;
                    }
                } else {
                    throw new IllegalArgumentException(J3dI18N.getString("BoundingBox1"));
                }
            }
            ++n;
        }
        this.updateBoundsStates();
    }

    public void getLower(Point3d point3d) {
        point3d.x = this.lower.x;
        point3d.y = this.lower.y;
        point3d.z = this.lower.z;
    }

    public void setLower(double d, double d2, double d3) {
        this.lower.x = d;
        this.lower.y = d2;
        this.lower.z = d3;
        this.updateBoundsStates();
    }

    public void setLower(Point3d point3d) {
        this.lower.x = point3d.x;
        this.lower.y = point3d.y;
        this.lower.z = point3d.z;
        this.updateBoundsStates();
    }

    public void getUpper(Point3d point3d) {
        point3d.x = this.upper.x;
        point3d.y = this.upper.y;
        point3d.z = this.upper.z;
    }

    public void setUpper(double d, double d2, double d3) {
        this.upper.x = d;
        this.upper.y = d2;
        this.upper.z = d3;
        this.updateBoundsStates();
    }

    public void setUpper(Point3d point3d) {
        this.upper.x = point3d.x;
        this.upper.y = point3d.y;
        this.upper.z = point3d.z;
        this.updateBoundsStates();
    }

    public void set(Bounds bounds) {
        if (bounds == null || bounds.boundsIsEmpty) {
            this.lower.z = 1.0;
            this.lower.y = 1.0;
            this.lower.x = 1.0;
            this.upper.z = -1.0;
            this.upper.y = -1.0;
            this.upper.x = -1.0;
        } else if (bounds.boundsIsInfinite) {
            this.lower.z = Double.NEGATIVE_INFINITY;
            this.lower.y = Double.NEGATIVE_INFINITY;
            this.lower.x = Double.NEGATIVE_INFINITY;
            this.upper.z = Double.POSITIVE_INFINITY;
            this.upper.y = Double.POSITIVE_INFINITY;
            this.upper.x = Double.POSITIVE_INFINITY;
        } else if (bounds.boundId == 1) {
            BoundingBox boundingBox = (BoundingBox)bounds;
            this.lower.x = boundingBox.lower.x;
            this.lower.y = boundingBox.lower.y;
            this.lower.z = boundingBox.lower.z;
            this.upper.x = boundingBox.upper.x;
            this.upper.y = boundingBox.upper.y;
            this.upper.z = boundingBox.upper.z;
        } else if (bounds.boundId == 2) {
            BoundingSphere boundingSphere = (BoundingSphere)bounds;
            this.lower.x = boundingSphere.center.x - boundingSphere.radius;
            this.lower.y = boundingSphere.center.y - boundingSphere.radius;
            this.lower.z = boundingSphere.center.z - boundingSphere.radius;
            this.upper.x = boundingSphere.center.x + boundingSphere.radius;
            this.upper.y = boundingSphere.center.y + boundingSphere.radius;
            this.upper.z = boundingSphere.center.z + boundingSphere.radius;
        } else if (bounds.boundId == 4) {
            BoundingPolytope boundingPolytope = (BoundingPolytope)bounds;
            this.lower.x = this.upper.x = boundingPolytope.verts[0].x;
            this.lower.y = this.upper.y = boundingPolytope.verts[0].y;
            this.lower.z = this.upper.z = boundingPolytope.verts[0].z;
            for (int i = 1; i < boundingPolytope.nVerts; ++i) {
                if (boundingPolytope.verts[i].x < this.lower.x) {
                    this.lower.x = boundingPolytope.verts[i].x;
                }
                if (boundingPolytope.verts[i].y < this.lower.y) {
                    this.lower.y = boundingPolytope.verts[i].y;
                }
                if (boundingPolytope.verts[i].z < this.lower.z) {
                    this.lower.z = boundingPolytope.verts[i].z;
                }
                if (boundingPolytope.verts[i].x > this.upper.x) {
                    this.upper.x = boundingPolytope.verts[i].x;
                }
                if (boundingPolytope.verts[i].y > this.upper.y) {
                    this.upper.y = boundingPolytope.verts[i].y;
                }
                if (!(boundingPolytope.verts[i].z > this.upper.z)) continue;
                this.upper.z = boundingPolytope.verts[i].z;
            }
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingBox0"));
        }
        this.updateBoundsStates();
    }

    public Object clone() {
        return new BoundingBox(this.lower, this.upper);
    }

    public boolean equals(Object object) {
        try {
            BoundingBox boundingBox = (BoundingBox)object;
            return this.lower.equals((Tuple3d)boundingBox.lower) && this.upper.equals((Tuple3d)boundingBox.upper);
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        long l = 1L;
        l = 31L * l + HashCodeUtil.doubleToLongBits((double)this.lower.x);
        l = 31L * l + HashCodeUtil.doubleToLongBits((double)this.lower.y);
        l = 31L * l + HashCodeUtil.doubleToLongBits((double)this.lower.z);
        l = 31L * l + HashCodeUtil.doubleToLongBits((double)this.upper.x);
        l = 31L * l + HashCodeUtil.doubleToLongBits((double)this.upper.y);
        l = 31L * l + HashCodeUtil.doubleToLongBits((double)this.upper.z);
        return (int)(l ^ l >> 32);
    }

    public void combine(Bounds bounds) {
        if (bounds == null || bounds.boundsIsEmpty || this.boundsIsInfinite) {
            return;
        }
        if (this.boundsIsEmpty || bounds.boundsIsInfinite) {
            this.set(bounds);
            return;
        }
        if (bounds.boundId == 1) {
            BoundingBox boundingBox = (BoundingBox)bounds;
            if (this.lower.x > boundingBox.lower.x) {
                this.lower.x = boundingBox.lower.x;
            }
            if (this.lower.y > boundingBox.lower.y) {
                this.lower.y = boundingBox.lower.y;
            }
            if (this.lower.z > boundingBox.lower.z) {
                this.lower.z = boundingBox.lower.z;
            }
            if (this.upper.x < boundingBox.upper.x) {
                this.upper.x = boundingBox.upper.x;
            }
            if (this.upper.y < boundingBox.upper.y) {
                this.upper.y = boundingBox.upper.y;
            }
            if (this.upper.z < boundingBox.upper.z) {
                this.upper.z = boundingBox.upper.z;
            }
        } else if (bounds.boundId == 2) {
            BoundingSphere boundingSphere = (BoundingSphere)bounds;
            if (this.lower.x > boundingSphere.center.x - boundingSphere.radius) {
                this.lower.x = boundingSphere.center.x - boundingSphere.radius;
            }
            if (this.lower.y > boundingSphere.center.y - boundingSphere.radius) {
                this.lower.y = boundingSphere.center.y - boundingSphere.radius;
            }
            if (this.lower.z > boundingSphere.center.z - boundingSphere.radius) {
                this.lower.z = boundingSphere.center.z - boundingSphere.radius;
            }
            if (this.upper.x < boundingSphere.center.x + boundingSphere.radius) {
                this.upper.x = boundingSphere.center.x + boundingSphere.radius;
            }
            if (this.upper.y < boundingSphere.center.y + boundingSphere.radius) {
                this.upper.y = boundingSphere.center.y + boundingSphere.radius;
            }
            if (this.upper.z < boundingSphere.center.z + boundingSphere.radius) {
                this.upper.z = boundingSphere.center.z + boundingSphere.radius;
            }
        } else if (bounds.boundId == 4) {
            BoundingPolytope boundingPolytope = (BoundingPolytope)bounds;
            for (int i = 1; i < boundingPolytope.nVerts; ++i) {
                if (boundingPolytope.verts[i].x < this.lower.x) {
                    this.lower.x = boundingPolytope.verts[i].x;
                }
                if (boundingPolytope.verts[i].y < this.lower.y) {
                    this.lower.y = boundingPolytope.verts[i].y;
                }
                if (boundingPolytope.verts[i].z < this.lower.z) {
                    this.lower.z = boundingPolytope.verts[i].z;
                }
                if (boundingPolytope.verts[i].x > this.upper.x) {
                    this.upper.x = boundingPolytope.verts[i].x;
                }
                if (boundingPolytope.verts[i].y > this.upper.y) {
                    this.upper.y = boundingPolytope.verts[i].y;
                }
                if (!(boundingPolytope.verts[i].z > this.upper.z)) continue;
                this.upper.z = boundingPolytope.verts[i].z;
            }
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingBox3"));
        }
        this.updateBoundsStates();
    }

    public void combine(Bounds[] boundsArray) {
        int n;
        if (boundsArray == null || boundsArray.length <= 0 || this.boundsIsInfinite) {
            return;
        }
        for (n = 0; n < boundsArray.length && (boundsArray[n] == null || boundsArray[n].boundsIsEmpty); ++n) {
        }
        if (n >= boundsArray.length) {
            return;
        }
        if (this.boundsIsEmpty) {
            this.set(boundsArray[n++]);
        }
        if (this.boundsIsInfinite) {
            return;
        }
        while (n < boundsArray.length) {
            if (boundsArray[n] != null && !boundsArray[n].boundsIsEmpty) {
                Bounds bounds;
                if (boundsArray[n].boundsIsInfinite) {
                    this.lower.z = Double.NEGATIVE_INFINITY;
                    this.lower.y = Double.NEGATIVE_INFINITY;
                    this.lower.x = Double.NEGATIVE_INFINITY;
                    this.upper.z = Double.POSITIVE_INFINITY;
                    this.upper.y = Double.POSITIVE_INFINITY;
                    this.upper.x = Double.POSITIVE_INFINITY;
                    break;
                }
                if (boundsArray[n].boundId == 1) {
                    bounds = (BoundingBox)boundsArray[n];
                    if (this.lower.x > bounds.lower.x) {
                        this.lower.x = bounds.lower.x;
                    }
                    if (this.lower.y > bounds.lower.y) {
                        this.lower.y = bounds.lower.y;
                    }
                    if (this.lower.z > bounds.lower.z) {
                        this.lower.z = bounds.lower.z;
                    }
                    if (this.upper.x < bounds.upper.x) {
                        this.upper.x = bounds.upper.x;
                    }
                    if (this.upper.y < bounds.upper.y) {
                        this.upper.y = bounds.upper.y;
                    }
                    if (this.upper.z < bounds.upper.z) {
                        this.upper.z = bounds.upper.z;
                    }
                } else if (boundsArray[n].boundId == 2) {
                    bounds = (BoundingSphere)boundsArray[n];
                    if (this.lower.x > ((BoundingSphere)bounds).center.x - ((BoundingSphere)bounds).radius) {
                        this.lower.x = ((BoundingSphere)bounds).center.x - ((BoundingSphere)bounds).radius;
                    }
                    if (this.lower.y > ((BoundingSphere)bounds).center.y - ((BoundingSphere)bounds).radius) {
                        this.lower.y = ((BoundingSphere)bounds).center.y - ((BoundingSphere)bounds).radius;
                    }
                    if (this.lower.z > ((BoundingSphere)bounds).center.z - ((BoundingSphere)bounds).radius) {
                        this.lower.z = ((BoundingSphere)bounds).center.z - ((BoundingSphere)bounds).radius;
                    }
                    if (this.upper.x < ((BoundingSphere)bounds).center.x + ((BoundingSphere)bounds).radius) {
                        this.upper.x = ((BoundingSphere)bounds).center.x + ((BoundingSphere)bounds).radius;
                    }
                    if (this.upper.y < ((BoundingSphere)bounds).center.y + ((BoundingSphere)bounds).radius) {
                        this.upper.y = ((BoundingSphere)bounds).center.y + ((BoundingSphere)bounds).radius;
                    }
                    if (this.upper.z < ((BoundingSphere)bounds).center.z + ((BoundingSphere)bounds).radius) {
                        this.upper.z = ((BoundingSphere)bounds).center.z + ((BoundingSphere)bounds).radius;
                    }
                } else if (boundsArray[n].boundId == 4) {
                    bounds = (BoundingPolytope)boundsArray[n];
                    for (n = 1; n < ((BoundingPolytope)bounds).nVerts; ++n) {
                        if (((BoundingPolytope)bounds).verts[n].x < this.lower.x) {
                            this.lower.x = ((BoundingPolytope)bounds).verts[n].x;
                        }
                        if (((BoundingPolytope)bounds).verts[n].y < this.lower.y) {
                            this.lower.y = ((BoundingPolytope)bounds).verts[n].y;
                        }
                        if (((BoundingPolytope)bounds).verts[n].z < this.lower.z) {
                            this.lower.z = ((BoundingPolytope)bounds).verts[n].z;
                        }
                        if (((BoundingPolytope)bounds).verts[n].x > this.upper.x) {
                            this.upper.x = ((BoundingPolytope)bounds).verts[n].x;
                        }
                        if (((BoundingPolytope)bounds).verts[n].y > this.upper.y) {
                            this.upper.y = ((BoundingPolytope)bounds).verts[n].y;
                        }
                        if (!(((BoundingPolytope)bounds).verts[n].z > this.upper.z)) continue;
                        this.upper.z = ((BoundingPolytope)bounds).verts[n].z;
                    }
                } else {
                    throw new IllegalArgumentException(J3dI18N.getString("BoundingBox4"));
                }
            }
            ++n;
        }
        this.updateBoundsStates();
    }

    public void combine(Point3d point3d) {
        if (this.boundsIsInfinite) {
            return;
        }
        if (this.boundsIsEmpty) {
            this.upper.x = this.lower.x = point3d.x;
            this.upper.y = this.lower.y = point3d.y;
            this.upper.z = this.lower.z = point3d.z;
        } else {
            if (point3d.x > this.upper.x) {
                this.upper.x = point3d.x;
            }
            if (point3d.y > this.upper.y) {
                this.upper.y = point3d.y;
            }
            if (point3d.z > this.upper.z) {
                this.upper.z = point3d.z;
            }
            if (point3d.x < this.lower.x) {
                this.lower.x = point3d.x;
            }
            if (point3d.y < this.lower.y) {
                this.lower.y = point3d.y;
            }
            if (point3d.z < this.lower.z) {
                this.lower.z = point3d.z;
            }
        }
        this.updateBoundsStates();
    }

    public void combine(Point3d[] point3dArray) {
        if (this.boundsIsInfinite) {
            return;
        }
        if (this.boundsIsEmpty) {
            this.setUpper(point3dArray[0]);
            this.setLower(point3dArray[0]);
        }
        for (int i = 0; i < point3dArray.length; ++i) {
            if (point3dArray[i].x > this.upper.x) {
                this.upper.x = point3dArray[i].x;
            }
            if (point3dArray[i].y > this.upper.y) {
                this.upper.y = point3dArray[i].y;
            }
            if (point3dArray[i].z > this.upper.z) {
                this.upper.z = point3dArray[i].z;
            }
            if (point3dArray[i].x < this.lower.x) {
                this.lower.x = point3dArray[i].x;
            }
            if (point3dArray[i].y < this.lower.y) {
                this.lower.y = point3dArray[i].y;
            }
            if (!(point3dArray[i].z < this.lower.z)) continue;
            this.lower.z = point3dArray[i].z;
        }
        this.updateBoundsStates();
    }

    public void transform(Bounds bounds, Transform3D transform3D) {
        if (bounds == null || bounds.boundsIsEmpty) {
            this.lower.z = 1.0;
            this.lower.y = 1.0;
            this.lower.x = 1.0;
            this.upper.z = -1.0;
            this.upper.y = -1.0;
            this.upper.x = -1.0;
            this.updateBoundsStates();
            return;
        }
        if (bounds.boundsIsInfinite) {
            this.lower.z = Double.NEGATIVE_INFINITY;
            this.lower.y = Double.NEGATIVE_INFINITY;
            this.lower.x = Double.NEGATIVE_INFINITY;
            this.upper.z = Double.POSITIVE_INFINITY;
            this.upper.y = Double.POSITIVE_INFINITY;
            this.upper.x = Double.POSITIVE_INFINITY;
            this.updateBoundsStates();
            return;
        }
        if (bounds.boundId == 1) {
            if (this.tmpBox == null) {
                this.tmpBox = new BoundingBox((BoundingBox)bounds);
            } else {
                this.tmpBox.set((BoundingBox)bounds);
            }
            this.tmpBox.transform(transform3D);
            this.set(this.tmpBox);
        } else if (bounds.boundId == 2) {
            if (this.tmpSphere == null) {
                this.tmpSphere = new BoundingSphere((BoundingSphere)bounds);
            } else {
                this.tmpSphere.set((BoundingSphere)bounds);
            }
            this.tmpSphere.transform(transform3D);
            this.set(this.tmpSphere);
        } else if (bounds.boundId == 4) {
            if (this.tmpPolytope == null) {
                this.tmpPolytope = new BoundingPolytope((BoundingPolytope)bounds);
            } else {
                this.tmpPolytope.set((BoundingPolytope)bounds);
            }
            this.tmpPolytope.transform(transform3D);
            this.set(this.tmpPolytope);
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingBox5"));
        }
        if (VirtualUniverse.mc.releaseBoundingBoxMemory) {
            this.tmpSphere = null;
            this.tmpBox = null;
            this.tmpPolytope = null;
        }
    }

    public void transform(Transform3D transform3D) {
        if (this.boundsIsInfinite) {
            return;
        }
        if (this.tmpP3d == null) {
            this.tmpP3d = new Point3d();
        }
        double d = this.upper.x;
        double d2 = this.upper.y;
        double d3 = this.upper.z;
        double d4 = this.lower.x;
        double d5 = this.lower.y;
        double d6 = this.lower.z;
        this.tmpP3d.set(d, d2, d3);
        transform3D.transform(this.tmpP3d);
        this.upper.x = this.tmpP3d.x;
        this.upper.y = this.tmpP3d.y;
        this.upper.z = this.tmpP3d.z;
        this.lower.x = this.tmpP3d.x;
        this.lower.y = this.tmpP3d.y;
        this.lower.z = this.tmpP3d.z;
        this.tmpP3d.set(d4, d2, d3);
        transform3D.transform(this.tmpP3d);
        if (this.tmpP3d.x > this.upper.x) {
            this.upper.x = this.tmpP3d.x;
        }
        if (this.tmpP3d.y > this.upper.y) {
            this.upper.y = this.tmpP3d.y;
        }
        if (this.tmpP3d.z > this.upper.z) {
            this.upper.z = this.tmpP3d.z;
        }
        if (this.tmpP3d.x < this.lower.x) {
            this.lower.x = this.tmpP3d.x;
        }
        if (this.tmpP3d.y < this.lower.y) {
            this.lower.y = this.tmpP3d.y;
        }
        if (this.tmpP3d.z < this.lower.z) {
            this.lower.z = this.tmpP3d.z;
        }
        this.tmpP3d.set(d4, d5, d3);
        transform3D.transform(this.tmpP3d);
        if (this.tmpP3d.x > this.upper.x) {
            this.upper.x = this.tmpP3d.x;
        }
        if (this.tmpP3d.y > this.upper.y) {
            this.upper.y = this.tmpP3d.y;
        }
        if (this.tmpP3d.z > this.upper.z) {
            this.upper.z = this.tmpP3d.z;
        }
        if (this.tmpP3d.x < this.lower.x) {
            this.lower.x = this.tmpP3d.x;
        }
        if (this.tmpP3d.y < this.lower.y) {
            this.lower.y = this.tmpP3d.y;
        }
        if (this.tmpP3d.z < this.lower.z) {
            this.lower.z = this.tmpP3d.z;
        }
        this.tmpP3d.set(d, d5, d3);
        transform3D.transform(this.tmpP3d);
        if (this.tmpP3d.x > this.upper.x) {
            this.upper.x = this.tmpP3d.x;
        }
        if (this.tmpP3d.y > this.upper.y) {
            this.upper.y = this.tmpP3d.y;
        }
        if (this.tmpP3d.z > this.upper.z) {
            this.upper.z = this.tmpP3d.z;
        }
        if (this.tmpP3d.x < this.lower.x) {
            this.lower.x = this.tmpP3d.x;
        }
        if (this.tmpP3d.y < this.lower.y) {
            this.lower.y = this.tmpP3d.y;
        }
        if (this.tmpP3d.z < this.lower.z) {
            this.lower.z = this.tmpP3d.z;
        }
        this.tmpP3d.set(d4, d2, d6);
        transform3D.transform(this.tmpP3d);
        if (this.tmpP3d.x > this.upper.x) {
            this.upper.x = this.tmpP3d.x;
        }
        if (this.tmpP3d.y > this.upper.y) {
            this.upper.y = this.tmpP3d.y;
        }
        if (this.tmpP3d.z > this.upper.z) {
            this.upper.z = this.tmpP3d.z;
        }
        if (this.tmpP3d.x < this.lower.x) {
            this.lower.x = this.tmpP3d.x;
        }
        if (this.tmpP3d.y < this.lower.y) {
            this.lower.y = this.tmpP3d.y;
        }
        if (this.tmpP3d.z < this.lower.z) {
            this.lower.z = this.tmpP3d.z;
        }
        this.tmpP3d.set(d, d2, d6);
        transform3D.transform(this.tmpP3d);
        if (this.tmpP3d.x > this.upper.x) {
            this.upper.x = this.tmpP3d.x;
        }
        if (this.tmpP3d.y > this.upper.y) {
            this.upper.y = this.tmpP3d.y;
        }
        if (this.tmpP3d.z > this.upper.z) {
            this.upper.z = this.tmpP3d.z;
        }
        if (this.tmpP3d.x < this.lower.x) {
            this.lower.x = this.tmpP3d.x;
        }
        if (this.tmpP3d.y < this.lower.y) {
            this.lower.y = this.tmpP3d.y;
        }
        if (this.tmpP3d.z < this.lower.z) {
            this.lower.z = this.tmpP3d.z;
        }
        this.tmpP3d.set(d4, d5, d6);
        transform3D.transform(this.tmpP3d);
        if (this.tmpP3d.x > this.upper.x) {
            this.upper.x = this.tmpP3d.x;
        }
        if (this.tmpP3d.y > this.upper.y) {
            this.upper.y = this.tmpP3d.y;
        }
        if (this.tmpP3d.z > this.upper.z) {
            this.upper.z = this.tmpP3d.z;
        }
        if (this.tmpP3d.x < this.lower.x) {
            this.lower.x = this.tmpP3d.x;
        }
        if (this.tmpP3d.y < this.lower.y) {
            this.lower.y = this.tmpP3d.y;
        }
        if (this.tmpP3d.z < this.lower.z) {
            this.lower.z = this.tmpP3d.z;
        }
        this.tmpP3d.set(d, d5, d6);
        transform3D.transform(this.tmpP3d);
        if (this.tmpP3d.x > this.upper.x) {
            this.upper.x = this.tmpP3d.x;
        }
        if (this.tmpP3d.y > this.upper.y) {
            this.upper.y = this.tmpP3d.y;
        }
        if (this.tmpP3d.z > this.upper.z) {
            this.upper.z = this.tmpP3d.z;
        }
        if (this.tmpP3d.x < this.lower.x) {
            this.lower.x = this.tmpP3d.x;
        }
        if (this.tmpP3d.y < this.lower.y) {
            this.lower.y = this.tmpP3d.y;
        }
        if (this.tmpP3d.z < this.lower.z) {
            this.lower.z = this.tmpP3d.z;
        }
        if (VirtualUniverse.mc.releaseBoundingBoxMemory) {
            this.tmpP3d = null;
        }
    }

    boolean intersect(Point3d point3d, Vector3d vector3d, Point4d point4d) {
        double d;
        double d2;
        double d3;
        double d4;
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            point4d.x = point3d.x;
            point4d.y = point3d.y;
            point4d.z = point3d.z;
            point4d.w = 0.0;
            return true;
        }
        double d5 = vector3d.x * vector3d.x + vector3d.y * vector3d.y + vector3d.z * vector3d.z;
        if (d5 == 0.0) {
            return this.intersect(point3d, point4d);
        }
        double d6 = 1.0 / Math.sqrt(d5);
        double d7 = vector3d.x * d6;
        double d8 = vector3d.y * d6;
        double d9 = vector3d.z * d6;
        double d10 = -1.7976931348623157E308;
        double d11 = Double.MAX_VALUE;
        if (d7 == 0.0) {
            if (point3d.x < this.lower.x || point3d.x > this.upper.x) {
                return false;
            }
        } else {
            d4 = 1.0 / d7;
            d3 = (this.lower.x - point3d.x) * d4;
            d2 = (this.upper.x - point3d.x) * d4;
            if (d3 > d2) {
                d10 = d2;
                d11 = d3;
            } else {
                d10 = d3;
                d11 = d2;
            }
            if (d11 < 0.0) {
                return false;
            }
        }
        if (d8 == 0.0) {
            if (point3d.y < this.lower.y || point3d.y > this.upper.y) {
                return false;
            }
        } else {
            d4 = 1.0 / d8;
            d3 = (this.lower.y - point3d.y) * d4;
            d2 = (this.upper.y - point3d.y) * d4;
            if (d3 > d2) {
                d = d3;
                d3 = d2;
                d2 = d;
            }
            if (d3 > d10) {
                d10 = d3;
            }
            if (d2 < d11) {
                d11 = d2;
            }
            if (d11 < 0.0 || d10 > d11) {
                return false;
            }
        }
        if (d9 == 0.0) {
            if (point3d.z < this.lower.z || point3d.z > this.upper.z) {
                return false;
            }
        } else {
            d4 = 1.0 / d9;
            d3 = (this.lower.z - point3d.z) * d4;
            d2 = (this.upper.z - point3d.z) * d4;
            if (d3 > d2) {
                d = d3;
                d3 = d2;
                d2 = d;
            }
            if (d3 > d10) {
                d10 = d3;
            }
            if (d2 < d11) {
                d11 = d2;
            }
            if (d11 < 0.0 || d10 > d11) {
                return false;
            }
        }
        if (d10 < 0.0 && d11 >= 0.0) {
            point4d.x = point3d.x + d7 * d11;
            point4d.y = point3d.y + d8 * d11;
            point4d.z = point3d.z + d9 * d11;
            point4d.w = d11;
        } else {
            point4d.x = point3d.x + d7 * d10;
            point4d.y = point3d.y + d8 * d10;
            point4d.z = point3d.z + d9 * d10;
            point4d.w = d10;
        }
        return true;
    }

    boolean intersect(Point3d point3d, Point4d point4d) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            point4d.x = point3d.x;
            point4d.y = point3d.y;
            point4d.z = point3d.z;
            point4d.w = 0.0;
            return true;
        }
        if (point3d.x <= this.upper.x && point3d.x >= this.lower.x && point3d.y <= this.upper.y && point3d.y >= this.lower.y && point3d.z <= this.upper.z && point3d.z >= this.lower.z) {
            point4d.x = point3d.x;
            point4d.y = point3d.y;
            point4d.z = point3d.z;
            point4d.w = 0.0;
            return true;
        }
        return false;
    }

    boolean intersect(Point3d point3d, Point3d point3d2, Point4d point4d) {
        double d;
        double d2;
        double d3;
        double d4;
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            point4d.x = point3d.x;
            point4d.y = point3d.y;
            point4d.z = point3d.z;
            point4d.w = 0.0;
            return true;
        }
        double d5 = point3d2.x - point3d.x;
        double d6 = point3d2.y - point3d.y;
        double d7 = point3d2.z - point3d.z;
        double d8 = d5 * d5 + d6 * d6 + d7 * d7;
        if (d8 == 0.0) {
            return this.intersect(point3d, point4d);
        }
        d8 = Math.sqrt(d8);
        double d9 = 1.0 / d8;
        d6 *= d9;
        d7 *= d9;
        double d10 = -1.7976931348623157E308;
        double d11 = Double.MAX_VALUE;
        if ((d5 *= d9) == 0.0) {
            if (point3d.x < this.lower.x || point3d.x > this.upper.x) {
                return false;
            }
        } else {
            d4 = 1.0 / d5;
            d3 = (this.lower.x - point3d.x) * d4;
            d2 = (this.upper.x - point3d.x) * d4;
            if (d3 > d2) {
                d10 = d2;
                d11 = d3;
            } else {
                d10 = d3;
                d11 = d2;
            }
            if (d11 < 0.0) {
                return false;
            }
        }
        if (d6 == 0.0) {
            if (point3d.y < this.lower.y || point3d.y > this.upper.y) {
                return false;
            }
        } else {
            d4 = 1.0 / d6;
            d3 = (this.lower.y - point3d.y) * d4;
            d2 = (this.upper.y - point3d.y) * d4;
            if (d3 > d2) {
                d = d3;
                d3 = d2;
                d2 = d;
            }
            if (d3 > d10) {
                d10 = d3;
            }
            if (d2 < d11) {
                d11 = d2;
            }
            if (d11 < 0.0 || d10 > d11) {
                return false;
            }
        }
        if (d7 == 0.0) {
            if (point3d.z < this.lower.z || point3d.z > this.upper.z) {
                return false;
            }
        } else {
            d4 = 1.0 / d7;
            d3 = (this.lower.z - point3d.z) * d4;
            d2 = (this.upper.z - point3d.z) * d4;
            if (d3 > d2) {
                d = d3;
                d3 = d2;
                d2 = d;
            }
            if (d3 > d10) {
                d10 = d3;
            }
            if (d2 < d11) {
                d11 = d2;
            }
            if (d11 < 0.0 || d10 > d11) {
                return false;
            }
        }
        if (d10 < 0.0 && d11 >= 0.0) {
            point4d.x = point3d.x + d5 * d11;
            point4d.y = point3d.y + d6 * d11;
            point4d.z = point3d.z + d7 * d11;
            point4d.w = d11;
        } else {
            if (d10 > d8) {
                return false;
            }
            point4d.x = point3d.x + d5 * d10;
            point4d.y = point3d.y + d6 * d10;
            point4d.z = point3d.z + d7 * d10;
            point4d.w = d10;
        }
        return true;
    }

    public boolean intersect(Point3d point3d, Vector3d vector3d) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            return true;
        }
        Point3d point3d2 = new Point3d();
        return this.intersect(point3d, vector3d, point3d2);
    }

    boolean intersect(Point3d point3d, Vector3d vector3d, Point3d point3d2) {
        double d = 0.0;
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            point3d2.x = point3d.x;
            point3d2.y = point3d.y;
            point3d2.z = point3d.z;
            return true;
        }
        if (vector3d.x > 0.0) {
            d = Math.max(d, (this.lower.x - point3d.x) / vector3d.x);
        }
        if (vector3d.x < 0.0) {
            d = Math.max(d, (this.upper.x - point3d.x) / vector3d.x);
        }
        if (vector3d.y > 0.0) {
            d = Math.max(d, (this.lower.y - point3d.y) / vector3d.y);
        }
        if (vector3d.y < 0.0) {
            d = Math.max(d, (this.upper.y - point3d.y) / vector3d.y);
        }
        if (vector3d.z > 0.0) {
            d = Math.max(d, (this.lower.z - point3d.z) / vector3d.z);
        }
        if (vector3d.z < 0.0) {
            d = Math.max(d, (this.upper.z - point3d.z) / vector3d.z);
        }
        point3d2.x = point3d.x + d * vector3d.x;
        point3d2.y = point3d.y + d * vector3d.y;
        point3d2.z = point3d.z + d * vector3d.z;
        if (point3d2.x < this.lower.x - 1.0E-8) {
            return false;
        }
        if (point3d2.x > this.upper.x + 1.0E-8) {
            return false;
        }
        if (point3d2.y < this.lower.y - 1.0E-8) {
            return false;
        }
        if (point3d2.y > this.upper.y + 1.0E-8) {
            return false;
        }
        if (point3d2.z < this.lower.z - 1.0E-8) {
            return false;
        }
        return !(point3d2.z > this.upper.z + 1.0E-8);
    }

    public boolean intersect(Point3d point3d) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            return true;
        }
        return point3d.x <= this.upper.x && point3d.x >= this.lower.x && point3d.y <= this.upper.y && point3d.y >= this.lower.y && point3d.z <= this.upper.z && point3d.z >= this.lower.z;
    }

    public boolean isEmpty() {
        return this.boundsIsEmpty;
    }

    boolean intersect(Bounds bounds, Point4d point4d) {
        return this.intersect(bounds);
    }

    public boolean intersect(Bounds bounds) {
        if (bounds == null) {
            return false;
        }
        if (this.boundsIsEmpty || bounds.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite || bounds.boundsIsInfinite) {
            return true;
        }
        if (bounds.boundId == 1) {
            BoundingBox boundingBox = (BoundingBox)bounds;
            return this.upper.x > boundingBox.lower.x && boundingBox.upper.x > this.lower.x && this.upper.y > boundingBox.lower.y && boundingBox.upper.y > this.lower.y && this.upper.z > boundingBox.lower.z && boundingBox.upper.z > this.lower.z;
        }
        if (bounds.boundId == 2) {
            BoundingSphere boundingSphere = (BoundingSphere)bounds;
            double d = boundingSphere.radius * boundingSphere.radius;
            double d2 = 0.0;
            if (boundingSphere.center.x < this.lower.x) {
                d2 = (boundingSphere.center.x - this.lower.x) * (boundingSphere.center.x - this.lower.x);
            } else if (boundingSphere.center.x > this.upper.x) {
                d2 = (boundingSphere.center.x - this.upper.x) * (boundingSphere.center.x - this.upper.x);
            }
            if (boundingSphere.center.y < this.lower.y) {
                d2 += (boundingSphere.center.y - this.lower.y) * (boundingSphere.center.y - this.lower.y);
            } else if (boundingSphere.center.y > this.upper.y) {
                d2 += (boundingSphere.center.y - this.upper.y) * (boundingSphere.center.y - this.upper.y);
            }
            if (boundingSphere.center.z < this.lower.z) {
                d2 += (boundingSphere.center.z - this.lower.z) * (boundingSphere.center.z - this.lower.z);
            } else if (boundingSphere.center.z > this.upper.z) {
                d2 += (boundingSphere.center.z - this.upper.z) * (boundingSphere.center.z - this.upper.z);
            }
            return d2 <= d;
        }
        if (bounds.boundId == 4) {
            return this.intersect_ptope_abox((BoundingPolytope)bounds, this);
        }
        throw new IllegalArgumentException(J3dI18N.getString("BoundingBox6"));
    }

    public boolean intersect(Bounds[] boundsArray) {
        if (boundsArray == null || boundsArray.length <= 0) {
            return false;
        }
        if (this.boundsIsEmpty) {
            return false;
        }
        for (int i = 0; i < boundsArray.length; ++i) {
            Bounds bounds;
            if (boundsArray[i] == null || boundsArray[i].boundsIsEmpty) continue;
            if (this.boundsIsInfinite || boundsArray[i].boundsIsInfinite) {
                return true;
            }
            if (boundsArray[i].boundId == 1) {
                bounds = (BoundingBox)boundsArray[i];
                if (!(this.upper.x > bounds.lower.x) || !(bounds.upper.x > this.lower.x) || !(this.upper.y > bounds.lower.y) || !(bounds.upper.y > this.lower.y) || !(this.upper.z > bounds.lower.z) || !(bounds.upper.z > this.lower.z)) continue;
                return true;
            }
            if (boundsArray[i].boundId == 2) {
                bounds = (BoundingSphere)boundsArray[i];
                double d = ((BoundingSphere)bounds).radius * ((BoundingSphere)bounds).radius;
                double d2 = 0.0;
                if (((BoundingSphere)bounds).center.x < this.lower.x) {
                    d2 = (((BoundingSphere)bounds).center.x - this.lower.x) * (((BoundingSphere)bounds).center.x - this.lower.x);
                } else if (((BoundingSphere)bounds).center.x > this.upper.x) {
                    d2 = (((BoundingSphere)bounds).center.x - this.upper.x) * (((BoundingSphere)bounds).center.x - this.upper.x);
                }
                if (((BoundingSphere)bounds).center.y < this.lower.y) {
                    d2 += (((BoundingSphere)bounds).center.y - this.lower.y) * (((BoundingSphere)bounds).center.y - this.lower.y);
                } else if (((BoundingSphere)bounds).center.y > this.upper.y) {
                    d2 += (((BoundingSphere)bounds).center.y - this.upper.y) * (((BoundingSphere)bounds).center.y - this.upper.y);
                }
                if (((BoundingSphere)bounds).center.z < this.lower.z) {
                    d2 += (((BoundingSphere)bounds).center.z - this.lower.z) * (((BoundingSphere)bounds).center.z - this.lower.z);
                } else if (((BoundingSphere)bounds).center.z > this.upper.z) {
                    d2 += (((BoundingSphere)bounds).center.z - this.upper.z) * (((BoundingSphere)bounds).center.z - this.upper.z);
                }
                if (!(d2 <= d)) continue;
                return true;
            }
            if (boundsArray[i].boundId != 4 || !this.intersect_ptope_abox((BoundingPolytope)boundsArray[i], this)) continue;
            return true;
        }
        return false;
    }

    public boolean intersect(Bounds bounds, BoundingBox boundingBox) {
        if (bounds == null || this.boundsIsEmpty || bounds.boundsIsEmpty) {
            boundingBox.setLower(1.0, 1.0, 1.0);
            boundingBox.setUpper(-1.0, -1.0, -1.0);
            return false;
        }
        if (this.boundsIsInfinite && !bounds.boundsIsInfinite) {
            boundingBox.set(bounds);
            return true;
        }
        if (!this.boundsIsInfinite && bounds.boundsIsInfinite) {
            boundingBox.set(this);
            return true;
        }
        if (this.boundsIsInfinite && bounds.boundsIsInfinite) {
            boundingBox.set(this);
            return true;
        }
        if (bounds.boundId == 1) {
            BoundingBox boundingBox2 = (BoundingBox)bounds;
            if (this.upper.x > boundingBox2.lower.x && boundingBox2.upper.x > this.lower.x && this.upper.y > boundingBox2.lower.y && boundingBox2.upper.y > this.lower.y && this.upper.z > boundingBox2.lower.z && boundingBox2.upper.z > this.lower.z) {
                boundingBox.upper.x = this.upper.x > boundingBox2.upper.x ? boundingBox2.upper.x : this.upper.x;
                boundingBox.upper.y = this.upper.y > boundingBox2.upper.y ? boundingBox2.upper.y : this.upper.y;
                boundingBox.upper.z = this.upper.z > boundingBox2.upper.z ? boundingBox2.upper.z : this.upper.z;
                boundingBox.lower.x = this.lower.x < boundingBox2.lower.x ? boundingBox2.lower.x : this.lower.x;
                boundingBox.lower.y = this.lower.y < boundingBox2.lower.y ? boundingBox2.lower.y : this.lower.y;
                boundingBox.lower.z = this.lower.z < boundingBox2.lower.z ? boundingBox2.lower.z : this.lower.z;
                boundingBox.updateBoundsStates();
                return true;
            }
            boundingBox.setLower(1.0, 1.0, 1.0);
            boundingBox.setUpper(-1.0, -1.0, -1.0);
            return false;
        }
        if (bounds.boundId == 2) {
            BoundingSphere boundingSphere = (BoundingSphere)bounds;
            if (this.intersect(boundingSphere)) {
                BoundingBox boundingBox3 = new BoundingBox(boundingSphere);
                this.intersect((Bounds)boundingBox3, boundingBox);
                return true;
            }
            boundingBox.setLower(1.0, 1.0, 1.0);
            boundingBox.setUpper(-1.0, -1.0, -1.0);
            return false;
        }
        if (bounds.boundId == 4) {
            BoundingPolytope boundingPolytope = (BoundingPolytope)bounds;
            if (this.intersect(boundingPolytope)) {
                BoundingBox boundingBox4 = new BoundingBox(boundingPolytope);
                this.intersect((Bounds)boundingBox4, boundingBox);
                return true;
            }
            boundingBox.setLower(1.0, 1.0, 1.0);
            boundingBox.setUpper(-1.0, -1.0, -1.0);
            return false;
        }
        throw new IllegalArgumentException(J3dI18N.getString("BoundingBox7"));
    }

    public boolean intersect(Bounds[] boundsArray, BoundingBox boundingBox) {
        int n;
        if (boundsArray == null || boundsArray.length <= 0 || this.boundsIsEmpty) {
            boundingBox.setLower(1.0, 1.0, 1.0);
            boundingBox.setUpper(-1.0, -1.0, -1.0);
            return false;
        }
        for (n = 0; boundsArray[n] == null && n < boundsArray.length; ++n) {
        }
        if (n >= boundsArray.length) {
            boundingBox.setLower(1.0, 1.0, 1.0);
            boundingBox.setUpper(-1.0, -1.0, -1.0);
            return false;
        }
        boolean bl = false;
        BoundingBox boundingBox2 = new BoundingBox();
        while (n < boundsArray.length) {
            if (boundsArray[n] != null && !boundsArray[n].boundsIsEmpty) {
                BoundingBox boundingBox3;
                Bounds bounds;
                if (boundsArray[n].boundId == 1) {
                    bounds = (BoundingBox)boundsArray[n];
                    if (this.upper.x > bounds.lower.x && bounds.upper.x > this.lower.x && this.upper.y > bounds.lower.y && bounds.upper.y > this.lower.y && this.upper.z > bounds.lower.z && bounds.upper.z > this.lower.z) {
                        boundingBox.upper.x = this.upper.x > bounds.upper.x ? bounds.upper.x : this.upper.x;
                        boundingBox.upper.y = this.upper.y > bounds.upper.y ? bounds.upper.y : this.upper.y;
                        boundingBox.upper.z = this.upper.z > bounds.upper.z ? bounds.upper.z : this.upper.z;
                        boundingBox.lower.x = this.lower.x < bounds.lower.x ? bounds.lower.x : this.lower.x;
                        boundingBox.lower.y = this.lower.y < bounds.lower.y ? bounds.lower.y : this.lower.y;
                        boundingBox.lower.z = this.lower.z < bounds.lower.z ? bounds.lower.z : this.lower.z;
                        bl = true;
                        boundingBox.updateBoundsStates();
                    }
                } else if (boundsArray[n].boundId == 2) {
                    bounds = (BoundingSphere)boundsArray[n];
                    if (this.intersect(bounds)) {
                        boundingBox3 = new BoundingBox(bounds);
                        this.intersect((Bounds)boundingBox3, boundingBox2);
                        if (bl) {
                            boundingBox.combine(boundingBox2);
                        } else {
                            boundingBox.set(boundingBox2);
                            bl = true;
                        }
                    }
                } else if (boundsArray[n].boundId == 4) {
                    bounds = (BoundingPolytope)boundsArray[n];
                    if (this.intersect(bounds)) {
                        boundingBox3 = new BoundingBox(bounds);
                        this.intersect((Bounds)boundingBox3, boundingBox2);
                        if (bl) {
                            boundingBox.combine(boundingBox2);
                        } else {
                            boundingBox.set(boundingBox2);
                            bl = true;
                        }
                    }
                } else {
                    throw new IllegalArgumentException(J3dI18N.getString("BoundingBox6"));
                }
            }
            if (boundingBox.boundsIsInfinite) break;
            ++n;
        }
        if (!bl) {
            boundingBox.setLower(1.0, 1.0, 1.0);
            boundingBox.setUpper(-1.0, -1.0, -1.0);
        }
        return bl;
    }

    public Bounds closestIntersection(Bounds[] boundsArray) {
        if (boundsArray == null || boundsArray.length <= 0) {
            return null;
        }
        if (this.boundsIsEmpty) {
            return null;
        }
        this.getCenter();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        boolean bl = false;
        boolean bl2 = false;
        double d4 = Double.MAX_VALUE;
        int n = 0;
        for (int i = 0; i < boundsArray.length; ++i) {
            boolean bl3;
            double d5;
            Bounds bounds;
            if (boundsArray[i] == null || !this.intersect(boundsArray[i])) continue;
            bl2 = true;
            if (boundsArray[i].boundId == 1) {
                bounds = (BoundingBox)boundsArray[i];
                d = (bounds.upper.x + bounds.lower.x) / 2.0;
                d2 = (bounds.upper.y + bounds.lower.y) / 2.0;
                d3 = (bounds.upper.z + bounds.lower.z) / 2.0;
                d5 = Math.sqrt((this.centroid.x - d) * (this.centroid.x - d) + (this.centroid.y - d2) * (this.centroid.y - d2) + (this.centroid.z - d3) * (this.centroid.z - d3));
                bl3 = false;
                if (this.lower.x <= bounds.lower.x && this.lower.y <= bounds.lower.y && this.lower.z <= bounds.lower.z && this.upper.x >= bounds.upper.x && this.upper.y >= bounds.upper.y && this.upper.z >= bounds.upper.z) {
                    bl3 = true;
                }
                if (bl3) {
                    if (!bl) {
                        n = i;
                        d4 = d5;
                        bl = true;
                        continue;
                    }
                    if (!(d5 < d4)) continue;
                    n = i;
                    d4 = d5;
                    continue;
                }
                if (bl || !(d5 < d4)) continue;
                n = i;
                d4 = d5;
                continue;
            }
            if (boundsArray[i].boundId == 2) {
                bounds = (BoundingSphere)boundsArray[i];
                d5 = Math.sqrt((this.centroid.x - ((BoundingSphere)bounds).center.x) * (this.centroid.x - ((BoundingSphere)bounds).center.x) + (this.centroid.y - ((BoundingSphere)bounds).center.y) * (this.centroid.y - ((BoundingSphere)bounds).center.y) + (this.centroid.z - ((BoundingSphere)bounds).center.z) * (this.centroid.z - ((BoundingSphere)bounds).center.z));
                bl3 = false;
                if (((BoundingSphere)bounds).center.x <= this.upper.x && ((BoundingSphere)bounds).center.x >= this.lower.x && ((BoundingSphere)bounds).center.y <= this.upper.y && ((BoundingSphere)bounds).center.y >= this.lower.y && ((BoundingSphere)bounds).center.z <= this.upper.z && ((BoundingSphere)bounds).center.z >= this.lower.z && ((BoundingSphere)bounds).center.x - this.lower.x >= ((BoundingSphere)bounds).radius && this.upper.x - ((BoundingSphere)bounds).center.x >= ((BoundingSphere)bounds).radius && ((BoundingSphere)bounds).center.y - this.lower.y >= ((BoundingSphere)bounds).radius && this.upper.y - ((BoundingSphere)bounds).center.y >= ((BoundingSphere)bounds).radius && ((BoundingSphere)bounds).center.z - this.lower.z >= ((BoundingSphere)bounds).radius && this.upper.z - ((BoundingSphere)bounds).center.z >= ((BoundingSphere)bounds).radius) {
                    bl3 = true;
                }
                if (bl3) {
                    if (!bl) {
                        n = i;
                        d4 = d5;
                        bl = true;
                        continue;
                    }
                    if (!(d5 < d4)) continue;
                    n = i;
                    d4 = d5;
                    continue;
                }
                if (bl || !(d5 < d4)) continue;
                n = i;
                d4 = d5;
                continue;
            }
            if (boundsArray[i].boundId == 4) {
                bounds = (BoundingPolytope)boundsArray[i];
                d5 = Math.sqrt((this.centroid.x - ((BoundingPolytope)bounds).centroid.x) * (this.centroid.x - ((BoundingPolytope)bounds).centroid.x) + (this.centroid.y - ((BoundingPolytope)bounds).centroid.y) * (this.centroid.y - ((BoundingPolytope)bounds).centroid.y) + (this.centroid.z - ((BoundingPolytope)bounds).centroid.z) * (this.centroid.z - ((BoundingPolytope)bounds).centroid.z));
                bl3 = true;
                for (int j = 0; j < ((BoundingPolytope)bounds).nVerts; ++j) {
                    if (!(((BoundingPolytope)bounds).verts[j].x < this.lower.x || ((BoundingPolytope)bounds).verts[j].y < this.lower.y || ((BoundingPolytope)bounds).verts[j].z < this.lower.z || ((BoundingPolytope)bounds).verts[j].x > this.upper.x || ((BoundingPolytope)bounds).verts[j].y > this.upper.y) && !(((BoundingPolytope)bounds).verts[j].z > this.upper.z)) continue;
                    bl3 = false;
                }
                if (bl3) {
                    if (!bl) {
                        n = i;
                        d4 = d5;
                        bl = true;
                        continue;
                    }
                    if (!(d5 < d4)) continue;
                    n = i;
                    d4 = d5;
                    continue;
                }
                if (bl || !(d5 < d4)) continue;
                n = i;
                d4 = d5;
                continue;
            }
            throw new IllegalArgumentException(J3dI18N.getString("BoundingBox9"));
        }
        if (bl2) {
            return boundsArray[n];
        }
        return null;
    }

    boolean intersect(CachedFrustum cachedFrustum) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            return true;
        }
        if (this.upper.x < cachedFrustum.lower.x || this.lower.x > cachedFrustum.upper.x || this.upper.y < cachedFrustum.lower.y || this.lower.y > cachedFrustum.upper.y || this.upper.z < cachedFrustum.lower.z || this.lower.z > cachedFrustum.upper.z) {
            return false;
        }
        int n = 5;
        while (n >= 0) {
            Vector4d vector4d = cachedFrustum.clipPlanes[n--];
            if (!(this.upper.x * vector4d.x + this.upper.y * vector4d.y + this.upper.z * vector4d.z + vector4d.w < 0.0) || !(this.upper.x * vector4d.x + this.lower.y * vector4d.y + this.upper.z * vector4d.z + vector4d.w < 0.0) || !(this.upper.x * vector4d.x + this.lower.y * vector4d.y + this.lower.z * vector4d.z + vector4d.w < 0.0) || !(this.upper.x * vector4d.x + this.upper.y * vector4d.y + this.lower.z * vector4d.z + vector4d.w < 0.0) || !(this.lower.x * vector4d.x + this.upper.y * vector4d.y + this.upper.z * vector4d.z + vector4d.w < 0.0) || !(this.lower.x * vector4d.x + this.lower.y * vector4d.y + this.upper.z * vector4d.z + vector4d.w < 0.0) || !(this.lower.x * vector4d.x + this.lower.y * vector4d.y + this.lower.z * vector4d.z + vector4d.w < 0.0) || !(this.lower.x * vector4d.x + this.upper.y * vector4d.y + this.lower.z * vector4d.z + vector4d.w < 0.0)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return new String("Bounding box: Lower=" + this.lower.x + " " + this.lower.y + " " + this.lower.z + " Upper=" + this.upper.x + " " + this.upper.y + " " + this.upper.z);
    }

    private void updateBoundsStates() {
        if (this.lower.x == Double.NEGATIVE_INFINITY && this.lower.y == Double.NEGATIVE_INFINITY && this.lower.z == Double.NEGATIVE_INFINITY && this.upper.x == Double.POSITIVE_INFINITY && this.upper.y == Double.POSITIVE_INFINITY && this.upper.z == Double.POSITIVE_INFINITY) {
            this.boundsIsEmpty = false;
            this.boundsIsInfinite = true;
            return;
        }
        if (this.checkBoundsIsNaN()) {
            this.boundsIsEmpty = true;
            this.boundsIsInfinite = false;
            return;
        }
        this.boundsIsInfinite = false;
        this.boundsIsEmpty = this.lower.x > this.upper.x || this.lower.y > this.upper.y || this.lower.z > this.upper.z;
    }

    Point3d getCenter() {
        if (this.centroid == null) {
            this.centroid = new Point3d();
        }
        this.centroid.x = (this.upper.x + this.lower.x) * 0.5;
        this.centroid.y = (this.upper.y + this.lower.y) * 0.5;
        this.centroid.z = (this.upper.z + this.lower.z) * 0.5;
        return this.centroid;
    }

    void translate(BoundingBox boundingBox, Vector3d vector3d) {
        if (boundingBox == null || boundingBox.boundsIsEmpty) {
            this.setLower(1.0, 1.0, 1.0);
            this.setUpper(-1.0, -1.0, -1.0);
            return;
        }
        if (boundingBox.boundsIsInfinite) {
            this.set(boundingBox);
            return;
        }
        this.lower.x = boundingBox.lower.x + vector3d.x;
        this.lower.y = boundingBox.lower.y + vector3d.y;
        this.lower.z = boundingBox.lower.z + vector3d.z;
        this.upper.x = boundingBox.upper.x + vector3d.x;
        this.upper.y = boundingBox.upper.y + vector3d.y;
        this.upper.z = boundingBox.upper.z + vector3d.z;
    }

    Bounds copy(Bounds bounds) {
        if (bounds != null && this.boundId == bounds.boundId) {
            BoundingBox boundingBox = (BoundingBox)bounds;
            boundingBox.lower.x = this.lower.x;
            boundingBox.lower.y = this.lower.y;
            boundingBox.lower.z = this.lower.z;
            boundingBox.upper.x = this.upper.x;
            boundingBox.upper.y = this.upper.y;
            boundingBox.upper.z = this.upper.z;
            boundingBox.boundsIsEmpty = this.boundsIsEmpty;
            boundingBox.boundsIsInfinite = this.boundsIsInfinite;
            return boundingBox;
        }
        return (Bounds)this.clone();
    }

    boolean checkBoundsIsNaN() {
        return Double.isNaN(this.lower.x + this.lower.y + this.lower.z + this.upper.x + this.upper.y + this.upper.z);
    }

    int getPickType() {
        return 6;
    }
}

