import * as lsp from 'vscode-languageserver';
import { LspDocuments } from './document.js';
import { tsp, SupportedFeatures } from './ts-protocol.js';
export declare function uriToPath(stringUri: string): string | undefined;
export declare function pathToUri(filepath: string, documents: LspDocuments | undefined): string;
/**
 * Normalizes the file system path.
 *
 * On systems other than Windows it should be an no-op.
 *
 * On Windows, an input path in a format like "C:/path/file.ts"
 * will be normalized to "c:/path/file.ts".
 */
export declare function normalizePath(filePath: string): string;
/**
 * Normalizes the path obtained through the "fsPath" property of the URI module.
 */
export declare function normalizeFsPath(fsPath: string): string;
export declare function toLocation(fileSpan: tsp.FileSpan, documents: LspDocuments | undefined): lsp.Location;
export declare function toSymbolKind(tspKind: string): lsp.SymbolKind;
export declare function toDiagnostic(diagnostic: tsp.Diagnostic, documents: LspDocuments | undefined, features: SupportedFeatures): lsp.Diagnostic;
export declare function toTextEdit(edit: tsp.CodeEdit): lsp.TextEdit;
export declare function toTextDocumentEdit(change: tsp.FileCodeEdits, documents: LspDocuments | undefined): lsp.TextDocumentEdit;
export declare function toDocumentHighlight(item: tsp.DocumentHighlightsItem): lsp.DocumentHighlight[];
//# sourceMappingURL=protocol-translation.d.ts.map