import type { tsp } from '../ts-protocol.js';
import { Logger } from '../utils/logger.js';
export declare enum Trace {
    Off = 0,
    Messages = 1,
    Verbose = 2
}
export type TraceValue = 'off' | 'messages' | 'verbose';
export declare namespace Trace {
    function fromString(value: string): Trace;
}
interface RequestExecutionMetadata {
    readonly queuingStartTime: number;
}
export default class Tracer {
    private readonly logger;
    private readonly trace;
    constructor(logger: Logger, trace: Trace);
    traceRequest(serverId: string, request: tsp.Request, responseExpected: boolean, queueLength: number): void;
    traceResponse(serverId: string, response: tsp.Response, meta: RequestExecutionMetadata): void;
    traceRequestCompleted(serverId: string, command: string, request_seq: number, meta: RequestExecutionMetadata): any;
    traceEvent(serverId: string, event: tsp.Event): void;
    logTrace(serverId: string, message: string, data?: any): void;
}
export {};
//# sourceMappingURL=tracer.d.ts.map