
// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyfalkon_python.h"

// main header
#include "plugins_plugin_wrapper.h"

// inner classes

// Extra includes
#include <plugins.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_Plugins_Plugin_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::Plugins::Plugin >()))
        return -1;

    ::Plugins::Plugin *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.Plugins.Plugin.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "Plugin", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: Plugin::Plugin()
    // 1: Plugin::Plugin(Plugins::Plugin)
    if (numArgs == 0) {
        overloadId = 0; // Plugin()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PLUGINS_PLUGIN_IDX]), (pyArgs[0])))) {
        overloadId = 1; // Plugin(Plugins::Plugin)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_Plugins_Plugin_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // Plugin()
        {

            if (!PyErr_Occurred()) {
                // Plugin()
                cptr = new ::Plugins::Plugin();
            }
            break;
        }
        case 1: // Plugin(const Plugins::Plugin & Plugin)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::Plugins::Plugin cppArg0_local;
            ::Plugins::Plugin *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PLUGINS_PLUGIN_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // Plugin(Plugins::Plugin)
                cptr = new ::Plugins::Plugin(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::Plugins::Plugin >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_Plugins_Plugin_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_Plugins_Plugin_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_Plugins_PluginFunc_isLoaded(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Plugins::Plugin *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINS_PLUGIN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.Plugins.Plugin.isLoaded";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isLoaded()const
            bool cppResult = const_cast<const ::Plugins::Plugin *>(cppSelf)->isLoaded();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Plugins_PluginFunc_isRemovable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::Plugins::Plugin *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINS_PLUGIN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.Plugins.Plugin.isRemovable";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isRemovable()const
            bool cppResult = const_cast<const ::Plugins::Plugin *>(cppSelf)->isRemovable();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_Plugins_Plugin___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::Plugins::Plugin *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINS_PLUGIN_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PLUGINS_PLUGIN_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_Plugins_Plugin_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_Plugins_Plugin_methods[] = {
    {"isLoaded", reinterpret_cast<PyCFunction>(Sbk_Plugins_PluginFunc_isLoaded), METH_NOARGS},
    {"isRemovable", reinterpret_cast<PyCFunction>(Sbk_Plugins_PluginFunc_isRemovable), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_Plugins_Plugin___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_Plugins_Plugin_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::Plugins::Plugin *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINS_PLUGIN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PLUGINS_PLUGIN_IDX]), (pyArg)))) {
                // operator==(const Plugins::Plugin & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::Plugins::Plugin cppArg0_local;
                ::Plugins::Plugin *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PLUGINS_PLUGIN_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_Plugins_Plugin_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_Plugins_Plugin_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

static PyObject *Sbk_Plugins_Plugin_get_type(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::Plugins::Plugin *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINS_PLUGIN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    ::Plugins::Plugin::Type cppOut_local = cppSelf->type;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPyFalkonTypes[SBK_PLUGINS_PLUGIN_TYPE_IDX])->converter, &cppOut_local);
    return pyOut;
}
static int Sbk_Plugins_Plugin_set_type(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::Plugins::Plugin *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINS_PLUGIN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'type' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPyFalkonTypes[SBK_PLUGINS_PLUGIN_TYPE_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'type', 'Type' or convertible type expected");
        return -1;
    }

    ::Plugins::Plugin::Type cppOut_local = cppSelf->type;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->type = cppOut_local;

    return 0;
}

static PyObject *Sbk_Plugins_Plugin_get_pluginId(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::Plugins::Plugin *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINS_PLUGIN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppSelf->pluginId);
    return pyOut;
}
static int Sbk_Plugins_Plugin_set_pluginId(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::Plugins::Plugin *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINS_PLUGIN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'pluginId' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'pluginId', 'QString' or convertible type expected");
        return -1;
    }

    ::QString& cppOut_ptr = cppSelf->pluginId;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_Plugins_Plugin_get_pluginPath(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::Plugins::Plugin *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINS_PLUGIN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppSelf->pluginPath);
    return pyOut;
}
static int Sbk_Plugins_Plugin_set_pluginPath(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::Plugins::Plugin *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINS_PLUGIN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'pluginPath' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'pluginPath', 'QString' or convertible type expected");
        return -1;
    }

    ::QString& cppOut_ptr = cppSelf->pluginPath;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_Plugins_Plugin_get_pluginSpec(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::Plugins::Plugin *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINS_PLUGIN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    if (reinterpret_cast<void *>(&(cppSelf->pluginSpec)) == reinterpret_cast<void *>(cppSelf)) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::Object::findColocatedChild(reinterpret_cast<SbkObject *>(self), reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PLUGINSPEC_IDX])));
        if (pyOut) {
            Py_IncRef(pyOut);
            return pyOut;
        }
    } else if (Shiboken::BindingManager::instance().hasWrapper(&(cppSelf->pluginSpec))) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->pluginSpec)));
        Py_IncRef(pyOut);
        return pyOut;
    }
    pyOut = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PLUGINSPEC_IDX]), &(cppSelf->pluginSpec), false, true);
    Shiboken::Object::setParent(self, pyOut);
    return pyOut;
}
static int Sbk_Plugins_Plugin_set_pluginSpec(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::Plugins::Plugin *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINS_PLUGIN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'pluginSpec' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PLUGINSPEC_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'pluginSpec', 'PluginSpec' or convertible type expected");
        return -1;
    }

    ::PluginSpec& cppOut_ptr = cppSelf->pluginSpec;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_Plugins_Plugin_get_instance(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::Plugins::Plugin *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINS_PLUGIN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PLUGININTERFACE_IDX]), cppSelf->instance);
    return pyOut;
}
static int Sbk_Plugins_Plugin_set_instance(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::Plugins::Plugin *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINS_PLUGIN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'instance' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PLUGININTERFACE_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'instance', 'PluginInterface' or convertible type expected");
        return -1;
    }

    ::PluginInterface *& cppOut_ptr = cppSelf->instance;
    pythonToCpp(pyIn, &cppOut_ptr);

    Shiboken::Object::keepReference(reinterpret_cast<SbkObject *>(self), "instance", pyIn);
    return 0;
}

static PyObject *Sbk_Plugins_Plugin_get_internalInstance(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::Plugins::Plugin *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINS_PLUGIN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PLUGININTERFACE_IDX]), cppSelf->internalInstance);
    return pyOut;
}
static int Sbk_Plugins_Plugin_set_internalInstance(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::Plugins::Plugin *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINS_PLUGIN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'internalInstance' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PLUGININTERFACE_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'internalInstance', 'PluginInterface' or convertible type expected");
        return -1;
    }

    ::PluginInterface *& cppOut_ptr = cppSelf->internalInstance;
    pythonToCpp(pyIn, &cppOut_ptr);

    Shiboken::Object::keepReference(reinterpret_cast<SbkObject *>(self), "internalInstance", pyIn);
    return 0;
}

static PyObject *Sbk_Plugins_Plugin_get_pluginLoader(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::Plugins::Plugin *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINS_PLUGIN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPLUGINLOADER_IDX]), cppSelf->pluginLoader);
    return pyOut;
}
static int Sbk_Plugins_Plugin_set_pluginLoader(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::Plugins::Plugin *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINS_PLUGIN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'pluginLoader' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPLUGINLOADER_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'pluginLoader', 'QPluginLoader' or convertible type expected");
        return -1;
    }

    ::QPluginLoader *& cppOut_ptr = cppSelf->pluginLoader;
    pythonToCpp(pyIn, &cppOut_ptr);

    Shiboken::Object::keepReference(reinterpret_cast<SbkObject *>(self), "pluginLoader", pyIn);
    return 0;
}

static PyObject *Sbk_Plugins_Plugin_get_data(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::Plugins::Plugin *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINS_PLUGIN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppSelf->data);
    return pyOut;
}
static int Sbk_Plugins_Plugin_set_data(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::Plugins::Plugin *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINS_PLUGIN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'data' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'data', 'QVariant' or convertible type expected");
        return -1;
    }

    ::QVariant& cppOut_ptr = cppSelf->data;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

// Getters and Setters for Plugin
static PyGetSetDef Sbk_Plugins_Plugin_getsetlist[] = {
    {const_cast<char *>("type"), Sbk_Plugins_Plugin_get_type, Sbk_Plugins_Plugin_set_type},
    {const_cast<char *>("pluginId"), Sbk_Plugins_Plugin_get_pluginId, Sbk_Plugins_Plugin_set_pluginId},
    {const_cast<char *>("pluginPath"), Sbk_Plugins_Plugin_get_pluginPath, Sbk_Plugins_Plugin_set_pluginPath},
    {const_cast<char *>("pluginSpec"), Sbk_Plugins_Plugin_get_pluginSpec, Sbk_Plugins_Plugin_set_pluginSpec},
    {const_cast<char *>("instance"), Sbk_Plugins_Plugin_get_instance, Sbk_Plugins_Plugin_set_instance},
    {const_cast<char *>("internalInstance"), Sbk_Plugins_Plugin_get_internalInstance, Sbk_Plugins_Plugin_set_internalInstance},
    {const_cast<char *>("pluginLoader"), Sbk_Plugins_Plugin_get_pluginLoader, Sbk_Plugins_Plugin_set_pluginLoader},
    {const_cast<char *>("data"), Sbk_Plugins_Plugin_get_data, Sbk_Plugins_Plugin_set_data},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_Plugins_Plugin_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_Plugins_Plugin_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_Plugins_Plugin_Type = nullptr;
static SbkObjectType *Sbk_Plugins_Plugin_TypeF(void)
{
    return _Sbk_Plugins_Plugin_Type;
}

static PyType_Slot Sbk_Plugins_Plugin_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_Plugins_Plugin_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_Plugins_Plugin_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_Plugins_Plugin_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_Plugins_Plugin_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_Plugins_Plugin_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_Plugins_Plugin_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_Plugins_Plugin_spec = {
    "1:PyFalkon.Plugins.Plugin",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_Plugins_Plugin_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void Plugins_Plugin_Type_PythonToCpp_Plugins_Plugin_Type(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Plugins::Plugin::Type *>(cppOut) =
        static_cast<::Plugins::Plugin::Type>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_Plugins_Plugin_Type_PythonToCpp_Plugins_Plugin_Type_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPyFalkonTypes[SBK_PLUGINS_PLUGIN_TYPE_IDX]))
        return Plugins_Plugin_Type_PythonToCpp_Plugins_Plugin_Type;
    return {};
}
static PyObject *Plugins_Plugin_Type_CppToPython_Plugins_Plugin_Type(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::Plugins::Plugin::Type *>(cppIn));
    return Shiboken::Enum::newItem(SbkPyFalkonTypes[SBK_PLUGINS_PLUGIN_TYPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void Plugin_PythonToCpp_Plugin_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_Plugins_Plugin_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_Plugin_PythonToCpp_Plugin_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_Plugins_Plugin_TypeF())))
        return Plugin_PythonToCpp_Plugin_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *Plugin_PTR_CppToPython_Plugin(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::Plugins::Plugin *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_Plugins_Plugin_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *Plugin_COPY_CppToPython_Plugin(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_Plugins_Plugin_TypeF(), new ::Plugins::Plugin(*reinterpret_cast<const ::Plugins::Plugin *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void Plugin_PythonToCpp_Plugin_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::Plugins::Plugin *>(cppOut) = *reinterpret_cast< ::Plugins::Plugin *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PLUGINS_PLUGIN_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_Plugin_PythonToCpp_Plugin_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_Plugins_Plugin_TypeF())))
        return Plugin_PythonToCpp_Plugin_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *Plugins_Plugin_SignatureStrings[] = {
    "1:PyFalkon.Plugins.Plugin(self)",
    "0:PyFalkon.Plugins.Plugin(self,Plugin:PyFalkon.Plugins.Plugin)",
    "PyFalkon.Plugins.Plugin.isLoaded(self)->bool",
    "PyFalkon.Plugins.Plugin.isRemovable(self)->bool",
    "PyFalkon.Plugins.Plugin.__copy__()",
    nullptr}; // Sentinel

void init_Plugins_Plugin(PyObject *enclosingClass)
{
    _Sbk_Plugins_Plugin_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "Plugin",
        "Plugins::Plugin",
        &Sbk_Plugins_Plugin_spec,
        &Shiboken::callCppDestructor< ::Plugins::Plugin >,
        0,
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_Plugins_Plugin_Type);
    InitSignatureStrings(pyType, Plugins_Plugin_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_Plugins_Plugin_Type), Sbk_Plugins_Plugin_PropertyStrings);
    SbkPyFalkonTypes[SBK_PLUGINS_PLUGIN_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_Plugins_Plugin_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_Plugins_Plugin_TypeF(),
        Plugin_PythonToCpp_Plugin_PTR,
        is_Plugin_PythonToCpp_Plugin_PTR_Convertible,
        Plugin_PTR_CppToPython_Plugin,
        Plugin_COPY_CppToPython_Plugin);

    Shiboken::Conversions::registerConverterName(converter, "Plugins::Plugin");
    Shiboken::Conversions::registerConverterName(converter, "Plugins::Plugin*");
    Shiboken::Conversions::registerConverterName(converter, "Plugins::Plugin&");
    Shiboken::Conversions::registerConverterName(converter, "Plugin");
    Shiboken::Conversions::registerConverterName(converter, "Plugin*");
    Shiboken::Conversions::registerConverterName(converter, "Plugin&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::Plugins::Plugin).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        Plugin_PythonToCpp_Plugin_COPY,
        is_Plugin_PythonToCpp_Plugin_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'Type'.
    SbkPyFalkonTypes[SBK_PLUGINS_PLUGIN_TYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_Plugins_Plugin_TypeF(),
        "Type",
        "1:PyFalkon.Plugins.Plugin.Type",
        "Plugins::Plugin::Type");
    if (!SbkPyFalkonTypes[SBK_PLUGINS_PLUGIN_TYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPyFalkonTypes[SBK_PLUGINS_PLUGIN_TYPE_IDX],
        Sbk_Plugins_Plugin_TypeF(), "Invalid", (long) Plugins::Plugin::Type::Invalid))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPyFalkonTypes[SBK_PLUGINS_PLUGIN_TYPE_IDX],
        Sbk_Plugins_Plugin_TypeF(), "InternalPlugin", (long) Plugins::Plugin::Type::InternalPlugin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPyFalkonTypes[SBK_PLUGINS_PLUGIN_TYPE_IDX],
        Sbk_Plugins_Plugin_TypeF(), "SharedLibraryPlugin", (long) Plugins::Plugin::Type::SharedLibraryPlugin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPyFalkonTypes[SBK_PLUGINS_PLUGIN_TYPE_IDX],
        Sbk_Plugins_Plugin_TypeF(), "PythonPlugin", (long) Plugins::Plugin::Type::PythonPlugin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPyFalkonTypes[SBK_PLUGINS_PLUGIN_TYPE_IDX],
        Sbk_Plugins_Plugin_TypeF(), "QmlPlugin", (long) Plugins::Plugin::Type::QmlPlugin))
        return;
    // Register converter for enum 'Plugins::Plugin::Type'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPyFalkonTypes[SBK_PLUGINS_PLUGIN_TYPE_IDX],
            Plugins_Plugin_Type_CppToPython_Plugins_Plugin_Type);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Plugins_Plugin_Type_PythonToCpp_Plugins_Plugin_Type,
            is_Plugins_Plugin_Type_PythonToCpp_Plugins_Plugin_Type_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPyFalkonTypes[SBK_PLUGINS_PLUGIN_TYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "Plugins::Plugin::Type");
        Shiboken::Conversions::registerConverterName(converter, "Plugin::Type");
        Shiboken::Conversions::registerConverterName(converter, "Type");
    }
    // End of 'Type' enum.

    qRegisterMetaType< ::Plugins::Plugin >("Plugin");
    qRegisterMetaType< ::Plugins::Plugin >("Plugins::Plugin");
    qRegisterMetaType< ::Plugins::Plugin::Type >("Plugin::Type");
    qRegisterMetaType< ::Plugins::Plugin::Type >("Plugins::Plugin::Type");
}
