/* backend.c generated by valac 0.56.0, the Vala compiler
 * generated from backend.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 */

#include "folks/folks.h"
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>

enum  {
	FOLKS_BACKEND_0_PROPERTY,
	FOLKS_BACKEND_IS_PREPARED_PROPERTY,
	FOLKS_BACKEND_IS_QUIESCENT_PROPERTY,
	FOLKS_BACKEND_NAME_PROPERTY,
	FOLKS_BACKEND_PERSONA_STORES_PROPERTY,
	FOLKS_BACKEND_NUM_PROPERTIES
};
static GParamSpec* folks_backend_properties[FOLKS_BACKEND_NUM_PROPERTIES];
enum  {
	FOLKS_BACKEND_PERSONA_STORE_ADDED_SIGNAL,
	FOLKS_BACKEND_PERSONA_STORE_REMOVED_SIGNAL,
	FOLKS_BACKEND_NUM_SIGNALS
};
static guint folks_backend_signals[FOLKS_BACKEND_NUM_SIGNALS] = {0};

static gpointer folks_backend_parent_class = NULL;

static void folks_backend_real_disable_persona_store (FolksBackend* self,
                                               FolksPersonaStore* store);
static void folks_backend_real_enable_persona_store (FolksBackend* self,
                                              FolksPersonaStore* store);
static void folks_backend_real_set_persona_stores (FolksBackend* self,
                                            GeeSet* storeids);
static GObject * folks_backend_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties);
static void folks_backend_finalize (GObject * obj);
static GType folks_backend_get_type_once (void);
static void _vala_folks_backend_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);

/**
   * Disable a {@link PersonaStore}.
   *
   * If the given persona store is in this backend {@link Backend.persona_stores},
   * it will be removed, and we will disconnect from its signals.
   *
   * @param store the {@link PersonaStore} to disable.
   *
   * @since 0.9.0
   */
static void
folks_backend_real_disable_persona_store (FolksBackend* self,
                                          FolksPersonaStore* store)
{
	g_critical ("Type `%s' does not implement abstract method `folks_backend_disable_persona_store'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
folks_backend_disable_persona_store (FolksBackend* self,
                                     FolksPersonaStore* store)
{
	FolksBackendClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FOLKS_BACKEND_GET_CLASS (self);
	if (_klass_->disable_persona_store) {
		_klass_->disable_persona_store (self, store);
	}
}

/**
   * Enable a {@link PersonaStore}.
   *
   * If the given persona store is not already in this backend
   * {@link Backend.persona_stores}, it will be added to the backend and
   * {@link Backend.persona_stores} property notification will be emitted,
   * along with {@link Backend.persona_store_added}.
   *
   * @param store the {@link PersonaStore} to enable.
   *
   * @since 0.9.0
   */
static void
folks_backend_real_enable_persona_store (FolksBackend* self,
                                         FolksPersonaStore* store)
{
	g_critical ("Type `%s' does not implement abstract method `folks_backend_enable_persona_store'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
folks_backend_enable_persona_store (FolksBackend* self,
                                    FolksPersonaStore* store)
{
	FolksBackendClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FOLKS_BACKEND_GET_CLASS (self);
	if (_klass_->enable_persona_store) {
		_klass_->enable_persona_store (self, store);
	}
}

/**
   * Set the {@link PersonaStore}s to use in this backend.
   *
   * This will cause {@link Backend.persona_store_removed} signals to be emitted
   * for all removed stores, followed by {@link Backend.persona_store_added}
   * signals for all added stores. As these signals are emitted, the sets of
   * individuals in any associated {@link IndividualAggregator}s will be
   * updated, and {@link IndividualAggregator.individuals_changed} may be
   * emitted multiple times as appropriate. A property change notification for
   * {@link Backend.persona_stores} will be emitted last.
   * Note: pass null storeids to use all available persona stores.
   *
   * @param storeids a Set of {@link PersonaStore} IDs to use.
   *
   * @since 0.9.0
   */
static void
folks_backend_real_set_persona_stores (FolksBackend* self,
                                       GeeSet* storeids)
{
	g_critical ("Type `%s' does not implement abstract method `folks_backend_set_persona_stores'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
folks_backend_set_persona_stores (FolksBackend* self,
                                  GeeSet* storeids)
{
	FolksBackendClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FOLKS_BACKEND_GET_CLASS (self);
	if (_klass_->set_persona_stores) {
		_klass_->set_persona_stores (self, storeids);
	}
}

void
folks_backend_prepare (FolksBackend* self,
                       GAsyncReadyCallback _callback_,
                       gpointer _user_data_)
{
	FolksBackendClass* _klass_;
	_klass_ = FOLKS_BACKEND_GET_CLASS (self);
	if (_klass_->prepare) {
		_klass_->prepare (self, _callback_, _user_data_);
	}
}

void
folks_backend_prepare_finish (FolksBackend* self,
                              GAsyncResult* _res_,
                              GError** error)
{
	FolksBackendClass* _klass_;
	_klass_ = FOLKS_BACKEND_GET_CLASS (self);
	if (_klass_->prepare_finish) {
		_klass_->prepare_finish (self, _res_, error);
	}
}

void
folks_backend_unprepare (FolksBackend* self,
                         GAsyncReadyCallback _callback_,
                         gpointer _user_data_)
{
	FolksBackendClass* _klass_;
	_klass_ = FOLKS_BACKEND_GET_CLASS (self);
	if (_klass_->unprepare) {
		_klass_->unprepare (self, _callback_, _user_data_);
	}
}

void
folks_backend_unprepare_finish (FolksBackend* self,
                                GAsyncResult* _res_,
                                GError** error)
{
	FolksBackendClass* _klass_;
	_klass_ = FOLKS_BACKEND_GET_CLASS (self);
	if (_klass_->unprepare_finish) {
		_klass_->unprepare_finish (self, _res_, error);
	}
}

FolksBackend*
folks_backend_construct (GType object_type)
{
	FolksBackend * self = NULL;
	self = (FolksBackend*) g_object_new (object_type, NULL);
	return self;
}

gboolean
folks_backend_get_is_prepared (FolksBackend* self)
{
	FolksBackendClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = FOLKS_BACKEND_GET_CLASS (self);
	if (_klass_->get_is_prepared) {
		return _klass_->get_is_prepared (self);
	}
	return FALSE;
}

gboolean
folks_backend_get_is_quiescent (FolksBackend* self)
{
	FolksBackendClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = FOLKS_BACKEND_GET_CLASS (self);
	if (_klass_->get_is_quiescent) {
		return _klass_->get_is_quiescent (self);
	}
	return FALSE;
}

const gchar*
folks_backend_get_name (FolksBackend* self)
{
	FolksBackendClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = FOLKS_BACKEND_GET_CLASS (self);
	if (_klass_->get_name) {
		return _klass_->get_name (self);
	}
	return NULL;
}

GeeMap*
folks_backend_get_persona_stores (FolksBackend* self)
{
	FolksBackendClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = FOLKS_BACKEND_GET_CLASS (self);
	if (_klass_->get_persona_stores) {
		return _klass_->get_persona_stores (self);
	}
	return NULL;
}

static GObject *
folks_backend_constructor (GType type,
                           guint n_construct_properties,
                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FolksBackend * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	parent_class = G_OBJECT_CLASS (folks_backend_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_BACKEND, FolksBackend);
	_tmp0_ = folks_backend_get_name (self);
	_tmp1_ = _tmp0_;
	g_debug ("backend.vala:40: Constructing Backend ‘%s’ (%p)", _tmp1_, self);
	return obj;
}

static void
folks_backend_class_init (FolksBackendClass * klass,
                          gpointer klass_data)
{
	folks_backend_parent_class = g_type_class_peek_parent (klass);
	((FolksBackendClass *) klass)->disable_persona_store = (void (*) (FolksBackend*, FolksPersonaStore*)) folks_backend_real_disable_persona_store;
	((FolksBackendClass *) klass)->enable_persona_store = (void (*) (FolksBackend*, FolksPersonaStore*)) folks_backend_real_enable_persona_store;
	((FolksBackendClass *) klass)->set_persona_stores = (void (*) (FolksBackend*, GeeSet*)) folks_backend_real_set_persona_stores;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_backend_get_property;
	G_OBJECT_CLASS (klass)->constructor = folks_backend_constructor;
	G_OBJECT_CLASS (klass)->finalize = folks_backend_finalize;
	/**
	   * Whether {@link Backend.prepare} has successfully completed for this
	   * backend.
	   *
	   * @since 0.3.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKEND_IS_PREPARED_PROPERTY, folks_backend_properties[FOLKS_BACKEND_IS_PREPARED_PROPERTY] = g_param_spec_boolean ("is-prepared", "is-prepared", "is-prepared", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * Whether the backend has reached a quiescent state. This will happen at some
	   * point after {@link Backend.prepare} has successfully completed for the
	   * backend. A backend is in a quiescent state when all the
	   * {@link PersonaStore}s that it originally knows about have been loaded.
	   *
	   * It's guaranteed that this property's value will only ever change after
	   * {@link Backend.is_prepared} has changed to ``true``.
	   *
	   * When {@link Backend.unprepare} is called, this will be reset to ``false``.
	   *
	   * @since 0.6.2
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKEND_IS_QUIESCENT_PROPERTY, folks_backend_properties[FOLKS_BACKEND_IS_QUIESCENT_PROPERTY] = g_param_spec_boolean ("is-quiescent", "is-quiescent", "is-quiescent", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * A unique name for the backend.
	   *
	   * This will be used to identify the backend, and should also be used as the
	   * {@link PersonaStore.type_id} of the {@link PersonaStore}s used by the
	   * backend.
	   *
	   * This is guaranteed to always be available; even before
	   * {@link Backend.prepare} is called.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKEND_NAME_PROPERTY, folks_backend_properties[FOLKS_BACKEND_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * The {@link PersonaStore}s in use by the backend.
	   *
	   * A backend may expose {@link Persona}s from multiple servers or accounts
	   * (for example), so may have a {@link PersonaStore} for each.
	   *
	   * @since 0.5.1
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKEND_PERSONA_STORES_PROPERTY, folks_backend_properties[FOLKS_BACKEND_PERSONA_STORES_PROPERTY] = g_param_spec_object ("persona-stores", "persona-stores", "persona-stores", GEE_TYPE_MAP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * Emitted when a {@link PersonaStore} is added to the backend.
	   *
	   * This will not be emitted until after {@link Backend.prepare} has been
	   * called.
	   *
	   * @param store the {@link PersonaStore}
	   */
	folks_backend_signals[FOLKS_BACKEND_PERSONA_STORE_ADDED_SIGNAL] = g_signal_new ("persona-store-added", FOLKS_TYPE_BACKEND, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, FOLKS_TYPE_PERSONA_STORE);
	/**
	   * Emitted when a {@link PersonaStore} is removed from the backend.
	   *
	   * This will not be emitted until after {@link Backend.prepare} has been
	   * called.
	   *
	   * @param store the {@link PersonaStore}
	   */
	folks_backend_signals[FOLKS_BACKEND_PERSONA_STORE_REMOVED_SIGNAL] = g_signal_new ("persona-store-removed", FOLKS_TYPE_BACKEND, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, FOLKS_TYPE_PERSONA_STORE);
}

static void
folks_backend_instance_init (FolksBackend * self,
                             gpointer klass)
{
}

static void
folks_backend_finalize (GObject * obj)
{
	FolksBackend * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_BACKEND, FolksBackend);
	_tmp0_ = folks_backend_get_name (self);
	_tmp1_ = _tmp0_;
	g_debug ("backend.vala:45: Destroying Backend ‘%s’ (%p)", _tmp1_, self);
	G_OBJECT_CLASS (folks_backend_parent_class)->finalize (obj);
}

/**
 * A single backend to libfolks, such as Telepathy or evolution-data-server.
 * Each backend provides {@link Persona}s which are aggregated to form
 * {@link Individual}s.
 *
 * After creating a Backend instance, you must connect to the
 * {@link Backend.persona_store_added} and
 * {@link Backend.persona_store_removed} signals, //then// call
 * {@link Backend.prepare}, otherwise a race condition may occur between
 * emission of {@link Backend.persona_store_added} and your code connecting to
 * it.
 */
static GType
folks_backend_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksBackend), 0, (GInstanceInitFunc) folks_backend_instance_init, NULL };
	GType folks_backend_type_id;
	folks_backend_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksBackend", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return folks_backend_type_id;
}

GType
folks_backend_get_type (void)
{
	static volatile gsize folks_backend_type_id__once = 0;
	if (g_once_init_enter (&folks_backend_type_id__once)) {
		GType folks_backend_type_id;
		folks_backend_type_id = folks_backend_get_type_once ();
		g_once_init_leave (&folks_backend_type_id__once, folks_backend_type_id);
	}
	return folks_backend_type_id__once;
}

static void
_vala_folks_backend_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	FolksBackend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_BACKEND, FolksBackend);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

