/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.algorithms.implementations;

import com.sun.org.apache.xml.internal.security.algorithms.JCEMapper;
import com.sun.org.apache.xml.internal.security.algorithms.SignatureAlgorithmSpi;
import com.sun.org.apache.xml.internal.security.algorithms.implementations.ECDSAUtils;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureException;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.slf4j.internal.Logger;
import com.sun.org.slf4j.internal.LoggerFactory;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;

public abstract class SignatureECDSA
extends SignatureAlgorithmSpi {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureECDSA.class);
    private Signature signatureAlgorithm;

    @Override
    public abstract String engineGetURI();

    public static byte[] convertASN1toXMLDSIG(byte[] byArray) throws IOException {
        return ECDSAUtils.convertASN1toXMLDSIG(byArray);
    }

    public static byte[] convertXMLDSIGtoASN1(byte[] byArray) throws IOException {
        return ECDSAUtils.convertXMLDSIGtoASN1(byArray);
    }

    public SignatureECDSA() throws XMLSignatureException {
        String string = JCEMapper.translateURItoJCEID(this.engineGetURI());
        LOG.debug("Created SignatureECDSA using {}", string);
        String string2 = JCEMapper.getProviderId();
        try {
            this.signatureAlgorithm = string2 == null ? Signature.getInstance(string) : Signature.getInstance(string, string2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Object[] objectArray = new Object[]{string, noSuchAlgorithmException.getLocalizedMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            Object[] objectArray = new Object[]{string, noSuchProviderException.getLocalizedMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray);
        }
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        try {
            this.signatureAlgorithm.setParameter(algorithmParameterSpec);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new XMLSignatureException(invalidAlgorithmParameterException);
        }
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws XMLSignatureException {
        try {
            byte[] byArray2 = SignatureECDSA.convertXMLDSIGtoASN1(byArray);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Called ECDSA.verify() on " + XMLUtils.encodeToString(byArray));
            }
            return this.signatureAlgorithm.verify(byArray2);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException(signatureException);
        }
        catch (IOException iOException) {
            throw new XMLSignatureException(iOException);
        }
    }

    @Override
    protected void engineInitVerify(Key key) throws XMLSignatureException {
        if (!(key instanceof PublicKey)) {
            String string = null;
            if (key != null) {
                string = key.getClass().getName();
            }
            String string2 = PublicKey.class.getName();
            Object[] objectArray = new Object[]{string, string2};
            throw new XMLSignatureException("algorithms.WrongKeyForThisOperation", objectArray);
        }
        try {
            this.signatureAlgorithm.initVerify((PublicKey)key);
        }
        catch (InvalidKeyException invalidKeyException) {
            Signature signature = this.signatureAlgorithm;
            try {
                this.signatureAlgorithm = Signature.getInstance(this.signatureAlgorithm.getAlgorithm());
            }
            catch (Exception exception) {
                LOG.debug("Exception when reinstantiating Signature: {}", exception);
                this.signatureAlgorithm = signature;
            }
            throw new XMLSignatureException(invalidKeyException);
        }
    }

    @Override
    protected byte[] engineSign() throws XMLSignatureException {
        try {
            byte[] byArray = this.signatureAlgorithm.sign();
            return SignatureECDSA.convertASN1toXMLDSIG(byArray);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException(signatureException);
        }
        catch (IOException iOException) {
            throw new XMLSignatureException(iOException);
        }
    }

    @Override
    protected void engineInitSign(Key key, SecureRandom secureRandom) throws XMLSignatureException {
        if (!(key instanceof PrivateKey)) {
            String string = null;
            if (key != null) {
                string = key.getClass().getName();
            }
            String string2 = PrivateKey.class.getName();
            Object[] objectArray = new Object[]{string, string2};
            throw new XMLSignatureException("algorithms.WrongKeyForThisOperation", objectArray);
        }
        try {
            if (secureRandom == null) {
                this.signatureAlgorithm.initSign((PrivateKey)key);
            } else {
                this.signatureAlgorithm.initSign((PrivateKey)key, secureRandom);
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSignatureException(invalidKeyException);
        }
    }

    @Override
    protected void engineInitSign(Key key) throws XMLSignatureException {
        this.engineInitSign(key, (SecureRandom)null);
    }

    @Override
    protected void engineUpdate(byte[] byArray) throws XMLSignatureException {
        try {
            this.signatureAlgorithm.update(byArray);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException(signatureException);
        }
    }

    @Override
    protected void engineUpdate(byte by) throws XMLSignatureException {
        try {
            this.signatureAlgorithm.update(by);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException(signatureException);
        }
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) throws XMLSignatureException {
        try {
            this.signatureAlgorithm.update(byArray, n, n2);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException(signatureException);
        }
    }

    @Override
    protected String engineGetJCEAlgorithmString() {
        return this.signatureAlgorithm.getAlgorithm();
    }

    @Override
    protected String engineGetJCEProviderName() {
        return this.signatureAlgorithm.getProvider().getName();
    }

    @Override
    protected void engineSetHMACOutputLength(int n) throws XMLSignatureException {
        throw new XMLSignatureException("algorithms.HMACOutputLengthOnlyForHMAC");
    }

    @Override
    protected void engineInitSign(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        throw new XMLSignatureException("algorithms.CannotUseAlgorithmParameterSpecOnRSA");
    }

    public static class SignatureECDSARIPEMD160
    extends SignatureECDSA {
        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2007/05/xmldsig-more#ecdsa-ripemd160";
        }
    }

    public static class SignatureECDSASHA512
    extends SignatureECDSA {
        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512";
        }
    }

    public static class SignatureECDSASHA384
    extends SignatureECDSA {
        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384";
        }
    }

    public static class SignatureECDSASHA256
    extends SignatureECDSA {
        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256";
        }
    }

    public static class SignatureECDSASHA224
    extends SignatureECDSA {
        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha224";
        }
    }

    public static class SignatureECDSASHA1
    extends SignatureECDSA {
        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1";
        }
    }
}

