/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jakartaee.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.stream.Stream;
import org.apache.tomcat.jakartaee.bcel.classfile.Attribute;
import org.apache.tomcat.jakartaee.bcel.classfile.BootstrapMethod;
import org.apache.tomcat.jakartaee.bcel.classfile.ConstantPool;
import org.apache.tomcat.jakartaee.bcel.classfile.Visitor;

public class BootstrapMethods
extends Attribute
implements Iterable<BootstrapMethod> {
    private BootstrapMethod[] bootstrapMethods;

    public BootstrapMethods(BootstrapMethods c) {
        this(c.getNameIndex(), c.getLength(), c.getBootstrapMethods(), c.getConstantPool());
    }

    public BootstrapMethods(int name_index, int length, BootstrapMethod[] bootstrapMethods, ConstantPool constant_pool) {
        super((byte)20, name_index, length, constant_pool);
        this.bootstrapMethods = bootstrapMethods;
    }

    BootstrapMethods(int name_index, int length, DataInput input, ConstantPool constant_pool) throws IOException {
        this(name_index, length, (BootstrapMethod[])null, constant_pool);
        int num_bootstrap_methods = input.readUnsignedShort();
        this.bootstrapMethods = new BootstrapMethod[num_bootstrap_methods];
        for (int i = 0; i < num_bootstrap_methods; ++i) {
            this.bootstrapMethods[i] = new BootstrapMethod(input);
        }
    }

    @Override
    public void accept(Visitor v) {
        v.visitBootstrapMethods(this);
    }

    @Override
    public BootstrapMethods copy(ConstantPool constantPool) {
        BootstrapMethods c = (BootstrapMethods)this.clone();
        c.bootstrapMethods = new BootstrapMethod[this.bootstrapMethods.length];
        for (int i = 0; i < this.bootstrapMethods.length; ++i) {
            c.bootstrapMethods[i] = this.bootstrapMethods[i].copy();
        }
        c.setConstantPool(constantPool);
        return c;
    }

    @Override
    public final void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.bootstrapMethods.length);
        for (BootstrapMethod bootstrap_method : this.bootstrapMethods) {
            bootstrap_method.dump(file);
        }
    }

    public final BootstrapMethod[] getBootstrapMethods() {
        return this.bootstrapMethods;
    }

    @Override
    public Iterator<BootstrapMethod> iterator() {
        return Stream.of(this.bootstrapMethods).iterator();
    }

    public final void setBootstrapMethods(BootstrapMethod[] bootstrapMethods) {
        this.bootstrapMethods = bootstrapMethods;
    }

    @Override
    public final String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("BootstrapMethods(");
        buf.append(this.bootstrapMethods.length);
        buf.append("):");
        for (int i = 0; i < this.bootstrapMethods.length; ++i) {
            buf.append("\n");
            int start = buf.length();
            buf.append("  ").append(i).append(": ");
            int indent_count = buf.length() - start;
            String[] lines = this.bootstrapMethods[i].toString(super.getConstantPool()).split("\\r?\\n");
            buf.append(lines[0]);
            for (int j = 1; j < lines.length; ++j) {
                buf.append("\n").append("          ", 0, indent_count).append(lines[j]);
            }
        }
        return buf.toString();
    }
}

