/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;

public class StringCache {
    private static final Log log = LogFactory.getLog(StringCache.class);
    protected static boolean byteEnabled = "true".equals(System.getProperty("tomcat.util.buf.StringCache.byte.enabled", "false"));
    protected static boolean charEnabled = "true".equals(System.getProperty("tomcat.util.buf.StringCache.char.enabled", "false"));
    protected static int trainThreshold = Integer.parseInt(System.getProperty("tomcat.util.buf.StringCache.trainThreshold", "20000"));
    protected static int cacheSize = Integer.parseInt(System.getProperty("tomcat.util.buf.StringCache.cacheSize", "200"));
    protected static final int maxStringSize = Integer.parseInt(System.getProperty("tomcat.util.buf.StringCache.maxStringSize", "128"));
    protected static final HashMap<ByteEntry, int[]> bcStats = new HashMap(cacheSize);
    protected static int bcCount = 0;
    protected static volatile ByteEntry[] bcCache = null;
    protected static final HashMap<CharEntry, int[]> ccStats = new HashMap(cacheSize);
    protected static int ccCount = 0;
    protected static volatile CharEntry[] ccCache = null;
    protected static int accessCount = 0;
    protected static int hitCount = 0;

    public int getCacheSize() {
        return cacheSize;
    }

    public void setCacheSize(int n) {
        cacheSize = n;
    }

    public boolean getByteEnabled() {
        return byteEnabled;
    }

    public void setByteEnabled(boolean bl) {
        byteEnabled = bl;
    }

    public boolean getCharEnabled() {
        return charEnabled;
    }

    public void setCharEnabled(boolean bl) {
        charEnabled = bl;
    }

    public int getTrainThreshold() {
        return trainThreshold;
    }

    public void setTrainThreshold(int n) {
        trainThreshold = n;
    }

    public int getAccessCount() {
        return accessCount;
    }

    public int getHitCount() {
        return hitCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        hitCount = 0;
        accessCount = 0;
        HashMap<Object, int[]> hashMap = bcStats;
        synchronized (hashMap) {
            bcCache = null;
            bcCount = 0;
        }
        hashMap = ccStats;
        synchronized (hashMap) {
            ccCache = null;
            ccCount = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(ByteChunk byteChunk) {
        if (bcCache == null) {
            String string = byteChunk.toStringInternal();
            if (byteEnabled && string.length() < maxStringSize) {
                HashMap<ByteEntry, int[]> hashMap = bcStats;
                synchronized (hashMap) {
                    if (bcCache != null) {
                        return string;
                    }
                    if (bcCount > trainThreshold) {
                        Integer l2;
                        Object object;
                        long l = System.currentTimeMillis();
                        TreeMap<Integer, ArrayList> treeMap = new TreeMap<Integer, ArrayList>();
                        for (Map.Entry<ByteEntry, int[]> byteEntryArray2 : bcStats.entrySet()) {
                            object = byteEntryArray2.getKey();
                            int[] n4 = byteEntryArray2.getValue();
                            l2 = n4[0];
                            treeMap.computeIfAbsent(l2, n -> new ArrayList()).add(object);
                        }
                        int n3 = bcStats.size();
                        if (n3 > cacheSize) {
                            n3 = cacheSize;
                        }
                        ByteEntry[] byteEntryArray = new ByteEntry[n3];
                        object = new ByteChunk();
                        int n2 = 0;
                        while (n2 < n3) {
                            l2 = treeMap.lastKey();
                            ArrayList arrayList = (ArrayList)treeMap.get(l2);
                            for (int i = 0; i < arrayList.size() && n2 < n3; ++n2, ++i) {
                                ByteEntry byteEntry = (ByteEntry)arrayList.get(i);
                                ((ByteChunk)object).setBytes(byteEntry.name, 0, byteEntry.name.length);
                                int n4 = StringCache.findClosest((ByteChunk)object, byteEntryArray, n2);
                                if (n4 == n2) {
                                    byteEntryArray[n2 + 1] = byteEntry;
                                    continue;
                                }
                                System.arraycopy(byteEntryArray, n4 + 1, byteEntryArray, n4 + 2, n2 - n4 - 1);
                                byteEntryArray[n4 + 1] = byteEntry;
                            }
                            treeMap.remove(l2);
                        }
                        bcCount = 0;
                        bcStats.clear();
                        bcCache = byteEntryArray;
                        if (log.isDebugEnabled()) {
                            long l3 = System.currentTimeMillis();
                            log.debug((Object)("ByteCache generation time: " + (l3 - l) + "ms"));
                        }
                    } else {
                        ++bcCount;
                        ByteEntry byteEntry = new ByteEntry();
                        byteEntry.value = string;
                        int[] nArray = bcStats.get(byteEntry);
                        if (nArray == null) {
                            int n6 = byteChunk.getEnd();
                            int n7 = byteChunk.getStart();
                            ByteEntry.access$002(byteEntry, new byte[byteChunk.getLength()]);
                            System.arraycopy(byteChunk.getBuffer(), n7, byteEntry.name, 0, n6 - n7);
                            byteEntry.charset = byteChunk.getCharset();
                            nArray = new int[]{1};
                            bcStats.put(byteEntry, nArray);
                        } else {
                            nArray[0] = nArray[0] + 1;
                        }
                    }
                }
            }
            return string;
        }
        ++accessCount;
        String string = StringCache.find(byteChunk);
        if (string == null) {
            return byteChunk.toStringInternal();
        }
        ++hitCount;
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(CharChunk charChunk) {
        if (ccCache == null) {
            String string = charChunk.toStringInternal();
            if (charEnabled && string.length() < maxStringSize) {
                HashMap<CharEntry, int[]> hashMap = ccStats;
                synchronized (hashMap) {
                    if (ccCache != null) {
                        return string;
                    }
                    if (ccCount > trainThreshold) {
                        ArrayList arrayList;
                        Integer l2;
                        Object object;
                        long l = System.currentTimeMillis();
                        TreeMap<Integer, ArrayList> treeMap = new TreeMap<Integer, ArrayList>();
                        for (Map.Entry<CharEntry, int[]> charEntryArray2 : ccStats.entrySet()) {
                            object = charEntryArray2.getKey();
                            int[] n4 = charEntryArray2.getValue();
                            l2 = n4[0];
                            arrayList = treeMap.computeIfAbsent(l2, n -> new ArrayList());
                            arrayList.add(object);
                        }
                        int n3 = ccStats.size();
                        if (n3 > cacheSize) {
                            n3 = cacheSize;
                        }
                        CharEntry[] charEntryArray = new CharEntry[n3];
                        object = new CharChunk();
                        int n2 = 0;
                        while (n2 < n3) {
                            l2 = treeMap.lastKey();
                            arrayList = (ArrayList)treeMap.get(l2);
                            for (int i = 0; i < arrayList.size() && n2 < n3; ++n2, ++i) {
                                CharEntry charEntry = (CharEntry)arrayList.get(i);
                                ((CharChunk)object).setChars(charEntry.name, 0, charEntry.name.length);
                                int n4 = StringCache.findClosest((CharChunk)object, charEntryArray, n2);
                                if (n4 == n2) {
                                    charEntryArray[n2 + 1] = charEntry;
                                    continue;
                                }
                                System.arraycopy(charEntryArray, n4 + 1, charEntryArray, n4 + 2, n2 - n4 - 1);
                                charEntryArray[n4 + 1] = charEntry;
                            }
                            treeMap.remove(l2);
                        }
                        ccCount = 0;
                        ccStats.clear();
                        ccCache = charEntryArray;
                        if (log.isDebugEnabled()) {
                            long l3 = System.currentTimeMillis();
                            log.debug((Object)("CharCache generation time: " + (l3 - l) + "ms"));
                        }
                    } else {
                        ++ccCount;
                        CharEntry charEntry = new CharEntry();
                        charEntry.value = string;
                        int[] nArray = ccStats.get(charEntry);
                        if (nArray == null) {
                            int n6 = charChunk.getEnd();
                            int n7 = charChunk.getStart();
                            CharEntry.access$402(charEntry, new char[charChunk.getLength()]);
                            System.arraycopy(charChunk.getBuffer(), n7, charEntry.name, 0, n6 - n7);
                            nArray = new int[]{1};
                            ccStats.put(charEntry, nArray);
                        } else {
                            nArray[0] = nArray[0] + 1;
                        }
                    }
                }
            }
            return string;
        }
        ++accessCount;
        String string = StringCache.find(charChunk);
        if (string == null) {
            return charChunk.toStringInternal();
        }
        ++hitCount;
        return string;
    }

    protected static final int compare(ByteChunk byteChunk, byte[] byArray) {
        int n;
        int n2 = 0;
        byte[] byArray2 = byteChunk.getBuffer();
        int n3 = byteChunk.getStart();
        int n4 = byteChunk.getEnd();
        if (n4 - n3 < (n = byArray.length)) {
            n = n4 - n3;
        }
        for (int i = 0; i < n && n2 == 0; ++i) {
            if (byArray2[i + n3] > byArray[i]) {
                n2 = 1;
                continue;
            }
            if (byArray2[i + n3] >= byArray[i]) continue;
            n2 = -1;
        }
        if (n2 == 0) {
            if (byArray.length > n4 - n3) {
                n2 = -1;
            } else if (byArray.length < n4 - n3) {
                n2 = 1;
            }
        }
        return n2;
    }

    protected static final String find(ByteChunk byteChunk) {
        int n = StringCache.findClosest(byteChunk, bcCache, bcCache.length);
        if (n < 0 || StringCache.compare(byteChunk, bcCache[n].name) != 0 || !byteChunk.getCharset().equals(bcCache[n].charset)) {
            return null;
        }
        return bcCache[n].value;
    }

    protected static final int findClosest(ByteChunk byteChunk, ByteEntry[] byteEntryArray, int n) {
        int n2 = 0;
        int n3 = n - 1;
        if (n3 == -1) {
            return -1;
        }
        if (StringCache.compare(byteChunk, byteEntryArray[0].name) < 0) {
            return -1;
        }
        if (n3 == 0) {
            return 0;
        }
        int n4 = 0;
        do {
            int n5;
            if ((n5 = StringCache.compare(byteChunk, byteEntryArray[n4 = n3 + n2 >>> 1].name)) == 1) {
                n2 = n4;
                continue;
            }
            if (n5 == 0) {
                return n4;
            }
            n3 = n4;
        } while (n3 - n2 != 1);
        int n6 = StringCache.compare(byteChunk, byteEntryArray[n3].name);
        if (n6 < 0) {
            return n2;
        }
        return n3;
    }

    protected static final int compare(CharChunk charChunk, char[] cArray) {
        int n;
        int n2 = 0;
        char[] cArray2 = charChunk.getBuffer();
        int n3 = charChunk.getStart();
        int n4 = charChunk.getEnd();
        if (n4 - n3 < (n = cArray.length)) {
            n = n4 - n3;
        }
        for (int i = 0; i < n && n2 == 0; ++i) {
            if (cArray2[i + n3] > cArray[i]) {
                n2 = 1;
                continue;
            }
            if (cArray2[i + n3] >= cArray[i]) continue;
            n2 = -1;
        }
        if (n2 == 0) {
            if (cArray.length > n4 - n3) {
                n2 = -1;
            } else if (cArray.length < n4 - n3) {
                n2 = 1;
            }
        }
        return n2;
    }

    protected static final String find(CharChunk charChunk) {
        int n = StringCache.findClosest(charChunk, ccCache, ccCache.length);
        if (n < 0 || StringCache.compare(charChunk, ccCache[n].name) != 0) {
            return null;
        }
        return ccCache[n].value;
    }

    protected static final int findClosest(CharChunk charChunk, CharEntry[] charEntryArray, int n) {
        int n2 = 0;
        int n3 = n - 1;
        if (n3 == -1) {
            return -1;
        }
        if (StringCache.compare(charChunk, charEntryArray[0].name) < 0) {
            return -1;
        }
        if (n3 == 0) {
            return 0;
        }
        int n4 = 0;
        do {
            int n5;
            if ((n5 = StringCache.compare(charChunk, charEntryArray[n4 = n3 + n2 >>> 1].name)) == 1) {
                n2 = n4;
                continue;
            }
            if (n5 == 0) {
                return n4;
            }
            n3 = n4;
        } while (n3 - n2 != 1);
        int n6 = StringCache.compare(charChunk, charEntryArray[n3].name);
        if (n6 < 0) {
            return n2;
        }
        return n3;
    }

    private static class CharEntry {
        private char[] name = null;
        private String value = null;

        private CharEntry() {
        }

        public String toString() {
            return this.value;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof CharEntry) {
                return this.value.equals(((CharEntry)object).value);
            }
            return false;
        }

        static /* synthetic */ char[] access$402(CharEntry charEntry, char[] cArray) {
            charEntry.name = cArray;
            return cArray;
        }
    }

    private static class ByteEntry {
        private byte[] name = null;
        private Charset charset = null;
        private String value = null;

        private ByteEntry() {
        }

        public String toString() {
            return this.value;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof ByteEntry) {
                return this.value.equals(((ByteEntry)object).value);
            }
            return false;
        }

        static /* synthetic */ byte[] access$002(ByteEntry byteEntry, byte[] byArray) {
            byteEntry.name = byArray;
            return byArray;
        }
    }
}

