/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.io;

import java.io.PrintWriter;
import org.netbeans.spi.io.InputOutputProvider;

public abstract class Fold {
    static final Fold UNSUPPORTED = new Fold(){

        @Override
        public void setExpanded(boolean bl) {
        }

        @Override
        void endFold() {
        }
    };

    private Fold() {
    }

    static <IO, OW extends PrintWriter, P, F> Fold create(InputOutputProvider<IO, OW, P, F> inputOutputProvider, IO IO, OW OW, F f) {
        if (f == null) {
            return UNSUPPORTED;
        }
        return new Impl<IO, OW, P, F>(inputOutputProvider, IO, OW, f);
    }

    public abstract void setExpanded(boolean var1);

    abstract void endFold();

    public final void expand() {
        this.setExpanded(true);
    }

    public final void collapse() {
        this.setExpanded(false);
    }

    private static class Impl<IO, OW extends PrintWriter, P, F>
    extends Fold {
        private final InputOutputProvider<IO, OW, P, F> provider;
        private final IO io;
        private final OW writer;
        private final F fold;

        public Impl(InputOutputProvider<IO, OW, P, F> inputOutputProvider, IO IO, OW OW, F f) {
            this.provider = inputOutputProvider;
            this.io = IO;
            this.writer = OW;
            this.fold = f;
        }

        @Override
        public void setExpanded(boolean bl) {
            this.provider.setFoldExpanded(this.io, this.writer, this.fold, bl);
        }

        @Override
        void endFold() {
            this.provider.endFold(this.io, this.writer, this.fold);
        }
    }
}

