/* sudoku-window.c generated by valac 0.56.3, the Vala compiler
 * generated from sudoku-window.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014, 2020 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include "libsudoku.h"
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>

#define SUDOKU_WINDOW_board_size 140
#define SUDOKU_WINDOW_clock_in_headerbar_min_width 450
#define SUDOKU_WINDOW_tiled_state ((((GDK_WINDOW_STATE_TILED | GDK_WINDOW_STATE_TOP_TILED) | GDK_WINDOW_STATE_BOTTOM_TILED) | GDK_WINDOW_STATE_LEFT_TILED) | GDK_WINDOW_STATE_RIGHT_TILED)
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SUDOKU_WINDOW (sudoku_window_get_type ())
#define SUDOKU_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_WINDOW, SudokuWindow))
#define SUDOKU_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_WINDOW, SudokuWindowClass))
#define IS_SUDOKU_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_WINDOW))
#define IS_SUDOKU_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_WINDOW))
#define SUDOKU_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_WINDOW, SudokuWindowClass))

typedef struct _SudokuWindow SudokuWindow;
typedef struct _SudokuWindowClass SudokuWindowClass;
typedef struct _SudokuWindowPrivate SudokuWindowPrivate;

#define TYPE_SUDOKU_VIEW (sudoku_view_get_type ())
#define SUDOKU_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_VIEW, SudokuView))
#define SUDOKU_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_VIEW, SudokuViewClass))
#define IS_SUDOKU_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_VIEW))
#define IS_SUDOKU_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_VIEW))
#define SUDOKU_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_VIEW, SudokuViewClass))

typedef struct _SudokuView SudokuView;
typedef struct _SudokuViewClass SudokuViewClass;
enum  {
	SUDOKU_WINDOW_0_PROPERTY,
	SUDOKU_WINDOW_VIEW_PROPERTY,
	SUDOKU_WINDOW_NUM_PROPERTIES
};
static GParamSpec* sudoku_window_properties[SUDOKU_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SudokuWindow {
	GtkApplicationWindow parent_instance;
	SudokuWindowPrivate * priv;
};

struct _SudokuWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _SudokuWindowPrivate {
	GtkHeaderBar* headerbar;
	GtkBox* start_box;
	GtkFrame* frame;
	GtkBox* game_box;
	GtkBox* undo_redo_box;
	GtkButton* back_button;
	GtkBox* clock_box;
	GtkLabel* clock_label;
	GtkImage* clock_image;
	GtkButton* play_custom_game_button;
	GtkButton* play_pause_button;
	GtkImage* play_pause_image;
	gboolean window_is_maximized;
	gboolean window_is_fullscreen;
	gboolean window_is_tiled;
	gint window_width;
	gint window_height;
	gboolean clock_in_headerbar;
	GSettings* settings;
	SudokuView* _view;
	SudokuGame* game;
};

static gint SudokuWindow_private_offset;
static gpointer sudoku_window_parent_class = NULL;

VALA_EXTERN GType sudoku_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SudokuWindow, g_object_unref)
VALA_EXTERN GType sudoku_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SudokuView, g_object_unref)
VALA_EXTERN SudokuWindow* sudoku_window_new (GSettings* settings);
VALA_EXTERN SudokuWindow* sudoku_window_construct (GType object_type,
                                       GSettings* settings);
static void sudoku_window_real_size_allocate (GtkWidget* base,
                                       GtkAllocation* allocation);
static void sudoku_window_set_clock_placed_in_headerbar (SudokuWindow* self,
                                                  gboolean value);
static gboolean sudoku_window_real_window_state_event (GtkWidget* base,
                                                GdkEventWindowState* event);
VALA_EXTERN void sudoku_window_will_start_game (SudokuWindow* self);
VALA_EXTERN void sudoku_window_start_game (SudokuWindow* self,
                               SudokuGame* game,
                               gboolean show_possibilities);
static void sudoku_window_tick_cb (SudokuWindow* self);
static void _sudoku_window_tick_cb_sudoku_game_tick (SudokuGame* _sender,
                                              gpointer self);
VALA_EXTERN SudokuView* sudoku_window_get_view (SudokuWindow* self);
VALA_EXTERN void sudoku_window_show_game_view (SudokuWindow* self);
VALA_EXTERN SudokuView* sudoku_view_new (SudokuGame* game);
VALA_EXTERN SudokuView* sudoku_view_construct (GType object_type,
                                   SudokuGame* game);
static void sudoku_window_set_view (SudokuWindow* self,
                             SudokuView* value);
VALA_EXTERN void sudoku_view_set_show_possibilities (SudokuView* self,
                                         gboolean value);
VALA_EXTERN void sudoku_view_set_show_warnings (SudokuView* self,
                                    gboolean value);
VALA_EXTERN void sudoku_view_set_highlighter (SudokuView* self,
                                  gboolean value);
VALA_EXTERN void sudoku_view_set_initialize_earmarks (SudokuView* self,
                                          gboolean value);
VALA_EXTERN void sudoku_window_show_new_game_screen (SudokuWindow* self);
VALA_EXTERN void sudoku_window_set_board_visible (SudokuWindow* self,
                                      gboolean visible);
VALA_EXTERN void sudoku_window_display_pause_button (SudokuWindow* self);
VALA_EXTERN gboolean sudoku_window_is_board_visible (SudokuWindow* self);
VALA_EXTERN void sudoku_window_set_headerbar_title (SudokuWindow* self);
VALA_EXTERN void sudoku_window_board_completed (SudokuWindow* self);
static void sudoku_window_finalize (GObject * obj);
static GType sudoku_window_get_type_once (void);
static void _vala_sudoku_window_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static void _vala_sudoku_window_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec);

static inline gpointer
sudoku_window_get_instance_private (SudokuWindow* self)
{
	return G_STRUCT_MEMBER_P (self, SudokuWindow_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

SudokuWindow*
sudoku_window_construct (GType object_type,
                         GSettings* settings)
{
	SudokuWindow * self = NULL;
	GSettings* _tmp0_;
	g_return_val_if_fail (settings != NULL, NULL);
	self = (SudokuWindow*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (settings);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	gtk_window_set_default_size ((GtkWindow*) self, g_settings_get_int (settings, "window-width"), g_settings_get_int (settings, "window-height"));
	if (g_settings_get_boolean (settings, "window-is-maximized")) {
		gtk_window_maximize ((GtkWindow*) self);
	}
	return self;
}

SudokuWindow*
sudoku_window_new (GSettings* settings)
{
	return sudoku_window_construct (TYPE_SUDOKU_WINDOW, settings);
}

static void
sudoku_window_real_size_allocate (GtkWidget* base,
                                  GtkAllocation* allocation)
{
	SudokuWindow * self;
	GtkAllocation _tmp0_;
	gint width = 0;
	gint height = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	self = (SudokuWindow*) base;
	g_return_if_fail (allocation != NULL);
	_tmp0_ = *allocation;
	GTK_WIDGET_CLASS (sudoku_window_parent_class)->size_allocate ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_window_get_type (), GtkApplicationWindow), &_tmp0_);
	gtk_window_get_size ((GtkWindow*) self, &_tmp1_, &_tmp2_);
	width = _tmp1_;
	height = _tmp2_;
	sudoku_window_set_clock_placed_in_headerbar (self, width > SUDOKU_WINDOW_clock_in_headerbar_min_width);
	if (self->priv->window_is_maximized) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = self->priv->window_is_fullscreen;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = self->priv->window_is_tiled;
	}
	if (_tmp3_) {
		return;
	}
	self->priv->window_width = width;
	self->priv->window_height = height;
}

static gboolean
sudoku_window_real_window_state_event (GtkWidget* base,
                                       GdkEventWindowState* event)
{
	SudokuWindow * self;
	gboolean result;
	self = (SudokuWindow*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if ((event->changed_mask & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
		self->priv->window_is_maximized = (event->new_window_state & GDK_WINDOW_STATE_MAXIMIZED) != 0;
	}
	if ((event->changed_mask & GDK_WINDOW_STATE_FULLSCREEN) != 0) {
		self->priv->window_is_fullscreen = (event->new_window_state & GDK_WINDOW_STATE_FULLSCREEN) != 0;
	}
	if ((event->changed_mask & SUDOKU_WINDOW_tiled_state) != 0) {
		self->priv->window_is_tiled = (event->new_window_state & SUDOKU_WINDOW_tiled_state) != 0;
	}
	result = GTK_WIDGET_CLASS (sudoku_window_parent_class)->window_state_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_window_get_type (), GtkApplicationWindow), event);
	return result;
}

void
sudoku_window_will_start_game (SudokuWindow* self)
{
	GtkButton* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->back_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, FALSE);
}

static void
_sudoku_window_tick_cb_sudoku_game_tick (SudokuGame* _sender,
                                         gpointer self)
{
	sudoku_window_tick_cb ((SudokuWindow*) self);
}

void
sudoku_window_start_game (SudokuWindow* self,
                          SudokuGame* game,
                          gboolean show_possibilities)
{
	SudokuGame* _tmp0_;
	SudokuGame* _tmp3_;
	SudokuView* _tmp4_;
	SudokuView* _tmp7_;
	SudokuView* _tmp8_;
	SudokuView* _tmp9_;
	SudokuView* _tmp10_;
	SudokuView* _tmp14_;
	GSettings* _tmp15_;
	SudokuView* _tmp16_;
	GSettings* _tmp17_;
	SudokuView* _tmp18_;
	GtkBox* _tmp19_;
	SudokuView* _tmp20_;
	GtkBox* _tmp21_;
	SudokuView* _tmp22_;
	GValue _tmp23_ = {0};
	GtkButton* _tmp24_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	_tmp0_ = self->priv->game;
	if (_tmp0_ != NULL) {
		SudokuGame* _tmp1_;
		guint _tmp2_;
		_tmp1_ = self->priv->game;
		g_signal_parse_name ("tick", TYPE_SUDOKU_GAME, &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _sudoku_window_tick_cb_sudoku_game_tick, self);
	}
	_tmp3_ = _g_object_ref0 (game);
	_g_object_unref0 (self->priv->game);
	self->priv->game = _tmp3_;
	g_signal_connect_object (game, "tick", (GCallback) _sudoku_window_tick_cb_sudoku_game_tick, self, 0);
	sudoku_game_start_clock (game);
	_tmp4_ = self->priv->_view;
	if (_tmp4_ != NULL) {
		GtkBox* _tmp5_;
		SudokuView* _tmp6_;
		_tmp5_ = self->priv->game_box;
		_tmp6_ = self->priv->_view;
		gtk_container_remove ((GtkContainer*) _tmp5_, (GtkWidget*) _tmp6_);
	}
	sudoku_window_show_game_view (self);
	_tmp7_ = sudoku_view_new (game);
	g_object_ref_sink (_tmp7_);
	_tmp8_ = _tmp7_;
	sudoku_window_set_view (self, _tmp8_);
	_g_object_unref0 (_tmp8_);
	_tmp9_ = self->priv->_view;
	gtk_widget_set_size_request ((GtkWidget*) _tmp9_, SUDOKU_WINDOW_board_size, SUDOKU_WINDOW_board_size);
	_tmp10_ = self->priv->_view;
	sudoku_view_set_show_possibilities (_tmp10_, show_possibilities);
	if (game->mode == GAME_MODE_CREATE) {
		SudokuView* _tmp11_;
		_tmp11_ = self->priv->_view;
		sudoku_view_set_show_warnings (_tmp11_, TRUE);
	} else {
		SudokuView* _tmp12_;
		GSettings* _tmp13_;
		_tmp12_ = self->priv->_view;
		_tmp13_ = self->priv->settings;
		sudoku_view_set_show_warnings (_tmp12_, g_settings_get_boolean (_tmp13_, "show-warnings"));
	}
	_tmp14_ = self->priv->_view;
	_tmp15_ = self->priv->settings;
	sudoku_view_set_highlighter (_tmp14_, g_settings_get_boolean (_tmp15_, "highlighter"));
	_tmp16_ = self->priv->_view;
	_tmp17_ = self->priv->settings;
	sudoku_view_set_initialize_earmarks (_tmp16_, g_settings_get_boolean (_tmp17_, "initialize-earmarks"));
	_tmp18_ = self->priv->_view;
	gtk_widget_show ((GtkWidget*) _tmp18_);
	_tmp19_ = self->priv->game_box;
	_tmp20_ = self->priv->_view;
	gtk_box_pack_start (_tmp19_, (GtkWidget*) _tmp20_, TRUE, TRUE, (guint) 0);
	_tmp21_ = self->priv->game_box;
	_tmp22_ = self->priv->_view;
	g_value_init (&_tmp23_, G_TYPE_INT);
	g_value_set_int (&_tmp23_, 0);
	gtk_container_child_set_property ((GtkContainer*) _tmp21_, (GtkWidget*) _tmp22_, "position", &_tmp23_);
	G_IS_VALUE (&_tmp23_) ? (g_value_unset (&_tmp23_), NULL) : NULL;
	_tmp24_ = self->priv->back_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp24_, TRUE);
}

void
sudoku_window_show_new_game_screen (SudokuWindow* self)
{
	GtkHeaderBar* _tmp0_;
	GtkButton* _tmp1_;
	SudokuGame* _tmp2_;
	GtkBox* _tmp3_;
	GtkLabel* _tmp4_;
	GtkImage* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->headerbar;
	gtk_header_bar_set_title (_tmp0_, _ ("Select Difficulty"));
	sudoku_window_set_board_visible (self, FALSE);
	_tmp1_ = self->priv->back_button;
	_tmp2_ = self->priv->game;
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, _tmp2_ != NULL);
	_tmp3_ = self->priv->undo_redo_box;
	gtk_widget_set_visible ((GtkWidget*) _tmp3_, FALSE);
	_tmp4_ = self->priv->clock_label;
	gtk_widget_set_visible ((GtkWidget*) _tmp4_, FALSE);
	_tmp5_ = self->priv->clock_image;
	gtk_widget_set_visible ((GtkWidget*) _tmp5_, FALSE);
}

void
sudoku_window_set_board_visible (SudokuWindow* self,
                                 gboolean visible)
{
	GtkBox* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GtkButton* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GtkFrame* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->start_box;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, !visible);
	if (visible) {
		SudokuGame* _tmp2_;
		_tmp2_ = self->priv->game;
		_tmp1_ = _tmp2_->mode == GAME_MODE_CREATE;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp3_ = self->priv->play_custom_game_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp3_, _tmp1_);
	if (visible) {
		SudokuGame* _tmp5_;
		_tmp5_ = self->priv->game;
		_tmp4_ = _tmp5_->mode != GAME_MODE_CREATE;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		sudoku_window_display_pause_button (self);
	} else {
		GtkButton* _tmp6_;
		_tmp6_ = self->priv->play_pause_button;
		gtk_widget_set_visible ((GtkWidget*) _tmp6_, FALSE);
	}
	_tmp7_ = self->priv->frame;
	gtk_widget_set_visible ((GtkWidget*) _tmp7_, visible);
}

gboolean
sudoku_window_is_board_visible (SudokuWindow* self)
{
	GtkFrame* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->frame;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
sudoku_window_show_game_view (SudokuWindow* self)
{
	SudokuGame* _tmp0_;
	GtkButton* _tmp1_;
	GtkBox* _tmp2_;
	GtkLabel* _tmp3_;
	GtkImage* _tmp4_;
	SudokuGame* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_vala_return_if_fail (_tmp0_ != NULL, "game != null");
	sudoku_window_set_board_visible (self, TRUE);
	_tmp1_ = self->priv->back_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, FALSE);
	_tmp2_ = self->priv->undo_redo_box;
	gtk_widget_set_visible ((GtkWidget*) _tmp2_, TRUE);
	_tmp3_ = self->priv->clock_label;
	gtk_widget_set_visible ((GtkWidget*) _tmp3_, TRUE);
	_tmp4_ = self->priv->clock_image;
	gtk_widget_set_visible ((GtkWidget*) _tmp4_, TRUE);
	_tmp5_ = self->priv->game;
	if (_tmp5_->mode == GAME_MODE_PLAY) {
		GtkButton* _tmp6_;
		GtkButton* _tmp7_;
		_tmp6_ = self->priv->play_custom_game_button;
		gtk_widget_set_visible ((GtkWidget*) _tmp6_, FALSE);
		_tmp7_ = self->priv->play_pause_button;
		gtk_widget_set_visible ((GtkWidget*) _tmp7_, TRUE);
	} else {
		GtkLabel* _tmp8_;
		GtkImage* _tmp9_;
		GtkButton* _tmp10_;
		GtkButton* _tmp11_;
		_tmp8_ = self->priv->clock_label;
		gtk_widget_set_visible ((GtkWidget*) _tmp8_, FALSE);
		_tmp9_ = self->priv->clock_image;
		gtk_widget_set_visible ((GtkWidget*) _tmp9_, FALSE);
		_tmp10_ = self->priv->play_custom_game_button;
		gtk_widget_set_visible ((GtkWidget*) _tmp10_, TRUE);
		_tmp11_ = self->priv->play_pause_button;
		gtk_widget_set_visible ((GtkWidget*) _tmp11_, FALSE);
	}
	sudoku_window_set_headerbar_title (self);
}

void
sudoku_window_board_completed (SudokuWindow* self)
{
	GtkButton* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->play_custom_game_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, FALSE);
}

void
sudoku_window_set_headerbar_title (SudokuWindow* self)
{
	SudokuGame* _tmp0_;
	SudokuGame* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_vala_return_if_fail (_tmp0_ != NULL, "game != null");
	_tmp1_ = self->priv->game;
	if (_tmp1_->mode == GAME_MODE_PLAY) {
		GtkHeaderBar* _tmp2_;
		_tmp2_ = self->priv->headerbar;
		gtk_header_bar_set_title (_tmp2_, _ ("Sudoku"));
	} else {
		GtkHeaderBar* _tmp3_;
		_tmp3_ = self->priv->headerbar;
		gtk_header_bar_set_title (_tmp3_, _ ("Create Puzzle"));
	}
}

void
sudoku_window_display_pause_button (SudokuWindow* self)
{
	GtkButton* _tmp0_;
	const gchar* _tmp1_ = NULL;
	SudokuGame* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GtkImage* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->play_pause_button;
	gtk_widget_show ((GtkWidget*) _tmp0_);
	_tmp2_ = self->priv->game;
	_tmp3_ = sudoku_game_get_paused (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		_tmp1_ = "media-playback-start-symbolic";
	} else {
		_tmp1_ = "media-playback-pause-symbolic";
	}
	_tmp5_ = self->priv->play_pause_image;
	g_object_set (_tmp5_, "icon-name", _tmp1_, NULL);
}

static void
sudoku_window_tick_cb (SudokuWindow* self)
{
	gint elapsed_time = 0;
	SudokuGame* _tmp0_;
	gint hours = 0;
	gint minutes = 0;
	gint seconds = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	elapsed_time = (gint) sudoku_game_get_total_time_played (_tmp0_);
	hours = elapsed_time / 3600;
	minutes = (elapsed_time - (hours * 3600)) / 60;
	seconds = (elapsed_time - (hours * 3600)) - (minutes * 60);
	if (hours > 0) {
		GtkLabel* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = self->priv->clock_label;
		_tmp2_ = g_strdup_printf ("%02d∶\xE2\x80\x8E%02d∶\xE2\x80\x8E%02d", hours, minutes, seconds);
		_tmp3_ = _tmp2_;
		gtk_label_set_text (_tmp1_, _tmp3_);
		_g_free0 (_tmp3_);
	} else {
		GtkLabel* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = self->priv->clock_label;
		_tmp5_ = g_strdup_printf ("%02d∶\xE2\x80\x8E%02d", minutes, seconds);
		_tmp6_ = _tmp5_;
		gtk_label_set_text (_tmp4_, _tmp6_);
		_g_free0 (_tmp6_);
	}
}

static void
sudoku_window_set_clock_placed_in_headerbar (SudokuWindow* self,
                                             gboolean value)
{
	g_return_if_fail (self != NULL);
	if (value == self->priv->clock_in_headerbar) {
		return;
	}
	self->priv->clock_in_headerbar = value;
	if (value) {
		GtkBox* _tmp0_;
		GtkBox* _tmp1_;
		GtkHeaderBar* _tmp2_;
		GtkBox* _tmp3_;
		_tmp0_ = self->priv->game_box;
		_tmp1_ = self->priv->clock_box;
		gtk_container_remove ((GtkContainer*) _tmp0_, (GtkWidget*) _tmp1_);
		_tmp2_ = self->priv->headerbar;
		_tmp3_ = self->priv->clock_box;
		gtk_header_bar_pack_end (_tmp2_, (GtkWidget*) _tmp3_);
	} else {
		GtkHeaderBar* _tmp4_;
		GtkBox* _tmp5_;
		GtkBox* _tmp6_;
		GtkBox* _tmp7_;
		_tmp4_ = self->priv->headerbar;
		_tmp5_ = self->priv->clock_box;
		gtk_container_remove ((GtkContainer*) _tmp4_, (GtkWidget*) _tmp5_);
		_tmp6_ = self->priv->game_box;
		_tmp7_ = self->priv->clock_box;
		gtk_box_pack_end (_tmp6_, (GtkWidget*) _tmp7_, TRUE, TRUE, (guint) 0);
	}
}

SudokuView*
sudoku_window_get_view (SudokuWindow* self)
{
	SudokuView* result;
	SudokuView* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_view;
	result = _tmp0_;
	return result;
}

static void
sudoku_window_set_view (SudokuWindow* self,
                        SudokuView* value)
{
	SudokuView* old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_window_get_view (self);
	if (old_value != value) {
		SudokuView* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_view);
		self->priv->_view = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sudoku_window_properties[SUDOKU_WINDOW_VIEW_PROPERTY]);
	}
}

static void
sudoku_window_class_init (SudokuWindowClass * klass,
                          gpointer klass_data)
{
	sudoku_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SudokuWindow_private_offset);
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget*, GtkAllocation*)) sudoku_window_real_size_allocate;
	((GtkWidgetClass *) klass)->window_state_event = (gboolean (*) (GtkWidget*, GdkEventWindowState*)) sudoku_window_real_window_state_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_sudoku_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sudoku_window_set_property;
	G_OBJECT_CLASS (klass)->finalize = sudoku_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_WINDOW_VIEW_PROPERTY, sudoku_window_properties[SUDOKU_WINDOW_VIEW_PROPERTY] = g_param_spec_object ("view", "view", "view", TYPE_SUDOKU_VIEW, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Sudoku/ui/sudoku-window.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "headerbar", FALSE, SudokuWindow_private_offset + G_STRUCT_OFFSET (SudokuWindowPrivate, headerbar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "start_box", FALSE, SudokuWindow_private_offset + G_STRUCT_OFFSET (SudokuWindowPrivate, start_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "frame", FALSE, SudokuWindow_private_offset + G_STRUCT_OFFSET (SudokuWindowPrivate, frame));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "game_box", FALSE, SudokuWindow_private_offset + G_STRUCT_OFFSET (SudokuWindowPrivate, game_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "undo_redo_box", FALSE, SudokuWindow_private_offset + G_STRUCT_OFFSET (SudokuWindowPrivate, undo_redo_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "back_button", FALSE, SudokuWindow_private_offset + G_STRUCT_OFFSET (SudokuWindowPrivate, back_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "clock_box", FALSE, SudokuWindow_private_offset + G_STRUCT_OFFSET (SudokuWindowPrivate, clock_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "clock_label", FALSE, SudokuWindow_private_offset + G_STRUCT_OFFSET (SudokuWindowPrivate, clock_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "clock_image", FALSE, SudokuWindow_private_offset + G_STRUCT_OFFSET (SudokuWindowPrivate, clock_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "play_custom_game_button", FALSE, SudokuWindow_private_offset + G_STRUCT_OFFSET (SudokuWindowPrivate, play_custom_game_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "play_pause_button", FALSE, SudokuWindow_private_offset + G_STRUCT_OFFSET (SudokuWindowPrivate, play_pause_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "play_pause_image", FALSE, SudokuWindow_private_offset + G_STRUCT_OFFSET (SudokuWindowPrivate, play_pause_image));
}

static void
sudoku_window_instance_init (SudokuWindow * self,
                             gpointer klass)
{
	self->priv = sudoku_window_get_instance_private (self);
	self->priv->game = NULL;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
sudoku_window_finalize (GObject * obj)
{
	SudokuWindow * self;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_WINDOW, SudokuWindow);
	_tmp0_ = self->priv->settings;
	g_settings_delay (_tmp0_);
	_tmp1_ = self->priv->settings;
	g_settings_set_int (_tmp1_, "window-width", self->priv->window_width);
	_tmp2_ = self->priv->settings;
	g_settings_set_int (_tmp2_, "window-height", self->priv->window_height);
	if (self->priv->window_is_maximized) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = self->priv->window_is_fullscreen;
	}
	_tmp4_ = self->priv->settings;
	g_settings_set_boolean (_tmp4_, "window-is-maximized", _tmp3_);
	_tmp5_ = self->priv->settings;
	g_settings_apply (_tmp5_);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->_view);
	_g_object_unref0 (self->priv->game);
	G_OBJECT_CLASS (sudoku_window_parent_class)->finalize (obj);
}

static GType
sudoku_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SudokuWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuWindow), 0, (GInstanceInitFunc) sudoku_window_instance_init, NULL };
	GType sudoku_window_type_id;
	sudoku_window_type_id = g_type_register_static (gtk_application_window_get_type (), "SudokuWindow", &g_define_type_info, 0);
	SudokuWindow_private_offset = g_type_add_instance_private (sudoku_window_type_id, sizeof (SudokuWindowPrivate));
	return sudoku_window_type_id;
}

GType
sudoku_window_get_type (void)
{
	static volatile gsize sudoku_window_type_id__once = 0;
	if (g_once_init_enter (&sudoku_window_type_id__once)) {
		GType sudoku_window_type_id;
		sudoku_window_type_id = sudoku_window_get_type_once ();
		g_once_init_leave (&sudoku_window_type_id__once, sudoku_window_type_id);
	}
	return sudoku_window_type_id__once;
}

static void
_vala_sudoku_window_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	SudokuWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_WINDOW, SudokuWindow);
	switch (property_id) {
		case SUDOKU_WINDOW_VIEW_PROPERTY:
		g_value_set_object (value, sudoku_window_get_view (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_sudoku_window_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec)
{
	SudokuWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_WINDOW, SudokuWindow);
	switch (property_id) {
		case SUDOKU_WINDOW_VIEW_PROPERTY:
		sudoku_window_set_view (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

