/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_yrl extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_bn = "b\u1ebdgari";
        final String metaValue_bo = "tibetanu";
        final String metaValue_el = "geregu";
        final String metaValue_he = "heburaiku";
        final String metaValue_hy = "arim\u1ebdniu";
        final String metaValue_ja = "yapunei";
        final String metaValue_jv = "yawanei";
        final String metaValue_ka = "geurgianu";
        final String metaValue_km = "kim\u00e9";
        final String metaValue_la = "rat\u0129";
        final String metaValue_ml = "marayara";
        final String metaValue_mn = "m\u0169g\u00fa";
        final String metaValue_my = "birimanei";
        final String metaValue_or = "uri\u00e1";
        final String metaValue_si = "s\u0129garei";
        final String metaValue_te = "t\u00e9rugu";
        final String metaValue_th = "tair\u00e3dei";
        final String metaValue_tl = "tagaru";
        final String metaValue_bax = "bam\u0169";
        final String metaValue_bug = "buginei";
        final String metaValue_chr = "xerok\u00ed";
        final String metaValue_got = "g\u00fatiku";
        final String metaValue_phn = "fin\u00edsiu";
        final String metaValue_uga = "ugar\u00edtiku";
        final String metaValue_vai = "wai";
        final String metaValue_type_hc_h12 = "Sist\u1ebdma 24 h\u00fara-ita (1-24)";
        final Object[][] data = new Object[][] {
            { "ksh", "kurixi" },
            { "Ogam", "ug\u00e3miku" },
            { "mwl", "mir\u00e3dei" },
            { "Zsym", "zsym" },
            { "cch", "atis\u00e3" },
            { "mwr", "mariwari" },
            { "Tagb", "tagibanua" },
            { "Zsye", "Emuyi" },
            { "%%NJIVA", "diyaretu giniwa/niyiwa" },
            { "ccp", "xakima" },
            { "egy", "egipisiu arkaiku" },
            { "raj", "rayasitani" },
            { "Phag", "phagipa" },
            { "tem", "timine" },
            { "teo", "teso" },
            { "rap", "rapanui" },
            { "ter", "terenu" },
            { "AC", "Ases\u00e3u Kapu\u00e3ma" },
            { "rar", "rurut\u0169ganu" },
            { "tet", "tet\u0169" },
            { "AD", "\u00c3dura" },
            { "AE", "Emiradu \u00c1rabi Yepewasuwait\u00e1" },
            { "nl_BE", "faram\u1ebdgu" },
            { "AF", "Afeg\u00e3niret\u00e3ma" },
            { "AG", "\u00c3tigua asu\u00ed Babuda" },
            { "type.ca.ethiopic", "Akayupawa Et\u00edupi" },
            { "AI", "\u00c3gira" },
            { "key.tz", "Kutu hurariyu" },
            { "AL", "Aub\u00e3niya" },
            { "AM", "Arim\u1ebdniya" },
            { "Teng", "t\u1ebdguwari" },
            { "AO", "\u00c3gura" },
            { "AQ", "\u00c3tartida" },
            { "AR", "Arg\u1ebdtina" },
            { "Prti", "prti" },
            { "AS", "Samua Amerikiwara" },
            { "AT", "Ausitiriya" },
            { "AU", "Ausitaraliya" },
            { "AW", "Aruba" },
            { "AX", "Kapu\u00e3ma-ita Ar\u00e3di" },
            { "mye", "miyene" },
            { "AZ", "Aseriret\u00e3ma" },
            { "%%AREVELA", "arim\u1ebdniyu uri\u1ebdtawara" },
            { "BA", "Businiya asu\u00ed Eseguwina" },
            { "BB", "Babadu" },
            { "ceb", "sebuanu" },
            { "BD", "B\u00e3garadexi" },
            { "kum", "kumiki" },
            { "BE", "Beujika" },
            { "gmh", "arem\u00e3u iwat\u00e9 m\u00e9diu" },
            { "BF", "Bukina Fasu" },
            { "BG", "Bug\u00e1riya" },
            { "BH", "Bar\u1ebdi" },
            { "BI", "Bur\u0169di" },
            { "BJ", "Ben\u0129" },
            { "BL", "S\u00e3 Batulumeu" },
            { "BM", "Bemuda" },
            { "kut", "kutenai" },
            { "myv", "erisia" },
            { "BN", "Burunei" },
            { "BO", "Bur\u00edwia" },
            { "BQ", "Tet\u00e3ma Iwibo\u00ed-ita Kar\u00edbi su\u00ed" },
            { "BR", "Brasiu" },
            { "BS", "Bayama" },
            { "xog", "rusoga" },
            { "BT", "But\u00e3u" },
            { "BV", "Kapu\u00e3ma Buweti" },
            { "BW", "Butisuwana" },
            { "BY", "Bieru-r\u00fasiya" },
            { "BZ", "Belisi" },
            { "Visp", "nhe\u1ebdga xipiawera" },
            { "type.ca.persian", "Akayupawa Persiyawara" },
            { "type.nu.hebr", "Augarismu-ita yudeu" },
            { "CA", "Kanad\u00e1" },
            { "CC", "Kapu\u00e3ma-ita Kuku (Keering)" },
            { "mzn", "mas\u00e3darani" },
            { "CD", "K\u0169gu - K\u0129xasa" },
            { "CF", "Repubirika Afirika-Piterapura" },
            { "CG", "Repubirika K\u0169guyara" },
            { "CH", "Suwisa" },
            { "CI", "Mafim Kup\u00e9" },
            { "CK", "Kapu\u00e3ma-ita Kooki" },
            { "CL", "Xiri" },
            { "Kthi", "kiti" },
            { "CM", "Puty-ita" },
            { "CN", "Xina" },
            { "CO", "Kur\u0169biya" },
            { "CP", "Kiripet\u0169 Kapu\u00e3ma" },
            { "CR", "Kup\u00e9 Rika" },
            { "CU", "Kuba" },
            { "CV", "Kabu Suikiri" },
            { "CW", "Kurasau" },
            { "CX", "Kapu\u00e3ma Kiritima" },
            { "CY", "Xipiri" },
            { "CZ", "Xekiya" },
            { "eka", "ekayuki" },
            { "DE", "Arem\u00e3ya" },
            { "goh", "arem\u00e3u arkaiku iwat\u00e9" },
            { "ace", "axemi" },
            { "cgg", "xiga" },
            { "DG", "Diyegu Garasiya" },
            { "type.nu.deva", "Augarismu-ita dewanag\u00e1ri" },
            { "DJ", "Dijibuti" },
            { "DK", "Dinamaka" },
            { "ach", "akuri" },
            { "gon", "g\u0169di" },
            { "Brai", "braire" },
            { "Brah", "brami" },
            { "DM", "Dominika" },
            { "type.nu.armnlow", "Augarismu-ita arim\u1ebdniyu mir\u0129wa" },
            { "DO", "Repubirika Duminikana" },
            { "gor", "gur\u0169taru" },
            { "got", metaValue_got },
            { "Mtei", "manipuri kuatiara" },
            { "zun", "s\u0169yi" },
            { "tig", "tigir\u00e9" },
            { "DZ", "Argeriya" },
            { "pag", "p\u00e3gasin\u00e3" },
            { "type.d0.hwidth", "Turususawa pisawera" },
            { "pal", "parawi" },
            { "EA", "Seuta asu\u00ed Merira" },
            { "chb", "xibixa" },
            { "pam", "p\u00e3p\u00e3ga" },
            { "EC", "Ekuad\u00fa" },
            { "pap", "papiam\u1ebdtu" },
            { "ada", "ad\u00e3gime" },
            { "EE", "Isituniya" },
            { "tiv", "tivi" },
            { "EG", "Egitu" },
            { "EH", "Saara Usid\u1ebdtawara" },
            { "chg", "xagatai" },
            { "pau", "parauanu" },
            { "chk", "xukisi" },
            { "chn", "yarig\u00e3u xinoki" },
            { "chm", "mari" },
            { "chp", "xipewiy\u00e3" },
            { "cho", "xokitau" },
            { "chr", metaValue_chr },
            { "ER", "Eritireya" },
            { "ES", "Isip\u00e3ya" },
            { "ET", "Etiupiya" },
            { "EU", "Eurupa Yepewasusawa" },
            { "elx", "eramite" },
            { "type.ca.gregorian", "Akayupawa Greguriuwara" },
            { "EZ", "euru suna" },
            { "chy", "xeyeni" },
            { "type.nu.gujr", "Augarismu-ita guserate" },
            { "Inds", "\u0129du" },
            { "ady", "adige" },
            { "FI", "Fir\u00e3diya" },
            { "FJ", "Fiyi" },
            { "FK", "Kapu\u00e3ma-ita Mawina" },
            { "FM", "Mikuruneziya" },
            { "key.va", "Tedawasawa muyereusawa" },
            { "FO", "Kapu\u00e3ma-ita Faruwe" },
            { "Taml", "t\u00e3miu" },
            { "FR", "Fr\u00e3sa" },
            { "tkl", "tukerauanu" },
            { "grb", "gerebu" },
            { "root", "raisi" },
            { "type.ca.indian", "Akayupawa Tet\u00e3mapawa \u0128diawara" },
            { "grc", "geregu arkaiku" },
            { "GA", "Gab\u00e3u" },
            { "vot", "w\u00fatiku" },
            { "GB", "Reyinu Yepewas\u00fa" },
            { "pcm", "pidig\u0129 niyerianu" },
            { "GD", "Garanada" },
            { "GE", "Geugiya" },
            { "GF", "Giyana Fr\u00e3sa yara" },
            { "GG", "Guw\u1ebdnisei" },
            { "GH", "Gana" },
            { "Tale", "tai re" },
            { "GI", "Gibaraut\u00e1" },
            { "afh", "afirihiri" },
            { "GL", "Guru\u1ebdr\u00e3diya" },
            { "enm", "\u1ebdgirixi m\u00e9diu" },
            { "GM", "G\u00e3biya" },
            { "GN", "Gin\u00e9" },
            { "GP", "Guadarupi" },
            { "GQ", "Gin\u00e9 Ekuaturiyau" },
            { "GR", "Geresiya" },
            { "GS", "Kapu\u00e3ma-ita Geugiya Su asu\u00ed S\u00e3duwixi Su" },
            { "GT", "Guatemara" },
            { "GU", "Guw\u00e3" },
            { "GW", "Gin\u00e9 Bisau" },
            { "tli", "tir\u0129giti" },
            { "tlh", "kir\u0129g\u0169" },
            { "Talu", "tai rue pisas\u00fa" },
            { "GY", "Giyana" },
            { "ckb", "kurdu piterapura" },
            { "zxx", "\u0169ba ayku\u00e9 nhe\u1ebdga sesewarait\u00e1" },
            { "Vaii", metaValue_vai },
            { "HK", "H\u0169gi K\u0169gi, RAE Xina yara" },
            { "HM", "Kapu\u00e3ma-ita Heard asu\u00ed McDonald" },
            { "HN", "\u0168dura" },
            { "HR", "Kuruwasiya" },
            { "agq", "ag\u1ebd" },
            { "gsw", "arem\u00e3u (Suisa)" },
            { "type.ca.islamic-umalqura", "Akayupawa Isl\u00e3suera (Umm al-Qura)" },
            { "HT", "Ait\u00ed" },
            { "HU", "\u0168giriya" },
            { "tmh", "tamaxeki" },
            { "IC", "Kapu\u00e3ma-ita Kanariya" },
            { "nan", "m\u0129 n\u00e3" },
            { "ID", "\u0128dunesiya" },
            { "peo", "persa arkaiku" },
            { "IE", "Ir\u00e3da" },
            { "nap", "napuritanu" },
            { "%%NDYUKA", "diyaretu \u0129diyuka" },
            { "naq", "nama" },
            { "zza", "sasaki" },
            { "IL", "Isirayeu" },
            { "IM", "M\u00e3 Kapu\u00e3ma" },
            { "IN", "\u0128diya" },
            { "type.co.eor", "Tek\u00f4 eurupawara muakar\u00e9sawa sup\u00e9" },
            { "IO", "Birit\u00e3niku Usuasawa Useyanu \u0128diku" },
            { "IQ", "Iraki" },
            { "IR", "Ir\u00e3" },
            { "IS", "Isir\u00e3diya" },
            { "IT", "Itariya" },
            { "Zmth", "matem\u00e1tika kuatiara" },
            { "type.nu.thai", "Augarismu-ita tair\u00e3diyawara" },
            { "%%POSIX", "k\u0169putarawa" },
            { "type.nu.beng", "Augarismu-ita b\u1ebdgari" },
            { "JE", "Yesei" },
            { "type.ca.islamic", "Akayupawa Isl\u00e3suera" },
            { "Beng", metaValue_bn },
            { "JM", "Yamaika" },
            { "JO", "Yud\u00e3niya" },
            { "JP", "Nip\u00f5" },
            { "%%1606NICT", "fr\u00e3sanhe\u1ebdga kaxi\u00edmawara 1606 up\u00e9" },
            { "ain", "ain\u00fa" },
            { "guz", "gusiyi" },
            { "tog", "t\u0169ganei Niasawara" },
            { "type.nu.knda", "Augarismu-ita kanarawara" },
            { "Kali", "kaya ri" },
            { "de_CH", "arem\u00e3u iwat\u00e9 (Suisa)" },
            { "type.co.phonetic", "Yupurawakasawa terefuniara mukaresawa" },
            { "type.ca.buddhist", "Akayupawa Budasuera" },
            { "KE", "K\u1ebdniya" },
            { "419", "Amerika Latina" },
            { "KG", "Kirigiret\u00e3ma" },
            { "KH", "K\u00e3buya" },
            { "KI", "Kiribati" },
            { "KM", "Kumure-ita" },
            { "KN", "S\u00e3 Kirituw\u00e3u su\u00ed Newi" },
            { "Knda", "k\u00e3nar\u00e1" },
            { "Zinh", "tauxariwa" },
            { "KP", "Kureya Nuti su\u00ed" },
            { "KR", "Kureya Su su\u00ed" },
            { "Plrd", "fun\u00e9tiku miau" },
            { "KW", "Kuwaiti" },
            { "tpi", "tuki pis\u0129" },
            { "KY", "Kapu\u00e3ma-ita Kaim\u00e3" },
            { "KZ", "Kasakiret\u00e3ma" },
            { "Cyrl", "sir\u00edriku" },
            { "LA", "Rawo" },
            { "LB", "Ribanu" },
            { "phn", metaValue_phn },
            { "LC", "S\u00e3ta Lusiya" },
            { "Cyrs", "sir\u00edriku isirawu ekeresiatiku" },
            { "gwi", "guwixi-\u0129" },
            { "nds", "arema\u0169 yatuka" },
            { "LI", "Rixit\u1ebdxita\u0129" },
            { "LK", "Siri R\u00e3ka" },
            { "akk", "akadi\u00e3nu" },
            { "cop", "kupita" },
            { "LR", "Rib\u00e9riya" },
            { "LS", "Resutu" },
            { "Phlv", "paravi kuxi\u00edmawara" },
            { "LT", "Rituw\u00e3niya" },
            { "LU", "Rux\u1ebdbugu" },
            { "LV", "Retuniya" },
            { "Kana", "katakan\u00e1" },
            { "LY", "Ribiya" },
            { "lad", "radinu" },
            { "vun", "w\u0169yu" },
            { "lah", "r\u00e3da" },
            { "lag", "r\u00e3gi" },
            { "Thaa", "ta-ana" },
            { "MA", "Maruku" },
            { "MC", "M\u0169naku" },
            { "MD", "M\u0169duwa" },
            { "ME", "M\u0169teneguru" },
            { "MF", "S\u00e3 Matiy\u0169" },
            { "lam", "r\u00e3ba" },
            { "MG", "Madagasik\u00e1" },
            { "Thai", metaValue_th },
            { "MH", "Kapu\u00e3ma-ita Marshall" },
            { "ale", "are\u00fati" },
            { "type.nu.vaii", "Diyitu-ita vai" },
            { "MK", "Mased\u0169niya" },
            { "ML", "Mari" },
            { "MM", "Miyam\u00e1 (Bim\u00e3niya)" },
            { "MN", "M\u0169guriya" },
            { "new", "newari" },
            { "MO", "Makau, RAE Xina yara" },
            { "MP", "Kapu\u00e3ma-ita Mariy\u00e3na Nuti su\u00ed" },
            { "MQ", "Matinika" },
            { "MR", "Mauritaniya" },
            { "MS", "M\u0169tiserati" },
            { "MT", "Mauta" },
            { "type.m0.ungegn", "Sinimukasawa UN GEGN" },
            { "MU", "Maurisiyu" },
            { "alt", "autai meridiunau" },
            { "MV", "Maudiwa-ita" },
            { "MW", "Marawi" },
            { "MX", "M\u1ebdsiku" },
            { "type.ca.japanese", "Akayupawa Nip\u00f5wara" },
            { "MY", "Malasiya" },
            { "MZ", "Mus\u00e3biki" },
            { "Phli", "phli" },
            { "NA", "Nam\u00edbiya" },
            { "202", "Afirika Subisariana" },
            { "type.ca.hebrew", "Akayupawa Yudeu" },
            { "type.co.dictionary", "Disiunariu muakaresawa" },
            { "NC", "Kared\u0169niya Pisas\u00fa" },
            { "%%WADEGILE", "romanisasawa Wade-Giles" },
            { "%%UCRCOR", "kuatiasawasup\u00ed musat\u00e3bikawa su\u00ed yespewas\u00fa" },
            { "NE", "Nige" },
            { "NF", "Kapu\u00e3ma Norfolk" },
            { "NG", "Nigeriya" },
            { "trv", "taruku" },
            { "Phlp", "phlp" },
            { "NI", "Nicaraguwa" },
            { "Hmng", "parau him\u0169gi" },
            { "NL", "Tet\u00e3ma Iwibo\u00ed-ita" },
            { "NO", "Nuruwega" },
            { "NP", "Nepau" },
            { "NR", "Nauru" },
            { "Phnx", metaValue_phn },
            { "NU", "Niwe" },
            { "rof", "r\u0169bu" },
            { "tsi", "tes\u0129m\u0129xianu" },
            { "NZ", "Ser\u00e3diya Pisas\u00fa" },
            { "Merc", "meru\u00edtiku kusiwu" },
            { "%%COLB1945", "K\u00f5v\u1ebds\u00e3u kuatiasawasup\u00ed Brasiu-Putugau 1945" },
            { "rom", "rumani" },
            { "Mero", "meru\u00edtiku" },
            { "crh", "Kirimeya turiku" },
            { "ang", "\u1ebdgirixi arkaiku" },
            { "OM", "Um\u00e3" },
            { "anp", "\u00e3yika" },
            { "crs", "kiriuru fr\u00e3sei seixeriwara" },
            { "Xpeo", "perisa kuxi\u00edmawara" },
            { "PA", "Panam\u00e3" },
            { "type.ca.islamic-civil", "Akayupawa Siwiu Isl\u00e3suera" },
            { "csb", "kaxubi\u00e3" },
            { "PE", "Peru" },
            { "PF", "Pulinesiya Fr\u00e3sa yara" },
            { "PG", "Papuwa-Gin\u00e9 Pisas\u00fa" },
            { "PH", "Firipina" },
            { "PK", "Pakiret\u00e3ma" },
            { "PL", "Puluniya" },
            { "ewo", "ew\u0169du" },
            { "PM", "S\u00e3 Peduru asu\u00ed Mikel\u00e3u" },
            { "PN", "Kapu\u00e3ma-ita Pitcairn" },
            { "PR", "Igarapawa Riku" },
            { "PS", "Tet\u00e3ma Paretinu-ita yara" },
            { "Bali", "barineisi" },
            { "PT", "Putugau" },
            { "PW", "Parau" },
            { "nia", "niyasi" },
            { "type.nu.greklow", "Augarismu-ita geregu mir\u0129wa" },
            { "PY", "Paraguwai" },
            { "tum", "t\u0169buka" },
            { "Hebr", metaValue_he },
            { "QA", "Katara" },
            { "%%SCOTLAND", "\u1ebdgirixi retewa esikusiyei" },
            { "niu", "niweanu" },
            { "QO", "Use\u00e3niya (R)" },
            { "lez", "resigi" },
            { "%%FONUPA", "fun\u00e9tika Aufabetu Fun\u00e9tiku Urariku" },
            { "tvl", "tuwaruanu" },
            { "Tavt", "tawiti" },
            { "001", "Iwi" },
            { "002", "Afirika" },
            { "003", "Amerika Nuti su\u00ed" },
            { "RE", "Yumuatirisawa" },
            { "005", "Amerika Su su\u00ed" },
            { "jbo", "ruyib\u00e3" },
            { "Rjng", "rey\u00e3gi" },
            { "009", "Use\u00e3niya" },
            { "RO", "Rom\u1ebdniya" },
            { "RS", "Sewiya" },
            { "RU", "Rusiya" },
            { "RW", "Hu\u00e3da" },
            { "Ugar", metaValue_uga },
            { "Mani", "manikeanu" },
            { "Khar", "karuxiti" },
            { "SA", "Arawia Saudita" },
            { "pon", "p\u0169peianu" },
            { "Mand", "m\u00e3daiku" },
            { "SB", "Kapu\u00e3ma-ita Sarum\u0169" },
            { "twq", "tasawake" },
            { "011", "Afirika Usid\u1ebdtawara" },
            { "SC", "Seixeri" },
            { "SD", "Ausud\u00e3" },
            { "013", "Amerika Piterapura" },
            { "SE", "Suwesiya" },
            { "014", "Afirika Uri\u1ebdtawara" },
            { "arc", "aramaiku" },
            { "015", "Afirika Nuti su\u00ed" },
            { "SG", "S\u0129gapura" },
            { "SH", "S\u00e3ta Erena" },
            { "type.lb.strict", "Mupenasawa ixama up\u00e9 ikusawa estiritu ir\u0169" },
            { "017", "Afirika Piterapura" },
            { "SI", "Esiruw\u1ebdniya" },
            { "018", "Afirika Meridiyunau" },
            { "SJ", "Siwaubati asu\u00ed Y\u00e3 Mayeni" },
            { "Bamu", metaValue_bax },
            { "019", "America-ita" },
            { "SK", "Esiruwakiya" },
            { "SL", "Iwitera Leowa" },
            { "SM", "S\u00e3 Marino" },
            { "SN", "Senegau" },
            { "SO", "Somariya" },
            { "arn", "mapud\u0169g\u0169" },
            { "arp", "araparu" },
            { "type.nu.taml", "Augarismu-ita tamir rikusawarup\u00ed" },
            { "SR", "Suriname" },
            { "SS", "Ausud\u00e3 Su su\u00ed" },
            { "ST", "S\u00e3 Tum\u00e9 asu\u00ed Pir\u0129sipe" },
            { "SV", "Eru Sawadu" },
            { "ars", "arabi negede" },
            { "SX", "S\u0129ti Maat\u1ebd" },
            { "SY", "Siriya" },
            { "yao", "yau" },
            { "SZ", "Esuat\u00edni" },
            { "arw", "arawaki" },
            { "yap", "yapese" },
            { "TA", "Tirit\u00e3u K\u0169ya" },
            { "asa", "asu" },
            { "type.ms.ussystem", "Sist\u1ebdma mus\u00e3gasawa amerikapura" },
            { "021", "Amerika Set\u1ebdtiriunau" },
            { "TC", "Kapu\u00e3ma-ita Tuka-ita asu\u00ed Kaiko-ita" },
            { "yav", "y\u00e3gib\u1ebd" },
            { "TD", "Xade" },
            { "TF", "Tet\u00e3ma Su-ita Fr\u00e3sa su\u00ed" },
            { "TG", "Togu" },
            { "TH", "Tairet\u00e3ma" },
            { "TJ", "Tayikiret\u00e3ma" },
            { "029", "Kar\u00edbi" },
            { "TK", "Tukerau" },
            { "TL", "Timu-Semusawa" },
            { "ybb", "y\u1ebdba" },
            { "type.co.searchjl", "Resikai k\u0169su\u00e3ti uyupiruwa hangul rup\u00ed" },
            { "TM", "Turkuranaret\u00e3ma" },
            { "%%BOONT", "boontling" },
            { "TN", "Tunisiya" },
            { "TO", "T\u00f5ga" },
            { "TR", "Tuk\u00edya" },
            { "TT", "Tirinidadi asu\u00ed Tobagu" },
            { "TV", "Tuwaru" },
            { "TW", "Taiw\u00e3" },
            { "ast", "asiturianu" },
            { "Orkh", "urik\u0169" },
            { "TZ", "T\u00e3saniya" },
            { "nmg", "kuwasiu" },
            { "Zzzz", "y\u0169pinimas\u00e1 \u0169bawa uyukuau" },
            { "UA", "Ukar\u00e3niya" },
            { "rup", "arumenu" },
            { "030", "\u00c1siya Uri\u1ebdtawara" },
            { "tyv", "tuwinianu" },
            { "sw_CD", "suairi k\u0169guwara" },
            { "034", "\u00c1siya Meridiyunau" },
            { "hai", "haida" },
            { "035", "Sudeti \u00c1siyatiku" },
            { "UG", "Ug\u00e3da" },
            { "hak", "hak\u00e1" },
            { "type.co.pinyin", "Pin-yin mukaresawa" },
            { "039", "Eurupa Meridiyunau" },
            { "Sinh", metaValue_si },
            { "UM", "Kapu\u00e3ma Kuiriwaita Apekatu EUA su\u00ed" },
            { "UN", "Nas\u00e3u Yepewasuwait\u00e1" },
            { "US", "Tet\u00e3ma-ita Yepewas\u00fa" },
            { "haw", "hawayanu" },
            { "%%1959ACAD", "akademiku" },
            { "type.co.gb2312han", "Xinanhe\u1ebdga iwasu\u0129ma muakarewa - GB2312" },
            { "UY", "Uruguwai" },
            { "prg", "purusianu" },
            { "UZ", "Y\u0169buesara-ret\u00e3ma" },
            { "tzm", "tamasiriti \u00c1tras katuwa" },
            { "type.co.stroke", "Sikis\u00e1-ita mukaresawa" },
            { "nnh", "\u0129gi\u1ebdb\u0169" },
            { "VA", "Watikanu Tawa-wasu" },
            { "pro", "puruw\u1ebdsau arkaiku" },
            { "VC", "S\u00e3 Wis\u1ebdti asu\u00ed Garanad\u0129na-ita" },
            { "VE", "Wenesuera" },
            { "VG", "Kapu\u00e3-ita Viy\u1ebd-ita Birit\u00e3nika-ita" },
            { "VI", "Kapu\u00e3-ira Viy\u1ebd-ita Amerikana-ita" },
            { "VN", "Wiyetin\u00e3" },
            { "VU", "Wanuatu" },
            { "nog", "nugai" },
            { "rwk", "ruwa" },
            { "non", "n\u00faridiku arkaiku" },
            { "053", "Ausitarasia" },
            { "%%AREVMDA", "arim\u1ebdniyu usid\u1ebdtawara" },
            { "054", "Meran\u00e9siya" },
            { "WF", "Wari asu\u00ed Futuna" },
            { "type.co.traditional", "Mukaresawa rikusawarup\u00ed" },
            { "057", "Micuronesiya Tet\u00e3ma" },
            { "jgo", "\u0129g\u1ebdba" },
            { "lkt", "rakuta" },
            { "type.nu.finance", "Papasawa-ita kariwa-rekuyara" },
            { "%%HEPBURN", "romanisasawa hepburn" },
            { "type.co.compat", "Muakaresawa rin\u0169dewa n\u0169gar\u00e1sawa" },
            { "wae", "wauseri" },
            { "WS", "Samowa" },
            { "wal", "woraita" },
            { "was", "waxu" },
            { "XA", "Sutakirana-ita" },
            { "war", "warai" },
            { "XB", "Bidiresiunaurana" },
            { "awa", "awadi" },
            { "061", "Pulinesiya" },
            { "XK", "Kusuwu" },
            { "Gujr", "guserati" },
            { "Zxxx", "y\u0169pinimas\u00e1\u0129ma" },
            { "Olck", "uxiki" },
            { "wbp", "waripiri" },
            { "Batk", "bataki" },
            { "Blis", "r\u00e3gasait\u00e1 bliss" },
            { "YE", "Yem\u1ebd" },
            { "nqo", "nik\u00fa" },
            { "type.co.standard", "Mukaresawa retewa" },
            { "fan", "f\u00e3ge" },
            { "%%ROZAJ", "resiawara" },
            { "fat", "f\u00e3ti" },
            { "Sgnw", "s\u00e3gawa kuatiara" },
            { "YT", "Mayuti" },
            { "ZA", "Afirika Su su\u00ed" },
            { "type.lb.loose", "Mupenasawa ixama up\u00e9 ikusawa yurawa ir\u0169" },
            { "Deva", "dewanagari" },
            { "type.nu.geor", "Augarismu-ita geurgianu" },
            { "Hira", "hiragana" },
            { "ZM", "S\u00e3biya" },
            { "%%PINYIN", "romanisasawa Piniy\u0129" },
            { "ZW", "S\u0129babuwe" },
            { "ZZ", "Tet\u00e3ma \u0168bawaukuamam\u1ebd" },
            { "Runr", "r\u00faniku" },
            { "type.ms.metric", "Sist\u1ebdma m\u00e9tiriku" },
            { "type.ca.iso8601", "Akayupawa ISSO-8601" },
            { "lol", "m\u0169gu" },
            { "nso", "sutu set\u1ebdtiriunau" },
            { "type.nu.telu", "Augarismu-ita terugu" },
            { "lou", "kiriuru ruisianawara" },
            { "loz", "rusi" },
            { "jmc", "maxami" },
            { "type.nu.hansfin", "Augarismu-ita kariwa-rekuyara xinawara iwasu\u00edma" },
            { "hil", "irigain\u0169" },
            { "type.nu.arabext", "Augarismu-ita \u0129du-arabiku musapira" },
            { "nus", "nuiri" },
            { "dak", "dakuta" },
            { "type.nu.fullwide", "Augarismu-ita teipausape" },
            { "hit", "hitita" },
            { "dar", "darigiwa" },
            { "dav", "taita" },
            { "Maya", "maya-ita kuatiara kuxi\u00edmawara" },
            { "lrc", "ruri set\u1ebdtiriunau" },
            { "Copt", "kupitiku" },
            { "nwc", "newari katuwa" },
            { "udm", "udimurite" },
            { "Khmr", metaValue_km },
            { "Limb", "r\u0129bu" },
            { "sad", "s\u00e3dawe" },
            { "type.nu.roman", "Augarismu-ita romawara" },
            { "sah", "saka" },
            { "sam", "aramaiku samaritanu" },
            { "%%SCOUSE", "isikuse" },
            { "saq", "s\u00e3buru" },
            { "sas", "sasak" },
            { "sat", "s\u00e3tari" },
            { "Tfng", "tifinagi" },
            { "jpr", "yudaiku-perisa" },
            { "type.d0.npinyin", "Papasawera" },
            { "type.nu.native", "Diyitu-wara-ita" },
            { "sba", "\u0129g\u00e3bai" },
            { "Guru", "gumuki" },
            { "lua", "ruba-rurua" },
            { "%%BISCAYAN", "bisikayawara" },
            { "type.d0.fwidth", "Turususawa teipausape" },
            { "sbp", "s\u00e3gu" },
            { "lui", "ruisenu" },
            { "nyn", "ni\u00e3kuri" },
            { "nym", "ni\u00e3muwesi" },
            { "lun", "r\u0169da" },
            { "nyo", "niyuru" },
            { "luo", "ruwu" },
            { "fil", "firipinu" },
            { "hmn", "him\u0169gi" },
            { "del", "deraware" },
            { "lus", "ruxai" },
            { "bal", "bar\u00faxi" },
            { "den", "isireivei" },
            { "uga", metaValue_uga },
            { "ban", "barinei" },
            { "luy", "ruiya" },
            { "bas", "basa" },
            { "bax", metaValue_bax },
            { "%%ABL1943", "Papira purakari-res\u00e9 kuatiasawasup\u00ed 1943 su\u00ed" },
            { "jrb", "yudaiku-arabiku" },
            { "nzi", "\u0129sima" },
            { "sco", "isiutis" },
            { "scn", "sisirianu" },
            { "aa", "afari" },
            { "ab", "abikasiyu" },
            { "ae", "awesitiku" },
            { "af", "afiri\u0137\u00e3ner" },
            { "ak", "ak\u00e3" },
            { "bbj", "gumara" },
            { "am", "am\u00e1riku" },
            { "an", "aragun\u1ebdi" },
            { "Arab", "arabika" },
            { "%%SOLBA", "diyaretu situwisa/subika" },
            { "Jpan", metaValue_ja },
            { "ar", "arabi" },
            { "Hrkt", "yapunei s\u00edraba ir\u0169" },
            { "as", "asamei" },
            { "Lina", "sat\u00e3bika A" },
            { "av", "awariku" },
            { "Linb", "sat\u00e3bika B" },
            { "sdh", "kuridu meridiunau" },
            { "ay", "aimar\u00e1" },
            { "az", "aserbayanu" },
            { "%%OSOJS", "diyaretu usiaku/usuyani" },
            { "ba", "baxikiri" },
            { "type.co.unihan", "Mukaresawa radikawa - sikis\u00e1-ita" },
            { "be", "bierurusu" },
            { "bg", "b\u00fagaru" },
            { "bi", "bisiram\u00e1" },
            { "bm", "b\u00e3bara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "dgr", "dogiri" },
            { "br", "beret\u00e3u" },
            { "bs", "businiu" },
            { "see", "seneka" },
            { "Mymr", metaValue_my },
            { "type.nu.laoo", "Augarismu-ita raosiwara" },
            { "seh", "sena" },
            { "Nkoo", "\u0129ku" },
            { "sel", "seukupi" },
            { "ca", "katar\u00e1" },
            { "ses", "kuiraburu seni" },
            { "ce", "xexenu" },
            { "ch", "xamuru" },
            { "%%REVISED", "kuatiasawasup\u00ed musat\u00e3bikawa" },
            { "co", "curisu" },
            { "Orya", metaValue_or },
            { "cr", "kiri" },
            { "cs", "tieku" },
            { "cu", "isirawu ekeresiatiku" },
            { "yrl", "nhe\u1ebdgatu" },
            { "cv", "tiuwaxi" },
            { "cy", "garei" },
            { "type.nu.ethi", "Augarismu-ita etiopiwara" },
            { "Yiii", "yi" },
            { "da", "dinamarikei" },
            { "de", "arem\u00e3u" },
            { "type.cf.standard", "Rikuyara rupisawa retewa" },
            { "bej", "beya" },
            { "din", "d\u0129ka" },
            { "Bugi", metaValue_bug },
            { "bem", "b\u1ebdba" },
            { "sga", "ir\u00e3desiarkaiku" },
            { "type.nu.mong", "Augarismu-ita m\u0169g\u00fai" },
            { "dv", "diwe\u00ed" },
            { "dz", "dis\u0169ga" },
            { "bez", "bena" },
            { "type.ca.chinese", "Akayupawa Xinawara" },
            { "Lisu", "risu" },
            { "dje", "sarima" },
            { "type.nu.grek", "Augarismu-ita geregu" },
            { "ee", "ewe" },
            { "bfd", "bafuti" },
            { "type.lb.normal", "Mupenasawa ixama up\u00e9 ikusawa nurmawa ir\u0169" },
            { "ro_MD", "mud\u00e1wiu" },
            { "el", metaValue_el },
            { "en", "\u1ebdgirixi" },
            { "eo", "esiper\u00e3tu" },
            { "type.co.big5han", "Xinanh\u1ebd\u1ebdga rikusawarup\u00ed muakaresawa - Big5" },
            { "es", "isip\u00e3yu" },
            { "et", "eituniyanu" },
            { "Hanb", "h\u00e3bi" },
            { "eu", "basiku" },
            { "Buhd", "buwidi" },
            { "Hang", "h\u00e3gu" },
            { "Samr", "samaritanu" },
            { "shi", "taxeriti" },
            { "hsb", "sur\u00e1biu iwat\u00e9" },
            { "Hani", "h\u00e3" },
            { "shn", "x\u00e3ni" },
            { "Hano", "hanunu" },
            { "fa", "perisa" },
            { "Hans", "iwasu\u0129ma" },
            { "type.nu.latn", "Augarismu-ita usid\u1ebdtawa" },
            { "Hant", "katuwa" },
            { "az_Arab", "aseri s\u00fa" },
            { "ff", "fura" },
            { "shu", "arabi xadianu" },
            { "hsn", "xi\u00e3gi" },
            { "fi", "fir\u00e3des" },
            { "fj", "fiyianu" },
            { "fon", "f\u0169mu" },
            { "bgn", "baruxi usid\u1ebdtawara" },
            { "yue", "k\u00e3tunei" },
            { "fo", "faruwesi" },
            { "type.m0.bgn", "Sinimukasawa BGN EUA" },
            { "umb", "\u0169b\u0169du" },
            { "fr", "fr\u00e3sei" },
            { "sid", "sidamu" },
            { "fy", "fr\u00edsiu usid\u1ebdtawara" },
            { "ga", "ir\u00e3deixi m\u00e9diu" },
            { "gd", "ga\u00e9riku ekusei" },
            { "gl", "garegu" },
            { "gn", "guwarani" },
            { "bho", "buyipuri" },
            { "und", "\u0169ba uyukuau nhe\u1ebdga" },
            { "type.ca.ethiopic-amete-alem", "Akayupawa Amete Alem Etiupiwara" },
            { "gu", "guserate" },
            { "gv", "m\u00e3kisi" },
            { "ha", "haus\u00e1" },
            { "he", metaValue_he },
            { "hi", "h\u0129di" },
            { "hup", "hupa" },
            { "bik", "bik\u00fa" },
            { "bin", "bin\u00ed" },
            { "ho", "hiri mutu" },
            { "hr", "kuruata" },
            { "ht", "haitianu" },
            { "hu", "\u0169garu" },
            { "hy", metaValue_hy },
            { "hz", "hereru" },
            { "frc", "fr\u00e3sei kay\u0169" },
            { "%%FONIPA", "fun\u00e9tika Aufabetu Fun\u00e9tiku \u0128tertet\u00e3ma-ita" },
            { "ia", "ne\u1ebdgasu\u00ed" },
            { "Jamo", "yamu" },
            { "id", "\u0129dun\u00e9siu" },
            { "type.nu.tibt", "Augarismu-ita tibetewara" },
            { "ie", "ne\u1ebdgapitera" },
            { "ig", "igibu" },
            { "ii", "sixu\u00e3 yi" },
            { "frm", "fr\u00e3sei m\u00e9diu" },
            { "%%AO1990", "Kuatiasawasup\u00ed Ewakisawa Nhe\u1ebdga Putugewara 1990" },
            { "ik", "inupiaki" },
            { "fro", "fr\u00e3sei arkaiku" },
            { "io", "idu" },
            { "frs", "fir\u00edsiu usid\u1ebdtawara" },
            { "frr", "fir\u00edsiu set\u1ebdtiriunau" },
            { "is", "isir\u00e3dei" },
            { "it", "itarianu" },
            { "iu", "inukitituti" },
            { "%%HOGNORSK", "nuruwegu iwat\u00e9" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "Sara", "sarati" },
            { "doi", "dogiribi" },
            { "bkm", "k\u0169" },
            { "sma", "sami meridiunau" },
            { "jv", metaValue_jv },
            { "Shaw", "xawianu" },
            { "mad", "madurei" },
            { "smj", "sami Lulewara" },
            { "mag", "magar\u00ed" },
            { "maf", "mafa" },
            { "mai", "maitiri" },
            { "smn", "sami Inariwara" },
            { "ka", metaValue_ka },
            { "bla", "sikisika" },
            { "mak", "makas\u00e1" },
            { "wuu", "wurapuki" },
            { "sms", "sami Skoltwara" },
            { "man", "m\u00e3d\u0129ga" },
            { "kg", "k\u0169gurei" },
            { "Goth", metaValue_got },
            { "ki", "kikuyu" },
            { "mas", "masai" },
            { "kj", "ku\u00e3yama" },
            { "kk", "kasaki" },
            { "kl", "guru\u1ebdr\u00e3dei" },
            { "km", metaValue_km },
            { "kn", "kanar\u0129" },
            { "ko", "kurianu" },
            { "kr", "kan\u00fari" },
            { "ks", "kaxemira" },
            { "Cirt", "runikarana" },
            { "Lepc", "repixa" },
            { "Avst", "aw\u00e9tiku" },
            { "ku", "kurdu" },
            { "kv", "kumi" },
            { "kw", "k\u00fariniku" },
            { "ky", "kirigixi" },
            { "snk", "sun\u0129k\u00ea" },
            { "la", metaValue_la },
            { "lb", "rux\u1ebdbugei" },
            { "type.nu.mlym", "Augarismu-ita marayaro" },
            { "lg", "rug\u00e3da" },
            { "Roro", "r\u0169gur\u0169gu" },
            { "li", "r\u0129burgei" },
            { "Tibt", metaValue_bo },
            { "ln", "r\u0129gana" },
            { "fur", "friuranu" },
            { "lo", "rausianu" },
            { "type.ms.uksystem", "Sist\u1ebdma mus\u00e3gasawa \u0129periawa" },
            { "lt", "rituanu" },
            { "lu", "ruba-kat\u00e3ga" },
            { "lv", "ret\u00e3u" },
            { "sog", "sugidianu" },
            { "mg", "maugaxe" },
            { "mh", "marixarei" },
            { "type.co.ducet", "Unicode muakaresawa retewa" },
            { "mi", "mauri" },
            { "mk", "mased\u0169niu" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marati" },
            { "ms", "marayu" },
            { "mt", "mautei" },
            { "my", metaValue_my },
            { "Saur", "sauraxitara" },
            { "Armn", metaValue_hy },
            { "mdf", "mukisa" },
            { "mde", "maba" },
            { "dsb", "sur\u00e1biu yatuka" },
            { "Armi", "arimi" },
            { "na", "nauruanu" },
            { "type.co.search", "Sikais\u00e1 purusawa panh\u00e9rup\u00ed" },
            { "nb", "bukimau nuruegei" },
            { "nd", "\u0129debere nutiwara" },
            { "ne", "neparei" },
            { "ng", "d\u0169gu" },
            { "mdr", "m\u00e3dari" },
            { "nl", "hur\u00e3dei" },
            { "nn", "ninorisiki nuruegei" },
            { "no", "nuruegei" },
            { "nr", "\u0129debere suwara" },
            { "nv", "nawayu" },
            { "kaa", "kara-kaupaki" },
            { "ny", "ni\u00e3ya" },
            { "kac", "kax\u0129" },
            { "kab", "kabire" },
            { "%%POLYTON", "t\u0169niku-ita" },
            { "oc", "usit\u00e3niku" },
            { "kaj", "iyu" },
            { "kam", "k\u00e3ba" },
            { "men", "m\u1ebdde" },
            { "oj", "uyibua" },
            { "mer", "meru" },
            { "type.nu.armn", "Augarismu-ita arim\u1ebdniyu" },
            { "om", "urumu" },
            { "kaw", "kawi" },
            { "or", metaValue_or },
            { "os", "usetu" },
            { "kbd", "kabaridianu" },
            { "mfe", "murisi\u1ebd" },
            { "srn", "surinamei" },
            { "pa", "p\u00e3yabi" },
            { "dua", "duara" },
            { "srr", "serere" },
            { "%%LIPAW", "diyaretu ripovai Resian yara" },
            { "kbl", "kan\u1ebdbu" },
            { "pi", "p\u00e1ri" },
            { "pl", "purunei" },
            { "dum", "hur\u00e3dei m\u00e9diu" },
            { "type.ca.dangi", "Akayupawa D\u00e3gi" },
            { "ps", "paxitu" },
            { "pt", "putugei" },
            { "mga", "ir\u00e3dei m\u00e9diu" },
            { "key.co", "Isir\u00e3sawa" },
            { "kcg", "tiyapi" },
            { "mgh", "makua" },
            { "key.cf", "Rupisawa rikuyara" },
            { "bra", "barayi" },
            { "key.ca", "Akayupawa" },
            { "Laoo", "rau" },
            { "mgo", "met\u00e1" },
            { "type.hc.h23", "Sist\u1ebdma 24 h\u00fara-ita (0-23)" },
            { "type.hc.h24", metaValue_type_hc_h12 },
            { "ssy", "saru" },
            { "type.nu.mymr", "Augarismu-ita Miyamawara" },
            { "qu", "k\u00edxua" },
            { "zap", "saputeku" },
            { "brx", "budu" },
            { "Lana", "rana" },
            { "kde", "mak\u0169di" },
            { "Ethi", "eti\u00fapiku" },
            { "type.hc.h12", metaValue_type_hc_h12 },
            { "type.hc.h11", "Sist\u1ebdma 12 h\u00fara-ita (0-11)" },
            { "rm", "rum\u00e3xi" },
            { "rn", "r\u0169di" },
            { "key.cu", "Rikuyara" },
            { "ro", "rumenu" },
            { "%%SAAHO", "saho" },
            { "type.nu.orya", "Augarismu-ita uri\u00e1" },
            { "type.nu.hanidec", "Augarismu-ita muk\u0169i-pusawa xinawara" },
            { "ru", "rusu" },
            { "bss", "akusi" },
            { "rw", "kiniaru\u00e3da" },
            { "zbl", "r\u00e3gasait\u00e1 brisi" },
            { "kea", "kiriuru kabu-suikiriwara" },
            { "mic", "mikemake" },
            { "suk", "sukuma" },
            { "sa", "s\u00e3sikiritu" },
            { "%%UCCOR", "kuatiasawasup\u00ed yepewas\u00fa" },
            { "sc", "sarid\u00fa" },
            { "sus", "susu" },
            { "sd", "s\u0129di" },
            { "se", "sami set\u1ebdtiriunau" },
            { "min", "min\u00e3gikabau" },
            { "sg", "s\u00e3g\u00fa" },
            { "sh", "seriwu-kruata" },
            { "si", metaValue_si },
            { "sux", "sumeriu" },
            { "sk", "esiruwaku" },
            { "sl", "esiruwenu" },
            { "sm", "samuanu" },
            { "sn", "xuna" },
            { "so", "sumari" },
            { "type.nu.arab", "Augarismu-ita \u0129du-arabiku" },
            { "sq", "aubanei" },
            { "sr", "s\u00e9riwiu" },
            { "ss", "su\u00e1si" },
            { "type.cf.account", "Rikuyara rupisawa papasawa sup\u00e9" },
            { "Java", metaValue_jv },
            { "st", "sutu suwara" },
            { "su", "s\u0169danei" },
            { "%%NEDIS", "diyaretu natisuni" },
            { "sv", "sueku" },
            { "sw", "sua\u00edri" },
            { "type.nu.hantfin", "Augarismu-ita kariwa-rekuyara xinawara rikusawarup\u00ed" },
            { "ibb", "ibibiu" },
            { "iba", "ib\u00e3" },
            { "ta", "tamiu" },
            { "142", "\u00c1siya" },
            { "bua", "buriatu" },
            { "143", "\u00c1siya Piterapura" },
            { "te", metaValue_te },
            { "145", "\u00c1siya Usid\u1ebdtawara" },
            { "tg", "tadiyike" },
            { "th", metaValue_th },
            { "bug", metaValue_bug },
            { "ti", "tigir\u00ednia" },
            { "kfo", "kuru" },
            { "tk", "turikumenu" },
            { "tl", metaValue_tl },
            { "tn", "tisuana" },
            { "to", "t\u0169ganei" },
            { "bum", "buru" },
            { "dyo", "yora-funiyi" },
            { "type.nu.jpan", "Augarismu-ita nip\u00f5wara" },
            { "tr", "turku" },
            { "ts", "tes\u0169ga" },
            { "swb", "kumurianu" },
            { "Cakm", "kakimi" },
            { "tt", "t\u00e1ritaru" },
            { "dyu", "diura" },
            { "tw", "tui" },
            { "ty", "taitianu" },
            { "%%BISKE", "diyaretu s\u00e3 giorgiu/bira" },
            { "150", "Eurupa" },
            { "151", "Eurupa Uri\u1ebdtawara" },
            { "154", "Eurupa Set\u1ebdtiriunau" },
            { "dzg", "dasaga" },
            { "155", "Eurupa Usid\u1ebdtawara" },
            { "ug", "wiguri" },
            { "Ital", "it\u00e1riku kuxi\u00edmawara" },
            { "Kore", "kureanu" },
            { "kgp", "ka\u0129g\u00e3gi" },
            { "Zyyy", "mayewera" },
            { "uk", "ukaranianu" },
            { "type.ca.coptic", "Akayupawa Kupitiku" },
            { "ur", "urdu" },
            { "%%1994", "kuatiasawasup\u00ed resiawara muretewa" },
            { "xal", "kaumiki" },
            { "zen", "senaga" },
            { "uz", "usibeki" },
            { "kha", "kasi" },
            { "%%1996", "kuatiasawasup\u00ed arim\u00e3 1996 up\u00e9" },
            { "nds_NL", "sakis\u00e3u yatuka" },
            { "Sylo", "siruti nagiri" },
            { "ve", "w\u1ebdda" },
            { "type.ca.roc", "Akayupawa Xina Rep\u00fabirikawara" },
            { "vi", "wietinamita" },
            { "kho", "kutanei" },
            { "khq", "kuyira xini" },
            { "key.hc", "Ara urariupura (12\u00a0vs 24)" },
            { "%%TARASK", "kuatiasawasup\u00ed tarasikiewika" },
            { "vo", "wurapuke" },
            { "syc", "siriaku katuwa" },
            { "Osma", "usmania" },
            { "quc", "kix\u00e9" },
            { "gaa", "ga" },
            { "wa", "war\u00e3u" },
            { "gag", "gagausi" },
            { "syr", "siriaku" },
            { "Grek", metaValue_el },
            { "gan", "g\u00e3" },
            { "Lydi", "r\u00eddiu" },
            { "Xsux", "sum\u00e9riu-akadianu kune-s\u00e3gawa" },
            { "wo", "worofi" },
            { "zgh", "tamasiriti marukinu padr\u00e3u" },
            { "ar_001", "arabi mudernu" },
            { "Cans", "y\u0169pinimas\u00e1 s\u00edraba ir\u0169 abur\u00edjini kanad\u00e1wara su\u00ed" },
            { "gay", "gayu" },
            { "Mong", metaValue_mn },
            { "mnc", "m\u00e3xu" },
            { "Latf", "rat\u0129 farakit\u00fa" },
            { "gba", "gibaya" },
            { "mni", "manipuri" },
            { "Latn", metaValue_la },
            { "Latg", "rat\u0129 ga\u00e9riku" },
            { "type.nu.hans", "Augarismu-ita xinawara iwasu\u00edma" },
            { "type.nu.hant", "Augarismu-ita xinawara rikusawarup\u00ed" },
            { "xh", "xosa" },
            { "type.nu.romanlow", "Augarismu-ita romawara mir\u0129wa" },
            { "byn", "bir\u0129" },
            { "%%PAMAKA", "diyaretu pamaka" },
            { "Lyci", "r\u00edsiu" },
            { "osa", "usayi" },
            { "byv", "med\u0169ba" },
            { "Moon", "Moon kuatiara" },
            { "moh", "muikanu" },
            { "kkj", "kaku" },
            { "%%1694ACAD", "fr\u00e3sanhe\u1ebdga kuiriwara" },
            { "yi", "y\u00eddixi" },
            { "mos", "musi" },
            { "Syrc", "sir\u00edaku" },
            { "Dsrt", "desereti" },
            { "yo", "yurub\u00e1" },
            { "type.nu.traditional", "Papasawa-ita rikusawarup\u00ed" },
            { "Syrj", "siriaku usid\u1ebdtawara" },
            { "ota", "turiku utumanu" },
            { "Syre", "sir\u00edaku esitar\u00e3geru" },
            { "vai", metaValue_vai },
            { "za", "su\u00e3gi" },
            { "Cari", "karianu" },
            { "kln", "kar\u1ebdy\u0129" },
            { "zh", "xinanhe\u1ebdga" },
            { "Bopo", "bupumufu" },
            { "Perm", "p\u00e9rimiku kuxi\u00edmawara" },
            { "key.lb", "Nim\u0169 mupukasawa rupisawa" },
            { "zu", "suru" },
            { "type.co.phonebook", "Terefuni sesewara muakaresawa" },
            { "%%MONOTON", "yepet\u0169niku" },
            { "Geor", metaValue_ka },
            { "kmb", "k\u0129b\u0169du" },
            { "type.nu.jpanfin", "Augarismu-ita kariwa-rekuyara nip\u00f5wara" },
            { "Cham", "x\u00e3mi" },
            { "gez", "giixi" },
            { "Syrn", "siriaku uri\u1ebdtawara" },
            { "type.co.reformed", "Muakaresawa am\u0169rupisawaira" },
            { "Tglg", metaValue_tl },
            { "Egyd", "dem\u00fatiku egipisiu" },
            { "Egyh", "ier\u00e1tiku egipisiu" },
            { "ebu", "\u1ebdbu" },
            { "Egyp", "egipsiu-ita kuatiara kuxi\u00edmawara" },
            { "Geok", "kutisuri geurgianu" },
            { "zh_Hans", "xinanhe\u1ebdga iwasu\u0129ma" },
            { "koi", "kumi-perimiaki" },
            { "Hung", "\u0169garu kuxi\u00edmawara" },
            { "kok", "k\u0169kani" },
            { "%%1901", "kuatiasawasup\u00ed arim\u00e3 rikusawarup\u00ed" },
            { "kos", "kusiray\u00e3" },
            { "zh_Hant", "xinanhe\u1ebdga katuwa" },
            { "Sund", "sud\u00e3nei" },
            { "kpe", "kipere" },
            { "type.nu.khmr", "Augarismu-ita kim\u00e9" },
            { "ilo", "irukanu" },
            { "%%VALENCIA", "war\u1ebdsiwara" },
            { "Cprt", "sipiriuta" },
            { "%%BAKU1926", "aufabetu ratinu turku yepewas\u00fa" },
            { "mua", "m\u0169d\u00e3gi" },
            { "type.nu.guru", "Augarismu-ita gurmuki" },
            { "mul", "si\u00eda nhe\u1ebdga" },
            { "cad", "cadu" },
            { "key.ms", "Mus\u0169gasawa tek\u00f4" },
            { "mus", "kirik" },
            { "Glag", "garagur\u00edtiku" },
            { "gil", "giubetei" },
            { "%%KKCOR", "kuatiasawasup\u00ed panh\u00e9-yara" },
            { "Cher", metaValue_chr },
            { "car", "karibi" },
            { "cay", "kayuga" },
            { "type.nu.tamldec", "Augarismu-ita ramir" },
            { "krc", "karaxai-bauk\u00e1" },
            { "inh", "\u0129guxi" },
            { "krl", "kar\u00e9riu" },
            { "efi", "efiki" },
            { "key.nu", "Papasawa-it\u00e1" },
            { "kru", "kuruki" },
            { "ksb", "x\u00e3bara" },
            { "Telu", metaValue_te },
            { "ksf", "bafia" },
        };
        return data;
    }
}
