/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.uisupport;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLWriter;
import org.graalvm.visualvm.lib.ui.UIUtils;

public class HTMLTextArea
extends JEditorPane
implements HyperlinkListener,
MouseListener {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.graalvm.visualvm.lib.ui.components.Bundle");
    private static final String CUT_STRING = messages.getString("HTMLTextArea_CutString");
    private static final String COPY_STRING = messages.getString("HTMLTextArea_CopyString");
    private static final String PASTE_STRING = messages.getString("HTMLTextArea_PasteString");
    private static final String DELETE_STRING = messages.getString("HTMLTextArea_DeleteString");
    private static final String SELECT_ALL_STRING = messages.getString("HTMLTextArea_SelectAllString");
    private ActionListener popupListener;
    private JMenuItem itemCopy;
    private JMenuItem itemCut;
    private JMenuItem itemDelete;
    private JMenuItem itemPaste;
    private JMenuItem itemSelectAll;
    private JPopupMenu popupMenu;
    private boolean showPopup = true;
    private String pendingText;
    private String currentText;
    private boolean forceSetText;

    public HTMLTextArea() {
        this.setEditorKit(new HTMLEditorKit());
        this.setEditable(false);
        this.setOpaque(true);
        this.setAutoscrolls(true);
        this.addHyperlinkListener(this);
        this.setTransferHandler(new HTMLTextAreaTransferHandler());
        this.setFont(UIManager.getFont("Label.font"));
        this.setBackground(UIUtils.getProfilerResultsBackground());
        this.addMouseListener(this);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    HTMLTextArea.this.invokeSelectedLink();
                }
            }
        });
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L && HTMLTextArea.this.isShowing() && HTMLTextArea.this.pendingText != null) {
                    HTMLTextArea.this.setText(HTMLTextArea.this.pendingText);
                }
            }
        });
    }

    public HTMLTextArea(String text) {
        this();
        this.setText(text);
    }

    @Override
    public void setOpaque(boolean o) {
        super.setOpaque(o);
        if (UIUtils.isNimbusLookAndFeel() && !o) {
            this.setBackground(new Color(0, 0, 0, 0));
        }
    }

    @Override
    public void setForeground(Color color) {
        Color foreground = this.getForeground();
        if (foreground != null && foreground.equals(color)) {
            return;
        }
        super.setForeground(color);
        this.forceSetText = true;
        this.setText(this.getText());
    }

    public void setShowPopup(boolean showPopup) {
        this.showPopup = showPopup;
    }

    public boolean getShowPopup() {
        return this.showPopup;
    }

    @Override
    public void setText(String value) {
        if (value == null) {
            return;
        }
        if (!this.isShowing() && !this.forceSetText) {
            this.pendingText = value;
        } else {
            if (!this.forceSetText && value.equals(this.currentText)) {
                return;
            }
            this.currentText = value;
            this.pendingText = null;
            Font font = this.getFont();
            Color textColor = this.getForeground();
            value = value.replaceAll("\\n\\r|\\r\\n|\\n|\\r", "<br>");
            value = value.replace("<code>", "<code style=\"font-size: " + font.getSize() + "pt;\">");
            String colorText = "rgb(" + textColor.getRed() + "," + textColor.getGreen() + "," + textColor.getBlue() + ")";
            String newText = "<html><body text=\"" + colorText + "\" style=\"font-size: " + font.getSize() + "pt; font-family: " + font.getName() + ";\">" + value + "</body></html>";
            this.setDocument(this.getEditorKit().createDefaultDocument());
            super.setText(newText);
        }
        this.forceSetText = false;
    }

    @Override
    public String getText() {
        return this.pendingText != null ? this.pendingText : this.currentText;
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.pendingText != null) {
            this.forceSetText = true;
            this.setText(this.pendingText);
        }
        return super.getMinimumSize();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.pendingText != null) {
            this.forceSetText = true;
            this.setText(this.pendingText);
        }
        return super.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        if (this.pendingText != null) {
            this.forceSetText = true;
            this.setText(this.pendingText);
        }
        return super.getMaximumSize();
    }

    public void deleteSelection() {
        try {
            this.getDocument().remove(this.getSelectionStart(), this.getSelectionEnd() - this.getSelectionStart());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void invokeSelectedLink() {
        for (Action action : this.getEditorKit().getActions()) {
            if (!"activate-link-action".equals(action.getValue("Name"))) continue;
            action.actionPerformed(new ActionEvent(this, 0, null));
            return;
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.showURL(e.getURL());
        } else if (e.getEventType() == HyperlinkEvent.EventType.ENTERED) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        JPopupMenu popup;
        if (e.getModifiers() == 4 && this.isEnabled() && this.isFocusable() && this.showPopup && (popup = this.getPopupMenu()) != null) {
            this.updatePopupMenu();
            if (!this.hasFocus()) {
                this.requestFocus();
            }
            popup.show(this, e.getX(), e.getY());
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void paste() {
        try {
            this.replaceSelection(Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this).getTransferData(DataFlavor.stringFlavor).toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = this.createPopupMenu();
        }
        return this.popupMenu;
    }

    protected JPopupMenu createPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        this.popupListener = this.createPopupListener();
        this.itemCut = new JMenuItem(CUT_STRING);
        this.itemCopy = new JMenuItem(COPY_STRING);
        this.itemPaste = new JMenuItem(PASTE_STRING);
        this.itemDelete = new JMenuItem(DELETE_STRING);
        this.itemSelectAll = new JMenuItem(SELECT_ALL_STRING);
        this.itemCut.addActionListener(this.popupListener);
        this.itemCopy.addActionListener(this.popupListener);
        this.itemPaste.addActionListener(this.popupListener);
        this.itemDelete.addActionListener(this.popupListener);
        this.itemSelectAll.addActionListener(this.popupListener);
        popup.add(this.itemCut);
        popup.add(this.itemCopy);
        popup.add(this.itemPaste);
        popup.add(this.itemDelete);
        popup.addSeparator();
        popup.add(this.itemSelectAll);
        return popup;
    }

    protected void showURL(URL url) {
    }

    protected void updatePopupMenu() {
        this.itemCut.setEnabled(this.isEditable() && this.getSelectedText() != null);
        this.itemCopy.setEnabled(this.getSelectedText() != null);
        try {
            Transferable clipboardContent = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this);
            this.itemPaste.setEnabled(this.isEditable() && clipboardContent != null && clipboardContent.isDataFlavorSupported(DataFlavor.stringFlavor));
        }
        catch (Exception e) {
            this.itemPaste.setEnabled(false);
        }
        if (this.isEditable()) {
            this.itemDelete.setVisible(true);
            this.itemDelete.setEnabled(this.getSelectedText() != null);
        } else {
            this.itemDelete.setVisible(false);
        }
    }

    private ActionListener createPopupListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == HTMLTextArea.this.itemCut) {
                    HTMLTextArea.this.cut();
                } else if (e.getSource() == HTMLTextArea.this.itemCopy) {
                    HTMLTextArea.this.copy();
                } else if (e.getSource() == HTMLTextArea.this.itemPaste) {
                    HTMLTextArea.this.paste();
                } else if (e.getSource() == HTMLTextArea.this.itemDelete) {
                    HTMLTextArea.this.deleteSelection();
                } else if (e.getSource() == HTMLTextArea.this.itemSelectAll) {
                    HTMLTextArea.this.selectAll();
                }
            }
        };
    }

    private static class NcrToUnicode {
        private static Map<String, String> entities;

        private NcrToUnicode() {
        }

        public static String decode(String str) {
            StringBuilder ostr = new StringBuilder();
            int i1 = 0;
            for (int i2 = 0; i2 < str.length(); ++i2) {
                i1 = str.indexOf(38, i2);
                if (i1 == -1) {
                    ostr.append(str.substring(i2, str.length()));
                    break;
                }
                ostr.append(str.substring(i2, i1));
                i2 = str.indexOf(59, i1);
                if (i2 == -1) {
                    ostr.append(str.substring(i1, str.length()));
                    break;
                }
                String tok = str.substring(i1 + 1, i2);
                if (tok.charAt(0) == '#') {
                    if (tok.equals("#160")) {
                        ostr.append(NcrToUnicode.getEntities().get("nbsp"));
                        continue;
                    }
                    tok = tok.substring(1);
                    try {
                        int radix = 10;
                        if (tok.trim().charAt(0) == 'x') {
                            radix = 16;
                            tok = tok.substring(1, tok.length());
                        }
                        ostr.append((char)Integer.parseInt(tok, radix));
                    }
                    catch (NumberFormatException exp) {
                        ostr.append('?');
                    }
                    continue;
                }
                tok = NcrToUnicode.getEntities().get(tok);
                if (tok != null) {
                    ostr.append(tok);
                    continue;
                }
                ostr.append('?');
            }
            return ostr.toString();
        }

        private static synchronized Map<String, String> getEntities() {
            if (entities == null) {
                entities = new HashMap<String, String>();
                entities.put("quot", "\"");
                entities.put("amp", "&");
                entities.put("lt", "<");
                entities.put("gt", ">");
                entities.put("nbsp", " ");
                entities.put("iexcl", "\u00a1");
                entities.put("cent", "\u00a2");
                entities.put("pound", "\u00a3");
                entities.put("curren", "\u00a4");
                entities.put("yen", "\u00a5");
                entities.put("brvbar", "\u00a6");
                entities.put("sect", "\u00a7");
                entities.put("uml", "\u00a8");
                entities.put("copy", "\u00a9");
                entities.put("ordf", "\u00aa");
                entities.put("laquo", "\u00ab");
                entities.put("not", "\u00ac");
                entities.put("shy", "\u00ad");
                entities.put("reg", "\u00ae");
                entities.put("macr", "\u00af");
                entities.put("deg", "\u00b0");
                entities.put("plusmn", "\u00b1");
                entities.put("sup2", "\u00b2");
                entities.put("sup3", "\u00b3");
                entities.put("acute", "\u00b4");
                entities.put("micro", "\u00b5");
                entities.put("para", "\u00b6");
                entities.put("middot", "\u00b7");
                entities.put("cedil", "\u00b8");
                entities.put("sup1", "\u00b9");
                entities.put("ordm", "\u00ba");
                entities.put("raquo", "\u00bb");
                entities.put("frac14", "\u00bc");
                entities.put("frac12", "\u00bd");
                entities.put("frac34", "\u00be");
                entities.put("iquest", "\u00bf");
                entities.put("Agrave", "\u00c0");
                entities.put("Aacute", "\u00c1");
                entities.put("Acirc", "\u00c2");
                entities.put("Atilde", "\u00c3");
                entities.put("Auml", "\u00c4");
                entities.put("Aring", "\u00c5");
                entities.put("AElig", "\u00c6");
                entities.put("Ccedil", "\u00c7");
                entities.put("Egrave", "\u00c8");
                entities.put("Eacute", "\u00c9");
                entities.put("Ecirc", "\u00ca");
                entities.put("Euml", "\u00cb");
                entities.put("Igrave", "\u00cc");
                entities.put("Iacute", "\u00cd");
                entities.put("Icirc", "\u00ce");
                entities.put("Iuml", "\u00cf");
                entities.put("ETH", "\u00d0");
                entities.put("Ntilde", "\u00d1");
                entities.put("Ograve", "\u00d2");
                entities.put("Oacute", "\u00d3");
                entities.put("Ocirc", "\u00d4");
                entities.put("Otilde", "\u00d5");
                entities.put("Ouml", "\u00d6");
                entities.put("times", "\u00d7");
                entities.put("Oslash", "\u00d8");
                entities.put("Ugrave", "\u00d9");
                entities.put("Uacute", "\u00da");
                entities.put("Ucirc", "\u00db");
                entities.put("Uuml", "\u00dc");
                entities.put("Yacute", "\u00dd");
                entities.put("THORN", "\u00de");
                entities.put("szlig", "\u00df");
                entities.put("agrave", "\u00e0");
                entities.put("aacute", "\u00e1");
                entities.put("acirc", "\u00e2");
                entities.put("atilde", "\u00e3");
                entities.put("auml", "\u00e4");
                entities.put("aring", "\u00e5");
                entities.put("aelig", "\u00e6");
                entities.put("ccedil", "\u00e7");
                entities.put("egrave", "\u00e8");
                entities.put("eacute", "\u00e9");
                entities.put("ecirc", "\u00ea");
                entities.put("euml", "\u00eb");
                entities.put("igrave", "\u00ec");
                entities.put("iacute", "\u00ed");
                entities.put("icirc", "\u00ee");
                entities.put("iuml", "\u00ef");
                entities.put("eth", "\u00f0");
                entities.put("ntilde", "\u00f1");
                entities.put("ograve", "\u00f2");
                entities.put("oacute", "\u00f3");
                entities.put("ocirc", "\u00f4");
                entities.put("otilde", "\u00f5");
                entities.put("ouml", "\u00f6");
                entities.put("divide", "\u00f7");
                entities.put("oslash", "\u00f8");
                entities.put("ugrave", "\u00f9");
                entities.put("uacute", "\u00fa");
                entities.put("ucirc", "\u00fb");
                entities.put("uuml", "\u00fc");
                entities.put("yacute", "\u00fd");
                entities.put("thorn", "\u00fe");
                entities.put("yuml", "\u00ff");
            }
            return entities;
        }
    }

    private class HTMLTextAreaTransferHandler
    extends TransferHandler {
        private HTMLTextAreaTransferHandler() {
        }

        @Override
        public void exportToClipboard(JComponent comp, Clipboard clip, int action) {
            try {
                int selStart = HTMLTextArea.this.getSelectionStart();
                int selLength = HTMLTextArea.this.getSelectionEnd() - selStart;
                StringWriter plainTextWriter = new StringWriter();
                try {
                    new ExtendedHTMLWriter((Writer)plainTextWriter, (HTMLDocument)HTMLTextArea.this.getDocument(), selStart, selLength).write();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String plainText = NcrToUnicode.decode(plainTextWriter.toString());
                clip.setContents(new StringSelection(plainText), null);
                if (action == 2) {
                    HTMLTextArea.this.getDocument().remove(selStart, selLength);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    private static class ExtendedHTMLWriter
    extends HTMLWriter {
        ExtendedHTMLWriter(Writer w, HTMLDocument doc, int pos, int len) {
            super(w, doc, pos, len);
            this.setLineLength(Integer.MAX_VALUE);
        }

        protected boolean isSupportedBreakFlowTag(AttributeSet attr) {
            Object o = attr.getAttribute(StyleConstants.NameAttribute);
            if (o instanceof HTML.Tag) {
                HTML.Tag tag = (HTML.Tag)o;
                if (tag == HTML.Tag.HTML || tag == HTML.Tag.HEAD || tag == HTML.Tag.BODY || tag == HTML.Tag.HR) {
                    return false;
                }
                return tag.breaksFlow();
            }
            return false;
        }

        @Override
        protected void emptyTag(Element elem) throws BadLocationException, IOException {
            if (this.isSupportedBreakFlowTag(elem.getAttributes())) {
                this.writeLineSeparator();
            }
            if (this.matchNameAttribute(elem.getAttributes(), HTML.Tag.CONTENT)) {
                this.text(elem);
            }
        }

        @Override
        protected void endTag(Element elem) throws IOException {
            if (this.isSupportedBreakFlowTag(elem.getAttributes())) {
                this.writeLineSeparator();
            }
        }

        @Override
        protected void startTag(Element elem) throws IOException, BadLocationException {
        }
    }
}

