/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.stringio;

import java.util.Arrays;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyInteger;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.java.addons.IOJavaAddons;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.encoding.EncodingCapable;
import org.jruby.runtime.marshal.DataType;
import org.jruby.util.ArraySupport;
import org.jruby.util.ByteList;
import org.jruby.util.StringSupport;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.EncodingUtils;
import org.jruby.util.io.Getline;
import org.jruby.util.io.ModeFlags;
import org.jruby.util.io.OpenFile;

@JRubyClass(name={"StringIO"})
public class StringIO
extends RubyObject
implements EncodingCapable,
DataType {
    StringIOData ptr;
    private static final int STRIO_READABLE = 16;
    private static final int STRIO_WRITABLE = 32;
    private static final int STRIO_READWRITE = 48;
    private static final int CHAR_BIT = 8;
    private static final Getline.Callback<StringIO, IRubyObject> GETLINE = new Getline.Callback<StringIO, IRubyObject>(){

        public IRubyObject getline(ThreadContext threadContext, StringIO stringIO, IRubyObject iRubyObject, int n, boolean bl, Block block) {
            if (n == 0) {
                return RubyString.newEmptyString((Ruby)threadContext.runtime, (Encoding)stringIO.getEncoding());
            }
            IRubyObject iRubyObject2 = stringIO.getline(threadContext, iRubyObject, n, bl);
            threadContext.setLastLine(iRubyObject2);
            return iRubyObject2;
        }
    };
    private static final Getline.Callback<StringIO, StringIO> GETLINE_YIELD = new Getline.Callback<StringIO, StringIO>(){

        public StringIO getline(ThreadContext threadContext, StringIO stringIO, IRubyObject iRubyObject, int n, boolean bl, Block block) {
            IRubyObject iRubyObject2;
            if (n == 0) {
                throw threadContext.runtime.newArgumentError("invalid limit: 0 for each_line");
            }
            while (!(iRubyObject2 = stringIO.getline(threadContext, iRubyObject, n, bl)).isNil()) {
                block.yieldSpecific(threadContext, iRubyObject2);
            }
            return stringIO;
        }
    };
    private static final Getline.Callback<StringIO, RubyArray> GETLINE_ARY = new Getline.Callback<StringIO, RubyArray>(){

        public RubyArray getline(ThreadContext threadContext, StringIO stringIO, IRubyObject iRubyObject, int n, boolean bl, Block block) {
            IRubyObject iRubyObject2;
            RubyArray rubyArray = threadContext.runtime.newArray();
            if (n == 0) {
                throw threadContext.runtime.newArgumentError("invalid limit: 0 for readlines");
            }
            while (!(iRubyObject2 = stringIO.getline(threadContext, iRubyObject, n, bl)).isNil()) {
                rubyArray.append(iRubyObject2);
            }
            return rubyArray;
        }
    };
    public static final ByteList NEWLINE = ByteList.create((CharSequence)"\n");

    public static RubyClass createStringIOClass(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("StringIO", ruby.getObject(), StringIO::new);
        rubyClass.defineAnnotatedMethods(StringIO.class);
        rubyClass.includeModule((IRubyObject)ruby.getEnumerable());
        if (ruby.getObject().isConstantDefined("Java")) {
            rubyClass.defineAnnotatedMethods(IOJavaAddons.AnyIO.class);
        }
        RubyModule rubyModule = ruby.getIO().defineOrGetModuleUnder("GenericReadable");
        rubyModule.defineAnnotatedMethods(GenericReadable.class);
        rubyClass.includeModule((IRubyObject)rubyModule);
        RubyModule rubyModule2 = ruby.getIO().defineOrGetModuleUnder("GenericWritable");
        rubyModule2.defineAnnotatedMethods(GenericWritable.class);
        rubyClass.includeModule((IRubyObject)rubyModule2);
        return rubyClass;
    }

    public Encoding getEncoding() {
        return this.ptr.enc != null ? this.ptr.enc : this.ptr.string.getEncoding();
    }

    public void setEncoding(Encoding encoding) {
        this.ptr.enc = encoding;
    }

    @JRubyMethod(name={"new"}, rest=true, meta=true)
    public static IRubyObject newInstance(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        return RubyIO.newInstance((ThreadContext)threadContext, (IRubyObject)iRubyObject, (IRubyObject[])iRubyObjectArray, (Block)block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(meta=true, rest=true)
    public static IRubyObject open(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        StringIO stringIO;
        StringIO stringIO2 = stringIO = (StringIO)((RubyClass)iRubyObject).newInstance(threadContext, iRubyObjectArray, Block.NULL_BLOCK);
        if (block.isGiven()) {
            try {
                stringIO2 = block.yield(threadContext, (IRubyObject)stringIO);
            }
            finally {
                stringIO.ptr.string = null;
                stringIO.flags &= 0xFFFFFFCF;
            }
        }
        return stringIO2;
    }

    protected StringIO(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    @JRubyMethod(optional=2, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        if (this.ptr == null) {
            this.ptr = new StringIOData();
        }
        this.strioInit(threadContext, iRubyObjectArray);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void strioInit(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        StringIOData stringIOData;
        Ruby ruby = threadContext.runtime;
        StringIOData stringIOData2 = stringIOData = this.ptr;
        synchronized (stringIOData2) {
            RubyString rubyString;
            switch (iRubyObjectArray.length) {
                case 2: {
                    boolean bl;
                    IRubyObject iRubyObject = iRubyObjectArray[1];
                    if (iRubyObject instanceof RubyFixnum) {
                        int n = RubyFixnum.fix2int((IRubyObject)iRubyObject);
                        stringIOData.flags = ModeFlags.getOpenFileFlagsFor((int)n);
                        bl = (n & ModeFlags.TRUNC) != 0;
                    } else {
                        String string = iRubyObjectArray[1].convertToString().toString();
                        stringIOData.flags = OpenFile.ioModestrFmode((Ruby)ruby, (String)string);
                        bl = string.length() > 0 && string.charAt(0) == 'w';
                    }
                    rubyString = iRubyObjectArray[0].convertToString();
                    if ((stringIOData.flags & 2) != 0 && rubyString.isFrozen()) {
                        throw ruby.newErrnoEACCESError("Permission denied");
                    }
                    if (!bl) break;
                    rubyString.resize(0);
                    break;
                }
                case 1: {
                    rubyString = iRubyObjectArray[0].convertToString();
                    stringIOData.flags = rubyString.isFrozen() ? 1 : 3;
                    break;
                }
                case 0: {
                    rubyString = RubyString.newEmptyString((Ruby)ruby, (Encoding)ruby.getDefaultExternalEncoding());
                    stringIOData.flags = 3;
                    break;
                }
                default: {
                    throw ruby.newArgumentError(iRubyObjectArray.length, 2);
                }
            }
            stringIOData.string = rubyString;
            stringIOData.enc = null;
            stringIOData.pos = 0;
            stringIOData.lineno = 0;
            this.flags |= (stringIOData.flags & 3) * 16;
        }
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(ThreadContext threadContext, IRubyObject iRubyObject) {
        StringIO stringIO = (StringIO)TypeConverter.convertToType((IRubyObject)iRubyObject, (RubyClass)threadContext.runtime.getClass("StringIO"), (String)"to_strio");
        if (this == stringIO) {
            return this;
        }
        this.ptr = stringIO.ptr;
        this.flags &= 0xFFFFFFCF;
        this.flags |= stringIO.flags & 0x30;
        return this;
    }

    @JRubyMethod
    public IRubyObject binmode(ThreadContext threadContext) {
        this.ptr.enc = EncodingUtils.ascii8bitEncoding((Ruby)threadContext.runtime);
        if (this.writable()) {
            this.ptr.string.setEncoding(this.ptr.enc);
        }
        return this;
    }

    @JRubyMethod(name={"flush"})
    public IRubyObject strio_self() {
        return this;
    }

    @JRubyMethod(name={"fcntl"}, rest=true)
    public IRubyObject strio_unimpl(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        throw threadContext.runtime.newNotImplementedError("");
    }

    @JRubyMethod(name={"fsync"})
    public IRubyObject strioZero(ThreadContext threadContext) {
        return RubyFixnum.zero((Ruby)threadContext.runtime);
    }

    @JRubyMethod(name={"sync="})
    public IRubyObject strioFirst(IRubyObject iRubyObject) {
        this.checkInitialized();
        return iRubyObject;
    }

    @JRubyMethod(name={"isatty", "tty?"})
    public IRubyObject strioFalse(ThreadContext threadContext) {
        return threadContext.fals;
    }

    @JRubyMethod(name={"pid", "fileno"})
    public IRubyObject strioNil(ThreadContext threadContext) {
        return threadContext.nil;
    }

    @JRubyMethod
    public IRubyObject close(ThreadContext threadContext) {
        this.checkInitialized();
        if (this.closed()) {
            return threadContext.nil;
        }
        this.flags &= 0xFFFFFFCF;
        return threadContext.nil;
    }

    @JRubyMethod(name={"closed?"})
    public IRubyObject closed_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.closed());
    }

    @JRubyMethod
    public IRubyObject close_read(ThreadContext threadContext) {
        this.checkInitialized();
        if ((this.ptr.flags & 1) == 0) {
            throw threadContext.runtime.newIOError("not opened for reading");
        }
        if ((this.flags & 0x10) != 0) {
            this.flags &= 0xFFFFFFEF;
        }
        return threadContext.nil;
    }

    @JRubyMethod(name={"closed_read?"})
    public IRubyObject closed_read_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(!this.readable());
    }

    @JRubyMethod
    public IRubyObject close_write(ThreadContext threadContext) {
        this.checkInitialized();
        if ((this.ptr.flags & 2) == 0) {
            throw threadContext.runtime.newIOError("not opened for writing");
        }
        if ((this.flags & 0x20) != 0) {
            this.flags &= 0xFFFFFFDF;
        }
        return threadContext.nil;
    }

    @JRubyMethod(name={"closed_write?"})
    public IRubyObject closed_write_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(!this.writable());
    }

    @JRubyMethod(name={"each"}, writes={FrameField.LASTLINE})
    public IRubyObject each(ThreadContext threadContext, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize((Ruby)threadContext.runtime, (IRubyObject)this, (String)"each");
        }
        return Getline.getlineCall((ThreadContext)threadContext, GETLINE_YIELD, (Object)((Object)this), (Encoding)this.getEncoding(), (int)0, null, null, null, (Block)block);
    }

    @JRubyMethod(name={"each"}, writes={FrameField.LASTLINE})
    public IRubyObject each(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize((Ruby)threadContext.runtime, (IRubyObject)this, (String)"each", (IRubyObject)iRubyObject);
        }
        return Getline.getlineCall((ThreadContext)threadContext, GETLINE_YIELD, (Object)((Object)this), (Encoding)this.getEncoding(), (int)1, (IRubyObject)iRubyObject, null, null, (Block)block);
    }

    @JRubyMethod(name={"each"}, writes={FrameField.LASTLINE})
    public IRubyObject each(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize((Ruby)threadContext.runtime, (IRubyObject)this, (String)"each", (IRubyObject[])Helpers.arrayOf((IRubyObject)iRubyObject, (IRubyObject[])new IRubyObject[]{iRubyObject2}));
        }
        return Getline.getlineCall((ThreadContext)threadContext, GETLINE_YIELD, (Object)((Object)this), (Encoding)this.getEncoding(), (int)2, (IRubyObject)iRubyObject, (IRubyObject)iRubyObject2, null, (Block)block);
    }

    @JRubyMethod(name={"each"})
    public IRubyObject each(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize((Ruby)threadContext.runtime, (IRubyObject)this, (String)"each", (IRubyObject[])Helpers.arrayOf((IRubyObject)iRubyObject, (IRubyObject[])new IRubyObject[]{iRubyObject2, iRubyObject3}));
        }
        return Getline.getlineCall((ThreadContext)threadContext, GETLINE_YIELD, (Object)((Object)this), (Encoding)this.getEncoding(), (int)3, (IRubyObject)iRubyObject, (IRubyObject)iRubyObject2, (IRubyObject)iRubyObject3, (Block)block);
    }

    public IRubyObject each(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize((Ruby)threadContext.runtime, (IRubyObject)this, (String)"each", (IRubyObject[])iRubyObjectArray);
        }
        switch (iRubyObjectArray.length) {
            case 0: {
                return this.each(threadContext, block);
            }
            case 1: {
                return this.each(threadContext, iRubyObjectArray[0], block);
            }
            case 2: {
                return this.each(threadContext, iRubyObjectArray[0], iRubyObjectArray[1], block);
            }
            case 3: {
                return this.each(threadContext, iRubyObjectArray[0], iRubyObjectArray[1], iRubyObjectArray[2], block);
            }
        }
        Arity.raiseArgumentError((ThreadContext)threadContext, (int)iRubyObjectArray.length, (int)0, (int)3);
        throw new AssertionError((Object)"BUG");
    }

    @JRubyMethod(name={"each_line"})
    public IRubyObject each_line(ThreadContext threadContext, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize((Ruby)threadContext.runtime, (IRubyObject)this, (String)"each_line");
        }
        return this.each(threadContext, block);
    }

    @JRubyMethod(name={"each_line"})
    public IRubyObject each_line(ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize((Ruby)threadContext.runtime, (IRubyObject)this, (String)"each_line", (IRubyObject)iRubyObject);
        }
        return this.each(threadContext, iRubyObject, block);
    }

    @JRubyMethod(name={"each_line"})
    public IRubyObject each_line(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize((Ruby)threadContext.runtime, (IRubyObject)this, (String)"each_line", (IRubyObject[])new IRubyObject[]{iRubyObject, iRubyObject2});
        }
        return this.each(threadContext, iRubyObject, iRubyObject2, block);
    }

    @JRubyMethod(name={"each_line"})
    public IRubyObject each_line(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize((Ruby)threadContext.runtime, (IRubyObject)this, (String)"each_line", (IRubyObject[])new IRubyObject[]{iRubyObject, iRubyObject2, iRubyObject3});
        }
        return this.each(threadContext, iRubyObject, iRubyObject2, iRubyObject3, block);
    }

    public IRubyObject each_line(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize((Ruby)threadContext.runtime, (IRubyObject)this, (String)"each_line", (IRubyObject[])iRubyObjectArray);
        }
        switch (iRubyObjectArray.length) {
            case 0: {
                return this.each_line(threadContext, block);
            }
            case 1: {
                return this.each_line(threadContext, iRubyObjectArray[0], block);
            }
            case 2: {
                return this.each_line(threadContext, iRubyObjectArray[0], iRubyObjectArray[1], block);
            }
            case 3: {
                return this.each_line(threadContext, iRubyObjectArray[0], iRubyObjectArray[1], iRubyObjectArray[2], block);
            }
        }
        Arity.raiseArgumentError((ThreadContext)threadContext, (int)iRubyObjectArray.length, (int)0, (int)3);
        throw new AssertionError((Object)"BUG");
    }

    @JRubyMethod(name={"lines"}, optional=2)
    public IRubyObject lines(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
        threadContext.runtime.getWarnings().warn("StringIO#lines is deprecated; use #each_line instead");
        return block.isGiven() ? this.each(threadContext, iRubyObjectArray, block) : RubyEnumerator.enumeratorize((Ruby)threadContext.runtime, (IRubyObject)this, (String)"each_line", (IRubyObject[])iRubyObjectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"each_byte", "bytes"})
    public IRubyObject each_byte(ThreadContext threadContext, Block block) {
        StringIOData stringIOData;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize((Ruby)threadContext.runtime, (IRubyObject)this, (String)"each_byte");
        }
        this.checkReadable();
        Ruby ruby = threadContext.runtime;
        StringIOData stringIOData2 = stringIOData = this.ptr;
        synchronized (stringIOData2) {
            ByteList byteList = stringIOData.string.getByteList();
            while (stringIOData.pos < byteList.length()) {
                block.yield(threadContext, (IRubyObject)ruby.newFixnum(byteList.get(stringIOData.pos++) & 0xFF));
            }
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject each_char(ThreadContext threadContext, Block block) {
        IRubyObject iRubyObject;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize((Ruby)threadContext.runtime, (IRubyObject)this, (String)"each_char");
        }
        while (!(iRubyObject = this.getc(threadContext)).isNil()) {
            block.yieldSpecific(threadContext, iRubyObject);
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject chars(ThreadContext threadContext, Block block) {
        threadContext.runtime.getWarnings().warn("StringIO#chars is deprecated; use #each_char instead");
        return this.each_char(threadContext, block);
    }

    @JRubyMethod(name={"eof", "eof?"})
    public IRubyObject eof(ThreadContext threadContext) {
        this.checkReadable();
        if (this.ptr.pos < this.ptr.string.size()) {
            return threadContext.fals;
        }
        return threadContext.tru;
    }

    private boolean isEndOfString() {
        return this.ptr.pos >= this.ptr.string.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"getc"})
    public IRubyObject getc(ThreadContext threadContext) {
        StringIOData stringIOData;
        this.checkReadable();
        if (this.isEndOfString()) {
            return threadContext.nil;
        }
        StringIOData stringIOData2 = stringIOData = this.ptr;
        synchronized (stringIOData2) {
            int n = stringIOData.pos;
            int n2 = 1 + StringSupport.bytesToFixBrokenTrailingCharacter((ByteList)stringIOData.string.getByteList(), (int)(n + 1));
            stringIOData.pos += n2;
            return threadContext.runtime.newString(stringIOData.string.getByteList().makeShared(n, n2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"getbyte"})
    public IRubyObject getbyte(ThreadContext threadContext) {
        int n;
        StringIOData stringIOData;
        this.checkReadable();
        if (this.isEndOfString()) {
            return threadContext.nil;
        }
        StringIOData stringIOData2 = stringIOData = this.ptr;
        synchronized (stringIOData2) {
            n = stringIOData.string.getByteList().get(this.ptr.pos++) & 0xFF;
        }
        return threadContext.runtime.newFixnum(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RubyString strioSubstr(Ruby ruby, int n, int n2, Encoding encoding) {
        StringIOData stringIOData;
        StringIOData stringIOData2 = stringIOData = this.ptr;
        synchronized (stringIOData2) {
            RubyString rubyString = stringIOData.string;
            ByteList byteList = rubyString.getByteList();
            int n3 = rubyString.size() - n;
            if (n2 > n3) {
                n2 = n3;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 == 0) {
                return RubyString.newEmptyString((Ruby)ruby, (Encoding)encoding);
            }
            rubyString.setByteListShared();
            return RubyString.newStringShared((Ruby)ruby, (byte[])byteList.getUnsafeBytes(), (int)(byteList.getBegin() + n), (int)n2, (Encoding)encoding);
        }
    }

    private static void bm_init_skip(int[] nArray, byte[] byArray, int n, int n2) {
        for (int i = 0; i < 256; ++i) {
            nArray[i] = n2;
        }
        while (--n2 > 0) {
            nArray[byArray[n++]] = n2;
        }
    }

    private static int bm_search(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, int[] nArray) {
        for (int i = n2 - 1; i < n4; i += nArray[byArray2[i + n3] & 0xFF]) {
            int n5;
            int n6 = i;
            for (n5 = n2 - 1; n5 >= 0 && byArray2[n6 + n3] == byArray[n5 + n]; --n5) {
                --n6;
            }
            if (n5 >= 0) continue;
            return n6 + 1;
        }
        return -1;
    }

    @JRubyMethod(name={"gets"}, writes={FrameField.LASTLINE})
    public IRubyObject gets(ThreadContext threadContext) {
        return Getline.getlineCall((ThreadContext)threadContext, GETLINE, (Object)((Object)this), (Encoding)this.getEncoding());
    }

    @JRubyMethod(name={"gets"}, writes={FrameField.LASTLINE})
    public IRubyObject gets(ThreadContext threadContext, IRubyObject iRubyObject) {
        return Getline.getlineCall((ThreadContext)threadContext, GETLINE, (Object)((Object)this), (Encoding)this.getEncoding(), (IRubyObject)iRubyObject);
    }

    @JRubyMethod(name={"gets"}, writes={FrameField.LASTLINE})
    public IRubyObject gets(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return Getline.getlineCall((ThreadContext)threadContext, GETLINE, (Object)((Object)this), (Encoding)this.getEncoding(), (IRubyObject)iRubyObject, (IRubyObject)iRubyObject2);
    }

    @JRubyMethod(name={"gets"}, writes={FrameField.LASTLINE})
    public IRubyObject gets(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        return Getline.getlineCall((ThreadContext)threadContext, GETLINE, (Object)((Object)this), (Encoding)this.getEncoding(), (IRubyObject)iRubyObject, (IRubyObject)iRubyObject2, (IRubyObject)iRubyObject3);
    }

    public IRubyObject gets(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        switch (iRubyObjectArray.length) {
            case 0: {
                return this.gets(threadContext);
            }
            case 1: {
                return this.gets(threadContext, iRubyObjectArray[0]);
            }
            case 2: {
                return this.gets(threadContext, iRubyObjectArray[0], iRubyObjectArray[1]);
            }
            case 3: {
                return this.gets(threadContext, iRubyObjectArray[0], iRubyObjectArray[1], iRubyObjectArray[2]);
            }
        }
        Arity.raiseArgumentError((ThreadContext)threadContext, (int)iRubyObjectArray.length, (int)0, (int)3);
        throw new AssertionError((Object)"BUG");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject getline(ThreadContext threadContext, IRubyObject iRubyObject, int n, boolean bl) {
        RubyString rubyString;
        Ruby ruby = threadContext.runtime;
        this.checkReadable();
        if (this.isEndOfString()) {
            return threadContext.nil;
        }
        StringIOData stringIOData = this.ptr;
        Encoding encoding = this.getEncoding();
        StringIOData stringIOData2 = stringIOData;
        synchronized (stringIOData2) {
            ByteList byteList = stringIOData.string.getByteList();
            byte[] byArray = byteList.getUnsafeBytes();
            int n2 = byteList.getBegin();
            int n3 = n2 + stringIOData.pos;
            int n4 = n2 + byteList.getRealSize();
            int n5 = 0;
            if (n > 0 && n3 + n < n4) {
                n4 = this.getEncoding().rightAdjustCharHead(byArray, n3, n3 + n, n4);
            }
            if (iRubyObject == threadContext.nil) {
                if (bl) {
                    n5 = StringIO.chompNewlineWidth(byArray, n3, n4);
                }
                rubyString = this.strioSubstr(ruby, stringIOData.pos, n4 - n3 - n5, encoding);
            } else {
                int n6 = ((RubyString)iRubyObject).size();
                if (n6 == 0) {
                    int n7 = n3;
                    while (byArray[n7] == 10) {
                        if (++n7 != n4) continue;
                        return threadContext.nil;
                    }
                    n3 = n7;
                    while ((n7 = StringSupport.memchr((byte[])byArray, (int)n7, (int)10, (int)(n4 - n7))) != -1 && n7 != n4 && ++n7 != n4) {
                        if (byArray[n7] == 10) {
                            n4 = n7 + 1;
                            n5 = bl ? 1 : 0;
                            break;
                        }
                        if (byArray[n7] != 13 || n7 >= n4 || byArray[n7 + 1] != 10) continue;
                        n4 = n7 + 2;
                        int n8 = n5 = bl ? 2 : 0;
                        break;
                    }
                    if (n5 == 0 && bl) {
                        n5 = StringIO.chompNewlineWidth(byArray, n3, n4);
                    }
                    rubyString = this.strioSubstr(ruby, n3 - n2, n4 - n3 - n5, encoding);
                } else if (n6 == 1) {
                    RubyString rubyString2 = (RubyString)iRubyObject;
                    ByteList byteList2 = rubyString2.getByteList();
                    int n9 = StringSupport.memchr((byte[])byArray, (int)n3, (int)byteList2.get(0), (int)(n4 - n3));
                    if (n9 != -1) {
                        n4 = n9 + 1;
                        n5 = bl ? (n9 > n3 && byArray[n9 - 1] == 13 ? 1 : 0) + 1 : 0;
                    }
                    rubyString = this.strioSubstr(ruby, stringIOData.pos, n4 - n3 - n5, encoding);
                } else {
                    if (n6 < n4 - n3) {
                        RubyString rubyString3 = (RubyString)iRubyObject;
                        ByteList byteList3 = rubyString3.getByteList();
                        byte[] byArray2 = byteList3.getUnsafeBytes();
                        int[] nArray = new int[256];
                        int n10 = byteList3.getBegin();
                        StringIO.bm_init_skip(nArray, byArray2, n10, n6);
                        int n11 = StringIO.bm_search(byArray2, n10, n6, byArray, n3, n4 - n3, nArray);
                        if (n11 >= 0) {
                            n4 = n3 + n11 + n6;
                        }
                    }
                    rubyString = this.strioSubstr(ruby, stringIOData.pos, n4 - n3 - n5, encoding);
                }
            }
            stringIOData.pos = n4 - n2;
            ++stringIOData.lineno;
        }
        return rubyString;
    }

    private static int chompNewlineWidth(byte[] byArray, int n, int n2) {
        if (n2 > n && byArray[--n2] == 10) {
            if (n2 > n && byArray[--n2] == 13) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    @JRubyMethod(name={"length", "size"})
    public IRubyObject length() {
        this.checkInitialized();
        this.checkFinalized();
        return this.getRuntime().newFixnum(this.ptr.string.size());
    }

    @JRubyMethod(name={"lineno"})
    public IRubyObject lineno(ThreadContext threadContext) {
        return threadContext.runtime.newFixnum(this.ptr.lineno);
    }

    @JRubyMethod(name={"lineno="}, required=1)
    public IRubyObject set_lineno(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.ptr.lineno = RubyNumeric.fix2int((IRubyObject)iRubyObject);
        return threadContext.nil;
    }

    @JRubyMethod(name={"pos", "tell"})
    public IRubyObject pos(ThreadContext threadContext) {
        this.checkInitialized();
        return threadContext.runtime.newFixnum(this.ptr.pos);
    }

    @JRubyMethod(name={"pos="}, required=1)
    public IRubyObject set_pos(IRubyObject iRubyObject) {
        this.checkInitialized();
        long l = RubyNumeric.fix2long((IRubyObject)iRubyObject);
        if (l < 0L) {
            throw this.getRuntime().newErrnoEINVALError(iRubyObject.toString());
        }
        if (l > Integer.MAX_VALUE) {
            throw this.getRuntime().newArgumentError("JRuby does not support StringIO larger than 2147483647 bytes");
        }
        this.ptr.pos = (int)l;
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void strioExtend(int n, int n2) {
        StringIOData stringIOData;
        StringIOData stringIOData2 = stringIOData = this.ptr;
        synchronized (stringIOData2) {
            int n3 = stringIOData.string.size();
            if (n + n2 > n3) {
                stringIOData.string.resize(n + n2);
                if (n > n3) {
                    stringIOData.string.modify19();
                    ByteList byteList = stringIOData.string.getByteList();
                    Arrays.fill(byteList.getUnsafeBytes(), byteList.getBegin() + n3, byteList.getBegin() + n, (byte)0);
                }
            } else {
                stringIOData.string.modify19();
            }
        }
    }

    @JRubyMethod(name={"putc"})
    public IRubyObject putc(ThreadContext threadContext, IRubyObject iRubyObject) {
        IRubyObject iRubyObject2;
        Ruby ruby = threadContext.runtime;
        this.checkWritable();
        this.checkModifiable();
        if (iRubyObject instanceof RubyString) {
            iRubyObject2 = ((RubyString)iRubyObject).substr19(ruby, 0, 1);
        } else {
            byte by = RubyNumeric.num2chr((IRubyObject)iRubyObject);
            iRubyObject2 = RubyString.newString((Ruby)ruby, (byte[])new byte[]{by});
        }
        this.write(threadContext, iRubyObject2);
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"read"}, optional=2)
    public IRubyObject read(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        RubyString rubyString;
        StringIOData stringIOData;
        this.checkReadable();
        Ruby ruby = threadContext.runtime;
        IRubyObject iRubyObject = threadContext.nil;
        boolean bl = false;
        StringIOData stringIOData2 = stringIOData = this.ptr;
        synchronized (stringIOData2) {
            int n;
            switch (iRubyObjectArray.length) {
                case 2: {
                    iRubyObject = iRubyObjectArray[1];
                    if (!iRubyObject.isNil()) {
                        iRubyObject = iRubyObject.convertToString();
                        ((RubyString)iRubyObject).modify();
                    }
                }
                case 1: {
                    if (!iRubyObjectArray[0].isNil()) {
                        n = RubyNumeric.fix2int((IRubyObject)iRubyObjectArray[0]);
                        if (n < 0) {
                            throw ruby.newArgumentError("negative length " + n + " given");
                        }
                        if (n > 0 && this.isEndOfString()) {
                            if (!iRubyObject.isNil()) {
                                ((RubyString)iRubyObject).resize(0);
                            }
                            return threadContext.nil;
                        }
                        bl = true;
                        break;
                    }
                }
                case 0: {
                    n = stringIOData.string.size();
                    if (n <= stringIOData.pos) {
                        ASCIIEncoding aSCIIEncoding;
                        Object object = aSCIIEncoding = bl ? ASCIIEncoding.INSTANCE : this.getEncoding();
                        if (iRubyObject.isNil()) {
                            iRubyObject = ruby.newString();
                        } else {
                            ((RubyString)iRubyObject).resize(0);
                        }
                        ((RubyString)iRubyObject).setEncoding((Encoding)aSCIIEncoding);
                        return iRubyObject;
                    }
                    n -= stringIOData.pos;
                    break;
                }
                default: {
                    throw ruby.newArgumentError(iRubyObjectArray.length, 0);
                }
            }
            if (iRubyObject.isNil()) {
                ASCIIEncoding aSCIIEncoding = bl ? ASCIIEncoding.INSTANCE : this.getEncoding();
                rubyString = this.strioSubstr(ruby, stringIOData.pos, n, (Encoding)aSCIIEncoding);
            } else {
                rubyString = (RubyString)iRubyObject;
                int n2 = stringIOData.string.size() - stringIOData.pos;
                if (n > n2) {
                    n = n2;
                }
                rubyString.resize(n);
                ByteList byteList = rubyString.getByteList();
                byte[] byArray = byteList.getUnsafeBytes();
                ByteList byteList2 = stringIOData.string.getByteList();
                byte[] byArray2 = byteList2.getUnsafeBytes();
                System.arraycopy(byArray2, byteList2.getBegin() + stringIOData.pos, byArray, byteList.getBegin(), n);
                if (bl) {
                    rubyString.setEncoding((Encoding)ASCIIEncoding.INSTANCE);
                } else {
                    rubyString.setEncoding(stringIOData.string.getEncoding());
                }
            }
            stringIOData.pos += rubyString.size();
        }
        return rubyString;
    }

    @JRubyMethod(name={"readlines"})
    public IRubyObject readlines(ThreadContext threadContext) {
        return Getline.getlineCall((ThreadContext)threadContext, GETLINE_ARY, (Object)((Object)this), (Encoding)this.getEncoding());
    }

    @JRubyMethod(name={"readlines"})
    public IRubyObject readlines(ThreadContext threadContext, IRubyObject iRubyObject) {
        return Getline.getlineCall((ThreadContext)threadContext, GETLINE_ARY, (Object)((Object)this), (Encoding)this.getEncoding(), (IRubyObject)iRubyObject);
    }

    @JRubyMethod(name={"readlines"})
    public IRubyObject readlines(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return Getline.getlineCall((ThreadContext)threadContext, GETLINE_ARY, (Object)((Object)this), (Encoding)this.getEncoding(), (IRubyObject)iRubyObject, (IRubyObject)iRubyObject2);
    }

    @JRubyMethod(name={"readlines"})
    public IRubyObject readlines(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        return Getline.getlineCall((ThreadContext)threadContext, GETLINE_ARY, (Object)((Object)this), (Encoding)this.getEncoding(), (IRubyObject)iRubyObject, (IRubyObject)iRubyObject2, (IRubyObject)iRubyObject3);
    }

    public IRubyObject readlines(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        switch (iRubyObjectArray.length) {
            case 0: {
                return this.readlines(threadContext);
            }
            case 1: {
                return this.readlines(threadContext, iRubyObjectArray[0]);
            }
            case 2: {
                return this.readlines(threadContext, iRubyObjectArray[0], iRubyObjectArray[1]);
            }
            case 3: {
                return this.readlines(threadContext, iRubyObjectArray[0], iRubyObjectArray[1], iRubyObjectArray[2]);
            }
        }
        Arity.raiseArgumentError((ThreadContext)threadContext, (int)iRubyObjectArray.length, (int)0, (int)3);
        throw new AssertionError((Object)"BUG");
    }

    @JRubyMethod(name={"reopen"}, required=0, optional=2)
    public IRubyObject reopen(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        this.checkFrozen();
        if (iRubyObjectArray.length == 1 && !(iRubyObjectArray[0] instanceof RubyString)) {
            return this.initialize_copy(threadContext, iRubyObjectArray[0]);
        }
        this.strioInit(threadContext, iRubyObjectArray);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"rewind"})
    public IRubyObject rewind(ThreadContext threadContext) {
        StringIOData stringIOData;
        this.checkInitialized();
        StringIOData stringIOData2 = stringIOData = this.ptr;
        synchronized (stringIOData2) {
            stringIOData.pos = 0;
            stringIOData.lineno = 0;
        }
        return RubyFixnum.zero((Ruby)threadContext.runtime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(required=1, optional=1)
    public IRubyObject seek(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        StringIOData stringIOData;
        Ruby ruby = threadContext.runtime;
        this.checkFrozen();
        this.checkFinalized();
        int n = RubyNumeric.num2int((IRubyObject)iRubyObjectArray[0]);
        IRubyObject iRubyObject = threadContext.nil;
        if (iRubyObjectArray.length > 1 && !iRubyObjectArray[0].isNil()) {
            iRubyObject = iRubyObjectArray[1];
        }
        this.checkOpen();
        StringIOData stringIOData2 = stringIOData = this.ptr;
        synchronized (stringIOData2) {
            switch (iRubyObject.isNil() ? 0 : RubyNumeric.num2int((IRubyObject)iRubyObject)) {
                case 0: {
                    break;
                }
                case 1: {
                    n += stringIOData.pos;
                    break;
                }
                case 2: {
                    n += stringIOData.string.size();
                    break;
                }
                default: {
                    throw ruby.newErrnoEINVALError("invalid whence");
                }
            }
            if (n < 0) {
                throw ruby.newErrnoEINVALError("invalid seek value");
            }
            stringIOData.pos = n;
        }
        return RubyFixnum.zero((Ruby)ruby);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"string="}, required=1)
    public IRubyObject set_string(IRubyObject iRubyObject) {
        StringIOData stringIOData;
        this.checkFrozen();
        StringIOData stringIOData2 = stringIOData = this.ptr;
        synchronized (stringIOData2) {
            stringIOData.flags &= 0xFFFFFFFC;
            RubyString rubyString = iRubyObject.convertToString();
            stringIOData.flags = rubyString.isFrozen() ? 1 : 3;
            stringIOData.pos = 0;
            stringIOData.lineno = 0;
            stringIOData.string = rubyString;
            return stringIOData.string;
        }
    }

    @JRubyMethod(name={"string"})
    public IRubyObject string(ThreadContext threadContext) {
        RubyString rubyString = this.ptr.string;
        if (rubyString == null) {
            return threadContext.nil;
        }
        return rubyString;
    }

    @JRubyMethod(name={"sync"})
    public IRubyObject sync(ThreadContext threadContext) {
        this.checkInitialized();
        return threadContext.tru;
    }

    public IRubyObject sysread(IRubyObject[] iRubyObjectArray) {
        return GenericReadable.sysread(this.getRuntime().getCurrentContext(), (IRubyObject)this, iRubyObjectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"truncate"}, required=1)
    public IRubyObject truncate(IRubyObject iRubyObject) {
        this.checkWritable();
        int n = RubyFixnum.fix2int((IRubyObject)iRubyObject);
        StringIOData stringIOData = this.ptr;
        RubyString rubyString = stringIOData.string;
        StringIOData stringIOData2 = stringIOData;
        synchronized (stringIOData2) {
            int n2 = rubyString.size();
            if (n < 0) {
                throw this.getRuntime().newErrnoEINVALError("negative legnth");
            }
            rubyString.resize(n);
            ByteList byteList = rubyString.getByteList();
            if (n2 < n) {
                Arrays.fill(byteList.getUnsafeBytes(), byteList.getBegin() + n2, byteList.getBegin() + n, (byte)0);
            }
        }
        return iRubyObject;
    }

    @JRubyMethod(name={"ungetc"})
    public IRubyObject ungetc(ThreadContext threadContext, IRubyObject iRubyObject) {
        RubyString rubyString;
        Encoding encoding;
        this.checkModifiable();
        this.checkReadable();
        if (iRubyObject.isNil()) {
            return iRubyObject;
        }
        if (iRubyObject instanceof RubyInteger) {
            int n = RubyNumeric.num2int((IRubyObject)iRubyObject);
            byte[] byArray = new byte[16];
            Encoding encoding2 = this.getEncoding();
            int n2 = encoding2.codeToMbcLength(n);
            if (n2 <= 0) {
                EncodingUtils.encUintChr((ThreadContext)threadContext, (int)n, (Encoding)encoding2);
            }
            encoding2.codeToMbc(n, byArray, 0);
            this.ungetbyteCommon(byArray, 0, n2);
            return threadContext.nil;
        }
        iRubyObject = iRubyObject.convertToString();
        Encoding encoding3 = this.getEncoding();
        if (encoding3 != (encoding = (rubyString = (RubyString)iRubyObject).getEncoding()) && encoding3 != ASCIIEncoding.INSTANCE) {
            rubyString = EncodingUtils.strConvEnc((ThreadContext)threadContext, (RubyString)rubyString, (Encoding)encoding, (Encoding)encoding3);
        }
        ByteList byteList = rubyString.getByteList();
        this.ungetbyteCommon(byteList.unsafeBytes(), byteList.begin(), byteList.realSize());
        return threadContext.nil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ungetbyteCommon(int n) {
        StringIOData stringIOData;
        StringIOData stringIOData2 = stringIOData = this.ptr;
        synchronized (stringIOData2) {
            stringIOData.string.modify();
            --stringIOData.pos;
            ByteList byteList = stringIOData.string.getByteList();
            if (this.isEndOfString()) {
                byteList.length(stringIOData.pos + 1);
            }
            if (stringIOData.pos == -1) {
                byteList.prepend((byte)n);
                stringIOData.pos = 0;
            } else {
                byteList.set(stringIOData.pos, n);
            }
        }
    }

    private void ungetbyteCommon(RubyString rubyString) {
        ByteList byteList = rubyString.getByteList();
        this.ungetbyteCommon(byteList.unsafeBytes(), byteList.begin(), byteList.realSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ungetbyteCommon(byte[] byArray, int n, int n2) {
        StringIOData stringIOData;
        if (n2 == 0) {
            return;
        }
        StringIOData stringIOData2 = stringIOData = this.ptr;
        synchronized (stringIOData2) {
            stringIOData.string.modify();
            int n3 = n2 > stringIOData.pos ? 0 : stringIOData.pos - n2;
            ByteList byteList = stringIOData.string.getByteList();
            if (this.isEndOfString()) {
                byteList.length(Math.max(stringIOData.pos, n2));
            }
            byteList.replace(n3, stringIOData.pos - n3, byArray, n, n2);
            stringIOData.pos = n3;
        }
    }

    @JRubyMethod
    public IRubyObject ungetbyte(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.checkReadable();
        if (iRubyObject.isNil()) {
            return iRubyObject;
        }
        this.checkModifiable();
        if (iRubyObject instanceof RubyInteger) {
            this.ungetbyteCommon(((RubyInteger)((RubyInteger)iRubyObject).op_mod(threadContext, 256L)).getIntValue());
        } else {
            this.ungetbyteCommon(iRubyObject.convertToString());
        }
        return threadContext.nil;
    }

    @JRubyMethod(name={"write"})
    public IRubyObject write(ThreadContext threadContext, IRubyObject iRubyObject) {
        Ruby ruby = threadContext.runtime;
        return RubyFixnum.newFixnum((Ruby)ruby, (long)this.stringIOWrite(threadContext, ruby, iRubyObject));
    }

    @JRubyMethod(name={"write"}, required=1, rest=true)
    public IRubyObject write(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        Ruby ruby = threadContext.runtime;
        long l = 0L;
        for (IRubyObject iRubyObject : iRubyObjectArray) {
            l += this.stringIOWrite(threadContext, ruby, iRubyObject);
        }
        return RubyFixnum.newFixnum((Ruby)ruby, (long)l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long stringIOWrite(ThreadContext threadContext, Ruby ruby, IRubyObject iRubyObject) {
        int n;
        StringIOData stringIOData;
        this.checkWritable();
        RubyString rubyString = iRubyObject.asString();
        StringIOData stringIOData2 = stringIOData = this.ptr;
        synchronized (stringIOData2) {
            Encoding encoding = this.getEncoding();
            Encoding encoding2 = rubyString.getEncoding();
            if (encoding != encoding2 && encoding != EncodingUtils.ascii8bitEncoding((Ruby)ruby) && encoding2 != ASCIIEncoding.INSTANCE) {
                rubyString = EncodingUtils.strConvEnc((ThreadContext)threadContext, (RubyString)rubyString, (Encoding)encoding2, (Encoding)encoding);
            }
            ByteList byteList = rubyString.getByteList();
            n = rubyString.size();
            if (n == 0) {
                return 0L;
            }
            this.checkModifiable();
            int n2 = stringIOData.string.size();
            if ((stringIOData.flags & 0x40) != 0) {
                stringIOData.pos = n2;
            }
            if (stringIOData.pos == n2) {
                if (encoding == EncodingUtils.ascii8bitEncoding((Ruby)ruby) || encoding2 == EncodingUtils.ascii8bitEncoding((Ruby)ruby)) {
                    EncodingUtils.encStrBufCat((Ruby)ruby, (RubyString)stringIOData.string, (ByteList)byteList, (Encoding)encoding);
                } else {
                    stringIOData.string.cat19(rubyString);
                }
            } else {
                this.strioExtend(stringIOData.pos, n);
                ByteList byteList2 = stringIOData.string.getByteList();
                System.arraycopy(byteList.getUnsafeBytes(), byteList.getBegin(), byteList2.getUnsafeBytes(), byteList2.begin() + stringIOData.pos, n);
            }
            stringIOData.pos += n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod
    public IRubyObject set_encoding(ThreadContext threadContext, IRubyObject iRubyObject) {
        StringIOData stringIOData;
        Encoding encoding = iRubyObject.isNil() ? EncodingUtils.defaultExternalEncoding((Ruby)threadContext.runtime) : EncodingUtils.rbToEncoding((ThreadContext)threadContext, (IRubyObject)iRubyObject);
        StringIOData stringIOData2 = stringIOData = this.ptr;
        synchronized (stringIOData2) {
            RubyString rubyString;
            stringIOData.enc = encoding;
            if (this.writable() && (rubyString = stringIOData.string).getEncoding() != encoding) {
                rubyString.modify();
                rubyString.setEncoding(encoding);
            }
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject set_encoding(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return this.set_encoding(threadContext, iRubyObject);
    }

    @JRubyMethod
    public IRubyObject set_encoding(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        return this.set_encoding(threadContext, iRubyObject);
    }

    @JRubyMethod
    public IRubyObject external_encoding(ThreadContext threadContext) {
        return threadContext.runtime.getEncodingService().convertEncodingToRubyEncoding(this.getEncoding());
    }

    @JRubyMethod
    public IRubyObject internal_encoding(ThreadContext threadContext) {
        return threadContext.nil;
    }

    @JRubyMethod(name={"each_codepoint"})
    public IRubyObject each_codepoint(ThreadContext threadContext, Block block) {
        StringIOData stringIOData;
        Ruby ruby = threadContext.runtime;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize((Ruby)ruby, (IRubyObject)this, (String)"each_codepoint");
        }
        this.checkReadable();
        StringIOData stringIOData2 = stringIOData = this.ptr;
        synchronized (stringIOData2) {
            Encoding encoding = this.getEncoding();
            ByteList byteList = stringIOData.string.getByteList();
            byte[] byArray = byteList.getUnsafeBytes();
            int n = byteList.getBegin();
            while (true) {
                if (stringIOData.pos >= stringIOData.string.size()) {
                    return this;
                }
                int n2 = StringSupport.codePoint((Ruby)ruby, (Encoding)encoding, (byte[])byArray, (int)(n + stringIOData.pos), (int)byArray.length);
                int n3 = StringSupport.codeLength((Encoding)encoding, (int)n2);
                block.yield(threadContext, (IRubyObject)ruby.newFixnum(n2));
                stringIOData.pos += n3;
            }
        }
    }

    @JRubyMethod(name={"codepoints"})
    public IRubyObject codepoints(ThreadContext threadContext, Block block) {
        Ruby ruby = threadContext.runtime;
        ruby.getWarnings().warn("StringIO#codepoints is deprecated; use #each_codepoint");
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize((Ruby)ruby, (IRubyObject)this, (String)"each_codepoint");
        }
        return this.each_codepoint(threadContext, block);
    }

    public IRubyObject puts(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        return GenericWritable.puts(threadContext, (IRubyObject)this, iRubyObjectArray);
    }

    public void checkFrozen() {
        super.checkFrozen();
        this.checkInitialized();
    }

    private boolean readable() {
        return (this.flags & 0x10) != 0 && (this.ptr.flags & 1) != 0;
    }

    private boolean writable() {
        return (this.flags & 0x20) != 0 && (this.ptr.flags & 2) != 0;
    }

    private boolean closed() {
        return (this.flags & 0x30) == 0 || (this.ptr.flags & 3) == 0;
    }

    private void checkReadable() {
        this.checkInitialized();
        if (!this.readable()) {
            throw this.getRuntime().newIOError("not opened for reading");
        }
    }

    private void checkWritable() {
        this.checkInitialized();
        if (!this.writable()) {
            throw this.getRuntime().newIOError("not opened for writing");
        }
    }

    private void checkModifiable() {
        this.checkFrozen();
        if (this.ptr.string.isFrozen()) {
            throw this.getRuntime().newIOError("not modifiable string");
        }
    }

    private void checkInitialized() {
        if (this.ptr == null) {
            throw this.getRuntime().newIOError("uninitialized stream");
        }
    }

    private void checkFinalized() {
        if (this.ptr.string == null) {
            throw this.getRuntime().newIOError("not opened");
        }
    }

    private void checkOpen() {
        if (this.closed()) {
            throw this.getRuntime().newIOError("closed stream");
        }
    }

    public static class GenericWritable {
        @JRubyMethod(name={"<<"}, required=1)
        public static IRubyObject append(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            iRubyObject.callMethod(threadContext, "write", iRubyObject2);
            return iRubyObject;
        }

        @JRubyMethod(name={"print"}, rest=true, writes={FrameField.LASTLINE})
        public static IRubyObject print(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
            return RubyIO.print((ThreadContext)threadContext, (IRubyObject)iRubyObject, (IRubyObject[])iRubyObjectArray);
        }

        @JRubyMethod(name={"printf"}, required=1, rest=true)
        public static IRubyObject printf(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
            iRubyObject.callMethod(threadContext, "write", RubyKernel.sprintf((ThreadContext)threadContext, (IRubyObject)iRubyObject, (IRubyObject[])iRubyObjectArray));
            return threadContext.nil;
        }

        /*
         * Enabled aggressive block sorting
         */
        @JRubyMethod(name={"puts"}, rest=true)
        public static IRubyObject puts(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
            Ruby ruby = threadContext.runtime;
            if (iRubyObjectArray.length == 0) {
                RubyIO.write((ThreadContext)threadContext, (IRubyObject)iRubyObject, (IRubyObject)RubyString.newStringShared((Ruby)ruby, (ByteList)NEWLINE));
                return ruby.getNil();
            }
            int n = 0;
            while (true) {
                block8: {
                    RubyString rubyString;
                    block5: {
                        block6: {
                            RubyArray rubyArray;
                            block7: {
                                if (n >= iRubyObjectArray.length) {
                                    return ruby.getNil();
                                }
                                rubyString = null;
                                if (iRubyObjectArray[n].isNil()) break block5;
                                IRubyObject iRubyObject2 = iRubyObjectArray[n].checkArrayType();
                                if (iRubyObject2.isNil()) break block6;
                                rubyArray = (RubyArray)iRubyObject2;
                                if (!ruby.isInspecting((Object)rubyArray)) break block7;
                                rubyString = ruby.newString("[...]");
                                break block5;
                            }
                            GenericWritable.inspectPuts(threadContext, iRubyObject, rubyArray);
                            break block8;
                        }
                        rubyString = iRubyObjectArray[n] instanceof RubyString ? (RubyString)iRubyObjectArray[n] : iRubyObjectArray[n].asString();
                    }
                    if (rubyString != null) {
                        RubyIO.write((ThreadContext)threadContext, (IRubyObject)iRubyObject, rubyString);
                    }
                    if (rubyString == null || !rubyString.getByteList().endsWith(NEWLINE)) {
                        RubyIO.write((ThreadContext)threadContext, (IRubyObject)iRubyObject, (IRubyObject)RubyString.newStringShared((Ruby)ruby, (ByteList)NEWLINE));
                    }
                }
                ++n;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static IRubyObject inspectPuts(ThreadContext threadContext, IRubyObject iRubyObject, RubyArray rubyArray) {
            Ruby ruby = threadContext.runtime;
            try {
                ruby.registerInspecting((Object)rubyArray);
                IRubyObject iRubyObject2 = GenericWritable.puts(threadContext, iRubyObject, rubyArray.toJavaArray());
                return iRubyObject2;
            }
            finally {
                ruby.unregisterInspecting((Object)rubyArray);
            }
        }

        @JRubyMethod(name={"syswrite"}, required=1)
        public static IRubyObject syswrite(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            return RubyIO.write((ThreadContext)threadContext, (IRubyObject)iRubyObject, (IRubyObject)iRubyObject2);
        }

        @JRubyMethod(name={"write_nonblock"}, required=1, optional=1)
        public static IRubyObject syswrite_nonblock(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
            Ruby ruby = threadContext.runtime;
            ArgsUtil.getOptionsArg((Ruby)ruby, (IRubyObject[])iRubyObjectArray);
            return GenericWritable.syswrite(threadContext, iRubyObject, iRubyObjectArray[0]);
        }
    }

    public static class GenericReadable {
        @JRubyMethod(name={"readchar"})
        public static IRubyObject readchar(ThreadContext threadContext, IRubyObject iRubyObject) {
            IRubyObject iRubyObject2 = iRubyObject.callMethod(threadContext, "getc");
            if (iRubyObject2.isNil()) {
                throw threadContext.runtime.newEOFError();
            }
            return iRubyObject2;
        }

        @JRubyMethod(name={"readbyte"})
        public static IRubyObject readbyte(ThreadContext threadContext, IRubyObject iRubyObject) {
            IRubyObject iRubyObject2 = iRubyObject.callMethod(threadContext, "getbyte");
            if (iRubyObject2.isNil()) {
                throw threadContext.runtime.newEOFError();
            }
            return iRubyObject2;
        }

        @JRubyMethod(name={"readline"}, optional=1, writes={FrameField.LASTLINE})
        public static IRubyObject readline(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
            IRubyObject iRubyObject2 = iRubyObject.callMethod(threadContext, "gets", iRubyObjectArray);
            if (iRubyObject2.isNil()) {
                throw threadContext.runtime.newEOFError();
            }
            return iRubyObject2;
        }

        @JRubyMethod(name={"sysread", "readpartial"}, optional=2)
        public static IRubyObject sysread(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
            IRubyObject iRubyObject2 = iRubyObject.callMethod(threadContext, "read", iRubyObjectArray);
            if (iRubyObject2.isNil()) {
                throw threadContext.runtime.newEOFError();
            }
            return iRubyObject2;
        }

        @JRubyMethod(name={"read_nonblock"}, required=1, optional=2)
        public static IRubyObject read_nonblock(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
            IRubyObject iRubyObject2;
            Ruby ruby = threadContext.runtime;
            boolean bl = true;
            IRubyObject iRubyObject3 = ArgsUtil.getOptionsArg((Ruby)ruby, (IRubyObject[])iRubyObjectArray);
            if (iRubyObject3 != threadContext.nil) {
                iRubyObjectArray = ArraySupport.newCopy((IRubyObject[])iRubyObjectArray, (int)(iRubyObjectArray.length - 1));
                bl = Helpers.extractExceptionOnlyArg((ThreadContext)threadContext, (RubyHash)((RubyHash)iRubyObject3));
            }
            if ((iRubyObject2 = iRubyObject.callMethod(threadContext, "read", iRubyObjectArray)) == threadContext.nil) {
                if (!bl) {
                    return threadContext.nil;
                }
                throw ruby.newEOFError();
            }
            return iRubyObject2;
        }
    }

    static class StringIOData {
        RubyString string;
        Encoding enc;
        int pos;
        int lineno;
        int flags;

        StringIOData() {
        }
    }
}

