/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialogEinstellungen;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jiconfont.icons.font_awesome.FontAwesome;
import jiconfont.swing.IconFontSwing;
import mediathek.config.MVConfig;
import mediathek.controller.SenderFilmlistLoadApprover;
import mediathek.gui.messages.FilmListImportTypeChangedEvent;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.FileDialogs;
import mediathek.tool.FilmListUpdateType;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.MessageBus;
import mediathek.tool.TextCopyPasteHandler;
import mediathek.tool.swing.MultilineLabel;
import net.engio.mbassy.listener.Handler;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.configuration2.Configuration;

public class PanelFilmlisteLaden
extends JPanel {
    private final List<JCheckBox> senderCbList = new ArrayList<JCheckBox>();
    private JLabel lblUrl;
    private JTextField jTextFieldUrl;
    private JButton jButtonDateiAuswaehlen;
    private JCheckBox jCheckBoxUpdate;
    private JRadioButton jRadioButtonAuto;
    private JRadioButton jRadioButtonManuell;
    private JCheckBox cbSign;
    private JCheckBox cbTrailer;
    private JCheckBox cbAudio;
    private JCheckBox cbLivestreams;
    private JCheckBox checkBox1;
    private JCheckBox checkBox2;
    private JCheckBox checkBox3;
    private JCheckBox checkBox4;
    private JCheckBox checkBox5;
    private JCheckBox checkBox6;
    private JCheckBox checkBox8;
    private JCheckBox checkBox11;
    private JCheckBox checkBox14;
    private JCheckBox checkBox17;
    private JCheckBox checkBox20;
    private JCheckBox checkBox7;
    private JCheckBox checkBox9;
    private JCheckBox checkBox12;
    private JCheckBox checkBox15;
    private JCheckBox checkBox18;
    private JCheckBox checkBox21;
    private JCheckBox checkBox10;
    private JCheckBox checkBox13;
    private JCheckBox checkBox16;
    private JCheckBox checkBox19;
    private JCheckBox checkBox22;

    public PanelFilmlisteLaden(boolean inSettingsDialog) {
        MessageBus.getMessageBus().subscribe(this);
        this.initComponents();
        this.init();
        this.setupCheckBoxes();
        if (inSettingsDialog) {
            this.prepareSettingsLayout();
        }
        this.setupSenderList();
        this.senderCbList.forEach(cb -> cb.setSelected(SenderFilmlistLoadApprover.isApproved(cb.getText())));
        this.senderCbList.forEach(cb -> cb.addItemListener(this::senderSelectionItemHandler));
        this.jRadioButtonManuell.addChangeListener(l -> {
            boolean selected = this.jRadioButtonManuell.isSelected();
            this.jTextFieldUrl.setEnabled(selected);
            this.jButtonDateiAuswaehlen.setEnabled(selected);
            this.jCheckBoxUpdate.setEnabled(selected);
        });
    }

    private void prepareSettingsLayout() {
        this.lblUrl.setVisible(false);
        this.jTextFieldUrl.setVisible(false);
        this.jButtonDateiAuswaehlen.setVisible(false);
    }

    private void setupCheckBoxes() {
        Configuration config = ApplicationConfiguration.getConfiguration();
        this.cbSign.setSelected(config.getBoolean("filmlist.load.sign_language", true));
        this.cbSign.addActionListener(e -> config.setProperty("filmlist.load.sign_language", this.cbSign.isSelected()));
        this.cbAudio.setSelected(config.getBoolean("filmlist.load.audio_description", true));
        this.cbAudio.addActionListener(e -> config.setProperty("filmlist.load.audio_description", this.cbAudio.isSelected()));
        this.cbTrailer.setSelected(config.getBoolean("filmlist.load.trailer", true));
        this.cbTrailer.addActionListener(e -> config.setProperty("filmlist.load.trailer", this.cbTrailer.isSelected()));
        this.cbLivestreams.setSelected(config.getBoolean("filmlist.load.livestreams", true));
        this.cbLivestreams.addActionListener(e -> config.setProperty("filmlist.load.livestreams", this.cbLivestreams.isSelected()));
        this.jCheckBoxUpdate.setSelected(config.getBoolean("filmlist.extend_old_filmlist", false));
        this.jCheckBoxUpdate.addActionListener(e -> config.setProperty("filmlist.extend_old_filmlist", this.jCheckBoxUpdate.isSelected()));
    }

    private void setupSenderList() {
        this.senderCbList.add(this.checkBox1);
        this.senderCbList.add(this.checkBox2);
        this.senderCbList.add(this.checkBox3);
        this.senderCbList.add(this.checkBox4);
        this.senderCbList.add(this.checkBox5);
        this.senderCbList.add(this.checkBox6);
        this.senderCbList.add(this.checkBox8);
        this.senderCbList.add(this.checkBox7);
        this.senderCbList.add(this.checkBox9);
        this.senderCbList.add(this.checkBox10);
        this.senderCbList.add(this.checkBox11);
        this.senderCbList.add(this.checkBox12);
        this.senderCbList.add(this.checkBox13);
        this.senderCbList.add(this.checkBox14);
        this.senderCbList.add(this.checkBox15);
        this.senderCbList.add(this.checkBox16);
        this.senderCbList.add(this.checkBox17);
        this.senderCbList.add(this.checkBox18);
        this.senderCbList.add(this.checkBox19);
        this.senderCbList.add(this.checkBox20);
        this.senderCbList.add(this.checkBox21);
        this.senderCbList.add(this.checkBox22);
    }

    private void senderSelectionItemHandler(ItemEvent e) {
        JCheckBox cb = (JCheckBox)e.getSource();
        boolean selected = cb.isSelected();
        String sender = cb.getText();
        if (selected) {
            SenderFilmlistLoadApprover.approve(sender);
        } else {
            SenderFilmlistLoadApprover.deny(sender);
        }
    }

    private void init() {
        this.initRadio();
        this.jButtonDateiAuswaehlen.setIcon(IconFontSwing.buildIcon(FontAwesome.FOLDER_OPEN_O, 16.0f));
        this.jButtonDateiAuswaehlen.addActionListener(l -> {
            File loadFile = FileDialogs.chooseLoadFileLocation(MediathekGui.ui(), "Filmliste laden", "");
            if (loadFile != null) {
                this.jTextFieldUrl.setText(loadFile.getAbsolutePath());
            }
        });
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PanelFilmlisteLaden.this.jRadioButtonManuell.isSelected()) {
                    GuiFunktionen.setFilmListUpdateType(FilmListUpdateType.MANUAL);
                } else {
                    GuiFunktionen.setFilmListUpdateType(FilmListUpdateType.AUTOMATIC);
                }
                MessageBus.getMessageBus().publishAsync(new FilmListImportTypeChangedEvent());
            }
        };
        this.jRadioButtonManuell.addActionListener(listener);
        this.jRadioButtonAuto.addActionListener(listener);
        this.jTextFieldUrl.getDocument().addDocumentListener(new BeobDateiUrl());
        TextCopyPasteHandler<JTextField> handler = new TextCopyPasteHandler<JTextField>(this.jTextFieldUrl);
        this.jTextFieldUrl.setComponentPopupMenu(handler.getPopupMenu());
    }

    @Handler
    private void handleFilmListImportTypeChanged(FilmListImportTypeChangedEvent e) {
        SwingUtilities.invokeLater(this::initRadio);
    }

    private void initRadio() {
        switch (GuiFunktionen.getFilmListUpdateType()) {
            case MANUAL: {
                this.jRadioButtonManuell.setSelected(true);
                break;
            }
            case AUTOMATIC: {
                this.jRadioButtonAuto.setSelected(true);
            }
        }
        this.jTextFieldUrl.setText(MVConfig.get(MVConfig.Configs.SYSTEM_IMPORT_URL_MANUELL));
    }

    public JCheckBox getJCheckBoxUpdate() {
        return this.jCheckBoxUpdate;
    }

    public JTextField getJTextFieldUrl() {
        return this.jTextFieldUrl;
    }

    private void initComponents() {
        JPanel jPanelAuto = new JPanel();
        MultilineLabel multilineLabel1 = new MultilineLabel();
        JPanel jPanelManuel = new JPanel();
        MultilineLabel multilineLabel2 = new MultilineLabel();
        this.lblUrl = new JLabel();
        this.jTextFieldUrl = new JTextField();
        this.jButtonDateiAuswaehlen = new JButton();
        this.jCheckBoxUpdate = new JCheckBox();
        this.jRadioButtonAuto = new JRadioButton();
        this.jRadioButtonManuell = new JRadioButton();
        JSeparator separator1 = new JSeparator();
        JPanel jPanel1 = new JPanel();
        this.cbSign = new JCheckBox();
        this.cbTrailer = new JCheckBox();
        this.cbAudio = new JCheckBox();
        this.cbLivestreams = new JCheckBox();
        JPanel panel1 = new JPanel();
        this.checkBox1 = new JCheckBox();
        this.checkBox2 = new JCheckBox();
        this.checkBox3 = new JCheckBox();
        this.checkBox4 = new JCheckBox();
        this.checkBox5 = new JCheckBox();
        this.checkBox6 = new JCheckBox();
        this.checkBox8 = new JCheckBox();
        this.checkBox11 = new JCheckBox();
        this.checkBox14 = new JCheckBox();
        this.checkBox17 = new JCheckBox();
        this.checkBox20 = new JCheckBox();
        this.checkBox7 = new JCheckBox();
        this.checkBox9 = new JCheckBox();
        this.checkBox12 = new JCheckBox();
        this.checkBox15 = new JCheckBox();
        this.checkBox18 = new JCheckBox();
        this.checkBox21 = new JCheckBox();
        this.checkBox10 = new JCheckBox();
        this.checkBox13 = new JCheckBox();
        this.checkBox16 = new JCheckBox();
        this.checkBox19 = new JCheckBox();
        this.checkBox22 = new JCheckBox();
        this.setMinimumSize(null);
        this.setPreferredSize(new Dimension(740, 450));
        this.setLayout(new MigLayout(new LC().insets("5").hideMode(3).gridGap("5", "5"), new AC().align("label").gap().size("640").grow().fill(), new AC().gap().gap().gap().gap()));
        jPanelAuto.setBorder(new TitledBorder("Die Filmliste automatisch laden"));
        jPanelAuto.setLayout(new MigLayout(new LC().insets("5").hideMode(3).gridGap("5", "5"), new AC().grow().fill().gap().grow().fill(), new AC().fill()));
        multilineLabel1.setText("Die Filmliste wird beim Programmstart automatisch geladen (wenn \u00e4lter als 3h). Zus\u00e4tzlich kann sie \u00fcber den Button \"Filmliste laden\" aktualisiert werden.");
        multilineLabel1.setFont(multilineLabel1.getFont().deriveFont((float)multilineLabel1.getFont().getSize() - 1.0f));
        jPanelAuto.add((Component)multilineLabel1, new CC().cell(0, 0, 2, 1));
        this.add((Component)jPanelAuto, new CC().cell(1, 0));
        jPanelManuel.setBorder(new TitledBorder("Filmliste nur manuell laden"));
        jPanelManuel.setLayout(new MigLayout(new LC().insets("5").hideMode(3).gridGap("5", "5"), new AC().fill().gap().grow().fill().gap().fill().gap().fill(), new AC().fill().gap().fill().gap().fill()));
        multilineLabel2.setText("Die Filmliste wird nur manuell \u00fcber den Button \"Filmliste laden\" aus dem Internet geladen. Alternativ kann auch eine Datei zum Laden angegeben werden.");
        multilineLabel2.setFont(multilineLabel2.getFont().deriveFont((float)multilineLabel2.getFont().getSize() - 1.0f));
        jPanelManuel.add((Component)multilineLabel2, new CC().cell(0, 0, 4, 1));
        this.lblUrl.setText("Datei:");
        jPanelManuel.add((Component)this.lblUrl, new CC().cell(0, 1));
        jPanelManuel.add((Component)this.jTextFieldUrl, new CC().cell(1, 1, 2, 1));
        this.jButtonDateiAuswaehlen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-file-open.png")));
        this.jButtonDateiAuswaehlen.setToolTipText("URL oder lokale Filmliste ausw\u00e4hlen");
        jPanelManuel.add((Component)this.jButtonDateiAuswaehlen, new CC().cell(3, 1).alignX("left").growX(0.0f).width("32:32:32").height("32:32:32"));
        this.jCheckBoxUpdate.setText("Alte Filmliste nicht l\u00f6schen, nur erweitern");
        jPanelManuel.add((Component)this.jCheckBoxUpdate, new CC().cell(0, 2, 2, 1));
        this.add((Component)jPanelManuel, new CC().cell(1, 1));
        this.add((Component)this.jRadioButtonAuto, new CC().cell(0, 0).alignY("top").growY(0.0f));
        this.add((Component)this.jRadioButtonManuell, new CC().cell(0, 1).alignY("top").growY(0.0f));
        this.add((Component)separator1, new CC().cell(0, 2, 2, 1).growX());
        jPanel1.setBorder(new TitledBorder("Zus\u00e4tzliche Filmdaten laden"));
        jPanel1.setToolTipText("<html>Alle nicht angew\u00e4hlten Eintr\u00e4ge werden beim Laden der Filmliste aus dem Endergebnis herausgefiltert.<br/><b>Die Eintr\u00e4ge werden dauerhaft aus der lokalen Filmliste entfernt.</b><br/>Sie werden erst wieder beim Laden einer neuen Liste vom Server hinzugef\u00fcgt wenn die Einstellungen entsprechend angepasst wurden.</html>");
        jPanel1.setLayout(new MigLayout(new LC().insets("5").hideMode(3).gridGap("5", "5"), new AC().fill().gap().fill().gap().fill().gap().fill(), new AC().fill()));
        this.cbSign.setText("Geb\u00e4rdensprache");
        jPanel1.add((Component)this.cbSign, new CC().cell(2, 0));
        this.cbTrailer.setText("Trailer/Teaser/Vorschau");
        jPanel1.add((Component)this.cbTrailer, new CC().cell(0, 0));
        this.cbAudio.setText("H\u00f6rfassungen");
        jPanel1.add((Component)this.cbAudio, new CC().cell(1, 0));
        this.cbLivestreams.setText("Livestreams");
        jPanel1.add((Component)this.cbLivestreams, new CC().cell(3, 0));
        this.add((Component)jPanel1, new CC().cell(0, 3, 2, 1).growX());
        panel1.setBorder(new TitledBorder("Diese Sender laden (Neustart ggf. erforderlich)"));
        panel1.setToolTipText("<html>Die Einstellung bezieht sich auf den n\u00e4chsten <b>vollst\u00e4ndigen</b> Ladevorgang einer Fillmliste.<br>Es kann somit vorkommen dass die Aktualisierung erst nach Neustart des Programms sichtbar wird.</html>");
        panel1.setLayout(new MigLayout(new LC().insets("5").hideMode(3).alignX("left").gridGapX("10"), new AC().fill().gap().fill().gap().fill().gap().fill().gap().fill().gap().fill(), new AC().gap().gap().gap()));
        this.checkBox1.setText("3Sat");
        panel1.add((Component)this.checkBox1, new CC().cell(0, 0));
        this.checkBox2.setText("BR");
        panel1.add((Component)this.checkBox2, new CC().cell(1, 0));
        this.checkBox3.setText("MDR");
        panel1.add((Component)this.checkBox3, new CC().cell(2, 0));
        this.checkBox4.setText("Radio Bremen TV");
        panel1.add((Component)this.checkBox4, new CC().cell(3, 0));
        this.checkBox5.setText("SRF.Podcast");
        panel1.add((Component)this.checkBox5, new CC().cell(4, 0));
        this.checkBox6.setText("ZDF-tivi");
        panel1.add((Component)this.checkBox6, new CC().cell(5, 0));
        this.checkBox8.setText("ARD");
        panel1.add((Component)this.checkBox8, new CC().cell(0, 1));
        this.checkBox11.setText("DW");
        panel1.add((Component)this.checkBox11, new CC().cell(1, 1));
        this.checkBox14.setText("NDR");
        panel1.add((Component)this.checkBox14, new CC().cell(2, 1));
        this.checkBox17.setText("RBB");
        panel1.add((Component)this.checkBox17, new CC().cell(3, 1));
        this.checkBox20.setText("SWR");
        panel1.add((Component)this.checkBox20, new CC().cell(4, 1));
        this.checkBox7.setText("Funk.net");
        panel1.add((Component)this.checkBox7, new CC().cell(5, 1));
        this.checkBox9.setText("ARTE.DE");
        panel1.add((Component)this.checkBox9, new CC().cell(0, 2));
        this.checkBox12.setText("HR");
        panel1.add((Component)this.checkBox12, new CC().cell(1, 2));
        this.checkBox15.setText("ORF");
        panel1.add((Component)this.checkBox15, new CC().cell(2, 2));
        this.checkBox18.setText("SR");
        panel1.add((Component)this.checkBox18, new CC().cell(3, 2));
        this.checkBox21.setText("WDR");
        panel1.add((Component)this.checkBox21, new CC().cell(4, 2));
        this.checkBox10.setText("ARTE.FR");
        panel1.add((Component)this.checkBox10, new CC().cell(0, 3));
        this.checkBox13.setText("KiKA");
        panel1.add((Component)this.checkBox13, new CC().cell(1, 3));
        this.checkBox16.setText("PHOENIX");
        panel1.add((Component)this.checkBox16, new CC().cell(2, 3));
        this.checkBox19.setText("SRF");
        panel1.add((Component)this.checkBox19, new CC().cell(3, 3));
        this.checkBox22.setText("ZDF");
        panel1.add((Component)this.checkBox22, new CC().cell(4, 3));
        this.add((Component)panel1, new CC().cell(0, 4, 2, 1).growX());
        ButtonGroup buttonGroup1 = new ButtonGroup();
        buttonGroup1.add(this.jRadioButtonAuto);
        buttonGroup1.add(this.jRadioButtonManuell);
    }

    private class BeobDateiUrl
    implements DocumentListener {
        private BeobDateiUrl() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.turnOnManualImport();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.turnOnManualImport();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.turnOnManualImport();
        }

        private void turnOnManualImport() {
            MVConfig.add(MVConfig.Configs.SYSTEM_IMPORT_URL_MANUELL, PanelFilmlisteLaden.this.jTextFieldUrl.getText());
        }
    }
}

