/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mediathek.tool.GuiFunktionen;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\f\u001a\u00020\rR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\t\u00a8\u0006\u000f"}, d2={"Lmediathek/tool/FileSpecifier;", "", "path", "", "fileName", "(Ljava/lang/String;Ljava/lang/String;)V", "getFileName", "()Ljava/lang/String;", "setFileName", "(Ljava/lang/String;)V", "getPath", "setPath", "checkLength", "", "Companion", "MediathekView"})
public final class FileSpecifier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String path;
    @NotNull
    private String fileName;
    private static final int WIN_MAX_PATH_LENGTH = 250;
    private static final int X_MAX_NAME_LENGTH = 255;
    private static final Logger logger = LogManager.getLogger();

    public FileSpecifier(@NotNull String path, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        this.path = path;
        this.fileName = fileName;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    public final void setPath(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.path = string;
    }

    @NotNull
    public final String getFileName() {
        return this.fileName;
    }

    public final void setFileName(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.fileName = string;
    }

    public final void checkLength() {
        if (SystemUtils.IS_OS_WINDOWS) {
            if (this.path.length() + 10 > 250) {
                logger.error("Path too long: {}", (Object)this.path);
                String string = SystemUtils.USER_HOME;
                Intrinsics.checkNotNullExpressionValue(string, "USER_HOME");
                this.path = string;
            }
            if (this.path.length() + this.fileName.length() > 250) {
                logger.error("FileSpecifier too long: {}", (Object)this.path);
                int maxNameL = 250 - this.path.length();
                String string = GuiFunktionen.cutName(this.fileName, maxNameL);
                Intrinsics.checkNotNullExpressionValue(string, "cutName(fileName, maxNameL)");
                this.fileName = string;
            }
        } else if (this.fileName.length() > 255) {
            logger.error("Name too long: {}", (Object)this.fileName);
            String string = GuiFunktionen.cutName(this.fileName, 255);
            Intrinsics.checkNotNullExpressionValue(string, "cutName(fileName, X_MAX_NAME_LENGTH)");
            this.fileName = string;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lmediathek/tool/FileSpecifier$Companion;", "", "()V", "WIN_MAX_PATH_LENGTH", "", "X_MAX_NAME_LENGTH", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "MediathekView"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

