# Configurations
<!-- *lspconfig-server-configurations* -->

The following LSP configs are included. This documentation is autogenerated from the lua files. Follow a link to find documentation for
that config. This file is accessible in neovim via `:help lspconfig-server-configurations`

- [als](#als)
- [angularls](#angularls)
- [ansiblels](#ansiblels)
- [arduino_language_server](#arduino_language_server)
- [asm_lsp](#asm_lsp)
- [awk_ls](#awk_ls)
- [bashls](#bashls)
- [beancount](#beancount)
- [bicep](#bicep)
- [bsl_ls](#bsl_ls)
- [ccls](#ccls)
- [clangd](#clangd)
- [clarity_lsp](#clarity_lsp)
- [clojure_lsp](#clojure_lsp)
- [cmake](#cmake)
- [codeqlls](#codeqlls)
- [crystalline](#crystalline)
- [csharp_ls](#csharp_ls)
- [cssls](#cssls)
- [cssmodules_ls](#cssmodules_ls)
- [cucumber_language_server](#cucumber_language_server)
- [dartls](#dartls)
- [denols](#denols)
- [dhall_lsp_server](#dhall_lsp_server)
- [diagnosticls](#diagnosticls)
- [dockerls](#dockerls)
- [dotls](#dotls)
- [efm](#efm)
- [elixirls](#elixirls)
- [elmls](#elmls)
- [ember](#ember)
- [emmet_ls](#emmet_ls)
- [erlangls](#erlangls)
- [esbonio](#esbonio)
- [eslint](#eslint)
- [flow](#flow)
- [flux_lsp](#flux_lsp)
- [foam_ls](#foam_ls)
- [fortls](#fortls)
- [fsautocomplete](#fsautocomplete)
- [fstar](#fstar)
- [gdscript](#gdscript)
- [ghcide](#ghcide)
- [golangci_lint_ls](#golangci_lint_ls)
- [gopls](#gopls)
- [gradle_ls](#gradle_ls)
- [grammarly](#grammarly)
- [graphql](#graphql)
- [groovyls](#groovyls)
- [haxe_language_server](#haxe_language_server)
- [hdl_checker](#hdl_checker)
- [hhvm](#hhvm)
- [hie](#hie)
- [hls](#hls)
- [hoon_ls](#hoon_ls)
- [html](#html)
- [idris2_lsp](#idris2_lsp)
- [intelephense](#intelephense)
- [java_language_server](#java_language_server)
- [jdtls](#jdtls)
- [jedi_language_server](#jedi_language_server)
- [jsonls](#jsonls)
- [jsonnet_ls](#jsonnet_ls)
- [julials](#julials)
- [kotlin_language_server](#kotlin_language_server)
- [lean3ls](#lean3ls)
- [leanls](#leanls)
- [lelwel_ls](#lelwel_ls)
- [lemminx](#lemminx)
- [ltex](#ltex)
- [metals](#metals)
- [mint](#mint)
- [mm0_ls](#mm0_ls)
- [nickel_ls](#nickel_ls)
- [nimls](#nimls)
- [ocamlls](#ocamlls)
- [ocamllsp](#ocamllsp)
- [ols](#ols)
- [omnisharp](#omnisharp)
- [opencl_ls](#opencl_ls)
- [openscad_ls](#openscad_ls)
- [pasls](#pasls)
- [perlls](#perlls)
- [perlnavigator](#perlnavigator)
- [perlpls](#perlpls)
- [phpactor](#phpactor)
- [please](#please)
- [powershell_es](#powershell_es)
- [prismals](#prismals)
- [prosemd_lsp](#prosemd_lsp)
- [psalm](#psalm)
- [puppet](#puppet)
- [purescriptls](#purescriptls)
- [pylsp](#pylsp)
- [pyre](#pyre)
- [pyright](#pyright)
- [quick_lint_js](#quick_lint_js)
- [r_language_server](#r_language_server)
- [racket_langserver](#racket_langserver)
- [reason_ls](#reason_ls)
- [remark_ls](#remark_ls)
- [rescriptls](#rescriptls)
- [rls](#rls)
- [rnix](#rnix)
- [robotframework_ls](#robotframework_ls)
- [rome](#rome)
- [rust_analyzer](#rust_analyzer)
- [salt_ls](#salt_ls)
- [scry](#scry)
- [serve_d](#serve_d)
- [sixtyfps](#sixtyfps)
- [slint_lsp](#slint_lsp)
- [solang](#solang)
- [solargraph](#solargraph)
- [solc](#solc)
- [solidity_ls](#solidity_ls)
- [sorbet](#sorbet)
- [sourcekit](#sourcekit)
- [sourcery](#sourcery)
- [spectral](#spectral)
- [sqlls](#sqlls)
- [sqls](#sqls)
- [stylelint_lsp](#stylelint_lsp)
- [sumneko_lua](#sumneko_lua)
- [svelte](#svelte)
- [svls](#svls)
- [tailwindcss](#tailwindcss)
- [taplo](#taplo)
- [teal_ls](#teal_ls)
- [terraform_lsp](#terraform_lsp)
- [terraformls](#terraformls)
- [texlab](#texlab)
- [tflint](#tflint)
- [theme_check](#theme_check)
- [tsserver](#tsserver)
- [typeprof](#typeprof)
- [vala_ls](#vala_ls)
- [vdmj](#vdmj)
- [verible](#verible)
- [vimls](#vimls)
- [vls](#vls)
- [volar](#volar)
- [vuels](#vuels)
- [yamlls](#yamlls)
- [zeta_note](#zeta_note)
- [zk](#zk)
- [zls](#zls)

## als

https://github.com/AdaCore/ada_language_server

Installation instructions can be found [here](https://github.com/AdaCore/ada_language_server#Install).

Can be configured by passing a "settings" object to `als.setup{}`:

```lua
require('lspconfig').als.setup{
    settings = {
      ada = {
        projectFile = "project.gpr";
        scenarioVariables = { ... };
      }
    }
}
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.als.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "ada_language_server" }
  ```
  - `filetypes` : 
  ```lua
  { "ada" }
  ```
  - `root_dir` : 
  ```lua
  util.root_pattern("Makefile", ".git", "*.gpr", "*.adc")
  ```


## angularls

https://github.com/angular/vscode-ng-language-service

`angular-language-server` can be installed via npm `npm install -g @angular/language-server`.

Note, that if you override the default `cmd`, you must also update `on_new_config` to set `new_config.cmd` during startup.

```lua
local project_library_path = "/path/to/project/lib"
local cmd = {"ngserver", "--stdio", "--tsProbeLocations", project_library_path , "--ngProbeLocations", project_library_path}

require'lspconfig'.angularls.setup{
  cmd = cmd,
  on_new_config = function(new_config,new_root_dir)
    new_config.cmd = cmd
  end,
}
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.angularls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "ngserver", "--stdio", "--tsProbeLocations", "", "--ngProbeLocations", "" }
  ```
  - `filetypes` : 
  ```lua
  { "typescript", "html", "typescriptreact", "typescript.tsx" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("angular.json", ".git")
  ```


## ansiblels

https://github.com/ansible/ansible-language-server

Language server for the ansible configuration management tool.

`ansible-language-server` can be installed via `npm`:

```sh
npm install -g @ansible/ansible-language-server
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.ansiblels.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "ansible-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "yaml.ansible" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {
    ansible = {
      ansible = {
        path = "ansible"
      },
      ansibleLint = {
        enabled = true,
        path = "ansible-lint"
      },
      executionEnvironment = {
        enabled = false
      },
      python = {
        interpreterPath = "python"
      }
    }
  }
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## arduino_language_server

https://github.com/arduino/arduino-language-server

Language server for Arduino

The `arduino-language-server` can be installed by running:
	go get -u github.com/arduino/arduino-language-server

The `arduino-cli` tools must also be installed. Follow these instructions for your distro:
	https://arduino.github.io/arduino-cli/latest/installation/

After installing the `arduino-cli` tools, follow these instructions for generating
a configuration file:
	https://arduino.github.io/arduino-cli/latest/getting-started/#create-a-configuration-file
and make sure you install any relevant platforms libraries:
	https://arduino.github.io/arduino-cli/latest/getting-started/#install-the-core-for-your-board

The language server also requires `clangd` be installed. It will look for `clangd` by default but
the binary path can be overridden if need be.

After all dependencies are installed you'll need to override the lspconfig command for the
language server in your setup function with the necessary configurations:

```lua
lspconfig.arduino_language_server.setup({
	cmd =  {
		-- Required
		"arduino-language-server",
		"-cli-config", "/path/to/arduino-cli.yaml",
		-- Optional
		"-cli", "/path/to/arduino-cli",
		"-clangd", "/path/to/clangd"
	}
})
```

For further instruction about configuration options, run `arduino-language-server --help`.




**Snippet to enable the language server:**
```lua
require'lspconfig'.arduino_language_server.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "arduino-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "arduino" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## asm_lsp

https://github.com/bergercookie/asm-lsp

Language Server for GAS/GO Assembly

`asm-lsp` can be installed via cargo:
cargo install asm-lsp



**Snippet to enable the language server:**
```lua
require'lspconfig'.asm_lsp.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "asm-lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "asm", "vmasm" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## awk_ls

https://github.com/Beaglefoot/awk-language-server/

`awk-language-server` can be installed via `npm`:
```sh
npm install -g awk-language-server
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.awk_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "awk-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "awk" }
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## bashls

https://github.com/mads-hartmann/bash-language-server

`bash-language-server` can be installed via `npm`:
```sh
npm i -g bash-language-server
```

Language server for bash, written using tree sitter in typescript.



**Snippet to enable the language server:**
```lua
require'lspconfig'.bashls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "bash-language-server", "start" }
  ```
  - `cmd_env` : 
  ```lua
  {
    GLOB_PATTERN = "*@(.sh|.inc|.bash|.command)"
  }
  ```
  - `filetypes` : 
  ```lua
  { "sh" }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## beancount

https://github.com/polarmutex/beancount-language-server#installation

See https://github.com/polarmutex/beancount-language-server#configuration for configuration options



**Snippet to enable the language server:**
```lua
require'lspconfig'.beancount.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "beancount-langserver", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "beancount" }
  ```
  - `init_options` : 
  ```lua
  {
    journalFile = "",
    pythonPath = "python3"
  }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("elm.json")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## bicep

https://github.com/azure/bicep
Bicep language server

Bicep language server can be installed by downloading and extracting a release of bicep-langserver.zip from [Bicep GitHub releases](https://github.com/Azure/bicep/releases).

Bicep language server requires the [dotnet-sdk](https://dotnet.microsoft.com/download) to be installed.

Neovim does not have built-in support for the bicep filetype which is required for lspconfig to automatically launch the language server.

Filetype detection can be added via an autocmd:
```lua
vim.cmd [[ autocmd BufNewFile,BufRead *.bicep set filetype=bicep ]]
```

**By default, bicep language server does not have a `cmd` set.** This is because nvim-lspconfig does not make assumptions about your path. You must add the following to your init.vim or init.lua to set `cmd` to the absolute path ($HOME and ~ are not expanded) of the unzipped run script or binary.

```lua
local bicep_lsp_bin = "/path/to/bicep-langserver/Bicep.LangServer.dll"
require'lspconfig'.bicep.setup{
    cmd = { "dotnet", bicep_lsp_bin };
    ...
}
```

To download the latest release and place in /usr/local/bin/bicep-langserver:
```bash
(cd $(mktemp -d) \
    && curl -fLO https://github.com/Azure/bicep/releases/latest/download/bicep-langserver.zip \
    && rm -rf /usr/local/bin/bicep-langserver \
    && unzip -d /usr/local/bin/bicep-langserver bicep-langserver.zip)
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.bicep.setup{}
```


**Default values:**
  - `filetypes` : 
  ```lua
  { "bicep" }
  ```
  - `init_options` : 
  ```lua
  {}
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor
  ```


## bsl_ls

    https://github.com/1c-syntax/bsl-language-server

    Language Server Protocol implementation for 1C (BSL) - 1C:Enterprise 8 and OneScript languages.

    


**Snippet to enable the language server:**
```lua
require'lspconfig'.bsl_ls.setup{}
```


**Default values:**
  - `filetypes` : 
  ```lua
  { "bsl", "os" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".git")
  ```


## ccls

https://github.com/MaskRay/ccls/wiki

ccls relies on a [JSON compilation database](https://clang.llvm.org/docs/JSONCompilationDatabase.html) specified
as compile_commands.json or, for simpler projects, a .ccls.
For details on how to automatically generate one using CMake look [here](https://cmake.org/cmake/help/latest/variable/CMAKE_EXPORT_COMPILE_COMMANDS.html). Alternatively, you can use [Bear](https://github.com/rizsotto/Bear).

Customization options are passed to ccls at initialization time via init_options, a list of available options can be found [here](https://github.com/MaskRay/ccls/wiki/Customization#initialization-options). For example:

```lua
local lspconfig = require'lspconfig'
lspconfig.ccls.setup {
  init_options = {
    compilationDatabaseDirectory = "build";
    index = {
      threads = 0;
    };
    clang = {
      excludeArgs = { "-frounding-math"} ;
    };
  }
}

```




**Snippet to enable the language server:**
```lua
require'lspconfig'.ccls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "ccls" }
  ```
  - `filetypes` : 
  ```lua
  { "c", "cpp", "objc", "objcpp" }
  ```
  - `offset_encoding` : 
  ```lua
  "utf-32"
  ```
  - `root_dir` : 
  ```lua
  root_pattern("compile_commands.json", ".ccls", ".git")
  ```
  - `single_file_support` : 
  ```lua
  false
  ```


## clangd

https://clangd.llvm.org/installation.html

**NOTE:** Clang >= 11 is recommended! See [this issue for more](https://github.com/neovim/nvim-lsp/issues/23).

clangd relies on a [JSON compilation database](https://clang.llvm.org/docs/JSONCompilationDatabase.html) specified as compile_commands.json, see https://clangd.llvm.org/installation#compile_commandsjson



**Snippet to enable the language server:**
```lua
require'lspconfig'.clangd.setup{}
```
**Commands:**
- ClangdSwitchSourceHeader: Switch between source/header

**Default values:**
  - `capabilities` : 
  ```lua
  default capabilities, with offsetEncoding utf-8
  ```
  - `cmd` : 
  ```lua
  { "clangd" }
  ```
  - `filetypes` : 
  ```lua
  { "c", "cpp", "objc", "objcpp" }
  ```
  - `root_dir` : 
  ```lua
          root_pattern(
            '.clangd',
            '.clang-tidy',
            '.clang-format',
            'compile_commands.json',
            'compile_flags.txt',
            'configure.ac',
            '.git'
          )
        
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## clarity_lsp

`clarity-lsp` is a language server for the Clarity language. Clarity is a decidable smart contract language that optimizes for predictability and security. Smart contracts allow developers to encode essential business logic on a blockchain.

To learn how to configure the clarity language server, see the [clarity-lsp documentation](https://github.com/hirosystems/clarity-lsp).



**Snippet to enable the language server:**
```lua
require'lspconfig'.clarity_lsp.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "clarity-lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "clar", "clarity" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".git")
  ```


## clojure_lsp

https://github.com/snoe/clojure-lsp

Clojure Language Server



**Snippet to enable the language server:**
```lua
require'lspconfig'.clojure_lsp.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "clojure-lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "clojure", "edn" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("project.clj", "deps.edn", "build.boot", "shadow-cljs.edn", ".git")
  ```


## cmake

https://github.com/regen100/cmake-language-server

CMake LSP Implementation



**Snippet to enable the language server:**
```lua
require'lspconfig'.cmake.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "cmake-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "cmake" }
  ```
  - `init_options` : 
  ```lua
  {
    buildDirectory = "build"
  }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".git", "compile_commands.json", "build")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## codeqlls

Reference:
https://help.semmle.com/codeql/codeql-cli.html

Binaries:
https://github.com/github/codeql-cli-binaries
        


**Snippet to enable the language server:**
```lua
require'lspconfig'.codeqlls.setup{}
```


**Default values:**
  - `before_init` : 
  ```lua
  see source file
  ```
  - `cmd` : 
  ```lua
  { "codeql", "execute", "language-server", "--check-errors", "ON_CHANGE", "-q" }
  ```
  - `filetypes` : 
  ```lua
  { "ql" }
  ```
  - `log_level` : 
  ```lua
  2
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {
    search_path = "list containing all search paths, eg: '~/codeql-home/codeql-repo'"
  }
  ```


## crystalline

https://github.com/elbywan/crystalline

Crystal language server.



**Snippet to enable the language server:**
```lua
require'lspconfig'.crystalline.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "crystalline" }
  ```
  - `filetypes` : 
  ```lua
  { "crystal" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern('shard.yml', '.git')
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## csharp_ls

https://github.com/razzmatazz/csharp-language-server

Language Server for C#.

csharp-ls requires the [dotnet-sdk](https://dotnet.microsoft.com/download) to be installed.

The preferred way to install csharp-ls is with `dotnet tool install --global csharp-ls`.
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.csharp_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "csharp-ls" }
  ```
  - `filetypes` : 
  ```lua
  { "cs" }
  ```
  - `init_options` : 
  ```lua
  {
    AutomaticWorkspaceInit = true
  }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## cssls


https://github.com/hrsh7th/vscode-langservers-extracted

`css-languageserver` can be installed via `npm`:

```sh
npm i -g vscode-langservers-extracted
```

Neovim does not currently include built-in snippets. `vscode-css-language-server` only provides completions when snippet support is enabled. To enable completion, install a snippet plugin and add the following override to your language client capabilities during setup.

```lua
--Enable (broadcasting) snippet capability for completion
local capabilities = vim.lsp.protocol.make_client_capabilities()
capabilities.textDocument.completion.completionItem.snippetSupport = true

require'lspconfig'.cssls.setup {
  capabilities = capabilities,
}
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.cssls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "vscode-css-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "css", "scss", "less" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("package.json", ".git") or bufdir
  ```
  - `settings` : 
  ```lua
  {
    css = {
      validate = true
    },
    less = {
      validate = true
    },
    scss = {
      validate = true
    }
  }
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## cssmodules_ls

https://github.com/antonk52/cssmodules-language-server

Language server for autocompletion and go-to-definition functionality for CSS modules.

You can install cssmodules-language-server via npm:
```sh
npm install -g cssmodules-language-server
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.cssmodules_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "cssmodules-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "javascript", "javascriptreact", "typescript", "typescriptreact" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("package.json")
  ```


## cucumber_language_server

https://cucumber.io
https://github.com/cucumber/common
https://www.npmjs.com/package/@cucumber/language-server

Language server for Cucumber.

`cucumber-language-server` can be installed via `npm`:
```sh
npm install -g @cucumber/language-server
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.cucumber_language_server.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "cucumber-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "cucumber" }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor
  ```


## dartls

https://github.com/dart-lang/sdk/tree/master/pkg/analysis_server/tool/lsp_spec

Language server for dart.



**Snippet to enable the language server:**
```lua
require'lspconfig'.dartls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "dart", "./snapshots/analysis_server.dart.snapshot", "--lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "dart" }
  ```
  - `init_options` : 
  ```lua
  {
    closingLabels = true,
    flutterOutline = true,
    onlyAnalyzeProjectsWithOpenFiles = true,
    outline = true,
    suggestFromUnimportedLibraries = true
  }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("pubspec.yaml")
  ```
  - `settings` : 
  ```lua
  {
    dart = {
      completeFunctionCalls = true,
      showTodos = true
    }
  }
  ```


## denols

https://github.com/denoland/deno

Deno's built-in language server

To approrpiately highlight codefences returned from denols, you will need to augment vim.g.markdown_fenced languages
 in your init.lua. Example:

```lua
vim.g.markdown_fenced_languages = {
  "ts=typescript"
}
```




**Snippet to enable the language server:**
```lua
require'lspconfig'.denols.setup{}
```
**Commands:**
- DenolsCache: Cache a module and all of its dependencies.

**Default values:**
  - `cmd` : 
  ```lua
  { "deno", "lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "javascript", "javascriptreact", "javascript.jsx", "typescript", "typescriptreact", "typescript.tsx" }
  ```
  - `handlers` : 
  ```lua
  {
    ["textDocument/definition"] = <function 1>,
    ["textDocument/references"] = <function 1>
  }
  ```
  - `init_options` : 
  ```lua
  {
    enable = true,
    lint = false,
    unstable = false
  }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("deno.json", "deno.jsonc", "tsconfig.json", ".git")
  ```


## dhall_lsp_server

https://github.com/dhall-lang/dhall-haskell/tree/master/dhall-lsp-server

language server for dhall

`dhall-lsp-server` can be installed via cabal:
```sh
cabal install dhall-lsp-server
```
prebuilt binaries can be found [here](https://github.com/dhall-lang/dhall-haskell/releases).



**Snippet to enable the language server:**
```lua
require'lspconfig'.dhall_lsp_server.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "dhall-lsp-server" }
  ```
  - `filetypes` : 
  ```lua
  { "dhall" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".git")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## diagnosticls

https://github.com/iamcco/diagnostic-languageserver

Diagnostic language server integrate with linters.



**Snippet to enable the language server:**
```lua
require'lspconfig'.diagnosticls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "diagnostic-languageserver", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  Empty by default, override to add filetypes
  ```
  - `root_dir` : 
  ```lua
  Vim's starting directory
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## dockerls

https://github.com/rcjsuen/dockerfile-language-server-nodejs

`docker-langserver` can be installed via `npm`:
```sh
npm install -g dockerfile-language-server-nodejs
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.dockerls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "docker-langserver", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "dockerfile" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("Dockerfile")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## dotls

https://github.com/nikeee/dot-language-server

`dot-language-server` can be installed via `npm`:
```sh
npm install -g dot-language-server
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.dotls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "dot-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "dot" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## efm

https://github.com/mattn/efm-langserver

General purpose Language Server that can use specified error message format generated from specified command.

Requires at minimum EFM version [v0.0.38](https://github.com/mattn/efm-langserver/releases/tag/v0.0.38) to support
launching the language server on single files. If on an older version of EFM, disable single file support:

```lua
require('lspconfig')['efm'].setup{
  settings = ..., -- You must populate this according to the EFM readme
  filetypes = ..., -- Populate this according to the note below
  single_file_support = false, -- This is the important line for supporting older version of EFM
}
```

Note: In order for neovim's built-in language server client to send the appropriate `languageId` to EFM, **you must
specify `filetypes` in your call to `setup{}`**. Otherwise `lspconfig` will launch EFM on the `BufEnter` instead
of the `FileType` autocommand, and the `filetype` variable used to populate the `languageId` will not yet be set.

```lua
require('lspconfig')['efm'].setup{
  settings = ..., -- You must populate this according to the EFM readme
  filetypes = { 'python','cpp','lua' }
}
```




**Snippet to enable the language server:**
```lua
require'lspconfig'.efm.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "efm-langserver" }
  ```
  - `root_dir` : 
  ```lua
  util.root_pattern(".git")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## elixirls

https://github.com/elixir-lsp/elixir-ls

`elixir-ls` can be installed by following the instructions [here](https://github.com/elixir-lsp/elixir-ls#building-and-running).

```bash
curl -fLO https://github.com/elixir-lsp/elixir-ls/releases/latest/download/elixir-ls.zip
unzip elixir-ls.zip -d /path/to/elixir-ls
# Unix
chmod +x /path/to/elixir-ls/language_server.sh
```

**By default, elixir-ls doesn't have a `cmd` set.** This is because nvim-lspconfig does not make assumptions about your path. You must add the following to your init.vim or init.lua to set `cmd` to the absolute path ($HOME and ~ are not expanded) of your unzipped elixir-ls.

```lua
require'lspconfig'.elixirls.setup{
    -- Unix
    cmd = { "/path/to/elixir-ls/language_server.sh" };
    -- Windows
    cmd = { "/path/to/elixir-ls/language_server.bat" };
    ...
}
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.elixirls.setup{}
```


**Default values:**
  - `filetypes` : 
  ```lua
  { "elixir", "eelixir" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("mix.exs", ".git") or vim.loop.os_homedir()
  ```


## elmls

https://github.com/elm-tooling/elm-language-server#installation

If you don't want to use Nvim to install it, then you can use:
```sh
npm install -g elm elm-test elm-format @elm-tooling/elm-language-server
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.elmls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "elm-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "elm" }
  ```
  - `init_options` : 
  ```lua
  {
    elmAnalyseTrigger = "change"
  }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("elm.json")
  ```


## ember

https://github.com/lifeart/ember-language-server

`ember-language-server` can be installed via `npm`:

```sh
npm install -g @lifeart/ember-language-server
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.ember.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "ember-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "handlebars", "typescript", "javascript" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("ember-cli-build.js", ".git")
  ```


## emmet_ls

https://github.com/aca/emmet-ls

Package can be installed via `npm`:
```sh
npm install -g emmet-ls
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.emmet_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "emmet-ls", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "html", "css" }
  ```
  - `root_dir` : 
  ```lua
  git root
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## erlangls

https://erlang-ls.github.io

Language Server for Erlang.

Clone [erlang_ls](https://github.com/erlang-ls/erlang_ls)
Compile the project with `make` and copy resulting binaries somewhere in your $PATH eg. `cp _build/*/bin/* ~/local/bin`

Installation instruction can be found [here](https://github.com/erlang-ls/erlang_ls).

Installation requirements:
    - [Erlang OTP 21+](https://github.com/erlang/otp)
    - [rebar3 3.9.1+](https://github.com/erlang/rebar3)



**Snippet to enable the language server:**
```lua
require'lspconfig'.erlangls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "erlang_ls" }
  ```
  - `filetypes` : 
  ```lua
  { "erlang" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern('rebar.config', 'erlang.mk', '.git')
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## esbonio

https://github.com/swyddfa/esbonio

Esbonio is a language server for [Sphinx](https://www.sphinx-doc.org/en/master/) documentation projects.
The language server can be installed via pip

```
pip install esbonio
```

Since Sphinx is highly extensible you will get best results if you install the language server in the same
Python environment as the one used to build your documentation. To ensure that the correct Python environment
is picked up, you can either launch `nvim` with the correct environment activated.

```
source env/bin/activate
nvim
```

Or you can modify the default `cmd` to include the full path to the Python interpreter.

```lua
require'lspconfig'.esbonio.setup {
  cmd = { '/path/to/virtualenv/bin/python', '-m', 'esbonio' }
}
```

Esbonio supports a number of config values passed as `init_options` on startup, for example.

```lua
require'lspconfig'.esbonio.setup {
  init_options = {
    server = {
      logLevel = "debug"
    },
    sphinx = {
      confDir = "/path/to/docs",
      srcDir = "${confDir}/../docs-src"
    }
}
```

A full list and explanation of the available options can be found [here](https://swyddfa.github.io/esbonio/docs/lsp/editors/index.html)



**Snippet to enable the language server:**
```lua
require'lspconfig'.esbonio.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "python3", "-m", "esbonio" }
  ```
  - `filetypes` : 
  ```lua
  { "rst" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## eslint

https://github.com/hrsh7th/vscode-langservers-extracted

vscode-eslint-language-server: A linting engine for JavaScript / Typescript

`vscode-eslint-language-server` can be installed via `npm`:
```sh
npm i -g vscode-langservers-extracted
```

vscode-eslint-language-server provides an EslintFixAll command that can be used to format document on save
```vim
autocmd BufWritePre *.tsx,*.ts,*.jsx,*.js EslintFixAll
```

See [vscode-eslint](https://github.com/microsoft/vscode-eslint/blob/55871979d7af184bf09af491b6ea35ebd56822cf/server/src/eslintServer.ts#L216-L229) for configuration options.

Additional messages you can handle: eslint/noConfig
Messages already handled in lspconfig: eslint/openDoc, eslint/confirmESLintExecution, eslint/probeFailed, eslint/noLibrary



**Snippet to enable the language server:**
```lua
require'lspconfig'.eslint.setup{}
```
**Commands:**
- EslintFixAll: Fix all eslint problems for this buffer

**Default values:**
  - `cmd` : 
  ```lua
  { "vscode-eslint-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "javascript", "javascriptreact", "javascript.jsx", "typescript", "typescriptreact", "typescript.tsx", "vue" }
  ```
  - `handlers` : 
  ```lua
  {
    ["eslint/confirmESLintExecution"] = <function 1>,
    ["eslint/noLibrary"] = <function 2>,
    ["eslint/openDoc"] = <function 3>,
    ["eslint/probeFailed"] = <function 4>
  }
  ```
  - `on_new_config` : 
  ```lua
  see source file
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {
    codeAction = {
      disableRuleComment = {
        enable = true,
        location = "separateLine"
      },
      showDocumentation = {
        enable = true
      }
    },
    codeActionOnSave = {
      enable = false,
      mode = "all"
    },
    format = true,
    nodePath = "",
    onIgnoredFiles = "off",
    packageManager = "npm",
    quiet = false,
    rulesCustomizations = {},
    run = "onType",
    useESLintClass = false,
    validate = "on",
    workingDirectory = {
      mode = "location"
    }
  }
  ```


## flow

https://flow.org/
https://github.com/facebook/flow

See below for how to setup Flow itself.
https://flow.org/en/docs/install/

See below for lsp command options.

```sh
npx flow lsp --help
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.flow.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "npx", "--no-install", "flow", "lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "javascript", "javascriptreact", "javascript.jsx" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".flowconfig")
  ```


## flux_lsp

https://github.com/influxdata/flux-lsp
`flux-lsp` can be installed via `cargo`:
```sh
cargo install --git https://github.com/influxdata/flux-lsp
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.flux_lsp.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "flux-lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "flux" }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## foam_ls

https://github.com/FoamScience/foam-language-server

`foam-language-server` can be installed via `npm`
```sh
npm install -g foam-language-server
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.foam_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "foam-ls", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "foam", "OpenFOAM" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## fortls

https://github.com/hansec/fortran-language-server

Fortran Language Server for the Language Server Protocol
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.fortls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "fortls" }
  ```
  - `filetypes` : 
  ```lua
  { "fortran" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".fortls")
  ```
  - `settings` : 
  ```lua
  {
    nthreads = 1
  }
  ```


## fsautocomplete

https://github.com/fsharp/FsAutoComplete

Language Server for F# provided by FsAutoComplete (FSAC).

FsAutoComplete requires the [dotnet-sdk](https://dotnet.microsoft.com/download) to be installed.

The preferred way to install FsAutoComplete is with `dotnet tool install --global fsautocomplete`.

Instructions to compile from source are found on the main [repository](https://github.com/fsharp/FsAutoComplete).

You may also need to configure the filetype as Vim defaults to Forth for `*.fs` files:

`autocmd BufNewFile,BufRead *.fs,*.fsx,*.fsi set filetype=fsharp`

This is automatically done by plugins such as [PhilT/vim-fsharp](https://github.com/PhilT/vim-fsharp), [fsharp/vim-fsharp](https://github.com/fsharp/vim-fsharp), and [adelarsq/neofsharp.vim](https://github.com/adelarsq/neofsharp.vim).

    


**Snippet to enable the language server:**
```lua
require'lspconfig'.fsautocomplete.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "fsautocomplete", "--background-service-enabled" }
  ```
  - `filetypes` : 
  ```lua
  { "fsharp" }
  ```
  - `init_options` : 
  ```lua
  {
    AutomaticWorkspaceInit = true
  }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## fstar

https://github.com/FStarLang/FStar

LSP support is included in FStar. Make sure `fstar.exe` is in your PATH.



**Snippet to enable the language server:**
```lua
require'lspconfig'.fstar.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "fstar.exe", "--lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "fstar" }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor
  ```


## gdscript

https://github.com/godotengine/godot

Language server for GDScript, used by Godot Engine.



**Snippet to enable the language server:**
```lua
require'lspconfig'.gdscript.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "nc", "localhost", "6008" }
  ```
  - `filetypes` : 
  ```lua
  { "gd", "gdscript", "gdscript3" }
  ```
  - `root_dir` : 
  ```lua
  util.root_pattern("project.godot", ".git")
  ```


## ghcide

https://github.com/digital-asset/ghcide

A library for building Haskell IDE tooling.
"ghcide" isn't for end users now. Use "haskell-language-server" instead of "ghcide".



**Snippet to enable the language server:**
```lua
require'lspconfig'.ghcide.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "ghcide", "--lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "haskell", "lhaskell" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("stack.yaml", "hie-bios", "BUILD.bazel", "cabal.config", "package.yaml")
  ```


## golangci_lint_ls

Combination of both lint server and client

https://github.com/nametake/golangci-lint-langserver
https://github.com/golangci/golangci-lint


Installation of binaries needed is done via

```
go install github.com/nametake/golangci-lint-langserver@latest
go install github.com/golangci/golangci-lint/cmd/golangci-lint@v1.42.1
```




**Snippet to enable the language server:**
```lua
require'lspconfig'.golangci_lint_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "golangci-lint-langserver" }
  ```
  - `filetypes` : 
  ```lua
  { "go", "gomod" }
  ```
  - `init_options` : 
  ```lua
  {
    command = { "golangci-lint", "run", "--out-format", "json" }
  }
  ```
  - `root_dir` : 
  ```lua
  root_pattern('go.work') or root_pattern('go.mod', '.golangci.yaml', '.git')
  ```


## gopls

https://github.com/golang/tools/tree/master/gopls

Google's lsp server for golang.



**Snippet to enable the language server:**
```lua
require'lspconfig'.gopls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "gopls" }
  ```
  - `filetypes` : 
  ```lua
  { "go", "gomod", "gotmpl" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("go.mod", ".git")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## gradle_ls

https://github.com/microsoft/vscode-gradle

Microsoft's lsp server for gradle files

If you're setting this up manually, build vscode-gradle using `./gradlew installDist` and point `cmd` to the `gradle-language-server` generated in the build directory



**Snippet to enable the language server:**
```lua
require'lspconfig'.gradle_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "gradle-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "groovy" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("settings.gradle")
  ```


## grammarly

https://github.com/emacs-grammarly/unofficial-grammarly-language-server

`unofficial-grammarly-language-server` can be installed via `npm`:

```sh
npm i -g @emacs-grammarly/unofficial-grammarly-language-server
```

WARNING: Since this language server uses Grammarly's API, any document you open with it running is shared with them. Please evaluate their [privacy policy](https://www.grammarly.com/privacy-policy) before using this.



**Snippet to enable the language server:**
```lua
require'lspconfig'.grammarly.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "unofficial-grammarly-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "markdown" }
  ```
  - `handlers` : 
  ```lua
  {
    ["$/updateDocumentState"] = <function 1>
  }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## graphql

https://github.com/graphql/graphiql/tree/main/packages/graphql-language-service-cli

`graphql-lsp` can be installed via `npm`:

```sh
npm install -g graphql-language-service-cli
```

Note that you must also have [the graphql package](https://github.com/graphql/graphql-js) installed and create a [GraphQL config file](https://www.graphql-config.com/docs/user/user-introduction).



**Snippet to enable the language server:**
```lua
require'lspconfig'.graphql.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "graphql-lsp", "server", "-m", "stream" }
  ```
  - `filetypes` : 
  ```lua
  { "graphql", "typescriptreact", "javascriptreact" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern('.git', '.graphqlrc*', '.graphql.config.*')
  ```


## groovyls

https://github.com/prominic/groovy-language-server.git

Requirements:
 - Linux/macOS (for now)
 - Java 11+

`groovyls` can be installed by following the instructions [here](https://github.com/prominic/groovy-language-server.git#build).

If you have installed groovy language server, you can set the `cmd` custom path as follow:

```lua
require'lspconfig'.groovyls.setup{
    -- Unix
    cmd = { "java", "-jar", "path/to/groovyls/groovy-language-server-all.jar" },
    ...
}
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.groovyls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "java", "-jar", "groovy-language-server-all.jar" }
  ```
  - `filetypes` : 
  ```lua
  { "groovy" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## haxe_language_server

https://github.com/vshaxe/haxe-language-server

The Haxe language server can be built by running the following commands from
the project's root directory:

    npm install
    npx lix run vshaxe-build -t language-server

This will create `bin/server.js`. Note that the server requires Haxe 3.4.0 or
higher.

After building the language server, set the `cmd` setting in your setup
function:

```lua
lspconfig.haxe_language_server.setup({
  cmd = {"node", "path/to/bin/server.js"},
})
```

By default, an HXML compiler arguments file named `build.hxml` is expected in
your project's root directory. If your file is named something different,
specify it using the `init_options.displayArguments` setting.



**Snippet to enable the language server:**
```lua
require'lspconfig'.haxe_language_server.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "haxe-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "haxe" }
  ```
  - `init_options` : 
  ```lua
  {
    displayArguments = { "build.hxml" }
  }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("*.hxml")
  ```
  - `settings` : 
  ```lua
  {
    haxe = {
      executable = "haxe"
    }
  }
  ```


## hdl_checker

https://github.com/suoto/hdl_checker
Language server for hdl-checker.
Install using: `pip install hdl-checker --upgrade`



**Snippet to enable the language server:**
```lua
require'lspconfig'.hdl_checker.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "hdl_checker", "--lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "vhdl", "verilog", "systemverilog" }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## hhvm

Language server for programs written in Hack
https://hhvm.com/
https://github.com/facebook/hhvm
See below for how to setup HHVM & typechecker:
https://docs.hhvm.com/hhvm/getting-started/getting-started
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.hhvm.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "hh_client", "lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "php", "hack" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".hhconfig")
  ```


## hie

https://github.com/haskell/haskell-ide-engine

the following init_options are supported (see https://github.com/haskell/haskell-ide-engine#configuration):
```lua
init_options = {
  languageServerHaskell = {
    hlintOn = bool;
    maxNumberOfProblems = number;
    diagnosticsDebounceDuration = number;
    liquidOn = bool (default false);
    completionSnippetsOn = bool (default true);
    formatOnImportOn = bool (default true);
    formattingProvider = string (default "brittany", alternate "floskell");
  }
}
```
        


**Snippet to enable the language server:**
```lua
require'lspconfig'.hie.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "hie-wrapper", "--lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "haskell" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("stack.yaml", "package.yaml", ".git")
  ```


## hls

https://github.com/haskell/haskell-language-server

Haskell Language Server
        


**Snippet to enable the language server:**
```lua
require'lspconfig'.hls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "haskell-language-server-wrapper", "--lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "haskell", "lhaskell" }
  ```
  - `lspinfo` : 
  ```lua
  see source file
  ```
  - `root_dir` : 
  ```lua
  root_pattern("*.cabal", "stack.yaml", "cabal.project", "package.yaml", "hie.yaml")
  ```
  - `settings` : 
  ```lua
  {
    haskell = {
      formattingProvider = "ormolu"
    }
  }
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## hoon_ls

https://github.com/urbit/hoon-language-server

A language server for Hoon.

The language server can be installed via `npm install -g @hoon-language-server`

Start a fake ~zod with `urbit -F zod`.
Start the language server at the Urbit Dojo prompt with: `|start %language-server`



**Snippet to enable the language server:**
```lua
require'lspconfig'.hoon_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "hoon-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "hoon" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## html

https://github.com/hrsh7th/vscode-langservers-extracted

`vscode-html-language-server` can be installed via `npm`:
```sh
npm i -g vscode-langservers-extracted
```

Neovim does not currently include built-in snippets. `vscode-html-language-server` only provides completions when snippet support is enabled.
To enable completion, install a snippet plugin and add the following override to your language client capabilities during setup.

The code-formatting feature of the lsp can be controlled with the `provideFormatter` option.

```lua
--Enable (broadcasting) snippet capability for completion
local capabilities = vim.lsp.protocol.make_client_capabilities()
capabilities.textDocument.completion.completionItem.snippetSupport = true

require'lspconfig'.html.setup {
  capabilities = capabilities,
}
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.html.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "vscode-html-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "html" }
  ```
  - `init_options` : 
  ```lua
  {
    configurationSection = { "html", "css", "javascript" },
    embeddedLanguages = {
      css = true,
      javascript = true
    },
    provideFormatter = true
  }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {}
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## idris2_lsp

https://github.com/idris-community/idris2-lsp

The Idris 2 language server.

Plugins for the Idris 2 filetype include
[Idris2-Vim](https://github.com/edwinb/idris2-vim) (fewer features, stable) and
[Nvim-Idris2](https://github.com/ShinKage/nvim-idris2) (cutting-edge,
experimental).

Idris2-Lsp requires a build of Idris 2 that includes the "Idris 2 API" package.
Package managers with known support for this build include the
[AUR](https://aur.archlinux.org/packages/idris2-api-git/) and
[Homebrew](https://formulae.brew.sh/formula/idris2#default).

If your package manager does not support the Idris 2 API, you will need to build
Idris 2 from source. Refer to the
[the Idris 2 installation instructions](https://github.com/idris-lang/Idris2/blob/main/INSTALL.md)
for details.  Steps 5 and 8 are listed as "optional" in that guide, but they are
necessary in order to make the Idris 2 API available.

You need to install a version of Idris2-Lsp that is compatible with your
version of Idris 2. There should be a branch corresponding to every released
Idris 2 version after v0.4.0. Use the latest commit on that branch. For example,
if you have Idris v0.5.1, you should use the v0.5.1 branch of Idris2-Lsp.

If your Idris 2 version is newer than the newest Idris2-Lsp branch, use the
latest commit on the `master` branch, and set a reminder to check the Idris2-Lsp
repo for the release of a compatible versioned branch.



**Snippet to enable the language server:**
```lua
require'lspconfig'.idris2_lsp.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "idris2-lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "idris2" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## intelephense

https://intelephense.com/

`intelephense` can be installed via `npm`:
```sh
npm install -g intelephense
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.intelephense.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "intelephense", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "php" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("composer.json", ".git")
  ```


## java_language_server

https://github.com/georgewfraser/java-language-server

Java language server

Point `cmd` to `lang_server_linux.sh` or the equivalent script for macOS/Windows provided by java-language-server



**Snippet to enable the language server:**
```lua
require'lspconfig'.java_language_server.setup{}
```


**Default values:**
  - `filetypes` : 
  ```lua
  { "java" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {}
  ```


## jdtls

https://projects.eclipse.org/projects/eclipse.jdt.ls

Language server for Java.

IMPORTANT: If you want all the features jdtls has to offer, [nvim-jdtls](https://github.com/mfussenegger/nvim-jdtls)
is highly recommended. If all you need is diagnostics, completion, imports, gotos and formatting and some code actions
you can keep reading here.

For manual installation you can download precompiled binaries from the
[official downloads site](http://download.eclipse.org/jdtls/snapshots/?d)

Due to the nature of java, settings cannot be inferred. Please set the following
environmental variables to match your installation. If you need per-project configuration
[direnv](https://github.com/direnv/direnv) is highly recommended.

```bash
# Mandatory:
# .bashrc
export JDTLS_HOME=/path/to/jdtls_root # Directory with the plugin and configs directories

# Optional:
export JAVA_HOME=/path/to/java_home # In case you don't have java in path or want to use a version in particular
export WORKSPACE=/path/to/workspace # Defaults to $HOME/workspace
```
```lua
  -- init.lua
  require'lspconfig'.jdtls.setup{}
```

For automatic installation you can use the following unofficial installers/launchers under your own risk:
  - [jdtls-launcher](https://github.com/eruizc-dev/jdtls-launcher) (Includes lombok support by default)
    ```lua
      -- init.lua
      require'lspconfig'.jdtls.setup{ cmd = { 'jdtls' } }
    ```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.jdtls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "/usr/lib/jvm/temurin-11-jdk-amd64/bin/java", "-Declipse.application=org.eclipse.jdt.ls.core.id1", "-Dosgi.bundles.defaultStartLevel=4", "-Declipse.product=org.eclipse.jdt.ls.core.product", "-Dlog.protocol=true", "-Dlog.level=ALL", "-Xms1g", "-Xmx2G", "--add-modules=ALL-SYSTEM", "--add-opens", "java.base/java.util=ALL-UNNAMED", "--add-opens", "java.base/java.lang=ALL-UNNAMED", "-jar", "/plugins/org.eclipse.equinox.launcher_*.jar", "-configuration", "config_linux", "-data", "/home/runner/workspace" }
  ```
  - `filetypes` : 
  ```lua
  { "java" }
  ```
  - `handlers` : 
  ```lua
  {
    ["language/status"] = <function 1>,
    ["textDocument/codeAction"] = <function 2>,
    ["textDocument/rename"] = <function 3>,
    ["workspace/applyEdit"] = <function 4>
  }
  ```
  - `init_options` : 
  ```lua
  {
    jvm_args = {},
    workspace = "/home/runner/workspace"
  }
  ```
  - `root_dir` : 
  ```lua
  {
          -- Single-module projects
          {
            'build.xml', -- Ant
            'pom.xml', -- Maven
            'settings.gradle', -- Gradle
            'settings.gradle.kts', -- Gradle
          },
          -- Multi-module projects
          { 'build.gradle', 'build.gradle.kts' },
        } or vim.fn.getcwd()
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## jedi_language_server

https://github.com/pappasam/jedi-language-server

`jedi-language-server`, a language server for Python, built on top of jedi
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.jedi_language_server.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "jedi-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "python" }
  ```
  - `root_dir` : 
  ```lua
  vim's starting directory
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## jsonls

https://github.com/hrsh7th/vscode-langservers-extracted

vscode-json-language-server, a language server for JSON and JSON schema

`vscode-json-language-server` can be installed via `npm`:
```sh
npm i -g vscode-langservers-extracted
```

Neovim does not currently include built-in snippets. `vscode-json-language-server` only provides completions when snippet support is enabled. To enable completion, install a snippet plugin and add the following override to your language client capabilities during setup.

```lua
--Enable (broadcasting) snippet capability for completion
local capabilities = vim.lsp.protocol.make_client_capabilities()
capabilities.textDocument.completion.completionItem.snippetSupport = true

require'lspconfig'.jsonls.setup {
  capabilities = capabilities,
}
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.jsonls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "vscode-json-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "json", "jsonc" }
  ```
  - `init_options` : 
  ```lua
  {
    provideFormatter = true
  }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## jsonnet_ls

https://github.com/grafana/jsonnet-language-server

A Language Server Protocol (LSP) server for Jsonnet.

The language server can be installed with `go`:
```sh
go install github.com/grafana/jsonnet-language-server@latest
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.jsonnet_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "jsonnet-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "jsonnet", "libsonnet" }
  ```
  - `on_new_config` : 
  ```lua
  see source file
  ```
  - `root_dir` : 
  ```lua
  root_pattern("jsonnetfile.json")
  ```


## julials

https://github.com/julia-vscode/julia-vscode

LanguageServer.jl can be installed with `julia` and `Pkg`:
```sh
julia --project=~/.julia/environments/nvim-lspconfig -e 'using Pkg; Pkg.add("LanguageServer")'
```
where `~/.julia/environments/nvim-lspconfig` is the location where
the default configuration expects LanguageServer.jl to be installed.

To update an existing install, use the following command:
```sh
julia --project=~/.julia/environments/nvim-lspconfig -e 'using Pkg; Pkg.update()'
```

Note: In order to have LanguageServer.jl pick up installed packages or dependencies in a
Julia project, you must make sure that the project is instantiated:
```sh
julia --project=/path/to/my/project -e 'using Pkg; Pkg.instantiate()'
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.julials.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "julia", "--startup-file=no", "--history-file=no", "-e", '    # Load LanguageServer.jl: attempt to load from ~/.julia/environments/nvim-lspconfig\n    # with the regular load path as a fallback\n    ls_install_path = joinpath(\n        get(DEPOT_PATH, 1, joinpath(homedir(), ".julia")),\n        "environments", "nvim-lspconfig"\n    )\n    pushfirst!(LOAD_PATH, ls_install_path)\n    using LanguageServer\n    popfirst!(LOAD_PATH)\n    depot_path = get(ENV, "JULIA_DEPOT_PATH", "")\n    project_path = let\n        dirname(something(\n            ## 1. Finds an explicitly set project (JULIA_PROJECT)\n            Base.load_path_expand((\n                p = get(ENV, "JULIA_PROJECT", nothing);\n                p === nothing ? nothing : isempty(p) ? nothing : p\n            )),\n            ## 2. Look for a Project.toml file in the current working directory,\n            ##    or parent directories, with $HOME as an upper boundary\n            Base.current_project(),\n            ## 3. First entry in the load path\n            get(Base.load_path(), 1, nothing),\n            ## 4. Fallback to default global environment,\n            ##    this is more or less unreachable\n            Base.load_path_expand("@v#.#"),\n        ))\n    end\n    @info "Running language server" VERSION pwd() project_path depot_path\n    server = LanguageServer.LanguageServerInstance(stdin, stdout, project_path, depot_path)\n    server.runlinter = true\n    run(server)\n  ' }
  ```
  - `filetypes` : 
  ```lua
  { "julia" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## kotlin_language_server

    A kotlin language server which was developed for internal usage and
    released afterwards. Maintaining is not done by the original author,
    but by fwcd.

    It is built via gradle and developed on github.
    Source and additional description:
    https://github.com/fwcd/kotlin-language-server

    This server requires vim to be aware of the kotlin-filetype.
    You could refer for this capability to:
    https://github.com/udalov/kotlin-vim (recommended)
    Note that there is no LICENSE specified yet.
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.kotlin_language_server.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "kotlin-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "kotlin" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("settings.gradle")
  ```


## lean3ls

https://github.com/leanprover/lean-client-js/tree/master/lean-language-server

Lean installation instructions can be found
[here](https://leanprover-community.github.io/get_started.html#regular-install).

Once Lean is installed, you can install the Lean 3 language server by running
```sh
npm install -g lean-language-server
```

Note: that if you're using [lean.nvim](https://github.com/Julian/lean.nvim),
that plugin fully handles the setup of the Lean language server,
and you shouldn't set up `lean3ls` both with it and `lspconfig`.
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.lean3ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "lean-language-server", "--stdio", "--", "-M", "4096", "-T", "100000" }
  ```
  - `filetypes` : 
  ```lua
  { "lean3" }
  ```
  - `offset_encoding` : 
  ```lua
  "utf-32"
  ```
  - `root_dir` : 
  ```lua
  root_pattern("leanpkg.toml") or root_pattern(".git")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## leanls

https://github.com/leanprover/lean4

Lean installation instructions can be found
[here](https://leanprover-community.github.io/get_started.html#regular-install).

The Lean 4 language server is built-in with a Lean 4 install
(and can be manually run with, e.g., `lean --server`).

Note: that if you're using [lean.nvim](https://github.com/Julian/lean.nvim),
that plugin fully handles the setup of the Lean language server,
and you shouldn't set up `leanls` both with it and `lspconfig`.
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.leanls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "lake", "serve", "--" }
  ```
  - `filetypes` : 
  ```lua
  { "lean" }
  ```
  - `on_new_config` : 
  ```lua
  see source file
  ```
  - `options` : 
  ```lua
  {
    no_lake_lsp_cmd = { "lean", "--server" }
  }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("lakefile.lean", "lean-toolchain", "leanpkg.toml", ".git")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## lelwel_ls

https://github.com/0x2a-42/lelwel

Language server for lelwel grammars.

You can install `lelwel-ls` via cargo:
```sh
cargo install --features="lsp" lelwel
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.lelwel_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "lelwel-ls" }
  ```
  - `filetypes` : 
  ```lua
  { "llw" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## lemminx

https://github.com/eclipse/lemminx

The easiest way to install the server is to get a binary at https://download.jboss.org/jbosstools/vscode/stable/lemminx-binary/ and place it in your PATH.

NOTE to macOS users: Binaries from unidentified developers are blocked by default. If you trust the downloaded binary from jboss.org, run it once, cancel the prompt, then remove the binary from Gatekeeper quarantine with `xattr -d com.apple.quarantine lemminx`. It should now run without being blocked.




**Snippet to enable the language server:**
```lua
require'lspconfig'.lemminx.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "lemminx" }
  ```
  - `filetypes` : 
  ```lua
  { "xml", "xsd", "xsl", "xslt", "svg" }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## ltex

https://github.com/valentjn/ltex-ls

LTeX Language Server: LSP language server for LanguageTool 🔍✔️ with support for LaTeX 🎓, Markdown 📝, and others

To install, download the latest [release](https://github.com/valentjn/ltex-ls/releases) and ensure `ltex-ls` is on your path.

To support org files or R sweave, users can define a custom filetype autocommand (or use a plugin which defines these filetypes):

```lua
vim.cmd [[ autocmd BufRead,BufNewFile *.org set filetype=org ]]
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.ltex.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "ltex-ls" }
  ```
  - `filetypes` : 
  ```lua
  { "bib", "gitcommit", "markdown", "org", "plaintex", "rst", "rnoweb", "tex" }
  ```
  - `get_language_id` : 
  ```lua
  see source file
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## metals

https://scalameta.org/metals/

Scala language server with rich IDE features.

See full instructions in the Metals documentation:

https://scalameta.org/metals/docs/editors/vim.html#using-an-alternative-lsp-client

Note: that if you're using [nvim-metals](https://github.com/scalameta/nvim-metals), that plugin fully handles the setup and installation of Metals, and you shouldn't set up Metals both with it and `lspconfig`.

To install Metals, make sure to have [coursier](https://get-coursier.io/docs/cli-installation) installed, and once you do you can install the latest Metals with `cs install metals`. You can also manually bootstrap Metals with the following command.

```bash
cs bootstrap \
  --java-opt -Xss4m \
  --java-opt -Xms100m \
  org.scalameta:metals_2.12:<enter-version-here> \
  -r bintray:scalacenter/releases \
  -r sonatype:snapshots \
  -o /usr/local/bin/metals -f
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.metals.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "metals" }
  ```
  - `filetypes` : 
  ```lua
  { "scala" }
  ```
  - `init_options` : 
  ```lua
  {
    compilerOptions = {
      snippetAutoIndent = false
    },
    isHttpEnabled = true,
    statusBarProvider = "show-message"
  }
  ```
  - `message_level` : 
  ```lua
  4
  ```
  - `root_dir` : 
  ```lua
  util.root_pattern("build.sbt", "build.sc", "build.gradle", "pom.xml")
  ```


## mint

https://www.mint-lang.com

Install Mint using the [instructions](https://www.mint-lang.com/install).
The language server is included since version 0.12.0.



**Snippet to enable the language server:**
```lua
require'lspconfig'.mint.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "mint", "ls" }
  ```
  - `filetypes` : 
  ```lua
  { "mint" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## mm0_ls

https://github.com/digama0/mm0

Language Server for the metamath-zero theorem prover.

Requires [mm0-rs](https://github.com/digama0/mm0/tree/master/mm0-rs) to be installed
and available on the `PATH`.
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.mm0_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "mm0-rs", "server" }
  ```
  - `filetypes` : 
  ```lua
  { "metamath-zero" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## nickel_ls

Nickel Language Server

https://github.com/tweag/nickel

`nls` can be installed with nix, or cargo, from the Nickel repository.
```sh
git clone https://github.com/tweag/nickel.git
```

Nix:
```sh
cd nickel
nix-env -f . -i
```

cargo:
```sh
cd nickel/lsp/nls
cargo install --path .
```

In order to have lspconfig detect Nickel filetypes (a prequisite for autostarting a server),
install the [Nickel vim plugin](https://github.com/nickel-lang/vim-nickel).
        


**Snippet to enable the language server:**
```lua
require'lspconfig'.nickel_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "nls" }
  ```
  - `filetypes` : 
  ```lua
  { "ncl", "nickel" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## nimls

https://github.com/PMunch/nimlsp
`nimlsp` can be installed via the `nimble` package manager:
```sh
nimble install nimlsp
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.nimls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "nimlsp" }
  ```
  - `filetypes` : 
  ```lua
  { "nim" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## ocamlls

https://github.com/ocaml-lsp/ocaml-language-server

`ocaml-language-server` can be installed via `npm`
```sh
npm install -g ocaml-language-server
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.ocamlls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "ocaml-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "ocaml", "reason" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("*.opam", "esy.json", "package.json")
  ```


## ocamllsp

https://github.com/ocaml/ocaml-lsp

`ocaml-lsp` can be installed as described in [installation guide](https://github.com/ocaml/ocaml-lsp#installation).

To install the lsp server in a particular opam switch:
```sh
opam pin add ocaml-lsp-server https://github.com/ocaml/ocaml-lsp.git
opam install ocaml-lsp-server
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.ocamllsp.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "ocamllsp" }
  ```
  - `filetypes` : 
  ```lua
  { "ocaml", "ocaml.menhir", "ocaml.interface", "ocaml.ocamllex", "reason" }
  ```
  - `get_language_id` : 
  ```lua
  see source file
  ```
  - `root_dir` : 
  ```lua
  root_pattern("*.opam", "esy.json", "package.json", ".git")
  ```


## ols

           https://github.com/DanielGavin/ols

           `Odin Language Server`.
        


**Snippet to enable the language server:**
```lua
require'lspconfig'.ols.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "ols" }
  ```
  - `filetypes` : 
  ```lua
  { "odin" }
  ```
  - `root_dir` : 
  ```lua
  util.root_pattern("ols.json", ".git")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## omnisharp

https://github.com/omnisharp/omnisharp-roslyn
OmniSharp server based on Roslyn workspaces

`omnisharp-roslyn` can be installed by downloading and extracting a release from [here](https://github.com/OmniSharp/omnisharp-roslyn/releases).
Omnisharp can also be built from source by following the instructions [here](https://github.com/omnisharp/omnisharp-roslyn#downloading-omnisharp).

Omnisharp requires the [dotnet-sdk](https://dotnet.microsoft.com/download) to be installed.

**By default, omnisharp-roslyn doesn't have a `cmd` set.** This is because nvim-lspconfig does not make assumptions about your path. You must add the following to your init.vim or init.lua to set `cmd` to the absolute path ($HOME and ~ are not expanded) of the unzipped run script or binary.

```lua
local pid = vim.fn.getpid()
-- On linux/darwin if using a release build, otherwise under scripts/OmniSharp(.Core)(.cmd)
local omnisharp_bin = "/path/to/omnisharp-repo/run"
-- on Windows
-- local omnisharp_bin = "/path/to/omnisharp/OmniSharp.exe"
require'lspconfig'.omnisharp.setup{
    cmd = { omnisharp_bin, "--languageserver" , "--hostPID", tostring(pid) };
    ...
}
```

Note, if you download the executable for darwin you will need to strip the quarantine label to run:
```bash
find /path/to/omnisharp-osx | xargs xattr -r -d com.apple.quarantine
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.omnisharp.setup{}
```


**Default values:**
  - `filetypes` : 
  ```lua
  { "cs", "vb" }
  ```
  - `init_options` : 
  ```lua
  {}
  ```
  - `on_new_config` : 
  ```lua
  see source file
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".sln") or root_pattern(".csproj")
  ```


## opencl_ls

https://github.com/Galarius/opencl-language-server

Build instructions can be found [here](https://github.com/Galarius/opencl-language-server/blob/main/_dev/build.md).

Prebuilt binaries are available for Linux, macOS and Windows [here](https://github.com/Galarius/opencl-language-server/releases).



**Snippet to enable the language server:**
```lua
require'lspconfig'.opencl_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "opencl-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "opencl" }
  ```
  - `root_dir` : 
  ```lua
  util.root_pattern(".git")
  ```


## openscad_ls

https://github.com/dzhu/openscad-language-server

A Language Server Protocol server for OpenSCAD

You can build and install `openscad-language-server` binary with `cargo`:
```sh
cargo install openscad-language-server
```

Vim does not have built-in syntax for the `openscad` filetype currently.

This can be added via an autocmd:

```lua
vim.cmd [[ autocmd BufRead,BufNewFile *.scad set filetype=openscad ]]
```

or by installing a filetype plugin such as https://github.com/sirtaj/vim-openscad



**Snippet to enable the language server:**
```lua
require'lspconfig'.openscad_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "openscad-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "openscad" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## pasls

https://github.com/genericptr/pascal-language-server

An LSP server implementation for Pascal variants that are supported by Free Pascal, including Object Pascal. It uses CodeTools from Lazarus as backend.

First set `cmd` to the Pascal lsp binary.

Customization options are passed to pasls as environment variables for example in your `.bashrc`:
```bash
export FPCDIR='/usr/lib/fpc/src'      # FPC source directory (This is the only required option for the server to work).
export PP='/usr/lib/fpc/3.2.2/ppcx64' # Path to the Free Pascal compiler executable.
export LAZARUSDIR='/usr/lib/lazarus'  # Path to the Lazarus sources.
export FPCTARGET=''                   # Target operating system for cross compiling.
export FPCTARGETCPU='x86_64'          # Target CPU for cross compiling.
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.pasls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "pasls" }
  ```
  - `filetypes` : 
  ```lua
  { "pascal" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## perlls

https://github.com/richterger/Perl-LanguageServer/tree/master/clients/vscode/perl

`Perl-LanguageServer`, a language server for Perl.

To use the language server, ensure that you have Perl::LanguageServer installed and perl command is on your path.



**Snippet to enable the language server:**
```lua
require'lspconfig'.perlls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "perl", "-MPerl::LanguageServer", "-e", "Perl::LanguageServer::run", "--", "--port 13603", "--nostdio 0", "--version 2.1.0" }
  ```
  - `filetypes` : 
  ```lua
  { "perl" }
  ```
  - `root_dir` : 
  ```lua
  vim's starting directory
  ```
  - `settings` : 
  ```lua
  {
    perl = {
      fileFilter = { ".pm", ".pl" },
      ignoreDirs = ".git",
      perlCmd = "perl",
      perlInc = " "
    }
  }
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## perlnavigator

https://github.com/bscan/PerlNavigator

A Perl language server

**By default, perlnavigator doesn't have a `cmd` set.** This is because nvim-lspconfig does not make assumptions about your path.
You have to install the language server manually.

Clone the PerlNavigator repo, install based on the [instructions](https://github.com/bscan/PerlNavigator#installation-for-other-editors),
and point `cmd` to `server.js` inside the `server/out` directory:

```lua
cmd = {'node', '<path_to_repo>/server/out/server.js', '--stdio'}
```

At minimum, you will need `perl` in your path. If you want to use a non-standard `perl` you will need to set your configuration like so:
```lua
settings = {
  perlnavigator = {
    perlPath = '/some/odd/location/my-perl'
  }
}
```

The `contributes.configuration.properties` section of `perlnavigator`'s `package.json` has all available configuration settings. All
settings have a reasonable default, but, at minimum, you may want to point `perlnavigator` at your `perltidy` and `perlcritic` configurations.



**Snippet to enable the language server:**
```lua
require'lspconfig'.perlnavigator.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  {}
  ```
  - `filetypes` : 
  ```lua
  { "perl" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## perlpls

https://github.com/FractalBoy/perl-language-server
https://metacpan.org/pod/PLS

`PLS`, another language server for Perl.

To use the language server, ensure that you have PLS installed and that it is in your path



**Snippet to enable the language server:**
```lua
require'lspconfig'.perlpls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "pls" }
  ```
  - `filetypes` : 
  ```lua
  { "perl" }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor
  ```
  - `settings` : 
  ```lua
  {
    perl = {
      perlcritic = {
        enabled = false
      },
      syntax = {
        enabled = true
      }
    }
  }
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## phpactor

https://github.com/phpactor/phpactor

Installation: https://phpactor.readthedocs.io/en/master/usage/standalone.html#global-installation



**Snippet to enable the language server:**
```lua
require'lspconfig'.phpactor.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "phpactor", "language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "php" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("composer.json", ".git")
  ```


## please

https://github.com/thought-machine/please

High-performance extensible build system for reproducible multi-language builds.

The `plz` binary will automatically install the LSP for you on first run



**Snippet to enable the language server:**
```lua
require'lspconfig'.please.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "plz", "tool", "lps" }
  ```
  - `filetypes` : 
  ```lua
  { "bzl" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## powershell_es

https://github.com/PowerShell/PowerShellEditorServices

Language server for PowerShell.

To install, download and extract PowerShellEditorServices.zip
from the [releases](https://github.com/PowerShell/PowerShellEditorServices/releases).
To configure the language server, set the property `bundle_path` to the root
of the extracted PowerShellEditorServices.zip.

The default configuration doesn't set `cmd` unless `bundle_path` is specified.

```lua
require'lspconfig'.powershell_es.setup{
  bundle_path = 'c:/w/PowerShellEditorServices',
}
```

By default the languageserver is started in `pwsh` (PowerShell Core). This can be changed by specifying `shell`.

```lua
require'lspconfig'.powershell_es.setup{
  bundle_path = 'c:/w/PowerShellEditorServices',
  shell = 'powershell.exe',
}
```

Note that the execution policy needs to be set to `Unrestricted` for the languageserver run under PowerShell

If necessary, specific `cmd` can be defined instead of `bundle_path`.
See [PowerShellEditorServices](https://github.com/PowerShell/PowerShellEditorServices#stdio)
to learn more.

```lua
require'lspconfig'.powershell_es.setup{
  cmd = {'pwsh', '-NoLogo', '-NoProfile', '-Command', "c:/PSES/Start-EditorServices.ps1 ..."}
}
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.powershell_es.setup{}
```


**Default values:**
  - `filetypes` : 
  ```lua
  { "ps1" }
  ```
  - `on_new_config` : 
  ```lua
  see source file
  ```
  - `root_dir` : 
  ```lua
  git root or current directory
  ```
  - `shell` : 
  ```lua
  "pwsh"
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## prismals

Language Server for the Prisma JavaScript and TypeScript ORM

`@prisma/language-server` can be installed via npm
```sh
npm install -g @prisma/language-server
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.prismals.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "prisma-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "prisma" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".git", "package.json")
  ```
  - `settings` : 
  ```lua
  {
    prisma = {
      prismaFmtBinPath = ""
    }
  }
  ```


## prosemd_lsp

https://github.com/kitten/prosemd-lsp

An experimental LSP for Markdown.

Please see the manual installation instructions: https://github.com/kitten/prosemd-lsp#manual-installation



**Snippet to enable the language server:**
```lua
require'lspconfig'.prosemd_lsp.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "prosemd-lsp", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "markdown" }
  ```
  - `root_dir` : 
  ```lua
  <function 1>
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## psalm

https://github.com/vimeo/psalm

Can be installed with composer.
```sh
composer global require vimeo/psalm
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.psalm.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "psalm-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "php" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("psalm.xml", "psalm.xml.dist")
  ```


## puppet

LSP server for Puppet.

Installation:

- Clone the editor-services repository:
    https://github.com/puppetlabs/puppet-editor-services

- Navigate into that directory and run: `bundle install`

- Install the 'puppet-lint' gem: `gem install puppet-lint`

- Add that repository to $PATH.

- Ensure you can run `puppet-languageserver` from outside the editor-services directory.



**Snippet to enable the language server:**
```lua
require'lspconfig'.puppet.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "puppet-languageserver", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "puppet" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("manifests", ".puppet-lint.rc", "hiera.yaml", ".git")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## purescriptls

https://github.com/nwolverson/purescript-language-server
`purescript-language-server` can be installed via `npm`
```sh
npm install -g purescript-language-server
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.purescriptls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "purescript-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "purescript" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("spago.dhall, 'psc-package.json', bower.json")
  ```


## pylsp

https://github.com/python-lsp/python-lsp-server

A Python 3.6+ implementation of the Language Server Protocol.

The language server can be installed via `pipx install 'python-lsp-server[all]'`.
Further instructions can be found in the [project's README](https://github.com/python-lsp/python-lsp-server).

Note: This is a community fork of `pyls`.
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.pylsp.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "pylsp" }
  ```
  - `filetypes` : 
  ```lua
  { "python" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## pyre

https://pyre-check.org/

`pyre` a static type checker for Python 3.

`pyre` offers an extremely limited featureset. It currently only supports diagnostics,
which are triggered on save.

Do not report issues for missing features in `pyre` to `lspconfig`.




**Snippet to enable the language server:**
```lua
require'lspconfig'.pyre.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "pyre", "persistent" }
  ```
  - `filetypes` : 
  ```lua
  { "python" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## pyright

https://github.com/microsoft/pyright

`pyright`, a static type checker and language server for python



**Snippet to enable the language server:**
```lua
require'lspconfig'.pyright.setup{}
```
**Commands:**
- PyrightOrganizeImports: Organize Imports

**Default values:**
  - `cmd` : 
  ```lua
  { "pyright-langserver", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "python" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {
    python = {
      analysis = {
        autoSearchPaths = true,
        diagnosticMode = "workspace",
        useLibraryCodeForTypes = true
      }
    }
  }
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## quick_lint_js

https://quick-lint-js.com/

quick-lint-js finds bugs in JavaScript programs.

See installation [instructions](https://quick-lint-js.com/install/)



**Snippet to enable the language server:**
```lua
require'lspconfig'.quick_lint_js.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "quick-lint-js", "--lsp-server" }
  ```
  - `filetypes` : 
  ```lua
  { "javascript" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## r_language_server

[languageserver](https://github.com/REditorSupport/languageserver) is an
implementation of the Microsoft's Language Server Protocol for the R
language.

It is released on CRAN and can be easily installed by

```R
install.packages("languageserver")
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.r_language_server.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "R", "--slave", "-e", "languageserver::run()" }
  ```
  - `filetypes` : 
  ```lua
  { "r", "rmd" }
  ```
  - `log_level` : 
  ```lua
  2
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".git") or os_homedir
  ```


## racket_langserver

[https://github.com/jeapostrophe/racket-langserver](https://github.com/jeapostrophe/racket-langserver)

The Racket language server. This project seeks to use
[DrRacket](https://github.com/racket/drracket)'s public API to provide
functionality that mimics DrRacket's code tools as closely as possible.

Install via `raco`: `raco pkg install racket-langserver`



**Snippet to enable the language server:**
```lua
require'lspconfig'.racket_langserver.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "racket", "--lib", "racket-langserver" }
  ```
  - `filetypes` : 
  ```lua
  { "racket", "scheme" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## reason_ls

Reason language server

**By default, reason_ls doesn't have a `cmd` set.** This is because nvim-lspconfig does not make assumptions about your path.
You have to install the language server manually.

You can install reason language server from [reason-language-server](https://github.com/jaredly/reason-language-server) repository.

```lua
cmd = {'<path_to_reason_language_server>'}
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.reason_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "reason-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "reason" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## remark_ls

https://github.com/remarkjs/remark-language-server

`remark-language-server` can be installed via `npm`:
```sh
npm install -g remark-language-server
```

`remark-language-server` uses the same
[configuration files](https://github.com/remarkjs/remark/tree/main/packages/remark-cli#example-config-files-json-yaml-js)
as `remark-cli`.

This uses a plugin based system. Each plugin needs to be installed locally using `npm` or `yarn`.

For example, given the following `.remarkrc.json`:

```json
{
  "presets": [
    "remark-preset-lint-recommended"
  ]
}
```

`remark-preset-lint-recommended` needs to be installed in the local project:

```sh
npm install remark-preset-lint-recommended
```




**Snippet to enable the language server:**
```lua
require'lspconfig'.remark_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "remark-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "markdown" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## rescriptls

https://github.com/rescript-lang/rescript-vscode

ReScript language server

**By default, rescriptls doesn't have a `cmd` set.** This is because nvim-lspconfig does not make assumptions about your path.
You have to install the language server manually.

You can use the bundled language server inside the [vim-rescript](https://github.com/rescript-lang/vim-rescript) repo.

Clone the vim-rescript repo and point `cmd` to `server.js` inside `server/out` directory:

```lua
cmd = {'node', '<path_to_repo>/server/out/server.js', '--stdio'}

```

If you have vim-rescript installed you can also use that installation. for example if you're using packer.nvim you can set cmd to something like this:

```lua
cmd = {
  'node',
  '/home/username/.local/share/nvim/site/pack/packer/start/vim-rescript/server/out/server.js',
  '--stdio'
}
```

Another option is to use vscode extension [release](https://github.com/rescript-lang/rescript-vscode/releases).
Take a look at [here](https://github.com/rescript-lang/rescript-vscode#use-with-other-editors) for instructions.



**Snippet to enable the language server:**
```lua
require'lspconfig'.rescriptls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  {}
  ```
  - `filetypes` : 
  ```lua
  { "rescript" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {}
  ```


## rls

https://github.com/rust-lang/rls

rls, a language server for Rust

See https://github.com/rust-lang/rls#setup to setup rls itself.
See https://github.com/rust-lang/rls#configuration for rls-specific settings.
All settings listed on the rls configuration section of the readme
must be set under settings.rust as follows:

```lua
nvim_lsp.rls.setup {
  settings = {
    rust = {
      unstable_features = true,
      build_on_save = false,
      all_features = true,
    },
  },
}
```

If you want to use rls for a particular build, eg nightly, set cmd as follows:

```lua
cmd = {"rustup", "run", "nightly", "rls"}
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.rls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "rls" }
  ```
  - `filetypes` : 
  ```lua
  { "rust" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("Cargo.toml")
  ```


## rnix

https://github.com/nix-community/rnix-lsp

A language server for Nix providing basic completion and formatting via nixpkgs-fmt.

To install manually, run `cargo install rnix-lsp`. If you are using nix, rnix-lsp is in nixpkgs.

This server accepts configuration via the `settings` key.

    


**Snippet to enable the language server:**
```lua
require'lspconfig'.rnix.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "rnix-lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "nix" }
  ```
  - `init_options` : 
  ```lua
  {}
  ```
  - `root_dir` : 
  ```lua
  vim's starting directory
  ```
  - `settings` : 
  ```lua
  {}
  ```


## robotframework_ls

https://github.com/robocorp/robotframework-lsp

Language Server Protocol implementation for Robot Framework.



**Snippet to enable the language server:**
```lua
require'lspconfig'.robotframework_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "robotframework_ls" }
  ```
  - `filetypes` : 
  ```lua
  { "robot" }
  ```
  - `root_dir` : 
  ```lua
  util.root_pattern('robotidy.toml', 'pyproject.toml')(fname) or util.find_git_ancestor(fname)
  ```


## rome

https://rome.tools

Language server for the Rome Frontend Toolchain.

```sh
npm install [-g] rome
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.rome.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "rome", "lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "javascript", "javascriptreact", "json", "typescript", "typescript.tsx", "typescriptreact" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern('package.json', 'node_modules', '.git')
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## rust_analyzer

https://github.com/rust-analyzer/rust-analyzer

rust-analyzer (aka rls 2.0), a language server for Rust

See [docs](https://github.com/rust-analyzer/rust-analyzer/tree/master/docs/user#settings) for extra settings.
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.rust_analyzer.setup{}
```
**Commands:**
- CargoReload: Reload current cargo workspace

**Default values:**
  - `cmd` : 
  ```lua
  { "rust-analyzer" }
  ```
  - `filetypes` : 
  ```lua
  { "rust" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("Cargo.toml", "rust-project.json")
  ```
  - `settings` : 
  ```lua
  {
    ["rust-analyzer"] = {}
  }
  ```


## salt_ls

Language server for Salt configuration files.
https://github.com/dcermak/salt-lsp

The language server can be installed with `pip`:
```sh
pip install salt-lsp
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.salt_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "salt_lsp_server" }
  ```
  - `filetypes` : 
  ```lua
  { "sls" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern('.git')
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## scry

https://github.com/crystal-lang-tools/scry

Crystal language server.



**Snippet to enable the language server:**
```lua
require'lspconfig'.scry.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "scry" }
  ```
  - `filetypes` : 
  ```lua
  { "crystal" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern('shard.yml', '.git')
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## serve_d

           https://github.com/Pure-D/serve-d

           `Microsoft language server protocol implementation for D using workspace-d.`
           Download a binary from https://github.com/Pure-D/serve-d/releases and put it in your $PATH.
        


**Snippet to enable the language server:**
```lua
require'lspconfig'.serve_d.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "serve-d" }
  ```
  - `filetypes` : 
  ```lua
  { "d" }
  ```
  - `root_dir` : 
  ```lua
  util.root_pattern("dub.json", "dub.sdl", ".git")
  ```


## sixtyfps

https://github.com/sixtyfpsui/sixtyfps
`SixtyFPS`'s language server

You can build and install `sixtyfps-lsp` binary with `cargo`:
```sh
cargo install sixtyfps-lsp
```

Vim does not have built-in syntax for the `sixtyfps` filetype currently.

This can be added via an autocmd:

```lua
vim.cmd [[ autocmd BufRead,BufNewFile *.60 set filetype=sixtyfps ]]
```

or by installing a filetype plugin such as https://github.com/RustemB/sixtyfps-vim



**Snippet to enable the language server:**
```lua
require'lspconfig'.sixtyfps.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "sixtyfps-lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "sixtyfps" }
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## slint_lsp

https://github.com/slint-ui/slint
`Slint`'s language server

You can build and install `slint-lsp` binary with `cargo`:
```sh
cargo install slint-lsp
```

Vim does not have built-in syntax for the `slint` filetype at this time.

This can be added via an autocmd:

```lua
vim.cmd [[ autocmd BufRead,BufNewFile *.slint set filetype=slint ]]
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.slint_lsp.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "slint-lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "slint" }
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## solang

A language server for Solidity

See the [documentation](https://solang.readthedocs.io/en/latest/installing.html) for installation instructions.

The language server only provides the following capabilities:
* Syntax highlighting
* Diagnostics
* Hover

There is currently no support for completion, goto definition, references, or other functionality.




**Snippet to enable the language server:**
```lua
require'lspconfig'.solang.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "solang", "--language-server", "--target", "ewasm" }
  ```
  - `filetypes` : 
  ```lua
  { "solidity" }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor
  ```


## solargraph

https://solargraph.org/

solargraph, a language server for Ruby

You can install solargraph via gem install.

```sh
gem install --user-install solargraph
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.solargraph.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "solargraph", "stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "ruby" }
  ```
  - `init_options` : 
  ```lua
  {
    formatting = true
  }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("Gemfile", ".git")
  ```
  - `settings` : 
  ```lua
  {
    solargraph = {
      diagnostics = true
    }
  }
  ```


## solc

https://docs.soliditylang.org/en/latest/installing-solidity.html

solc is the native language server for the Solidity language.



**Snippet to enable the language server:**
```lua
require'lspconfig'.solc.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "solc", "--lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "solidity" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".git")
  ```


## solidity_ls

npm install -g solidity-language-server

solidity-language-server is a language server for the solidity language ported from the vscode solidity extension



**Snippet to enable the language server:**
```lua
require'lspconfig'.solidity_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "solidity-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "solidity" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".git", "package.json")
  ```


## sorbet

https://sorbet.org

Sorbet is a fast, powerful type checker designed for Ruby.

You can install Sorbet via gem install. You might also be interested in how to set
Sorbet up for new projects: https://sorbet.org/docs/adopting.

```sh
gem install sorbet
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.sorbet.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "srb", "tc", "--lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "ruby" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("Gemfile", ".git")
  ```


## sourcekit

https://github.com/apple/sourcekit-lsp

Language server for Swift and C/C++/Objective-C.
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.sourcekit.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "sourcekit-lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "swift", "c", "cpp", "objective-c", "objective-cpp" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("Package.swift", ".git")
  ```


## sourcery

https://github.com/sourcery-ai/sourcery

Refactor Python instantly using the power of AI.

It requires the initializationOptions param to be populated as shown below and will respond with the list of ServerCapabilities that it supports.

init_options = {
    --- The Sourcery token for authenticating the user.
    --- This is retrieved from the Sourcery website and must be
    --- provided by each user. The extension must provide a
    --- configuration option for the user to provide this value.
    token = <YOUR_TOKEN>

    --- The extension's name and version as defined by the extension.
    extension_version = 'vim.lsp'

    --- The editor's name and version as defined by the editor.
    editor_version = 'vim'
}



**Snippet to enable the language server:**
```lua
require'lspconfig'.sourcery.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "sourcery", "lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "python" }
  ```
  - `init_options` : 
  ```lua
  {
    editor_version = "vim",
    extension_version = "vim.lsp"
  }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## spectral

https://github.com/luizcorreia/spectral-language-server
 `A flexible JSON/YAML linter for creating automated style guides, with baked in support for OpenAPI v2 & v3.`

`spectral-language-server` can be installed via `npm`:
```sh
npm i -g spectral-language-server
```
See [vscode-spectral](https://github.com/stoplightio/vscode-spectral#extension-settings) for configuration options.



**Snippet to enable the language server:**
```lua
require'lspconfig'.spectral.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "spectral-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "yaml", "json", "yml" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {
    enable = true,
    run = "onType",
    validateLanguages = { "yaml", "json", "yml" }
  }
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## sqlls

https://github.com/joe-re/sql-language-server

This LSP can be installed via  `npm`. Find further instructions on manual installation of the sql-language-server at [joe-re/sql-language-server](https://github.com/joe-re/sql-language-server).
<br>
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.sqlls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "sql-language-server", "up", "--method", "stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "sql", "mysql" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {}
  ```


## sqls

https://github.com/lighttiger2505/sqls

```lua
require'lspconfig'.sqls.setup{
  cmd = {"path/to/command", "-config", "path/to/config.yml"};
  ...
}
```
Sqls can be installed via `go get github.com/lighttiger2505/sqls`. Instructions for compiling Sqls from the source can be found at [lighttiger2505/sqls](https://github.com/lighttiger2505/sqls).

    


**Snippet to enable the language server:**
```lua
require'lspconfig'.sqls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "sqls" }
  ```
  - `filetypes` : 
  ```lua
  { "sql", "mysql" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {}
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## stylelint_lsp

https://github.com/bmatcuk/stylelint-lsp

`stylelint-lsp` can be installed via `npm`:

```sh
npm i -g stylelint-lsp
```

Can be configured by passing a `settings.stylelintplus` object to `stylelint_lsp.setup`:

```lua
require'lspconfig'.stylelint_lsp.setup{
  settings = {
    stylelintplus = {
      -- see available options in stylelint-lsp documentation
    }
  }
}
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.stylelint_lsp.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "stylelint-lsp", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "css", "less", "scss", "sugarss", "vue", "wxss", "javascript", "javascriptreact", "typescript", "typescriptreact" }
  ```
  - `root_dir` : 
  ```lua
   root_pattern('.stylelintrc', 'package.json') 
  ```
  - `settings` : 
  ```lua
  {}
  ```


## sumneko_lua

https://github.com/sumneko/lua-language-server

Lua language server.

`lua-language-server` can be installed by following the instructions [here](https://github.com/sumneko/lua-language-server/wiki/Build-and-Run). The default `cmd` assumes that the `lua-language-server` binary can be found in `$PATH`.

```lua
local runtime_path = vim.split(package.path, ';')
table.insert(runtime_path, "lua/?.lua")
table.insert(runtime_path, "lua/?/init.lua")

require'lspconfig'.sumneko_lua.setup {
  settings = {
    Lua = {
      runtime = {
        -- Tell the language server which version of Lua you're using (most likely LuaJIT in the case of Neovim)
        version = 'LuaJIT',
        -- Setup your lua path
        path = runtime_path,
      },
      diagnostics = {
        -- Get the language server to recognize the `vim` global
        globals = {'vim'},
      },
      workspace = {
        -- Make the server aware of Neovim runtime files
        library = vim.api.nvim_get_runtime_file("", true),
      },
      -- Do not send telemetry data containing a randomized but unique identifier
      telemetry = {
        enable = false,
      },
    },
  },
}
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.sumneko_lua.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "lua-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "lua" }
  ```
  - `log_level` : 
  ```lua
  2
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".luarc.json", ".luacheckrc", ".stylua.toml", "selene.toml", ".git")
  ```
  - `settings` : 
  ```lua
  {
    Lua = {
      telemetry = {
        enable = false
      }
    }
  }
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## svelte

https://github.com/sveltejs/language-tools/tree/master/packages/language-server

`svelte-language-server` can be installed via `npm`:
```sh
npm install -g svelte-language-server
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.svelte.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "svelteserver", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "svelte" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("package.json", ".git")
  ```


## svls

https://github.com/dalance/svls

Language server for verilog and SystemVerilog

`svls` can be installed via `cargo`:
 ```sh
 cargo install svls
 ```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.svls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "svls" }
  ```
  - `filetypes` : 
  ```lua
  { "verilog", "systemverilog" }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor
  ```


## tailwindcss

https://github.com/tailwindlabs/tailwindcss-intellisense

Tailwind CSS Language Server can be installed via npm:
```sh
npm install -g @tailwindcss/language-server
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.tailwindcss.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "tailwindcss-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "aspnetcorerazor", "astro", "astro-markdown", "blade", "django-html", "htmldjango", "edge", "eelixir", "ejs", "erb", "eruby", "gohtml", "haml", "handlebars", "hbs", "html", "html-eex", "heex", "jade", "leaf", "liquid", "markdown", "mdx", "mustache", "njk", "nunjucks", "php", "razor", "slim", "twig", "css", "less", "postcss", "sass", "scss", "stylus", "sugarss", "javascript", "javascriptreact", "reason", "rescript", "typescript", "typescriptreact", "vue", "svelte" }
  ```
  - `init_options` : 
  ```lua
  {
    userLanguages = {
      eelixir = "html-eex",
      eruby = "erb"
    }
  }
  ```
  - `on_new_config` : 
  ```lua
  see source file
  ```
  - `root_dir` : 
  ```lua
  root_pattern('tailwind.config.js', 'tailwind.config.ts', 'postcss.config.js', 'postcss.config.ts', 'package.json', 'node_modules', '.git')
  ```
  - `settings` : 
  ```lua
  {
    tailwindCSS = {
      classAttributes = { "class", "className", "classList", "ngClass" },
      lint = {
        cssConflict = "warning",
        invalidApply = "error",
        invalidConfigPath = "error",
        invalidScreen = "error",
        invalidTailwindDirective = "error",
        invalidVariant = "error",
        recommendedVariantOrder = "warning"
      },
      validate = true
    }
  }
  ```


## taplo

https://taplo.tamasfe.dev/lsp/

Language server for Taplo, a TOML toolkit.

`taplo-cli` can be installed via `cargo`:
```sh
cargo install --locked taplo-cli
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.taplo.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "taplo", "lsp", "stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "toml" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("*.toml", ".git")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## teal_ls

https://github.com/teal-language/teal-language-server

Install with:
```
luarocks install --dev teal-language-server
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.teal_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "teal-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "teal" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("tlconfig.lua", ".git")
  ```


## terraform_lsp

https://github.com/juliosueiras/terraform-lsp

Terraform language server
Download a released binary from
https://github.com/juliosueiras/terraform-lsp/releases.

From https://github.com/hashicorp/terraform-ls#terraform-ls-vs-terraform-lsp:

Both HashiCorp and the maintainer of terraform-lsp expressed interest in
collaborating on a language server and are working towards a _long-term_
goal of a single stable and feature-complete implementation.

For the time being both projects continue to exist, giving users the
choice:

- `terraform-ls` providing
  - overall stability (by relying only on public APIs)
  - compatibility with any provider and any Terraform >=0.12.0 currently
    less features
  - due to project being younger and relying on public APIs which may
    not offer the same functionality yet

- `terraform-lsp` providing
  - currently more features
  - compatibility with a single particular Terraform (0.12.20 at time of writing)
    - configs designed for other 0.12 versions may work, but interpretation may be inaccurate
  - less stability (due to reliance on Terraform's own internal packages)



**Snippet to enable the language server:**
```lua
require'lspconfig'.terraform_lsp.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "terraform-lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "terraform", "hcl" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".terraform", ".git")
  ```


## terraformls

https://github.com/hashicorp/terraform-ls

Terraform language server
Download a released binary from https://github.com/hashicorp/terraform-ls/releases.

From https://github.com/hashicorp/terraform-ls#terraform-ls-vs-terraform-lsp:

Both HashiCorp and the maintainer of terraform-lsp expressed interest in
collaborating on a language server and are working towards a _long-term_
goal of a single stable and feature-complete implementation.

For the time being both projects continue to exist, giving users the
choice:

- `terraform-ls` providing
  - overall stability (by relying only on public APIs)
  - compatibility with any provider and any Terraform >=0.12.0 currently
    less features
  - due to project being younger and relying on public APIs which may
    not offer the same functionality yet

- `terraform-lsp` providing
  - currently more features
  - compatibility with a single particular Terraform (0.12.20 at time of writing)
    - configs designed for other 0.12 versions may work, but interpretation may be inaccurate
  - less stability (due to reliance on Terraform's own internal packages)



**Snippet to enable the language server:**
```lua
require'lspconfig'.terraformls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "terraform-ls", "serve" }
  ```
  - `filetypes` : 
  ```lua
  { "terraform" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".terraform", ".git")
  ```


## texlab

https://github.com/latex-lsp/texlab

A completion engine built from scratch for (La)TeX.

See https://github.com/latex-lsp/texlab/blob/master/docs/options.md for configuration options.



**Snippet to enable the language server:**
```lua
require'lspconfig'.texlab.setup{}
```
**Commands:**
- TexlabBuild: Build the current buffer
- TexlabForward: Forward search from current position

**Default values:**
  - `cmd` : 
  ```lua
  { "texlab" }
  ```
  - `filetypes` : 
  ```lua
  { "tex", "bib" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {
    texlab = {
      auxDirectory = ".",
      bibtexFormatter = "texlab",
      build = {
        args = { "-pdf", "-interaction=nonstopmode", "-synctex=1", "%f" },
        executable = "latexmk",
        forwardSearchAfter = false,
        onSave = false
      },
      chktex = {
        onEdit = false,
        onOpenAndSave = false
      },
      diagnosticsDelay = 300,
      formatterLineLength = 80,
      forwardSearch = {
        args = {}
      },
      latexFormatter = "latexindent",
      latexindent = {
        modifyLineBreaks = false
      }
    }
  }
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## tflint

https://github.com/terraform-linters/tflint

A pluggable Terraform linter that can act as lsp server.
Installation instructions can be found in https://github.com/terraform-linters/tflint#installation.



**Snippet to enable the language server:**
```lua
require'lspconfig'.tflint.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "tflint", "--langserver" }
  ```
  - `filetypes` : 
  ```lua
  { "terraform" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".terraform", ".git", ".tflint.hcl")
  ```


## theme_check

https://github.com/Shopify/shopify-cli

`theme-check-language-server` is bundled with `shopify-cli` or it can also be installed via

https://github.com/Shopify/theme-check#installation

**NOTE:**
If installed via Homebrew, `cmd` must be set to 'theme-check-liquid-server'

```lua
require lspconfig.theme_check.setup {
  cmd = { 'theme-check-liquid-server' }
}
```




**Snippet to enable the language server:**
```lua
require'lspconfig'.theme_check.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "theme-check-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "liquid" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```
  - `settings` : 
  ```lua
  {}
  ```


## tsserver

https://github.com/theia-ide/typescript-language-server

`typescript-language-server` depends on `typescript`. Both packages can be installed via `npm`:
```sh
npm install -g typescript typescript-language-server
```

To configure type language server, add a
[`tsconfig.json`](https://www.typescriptlang.org/docs/handbook/tsconfig-json.html) or
[`jsconfig.json`](https://code.visualstudio.com/docs/languages/jsconfig) to the root of your
project.

Here's an example that disables type checking in JavaScript files.

```json
{
  "compilerOptions": {
    "module": "commonjs",
    "target": "es6",
    "checkJs": false
  },
  "exclude": [
    "node_modules"
  ]
}
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.tsserver.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "typescript-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "javascript", "javascriptreact", "javascript.jsx", "typescript", "typescriptreact", "typescript.tsx" }
  ```
  - `init_options` : 
  ```lua
  {
    hostInfo = "neovim"
  }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("package.json", "tsconfig.json", "jsconfig.json", ".git")
  ```


## typeprof

https://github.com/ruby/typeprof

`typeprof` is the built-in analysis and LSP tool for Ruby 3.1+.
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.typeprof.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "typeprof", "--lsp", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "ruby", "eruby" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("Gemfile", ".git")
  ```


## vala_ls

https://github.com/Prince781/vala-language-server


**Snippet to enable the language server:**
```lua
require'lspconfig'.vala_ls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "vala-language-server" }
  ```
  - `filetypes` : 
  ```lua
  { "vala", "genie" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("meson.build", ".git")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## vdmj

https://github.com/nickbattle/vdmj

The VDMJ language server can be installed by cloning the VDMJ repository and
running `mvn clean install`.

Various options are provided to configure the language server (see below). In
particular:
- `annotation_paths` is a list of folders and/or jar file paths for annotations
that should be used with the language server;
- any value of `debugger_port` less than zero will disable the debugger; note
that if a non-zero value is used, only one instance of the server can be active
at a time.

More settings for VDMJ can be changed in a file called `vdmj.properties` under
`root_dir/.vscode`. For a description of the available settings, see
[Section 7 of the VDMJ User Guide](https://raw.githubusercontent.com/nickbattle/vdmj/master/vdmj/documentation/UserGuide.pdf).

Note: proof obligations and combinatorial testing are not currently supported
by neovim.



**Snippet to enable the language server:**
```lua
require'lspconfig'.vdmj.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  Generated from the options given
  ```
  - `filetypes` : 
  ```lua
  { "vdmsl", "vdmpp", "vdmrt" }
  ```
  - `options` : 
  ```lua
  {
    annotation_paths = {},
    debugger_port = -1,
    high_precision = false,
    java = "$JAVA_HOME/bin/java",
    java_opts = { "-Xmx3000m", "-Xss1m" },
    logfile = "path.join(vim.fn.stdpath 'cache', 'vdm-lsp.log')",
    mavenrepo = "$HOME/.m2/repository/com/fujitsu",
    version = "The latest version installed in `mavenrepo`"
  }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor(fname) or find_vscode_ancestor(fname)
  ```


## verible

https://github.com/chipsalliance/verible

A linter and formatter for verilog and SystemVerilog files.

Release binaries can be downloaded from [here](https://github.com/chipsalliance/verible/releases)
and placed in a directory on PATH.

See https://github.com/chipsalliance/verible/tree/master/verilog/tools/ls/README.md for options.
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.verible.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "verible-verilog-ls" }
  ```
  - `filetypes` : 
  ```lua
  { "systemverilog", "verilog" }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## vimls

https://github.com/iamcco/vim-language-server

You can install vim-language-server via npm:
```sh
npm install -g vim-language-server
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.vimls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "vim-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "vim" }
  ```
  - `init_options` : 
  ```lua
  {
    diagnostic = {
      enable = true
    },
    indexes = {
      count = 3,
      gap = 100,
      projectRootPatterns = { "runtime", "nvim", ".git", "autoload", "plugin" },
      runtimepath = true
    },
    iskeyword = "@,48-57,_,192-255,-#",
    runtimepath = "",
    suggest = {
      fromRuntimepath = true,
      fromVimruntime = true
    },
    vimruntime = ""
  }
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## vls

https://github.com/vlang/vls

V language server.

`v-language-server` can be installed by following the instructions [here](https://github.com/vlang/vls#installation).

**By default, v-language-server doesn't have a `cmd` set.** This is because nvim-lspconfig does not make assumptions about your path. You must add the following to your init.vim or init.lua to set `cmd` to the absolute path ($HOME and ~ are not expanded) of your unzipped and compiled v-language-server.

```lua
-- set the path to the vls installation;
local vls_root_path = vim.fn.stdpath('cache')..'/lspconfig/vls'
local vls_binary = vls_root_path.."/cmd/vls/vls"

require'lspconfig'.vls.setup {
  cmd = {vls_binary},
}
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.vls.setup{}
```


**Default values:**
  - `filetypes` : 
  ```lua
  { "vlang" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("v.mod", ".git")
  ```


## volar

https://github.com/johnsoncodehk/volar/tree/master/packages/vue-language-server

Volar language server for Vue

Volar can be installed via npm:

```sh
npm install -g @volar/vue-language-server
```

Volar by default supports Vue 3 projects. Vue 2 projects need [additional configuration](https://github.com/johnsoncodehk/volar/blob/master/extensions/vscode-vue-language-features/README.md?plain=1#L28-L63).

**Take Over Mode**
Volar can serve as a language server for both Vue and TypeScript via [Take Over Mode](https://github.com/johnsoncodehk/volar/discussions/471).

To enable Take Over Mode, override the default filetypes in `setup{}` as follows:

```lua
require'lspconfig'.volar.setup{
  filetypes = {'typescript', 'javascript', 'javascriptreact', 'typescriptreact', 'vue', 'json'}
}
```

**Overriding the default TypeScript Server used by Volar**
The default config looks for TS in the local node_modules. The alternatives are:

- use a global TypeScript Server installation

```lua
require'lspconfig'.volar.setup{
  init_options = {
    typescript = {
      serverPath = '/path/to/.npm/lib/node_modules/typescript/lib/tsserverlib.js'
    }
  }
}
```

- use a global TypeScript Server installation if a local server is not found

```lua
local util = require 'lspconfig.util'

local function get_typescript_server_path(root_dir)
  local project_root = util.find_node_modules_ancestor(root_dir)

  local local_tsserverlib = project_root ~= nil and util.path.join(project_root, 'node_modules', 'typescript', 'lib', 'tsserverlibrary.js')
  local global_tsserverlib = '/home/[yourusernamehere]/.npm/lib/node_modules/typescript/lib/tsserverlibrary.js'

  if local_tsserverlib and util.path.exists(local_tsserverlib) then
    return local_tsserverlib
  else
    return global_tsserverlib
  end
end

require'lspconfig'.volar.setup{
  on_new_config = function(new_config, new_root_dir)
    new_config.init_options.typescript.serverPath = get_typescript_server_path(new_root_dir)
  end,
}
```
    


**Snippet to enable the language server:**
```lua
require'lspconfig'.volar.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "vue-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "vue" }
  ```
  - `init_options` : 
  ```lua
  {
    documentFeatures = {
      documentColor = false,
      documentFormatting = {
        defaultPrintWidth = 100
      },
      documentSymbol = true,
      foldingRange = true,
      linkedEditingRange = true,
      selectionRange = true
    },
    languageFeatures = {
      callHierarchy = true,
      codeAction = true,
      codeLens = true,
      completion = {
        defaultAttrNameCase = "kebabCase",
        defaultTagNameCase = "both"
      },
      definition = true,
      diagnostics = true,
      documentHighlight = true,
      documentLink = true,
      hover = true,
      implementation = true,
      references = true,
      rename = true,
      renameFileRefactoring = true,
      schemaRequestService = true,
      semanticTokens = false,
      signatureHelp = true,
      typeDefinition = true
    },
    typescript = {
      serverPath = ""
    }
  }
  ```
  - `on_new_config` : 
  ```lua
  see source file
  ```
  - `root_dir` : 
  ```lua
  see source file
  ```


## vuels

https://github.com/vuejs/vetur/tree/master/server

Vue language server(vls)
`vue-language-server` can be installed via `npm`:
```sh
npm install -g vls
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.vuels.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "vls" }
  ```
  - `filetypes` : 
  ```lua
  { "vue" }
  ```
  - `init_options` : 
  ```lua
  {
    config = {
      css = {},
      emmet = {},
      html = {
        suggest = {}
      },
      javascript = {
        format = {}
      },
      stylusSupremacy = {},
      typescript = {
        format = {}
      },
      vetur = {
        completion = {
          autoImport = false,
          tagCasing = "kebab",
          useScaffoldSnippets = false
        },
        format = {
          defaultFormatter = {
            js = "none",
            ts = "none"
          },
          defaultFormatterOptions = {},
          scriptInitialIndent = false,
          styleInitialIndent = false
        },
        useWorkspaceDependencies = false,
        validation = {
          script = true,
          style = true,
          template = true
        }
      }
    }
  }
  ```
  - `root_dir` : 
  ```lua
  root_pattern("package.json", "vue.config.js")
  ```


## yamlls

https://github.com/redhat-developer/yaml-language-server

`yaml-language-server` can be installed via `yarn`:
```sh
yarn global add yaml-language-server
```

To use a schema for validation, there are two options:

1. Add a modeline to the file. A modeline is a comment of the form:

```
# yaml-language-server: $schema=<urlToTheSchema|relativeFilePath|absoluteFilePath}>
```

where the relative filepath is the path relative to the open yaml file, and the absolute filepath
is the filepath relative to the filesystem root ('/' on unix systems)

2. Associated a schema url, relative , or absolute (to root of project, not to filesystem root) path to
the a glob pattern relative to the detected project root. Check `:LspInfo` to determine the resolved project
root.

```lua
require('lspconfig').yamlls.setup {
  ... -- other configuration for setup {}
  settings = {
    yaml = {
      ... -- other settings. note this overrides the lspconfig defaults.
      schemas = {
        ["https://json.schemastore.org/github-workflow.json"] = "/.github/workflows/*"
        ["../path/relative/to/file.yml"] = "/.github/workflows/*"
        ["/path/from/root/of/project"] = "/.github/workflows/*"
      },
    },
  }
}
```

Currently, kubernetes is special-cased in yammls, see the following upstream issues:
* [#211](https://github.com/redhat-developer/yaml-language-server/issues/211).
* [#307](https://github.com/redhat-developer/yaml-language-server/issues/307).

To override a schema to use a specific k8s schema version (for example, to use 1.18):

```lua
require('lspconfig').yamlls.setup {
  ... -- other configuration for setup {}
  settings = {
    yaml = {
      ... -- other settings. note this overrides the lspconfig defaults.
      schemas = {
        ["https://raw.githubusercontent.com/instrumenta/kubernetes-json-schema/master/v1.18.0-standalone-strict/all.json"] = "/*.k8s.yaml",
        ... -- other schemas
      },
    },
  }
}
```




**Snippet to enable the language server:**
```lua
require'lspconfig'.yamlls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "yaml-language-server", "--stdio" }
  ```
  - `filetypes` : 
  ```lua
  { "yaml", "yaml.docker-compose" }
  ```
  - `root_dir` : 
  ```lua
  util.find_git_ancestor
  ```
  - `settings` : 
  ```lua
  {
    redhat = {
      telemetry = {
        enabled = false
      }
    }
  }
  ```
  - `single_file_support` : 
  ```lua
  true
  ```


## zeta_note

https://github.com/artempyanykh/zeta-note

Markdown LSP server for easy note-taking with cross-references and diagnostics.

Binaries can be downloaded from https://github.com/artempyanykh/zeta-note/releases

**By default, zeta-note doesn't have a `cmd` set.** This is because nvim-lspconfig does not make assumptions about your path. You must add the following to your init.vim or init.lua to set `cmd` to the absolute path ($HOME and ~ are not expanded) of your zeta-note binary.

```lua
require'lspconfig'.zeta_note.setup{
  cmd = {'path/to/zeta-note'}
}
```



**Snippet to enable the language server:**
```lua
require'lspconfig'.zeta_note.setup{}
```


**Default values:**
  - `filetypes` : 
  ```lua
  { "markdown" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".zeta.toml")
  ```


## zk

github.com/mickael-menu/zk

A plain text note-taking assistant



**Snippet to enable the language server:**
```lua
require'lspconfig'.zk.setup{}
```
**Commands:**
- ZkIndex: Index
- ZkNew: ZkNew

**Default values:**
  - `cmd` : 
  ```lua
  { "zk", "lsp" }
  ```
  - `filetypes` : 
  ```lua
  { "markdown" }
  ```
  - `root_dir` : 
  ```lua
  root_pattern(".zk")
  ```


## zls

https://github.com/zigtools/zls

Zig LSP implementation + Zig Language Server
        


**Snippet to enable the language server:**
```lua
require'lspconfig'.zls.setup{}
```


**Default values:**
  - `cmd` : 
  ```lua
  { "zls" }
  ```
  - `filetypes` : 
  ```lua
  { "zig", "zir" }
  ```
  - `root_dir` : 
  ```lua
  util.root_pattern("zls.json", ".git")
  ```
  - `single_file_support` : 
  ```lua
  true
  ```



vim:ft=markdown
