/*
 * Decompiled with CFR 0.152.
 */
package org.perl.inline.java;

import java.io.IOException;
import java.util.StringTokenizer;
import org.perl.inline.java.InlineJavaClass;
import org.perl.inline.java.InlineJavaException;
import org.perl.inline.java.InlineJavaPerlException;
import org.perl.inline.java.InlineJavaPerlObject;
import org.perl.inline.java.InlineJavaProtocol;
import org.perl.inline.java.InlineJavaServer;
import org.perl.inline.java.InlineJavaServerThread;
import org.perl.inline.java.InlineJavaUtils;

class InlineJavaCallback {
    private InlineJavaServer ijs = InlineJavaServer.GetInstance();
    private String pkg = null;
    private InlineJavaPerlObject obj = null;
    private String method = null;
    private Object[] args = null;
    private Class cast = null;
    private Object response = null;
    private boolean response_set = false;

    InlineJavaCallback(String _pkg, String _method, Object[] _args, Class _cast) {
        this(null, _pkg, _method, _args, _cast);
    }

    InlineJavaCallback(InlineJavaPerlObject _obj, String _method, Object[] _args, Class _cast) {
        this(_obj, null, _method, _args, _cast);
        if (this.obj == null) {
            throw new NullPointerException();
        }
    }

    private InlineJavaCallback(InlineJavaPerlObject _obj, String _pkg, String _method, Object[] _args, Class _cast) {
        this.obj = _obj;
        this.pkg = _pkg;
        this.method = _method;
        this.args = _args;
        this.cast = _cast;
        if (this.method == null) {
            throw new NullPointerException();
        }
        if (this.cast == null) {
            this.cast = Object.class;
        }
    }

    private String GetCommand(InlineJavaProtocol ijp) throws InlineJavaException {
        Object via = null;
        if (this.obj != null) {
            via = "" + this.obj.GetId();
        } else if (this.pkg != null) {
            via = this.pkg;
        }
        StringBuffer cmdb = new StringBuffer("callback " + (String)via + " " + this.method + " " + this.cast.getName());
        if (this.args != null) {
            for (int i = 0; i < this.args.length; ++i) {
                cmdb.append(" " + ijp.SerializeObject(this.args[i], null));
            }
        }
        return cmdb.toString();
    }

    void ClearResponse() {
        this.response = null;
        this.response_set = false;
    }

    Object GetResponse() {
        return this.response;
    }

    synchronized Object WaitForResponse(Thread t) {
        while (!this.response_set) {
            try {
                InlineJavaUtils.debug(3, "waiting for callback response in " + t.getName() + "...");
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        InlineJavaUtils.debug(3, "got callback response");
        Object resp = this.response;
        this.response = null;
        this.response_set = false;
        return resp;
    }

    synchronized void NotifyOfResponse(Thread t) {
        InlineJavaUtils.debug(3, "notifying that callback has completed in " + t.getName());
        this.notify();
    }

    synchronized void Process() throws InlineJavaException, InlineJavaPerlException {
        Object ret = null;
        try {
            InlineJavaProtocol ijp = new InlineJavaProtocol(this.ijs, null);
            String cmd = this.GetCommand(ijp);
            InlineJavaUtils.debug(2, "callback command: " + cmd);
            Thread t = Thread.currentThread();
            String resp = null;
            while (true) {
                InlineJavaUtils.debug(3, "packet sent (callback) is " + cmd);
                if (!this.ijs.IsJNI()) {
                    InlineJavaServerThread ijt = (InlineJavaServerThread)t;
                    ijt.GetWriter().write(cmd + "\n");
                    ijt.GetWriter().flush();
                    resp = ijt.GetReader().readLine();
                } else {
                    resp = this.ijs.jni_callback(cmd);
                }
                InlineJavaUtils.debug(3, "packet recv (callback) is " + resp);
                StringTokenizer st = new StringTokenizer(resp, " ");
                String c = st.nextToken();
                if (c.equals("callback")) {
                    boolean thrown = Boolean.parseBoolean(st.nextToken());
                    String arg = st.nextToken();
                    InlineJavaClass ijc = new InlineJavaClass(this.ijs, ijp);
                    ret = ijc.CastArgument(this.cast, arg);
                    if (thrown) {
                        throw new InlineJavaPerlException(ret);
                    }
                    break;
                }
                InlineJavaUtils.debug(3, "packet is not callback response: " + resp);
                cmd = this.ijs.ProcessCommand(resp, false);
            }
        }
        catch (IOException e) {
            throw new InlineJavaException("IO error: " + e.getMessage());
        }
        this.response = ret;
        this.response_set = true;
    }
}

