/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.extremity;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.svek.extremity.Extremity;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColors;

class ExtremityCircle
extends Extremity {
    private static final double radius = 6.0;
    private final Point2D dest;
    private final boolean fill;
    private final HColor backgroundColor;

    @Override
    public Point2D somePoint() {
        return this.dest;
    }

    public static UDrawable create(Point2D center, boolean fill, double angle, HColor backgroundColor) {
        return new ExtremityCircle(center.getX(), center.getY(), fill, angle, backgroundColor);
    }

    private ExtremityCircle(double x, double y, boolean fill, double angle, HColor backgroundColor) {
        this.dest = new Point2D.Double(x - 6.0 * Math.cos(angle + 1.5707963267948966), y - 6.0 * Math.sin(angle + 1.5707963267948966));
        this.backgroundColor = backgroundColor;
        this.fill = fill;
    }

    @Override
    public void drawU(UGraphic ug) {
        ug = ug.apply(new UStroke(1.5));
        ug = this.fill ? ug.apply(HColors.changeBack(ug)) : ug.apply(this.backgroundColor.bg());
        ug = ug.apply(new UTranslate(this.dest.getX() - 6.0, this.dest.getY() - 6.0));
        ug.draw(new UEllipse(12.0, 12.0));
    }
}

