/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.html5;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.tikz.TikzGraphics;

public class Html5Drawer {
    private int maxX = 10;
    private int maxY = 10;
    private String strokeStyle = "black";
    private String fillStyle = "black";
    private List<String> data = new ArrayList<String>();

    protected final void ensureVisible(double x, double y) {
        if (x > (double)this.maxX) {
            this.maxX = (int)(x + 1.0);
        }
        if (y > (double)this.maxY) {
            this.maxY = (int)(y + 1.0);
        }
    }

    private static String format(double x) {
        return TikzGraphics.format(x);
    }

    public final void setStrokeColor(String stroke) {
        this.strokeStyle = stroke;
    }

    public final void setFillColor(String fill) {
        this.fillStyle = fill;
    }

    public String generateHtmlCode() {
        StringBuilder sb = new StringBuilder();
        this.ap(sb, "<html>");
        this.ap(sb, "<canvas id=\"demo\" width=\"700\" height=\"350\">");
        this.ap(sb, "</canvas>");
        this.ap(sb, "</html>");
        this.ap(sb, "<script>");
        this.ap(sb, "window.addEventListener('load', function () {");
        this.ap(sb, "var elem = document.getElementById('demo');");
        this.ap(sb, "if (!elem || !elem.getContext) { return;}");
        this.ap(sb, "var ctx = elem.getContext('2d');");
        this.ap(sb, "if (!ctx) { return;}");
        for (String s : this.data) {
            this.ap(sb, s);
        }
        this.ap(sb, "}, false);");
        this.ap(sb, "</script>");
        this.ap(sb, "</html>");
        return sb.toString();
    }

    private void ap(StringBuilder sb, String s) {
        sb.append(s);
        sb.append('\n');
    }

    public void htmlRectangle(double x, double y, double width, double height, double rx, double ry) {
        this.ensureVisible(x, y);
        this.ensureVisible(x + width, y + height);
        this.data.add("//RECT");
        this.data.add("ctx.strokeStyle='" + this.strokeStyle + "';");
        this.data.add("ctx.fillStyle='" + this.fillStyle + "';");
        this.data.add("ctx.rect(" + Html5Drawer.format(x) + "," + Html5Drawer.format(y) + "," + Html5Drawer.format(width) + "," + Html5Drawer.format(height) + ");");
        this.data.add("ctx.fill();");
        this.data.add("ctx.stroke();");
    }

    public void htmlLine(double x1, double y1, double x2, double y2, double deltaShadow) {
        this.ensureVisible(x1 + 2.0 * deltaShadow, y1 + 2.0 * deltaShadow);
        this.ensureVisible(x2 + 2.0 * deltaShadow, y2 + 2.0 * deltaShadow);
        this.data.add("ctx.strokeStyle='" + this.strokeStyle + "';");
        this.data.add("ctx.beginPath();");
        this.data.add("ctx.moveTo(" + Html5Drawer.format(x1) + "," + Html5Drawer.format(y1) + ");");
        this.data.add("ctx.lineTo(" + Html5Drawer.format(x2) + "," + Html5Drawer.format(y2) + ");");
        this.data.add("ctx.stroke();");
        this.data.add("ctx.closePath();");
    }
}

